/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.utils;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.sib.matchspace.utils.Printable;
import com.ibm.ws.sib.matchspace.utils.Trace;
import com.ibm.ws.sib.matchspace.utils.TraceFactory;
import java.io.PrintWriter;
import java.io.StringWriter;

public class FFDC {
    private static final Class cclass = FFDC.class;
    private static Trace trace = TraceFactory.getTrace(FFDC.class, "SIBMatchSpace");
    public static PrintWriter printWriter = null;
    private static Diagnostics diagnostics = new Diagnostics();

    public static void processException(Class sourceClass, String methodName, Throwable throwable, String probe) {
        if (TraceComponent.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(cclass, "processException", new Object[]{sourceClass, methodName, throwable, probe});
        }
        if (TraceComponent.isAnyTracingEnabled() && trace.isEventEnabled()) {
            trace.event(cclass, "processException", throwable);
        }
        FFDC.print(null, sourceClass, methodName, throwable, probe, null);
        FFDCFilter.processException((Throwable)throwable, (String)(sourceClass.getName() + ":" + methodName), (String)probe);
        if (TraceComponent.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(cclass, "processException");
        }
    }

    public static void processException(Class sourceClass, String methodName, Throwable throwable, String probe, Object[] objects) {
        if (TraceComponent.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(cclass, "processException", new Object[]{sourceClass, methodName, throwable, probe, objects});
        }
        if (TraceComponent.isAnyTracingEnabled() && trace.isEventEnabled()) {
            trace.event(cclass, "processException", throwable);
        }
        FFDC.print(null, sourceClass, methodName, throwable, probe, objects);
        FFDCFilter.processException((Throwable)throwable, (String)(sourceClass.getName() + ":" + methodName), (String)probe, (Object[])objects);
        if (TraceComponent.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(cclass, "processException");
        }
    }

    public static void processException(Object source, Class sourceClass, String methodName, Throwable throwable, String probe) {
        if (TraceComponent.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(cclass, "processException", new Object[]{source, sourceClass, methodName, throwable, probe});
        }
        if (TraceComponent.isAnyTracingEnabled() && trace.isEventEnabled()) {
            trace.event(cclass, "processException", throwable);
        }
        FFDC.print(source, sourceClass, methodName, throwable, probe, null);
        FFDCFilter.processException((Throwable)throwable, (String)(sourceClass.getName() + ":" + methodName), (String)probe, (Object)source);
        if (TraceComponent.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(cclass, "processException");
        }
    }

    public static void processException(Object source, Class sourceClass, String methodName, Throwable throwable, String probe, Object[] objects) {
        if (TraceComponent.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(cclass, "processException", new Object[]{source, sourceClass, methodName, throwable, probe, objects});
        }
        if (TraceComponent.isAnyTracingEnabled() && trace.isEventEnabled()) {
            trace.event(cclass, "processException", throwable);
        }
        FFDC.print(source, sourceClass, methodName, throwable, probe, objects);
        FFDCFilter.processException((Throwable)throwable, (String)(sourceClass.getName() + ":" + methodName), (String)probe, (Object)source, (Object[])objects);
        if (TraceComponent.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(cclass, "processException");
        }
    }

    private static void print(Object source, Class sourceClass, String methodName, Throwable throwable, String probe, Object object) {
        if (printWriter != null) {
            printWriter.println("========================FFDC Start==========================");
            if (source != null) {
                printWriter.println("Source=" + source);
            }
            printWriter.println("Source=" + sourceClass + ":" + methodName + " probe=" + probe + "\n throwable=" + throwable);
            FFDC.print(source, printWriter);
            if (object != null) {
                if (object instanceof Object[]) {
                    Object[] objects = (Object[])object;
                    for (int i = 0; i < objects.length; ++i) {
                        printWriter.println("------------------------------------------------------------");
                        FFDC.print(objects[i], printWriter);
                    }
                } else {
                    printWriter.println("------------------------------------------------------------");
                    FFDC.print(object, printWriter);
                }
            }
            printWriter.println();
            throwable.printStackTrace(printWriter);
            printWriter.println("=========================FFDC End===========================");
            printWriter.flush();
        }
    }

    static void print(Object object, PrintWriter printWriter) {
        if (object instanceof Printable) {
            ((Printable)object).print(printWriter);
        } else {
            printWriter.print(object);
        }
    }

    public static class Diagnostics
    extends DiagnosticModule {
        private Diagnostics() {
            if (diagnostics == null) {
                com.ibm.ws.ffdc.FFDC.registerDiagnosticModule((DiagnosticModule)this, (String)"com.ibm.ws.objectManager");
                com.ibm.ws.ffdc.FFDC.registerDiagnosticModule((DiagnosticModule)this, (String)"com.ibm.ws.objectManager.utils");
            }
        }

        public void ffdcDumpDefault(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objects, String sourceId) {
            if (TraceComponent.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "ffdcDumpDefault", new Object[]{throwable, incidentStream, object, objects, sourceId});
            }
            this.dump(object, incidentStream);
            for (int i = 0; i < objects.length; ++i) {
                this.dump(objects[i], incidentStream);
            }
            if (TraceComponent.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "ffdcDumpDefault");
            }
        }

        private void dump(Object object, IncidentStream incidentStream) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            if (object instanceof Printable) {
                try {
                    ((Printable)object).print(printWriter);
                }
                catch (Exception exception) {
                    printWriter.print(object);
                    printWriter.println();
                    printWriter.print(exception);
                }
            } else {
                printWriter.print(object);
            }
            incidentStream.write(object.getClass().getName(), stringWriter.toString());
        }
    }
}

