/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sib.core;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.common.service.CommonServiceFacade;
import com.ibm.ws.sib.trm.TrmSICoreConnectionFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.exception.SIInsufficientDataForFactoryTypeException;
import com.ibm.wsspi.sib.core.selector.FactoryType;
import com.ibm.wsspi.sib.core.selector.PrivateFactoryType;
import java.util.Collections;
import java.util.Map;

public final class SICoreConnectionFactorySelector {
    private static final String TRACE_MESSAGES = "com.ibm.wsspi.sib.core.selector.Messages";
    private static final String TRACE_GROUP = "SIBCore";
    private static final TraceComponent _tc = SibTr.register(SICoreConnectionFactorySelector.class, (String)"SIBCore", (String)"com.ibm.wsspi.sib.core.selector.Messages");
    private static final TraceNLS _nls = TraceNLS.getTraceNLS((String)"com.ibm.wsspi.sib.core.selector.Messages");

    public static final SICoreConnectionFactory getSICoreConnectionFactory(FactoryType type) throws SIInsufficientDataForFactoryTypeException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"getSICoreConnectionFactory", (Object)type);
        }
        SICoreConnectionFactory factory = null;
        try {
            factory = SICoreConnectionFactorySelector.getSICoreConnectionFactory(type, Collections.EMPTY_MAP);
        }
        catch (SIIncorrectCallException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.wsspi.sib.core.selector.SICoreConnectionFactorySelector.getSICoreConnectionFactory", (String)"126");
            if (TraceComponent.isAnyTracingEnabled() && _tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"rethrowing", (Object)e);
            }
            if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)_tc, (String)"getSICoreConnectionFactory");
            }
            throw e;
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.wsspi.sib.core.selector.SICoreConnectionFactorySelector.getSICoreConnectionFactory", (String)"143");
            if (TraceComponent.isAnyTracingEnabled() && _tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"rethrowing", (Object)e);
            }
            if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)_tc, (String)"getSICoreConnectionFactory");
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"getSICoreConnectionFactory", (Object)factory);
        }
        return factory;
    }

    public static final SICoreConnectionFactory getSICoreConnectionFactory(FactoryType type, Map properties) throws SIInsufficientDataForFactoryTypeException, SIIncorrectCallException, SIResourceException {
        SICoreConnectionFactory factory = null;
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"getSICoreConnectionFactory", (Object)new Object[]{type, properties});
        }
        if (properties == null) {
            properties = Collections.EMPTY_MAP;
        }
        if (type == FactoryType.TRM_CONNECTION) {
            factory = TrmSICoreConnectionFactory.getInstance();
        } else if (type == PrivateFactoryType.LOCAL_CONNECTION) {
            String bus = (String)properties.get("BUS_NAME");
            String me = (String)properties.get("ME_NAME");
            if (bus == null || me == null) {
                String debugMessage;
                String errorMessage;
                if (bus == null && me == null) {
                    errorMessage = _nls.getString("BUS_AND_ME_NAMES_ARE_NULL_CWSJC0001E");
                    debugMessage = "Both the Bus and ME names are null";
                } else if (bus == null) {
                    errorMessage = _nls.getFormattedMessage("BUS_NAME_IS_NULL_CWSJC0002E", new Object[]{me}, null);
                    debugMessage = "The bus name is null";
                } else {
                    errorMessage = _nls.getFormattedMessage("ME_NAME_IS_NULL_CWSJC0003E", new Object[]{bus}, null);
                    debugMessage = "The ME name is null";
                }
                if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)debugMessage);
                }
                SIInsufficientDataForFactoryTypeException newE = new SIInsufficientDataForFactoryTypeException(errorMessage);
                if (TraceComponent.isAnyTracingEnabled() && _tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"throwing", (Object)newE);
                }
                if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)_tc, (String)"getSICoreConnectionFactory");
                }
                throw newE;
            }
            JsAdminService admin = CommonServiceFacade.getJsAdminService();
            if (admin == null) {
                if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"Unable to contact the admin service");
                }
                SIResourceException newE = new SIResourceException(_nls.getFormattedMessage("ADMIN_SERVICE_NULL_CWSJC0004E", new Object[]{bus, me}, null));
                if (TraceComponent.isAnyTracingEnabled() && _tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"throwing", (Object)newE);
                }
                if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)_tc, (String)"getSICoreConnectionFactory");
                }
                throw newE;
            }
            JsMessagingEngine engine = admin.getMessagingEngine(bus, me);
            if (engine == null) {
                if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"Messaging Engine does not exists");
                }
                SIResourceException newE = new SIResourceException(_nls.getFormattedMessage("ME_NOT_FOUND_CWSJC0005E", new Object[]{bus, me}, null));
                if (TraceComponent.isAnyTracingEnabled() && _tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"throwing", (Object)newE);
                }
                if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)_tc, (String)"getSICoreConnectionFactory");
                }
                throw newE;
            }
            factory = (SICoreConnectionFactory)((Object)engine.getMessageProcessor());
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"getSICoreConnectionFactory", (Object)factory);
        }
        return factory;
    }
}

