/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.metadata;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.jaxrs20.metadata.JaxRsServerMetaData;
import com.ibm.ws.jaxrs20.utils.JaxRsUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxRsModuleMetaData {
    private static final TraceComponent tc = Tr.register(JaxRsModuleMetaData.class, null, null);
    private volatile JaxRsServerMetaData serverMetaData;
    private String name;
    private final ClassLoader appContextClassLoader;
    private final J2EEName j2EEName;
    private final Container moduleContainer;
    private final ModuleInfo moduleInfo;
    private Object managedAppRef;
    public static MetaDataSlot jaxrsModuleSlot = null;
    private final List<ModuleMetaData> enclosingModuleMetaDatas = new ArrayList<ModuleMetaData>(2);
    static final long serialVersionUID = -7464020320882459427L;

    public static void setJaxRsModuleMetaData(ModuleMetaData mmd, JaxRsModuleMetaData moduleMetaData) {
        if (mmd != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting ModuleMetaData on ModuleMetaData instance: " + mmd), (Object[])new Object[0]);
            }
            mmd.setMetaData(jaxrsModuleSlot, (Object)moduleMetaData);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Could not set ModuleMetaData because ModuleMetaData is null", (Object[])new Object[0]);
        }
    }

    public static JaxRsModuleMetaData getJaxRsModuleMetaData(ModuleMetaData mmd) {
        if (mmd != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Getting JaxRs module metadata from module metadata instance: " + mmd), (Object[])new Object[0]);
            }
            return (JaxRsModuleMetaData)mmd.getMetaData(jaxrsModuleSlot);
        }
        return null;
    }

    public Object getManagedAppRef() {
        return this.managedAppRef;
    }

    public void setManagedAppRef(Object managedAppRef) {
        this.managedAppRef = managedAppRef;
    }

    public JaxRsModuleMetaData(ModuleMetaData moduleMetaData, Container moduleContainer, ClassLoader appContextClassLoader) {
        this.moduleContainer = moduleContainer;
        this.enclosingModuleMetaDatas.add(moduleMetaData);
        this.j2EEName = moduleMetaData.getJ2EEName();
        this.moduleInfo = JaxRsUtils.getModuleInfo(moduleContainer);
        this.appContextClassLoader = appContextClassLoader;
    }

    public ModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JaxRsServerMetaData getServerMetaData() {
        if (this.serverMetaData == null) {
            JaxRsModuleMetaData jaxRsModuleMetaData = this;
            synchronized (jaxRsModuleMetaData) {
                if (this.serverMetaData == null) {
                    this.serverMetaData = new JaxRsServerMetaData(this);
                }
            }
        }
        return this.serverMetaData;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ClassLoader getAppContextClassLoader() {
        return this.appContextClassLoader;
    }

    public J2EEName getJ2EEName() {
        return this.j2EEName;
    }

    public Container getModuleContainer() {
        return this.moduleContainer;
    }

    public List<ModuleMetaData> getEnclosingModuleMetaDatas() {
        return this.enclosingModuleMetaDatas;
    }

    public void destroy() {
        if (this.serverMetaData != null) {
            this.serverMetaData.destroy();
        }
    }
}

