/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.server.ServerJFapCommunicator;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationAvailability;
import com.ibm.wsspi.sib.core.DestinationListener;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;

public class ServerDestinationListener
extends ServerJFapCommunicator
implements DestinationListener {
    private static String CLASS_NAME = ServerDestinationListener.class.getName();
    private static final TraceComponent tc = SibTr.register(ServerDestinationListener.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private final short id;
    private final short convId;

    public ServerDestinationListener(short id, short convId, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"<init>", (Object)("id=" + id + ",convId=" + convId + ",conversation=" + conversation));
        }
        this.id = id;
        this.convId = convId;
        this.setConversation(conversation);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"<init>");
        }
    }

    public void destinationAvailable(SICoreConnection connection, SIDestinationAddress destinationAddress, DestinationAvailability destinationAvailability) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"destinationAvailable", (Object)new Object[]{connection, destinationAddress, destinationAvailability});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Sending DestinationListener callback for: convId=" + this.convId + ",id=" + this.id));
        }
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.putShort(this.convId);
        request.putShort(this.id);
        request.putSIDestinationAddress(destinationAddress, this.getConversation().getHandshakeProperties().getFapLevel());
        if (destinationAvailability == null) {
            request.putShort((short)-1);
        } else {
            request.putShort((short)destinationAvailability.toInt());
        }
        try {
            this.jfapSend(request, 120, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD);
        }
        catch (SIConnectionLostException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".destinationAvailable"), (String)"3-032-0001", (Object)((Object)this));
        }
        catch (SIConnectionDroppedException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".destinationAvailable"), (String)"3-032-0002", (Object)((Object)this));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"destinationAvailable");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/ServerDestinationListener.java, SIB.comms, WASX.SIB, aa1225.01 1.7");
        }
    }
}

