/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.error;

import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.security.oauth20.web.WebUtils;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class OAuthConfigurationException
extends OAuthException {
    private static final long serialVersionUID = 1L;
    private static final String RESOURCE_BUNDLE = "com.ibm.ws.security.oauth20.resources.ProviderMsgs";
    private static final TraceComponent tc = Tr.register(OAuthConfigurationException.class, (String)"OAUTH20", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    public static final String ERROR_TYPE = "configuration_error";
    private String _configProperty;
    private String _value;
    private String _msgKey;
    private Throwable _cause;

    public OAuthConfigurationException(String configProperty, String value, Throwable cause) {
        super("Error with configuration property: " + configProperty + " value: " + value, cause);
        this._configProperty = configProperty;
        this._value = value;
        this._cause = cause;
    }

    public OAuthConfigurationException(String msgKey, String configProperty, String value, Throwable cause) {
        super(Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])new Object[]{configProperty, value, cause}), cause);
        this._msgKey = msgKey;
        this._configProperty = configProperty;
        this._value = value;
        this._cause = cause;
    }

    public String getConfigProperty() {
        return this._configProperty;
    }

    public String getValue() {
        return this._value;
    }

    @Override
    public String getError() {
        return ERROR_TYPE;
    }

    @Override
    public String formatSelf(Locale locale, String encoding) {
        if (this._msgKey != null) {
            Object[] params = null;
            params = this._cause != null ? new Object[]{WebUtils.encode(this._configProperty, locale, encoding), WebUtils.encode(this._value, locale, encoding), this._cause.getMessage()} : new Object[]{WebUtils.encode(this._configProperty, locale, encoding), WebUtils.encode(this._value, locale, encoding), ""};
            return MessageFormat.format(ResourceBundle.getBundle(RESOURCE_BUNDLE, locale).getString(this._msgKey), params);
        }
        return this.getMessage() + (this._cause != null ? " : " + this._cause.getMessage() : "");
    }
}

