/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins;

import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20DuplicateParameterException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MissingParameterException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.OAuth20Constants;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenHelper;
import com.ibm.oauth.core.internal.oauth20.tokentype.OAuth20TokenTypeHandler;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.token.propagation.TokenPropagationHelper;
import com.ibm.ws.security.oauth20.ProvidersService;
import com.ibm.ws.security.oauth20.api.OAuth20EnhancedTokenCache;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.plugins.OAuth20BearerTokenImpl;
import com.ibm.ws.security.oauth20.plugins.OAuth20TokenImpl;
import com.ibm.ws.security.oauth20.plugins.jose4j.JWTData;
import com.ibm.ws.security.oauth20.plugins.jose4j.JwtCreator;
import com.ibm.ws.security.oauth20.util.ConfigUtils;
import com.ibm.ws.security.oauth20.util.HashUtils;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import com.ibm.wsspi.security.oauth20.JwtAccessTokenMediator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BaseTokenHandler
implements OAuth20TokenTypeHandler {
    private static TraceComponent tc = Tr.register(BaseTokenHandler.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    static final String CLASS = BaseTokenHandler.class.getName();
    private static Logger _log = Logger.getLogger(CLASS);
    static final long serialVersionUID = 2992077889587838509L;

    @Override
    public void init(OAuthComponentConfiguration config) {
    }

    @Override
    public String getTypeTokenType() {
        return "Bearer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public OAuth20Token createToken(Map<String, String[]> tokenMap) {
        String methodName = "createToken";
        _log.entering(CLASS, methodName);
        OAuth20BearerTokenImpl token = null;
        try {
            String tokenId;
            String grantType;
            String clientId = OAuth20Util.getValueFromMap("client_id", tokenMap);
            String componentId = OAuth20Util.getValueFromMap("COMPONENTID", tokenMap);
            String username = OAuth20Util.getValueFromMap("username", tokenMap);
            String redirectUri = OAuth20Util.getValueFromMap("redirect_uri", tokenMap);
            String[] scope = tokenMap.get("scope");
            int length = 0;
            int lifetime = 0;
            String lengthStr = OAuth20Util.getValueFromMap("LENGTH", tokenMap);
            length = Integer.parseInt(lengthStr);
            String lifeStr = OAuth20Util.getValueFromMap("LIFETIME", tokenMap);
            lifetime = Integer.parseInt(lifeStr);
            String stateId = OAuth20Util.getValueFromMap("state_id", tokenMap);
            if (stateId == null) {
                stateId = OAuth20Util.generateUUID();
            }
            boolean isAppPasswordOrTokenGT = "app_password".equals(grantType = OAuth20Util.getValueFromMap("grant_type", tokenMap)) || "app_token".equals(grantType);
            Map<String, String[]> externalClaims = OAuth20TokenHelper.getExternalClaims(tokenMap);
            if (isAppPasswordOrTokenGT) {
                length += 2;
            }
            String tokenContent = tokenId = OAuth20Util.getRandom(length);
            OidcServerConfig oidcServerConfig = ConfigUtils.getOidcServerConfigForOAuth20Provider(componentId);
            OAuth20Provider oauth20Provider = ProvidersService.getOAuth20Provider(componentId);
            if (oidcServerConfig != null && oauth20Provider != null && !isAppPasswordOrTokenGT) {
                boolean jwtAccessToken = oauth20Provider.isJwtAccessToken();
                boolean jwtSpi = this.isJwtMediatorSpi();
                String jsonFromSpi = null;
                Subject priorSubject = null;
                boolean subjectPushed = false;
                if (jwtSpi) {
                    BaseTokenHandler baseTokenHandler = this;
                    synchronized (baseTokenHandler) {
                        try {
                            priorSubject = TokenPropagationHelper.getRunAsSubject();
                            subjectPushed = TokenPropagationHelper.pushSubject((String)username);
                            jsonFromSpi = this.getJwtFromMediatorSpi(tokenMap);
                        }
                        finally {
                            if (subjectPushed) {
                                TokenPropagationHelper.setRunAsSubject((Subject)priorSubject);
                            }
                        }
                    }
                    if (jsonFromSpi != null) {
                        JWTData jwtData = this.getJwtData(tokenMap, oidcServerConfig);
                        tokenContent = JwtCreator.createJwtAsStringForSpi(jsonFromSpi, oidcServerConfig, clientId, username, scope, lifetime, tokenMap, grantType, null, jwtData);
                        tokenId = HashUtils.digest(tokenContent);
                    }
                } else if (jwtAccessToken) {
                    JWTData jwtData = this.getJwtData(tokenMap, oidcServerConfig);
                    tokenContent = JwtCreator.createJwtAsString(oidcServerConfig, clientId, username, scope, lifetime, tokenMap, null, jwtData, oauth20Provider.isMpJwt());
                    tokenId = HashUtils.digest(tokenContent);
                }
            }
            if ((token = new OAuth20BearerTokenImpl(tokenId, tokenContent, componentId, clientId, username, redirectUri, stateId, scope, lifetime, externalClaims, grantType)) != null) {
                this.updateAccessToken(token, tokenMap, componentId);
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return token;
    }

    private JWTData getJwtData(Map<String, String[]> tokenMap, OidcServerConfig oidcServerConfig) {
        String sharedKey = OAuth20Util.getValueFromMap("client_secret", tokenMap);
        return new JWTData(sharedKey, oidcServerConfig, "Json Web Token");
    }

    boolean isJwtMediatorSpi() {
        if (ConfigUtils.getJwtAccessTokenMediatorService().size() > 0) {
            if (OAuth20Constants.JAVA_VERSION_6) {
                Tr.warning((TraceComponent)tc, (String)"JWT_MEDIATOR_SPI_REQUIRES_JDK", (Object[])new Object[]{OAuth20Constants.JAVA_VERSION});
                return false;
            }
            return true;
        }
        return false;
    }

    protected String getJwtFromMediatorSpi(Map<String, String[]> tokenMap) {
        String jwtStr = null;
        Iterator jwtMediators = ConfigUtils.getJwtAccessTokenMediatorService().getServices();
        if (jwtMediators.hasNext()) {
            JwtAccessTokenMediator jwtMediator = (JwtAccessTokenMediator)jwtMediators.next();
            jwtStr = jwtMediator.mediateToken(tokenMap);
        }
        return jwtStr;
    }

    protected void updateAccessToken(OAuth20Token token, Map<String, String[]> accessTokenMap, String componentId) {
        if (accessTokenMap.containsKey("refresh_key")) {
            String refreshId = OAuth20Util.getValueFromMap("refresh_key", accessTokenMap);
            ((OAuth20TokenImpl)token).setRefreshTokenKey(refreshId);
            if (accessTokenMap.containsKey("old_refresh_key")) {
                String oldrefreshId = OAuth20Util.getValueFromMap("old_refresh_key", accessTokenMap);
                if (refreshId != null && !refreshId.equals(oldrefreshId)) {
                    this.updateExistingAccessTokens(componentId, refreshId, accessTokenMap);
                }
            }
        }
    }

    protected void updateExistingAccessTokens(String componentId, String refreshid, Map<String, String[]> tokenMap) {
        OAuth20Provider provider = ProvidersService.getOAuth20Provider(componentId);
        if (provider != null && provider.getTokenCache() != null) {
            OAuth20EnhancedTokenCache cache = provider.getTokenCache();
            String username = OAuth20Util.getValueFromMap("username", tokenMap);
            String clientId = OAuth20Util.getValueFromMap("client_id", tokenMap);
            if (username != null && clientId != null) {
                Collection<OAuth20Token> tokens = cache.getAllUserTokens(username);
                for (OAuth20Token token : tokens) {
                    if ("app_password".equals(token.getGrantType()) || !"access_token".equals(token.getType()) || !clientId.equals(token.getClientId())) continue;
                    ((OAuth20TokenImpl)token).setRefreshTokenKey(refreshid);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public List<String> getKeysTokenType(AttributeList attributeList) throws OAuthException {
        String methodName = "getKeysTokenType";
        _log.entering(CLASS, methodName);
        ArrayList<String> tokenKeys = null;
        try {
            String token = attributeList.getAttributeValueByName("access_token");
            if (token == null || token.length() <= 0) {
                throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "access_token", null);
            }
            tokenKeys = new ArrayList<String>();
            tokenKeys.add(token);
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return tokenKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public void validateRequestTokenType(AttributeList attributeList, List<OAuth20Token> tokens) throws OAuthException {
        String methodName = "validateRequestTokenType";
        _log.entering(CLASS, methodName);
        try {
            String[] tokenArray = attributeList.getAttributeValuesByName("access_token");
            if (tokenArray != null && tokenArray.length > 1) {
                throw new OAuth20DuplicateParameterException("security.oauth20.error.duplicate.parameter", "access_token");
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public void buildResponseTokenType(AttributeList attributeList, List<OAuth20Token> tokens) {
        String methodName = "buildResponseTokenType";
        _log.entering(CLASS, methodName);
        try {
            OAuth20Token token;
            if (tokens.size() >= 1 && (token = tokens.get(0)) != null) {
                attributeList.setAttribute("expires", "urn:ibm:names:oauth:response:decision", new String[]{OAuth20TokenHelper.expiresUTC(token)});
                attributeList.setAttribute("username", "urn:ibm:names:oauth:response:attribute", new String[]{token.getUsername()});
                attributeList.setAttribute("access_token", "urn:ibm:names:oauth:response:attribute", new String[]{token.getTokenString()});
                attributeList.setAttribute("access_token_id", "urn:ibm:names:oauth:response:metadata", new String[]{token.getId()});
                attributeList.setAttribute("oauth_token_client_id", "urn:ibm:names:oauth:response:attribute", new String[]{token.getClientId()});
                attributeList.setAttribute("state_id", "urn:ibm:names:oauth:state", new String[]{token.getStateId()});
                String[] scope = token.getScope();
                if (scope != null) {
                    attributeList.setAttribute("scope", "urn:ibm:names:oauth:response:attribute", scope);
                }
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
    }
}

