/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.catalog.OASISCatalogManagerHelper;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.frontend.WSDLGetInterceptor;
import org.apache.cxf.frontend.WSDLQueryException;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.ResourceManagerWSDLLocator;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class WSDLGetUtils {
    public static final String AUTO_REWRITE_ADDRESS = "autoRewriteSoapAddress";
    public static final String AUTO_REWRITE_ADDRESS_ALL = "autoRewriteSoapAddressForAllServices";
    public static final String PUBLISHED_ENDPOINT_URL = "publishedEndpointUrl";
    public static final String WSDL_CREATE_IMPORTS = "org.apache.cxf.wsdl.create.imports";
    private static final String WSDLS_KEY = WSDLGetUtils.class.getName() + ".WSDLs";
    private static final String SCHEMAS_KEY = WSDLGetUtils.class.getName() + ".Schemas";
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLGetInterceptor.class);
    static final long serialVersionUID = -3808758553540153846L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSDLGetUtils() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.frontend.WSDLGetUtils", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getWSDLIds(Message message, String base, String ctxUri, EndpointInfo endpointInfo) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.frontend.WSDLGetUtils", "getWSDLIds", new Object[]{message, base, ctxUri, endpointInfo});
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("wsdl", "");
        new WSDLGetUtils().getDocument(message, base, params, ctxUri, endpointInfo);
        Map mp = CastUtils.cast((Map)((Map)endpointInfo.getService().getProperty(WSDLS_KEY)));
        Set<String> set = mp.keySet();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "getWSDLIds", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String buildUrl(String base, String ctxUri, String s) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.frontend.WSDLGetUtils", "buildUrl", new Object[]{base, ctxUri, s});
        }
        String string = base + ctxUri + "?" + s;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "buildUrl", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, String> getSchemaLocations(Message message, String base, String ctxUri, EndpointInfo endpointInfo) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.frontend.WSDLGetUtils", "getSchemaLocations", new Object[]{message, base, ctxUri, endpointInfo});
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("wsdl", "");
        new WSDLGetUtils().getDocument(message, base, params, ctxUri, endpointInfo);
        Map mp = CastUtils.cast((Map)((Map)endpointInfo.getService().getProperty(SCHEMAS_KEY)));
        HashMap<String, String> schemas = new HashMap<String, String>();
        for (Map.Entry ent : mp.entrySet()) {
            params.clear();
            params.put("xsd", (String)ent.getKey());
            Document doc = this.getDocument(message, base, params, ctxUri, endpointInfo);
            schemas.put(doc.getDocumentElement().getAttribute("targetNamespace"), this.buildUrl(base, ctxUri, "xsd=" + (String)ent.getKey()));
        }
        HashMap<String, String> hashMap = schemas;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashMap = hashMap;
            LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "getSchemaLocations", hashMap);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Document getDocument(Message message, String base, Map<String, String> params, String ctxUri, EndpointInfo endpointInfo) {
        Document document;
        block22: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.frontend.WSDLGetUtils", "getDocument", new Object[]{message, base, params, ctxUri, endpointInfo});
            }
            try {
                Document doc;
                Definition def;
                String xsd;
                String wsdl;
                Bus bus = message.getExchange().getBus();
                Object prop = message.getContextualProperty(PUBLISHED_ENDPOINT_URL);
                if (prop == null) {
                    prop = endpointInfo.getProperty(PUBLISHED_ENDPOINT_URL);
                }
                if (prop != null) {
                    base = String.valueOf(prop);
                }
                if ((wsdl = params.get("wsdl")) != null) {
                    wsdl = URLDecoder.decode(wsdl, "utf-8");
                }
                if ((xsd = params.get("xsd")) != null) {
                    xsd = URLDecoder.decode(xsd, "utf-8");
                }
                Map mp = CastUtils.cast((Map)((Map)endpointInfo.getService().getProperty(WSDLS_KEY)));
                Map smp = CastUtils.cast((Map)((Map)endpointInfo.getService().getProperty(SCHEMAS_KEY)));
                if (mp == null) {
                    endpointInfo.getService().setProperty(WSDLS_KEY, new ConcurrentHashMap(8, 0.75f, 4));
                    mp = CastUtils.cast((Map)((Map)endpointInfo.getService().getProperty(WSDLS_KEY)));
                }
                if (smp == null) {
                    endpointInfo.getService().setProperty(SCHEMAS_KEY, new ConcurrentHashMap(8, 0.75f, 4));
                    smp = CastUtils.cast((Map)((Map)endpointInfo.getService().getProperty(SCHEMAS_KEY)));
                }
                if (!mp.containsKey("")) {
                    ServiceWSDLBuilder builder = new ServiceWSDLBuilder(bus, new ServiceInfo[]{endpointInfo.getService()});
                    builder.setUseSchemaImports(MessageUtils.getContextualBoolean((Message)message, (String)WSDL_CREATE_IMPORTS, (boolean)false));
                    builder.setBaseFileName(endpointInfo.getService().getName().getLocalPart());
                    def = builder.build(new HashMap());
                    mp.put("", def);
                    this.updateDefinition(bus, def, mp, smp, base, endpointInfo);
                }
                if (xsd == null) {
                    Object wsdl2;
                    def = (Definition)mp.get(wsdl);
                    if (def == null && (wsdl2 = this.resolveWithCatalogs(OASISCatalogManager.getCatalogManager((Bus)bus), wsdl, base)) != null) {
                        def = (Definition)mp.get(wsdl2);
                    }
                    if (def == null) {
                        throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("WSDL_NOT_FOUND", LOG, new Object[]{wsdl}), null);
                    }
                    wsdl2 = def;
                    synchronized (wsdl2) {
                        if (endpointInfo.getProperty(PUBLISHED_ENDPOINT_URL) != null) {
                            String epurl = String.valueOf(endpointInfo.getProperty(PUBLISHED_ENDPOINT_URL));
                            this.updatePublishedEndpointUrl(epurl, def, endpointInfo.getName());
                            base = epurl;
                        }
                        WSDLWriter wsdlWriter = ((WSDLManager)bus.getExtension(WSDLManager.class)).getWSDLFactory().newWSDLWriter();
                        def.setExtensionRegistry(((WSDLManager)bus.getExtension(WSDLManager.class)).getExtensionRegistry());
                        doc = wsdlWriter.getDocument(def);
                    }
                } else {
                    ResourceManagerWSDLLocator rml;
                    InputSource src;
                    String xsd2;
                    SchemaReference si = (SchemaReference)smp.get(xsd);
                    if (si == null && (xsd2 = this.resolveWithCatalogs(OASISCatalogManager.getCatalogManager((Bus)bus), xsd, base)) != null) {
                        si = (SchemaReference)smp.get(xsd2);
                    }
                    if (si == null) {
                        throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("SCHEMA_NOT_FOUND", LOG, new Object[]{wsdl}), null);
                    }
                    String uri = si.getReferencedSchema().getDocumentBaseURI();
                    uri = this.resolveWithCatalogs(OASISCatalogManager.getCatalogManager((Bus)bus), uri, si.getReferencedSchema().getDocumentBaseURI());
                    if (uri == null) {
                        uri = si.getReferencedSchema().getDocumentBaseURI();
                    }
                    doc = (src = (rml = new ResourceManagerWSDLLocator(uri, bus)).getBaseInputSource()).getByteStream() != null || src.getCharacterStream() != null ? StaxUtils.read((InputSource)src) : StaxUtils.read((Source)new DOMSource(si.getReferencedSchema().getElement().getOwnerDocument()));
                }
                this.updateDoc(doc, base, mp, smp, message);
                document = doc;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block22;
            }
            catch (WSDLQueryException wex) {
                throw wex;
            }
            catch (Exception wex) {
                throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, new Object[]{base}), wex);
            }
            document = document;
            LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "getDocument", document);
        }
        return document;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String mapUri(String base, Map<String, SchemaReference> smp, String loc) throws UnsupportedEncodingException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.frontend.WSDLGetUtils", "mapUri", new Object[]{base, smp, loc});
        }
        SchemaReference ref = smp.get(URLDecoder.decode(loc, "utf-8"));
        if (ref != null) {
            String string = base + "?xsd=" + ref.getSchemaLocationURI().replace(" ", "%20");
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "mapUri", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "mapUri", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void updateDoc(Document doc, String base, Map<String, Definition> mp, Map<String, SchemaReference> smp, Message message) {
        Object rewriteSoapAddress;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.frontend.WSDLGetUtils", "updateDoc", new Object[]{doc, base, mp, smp, message});
        }
        List elementList = null;
        try {
            String sl;
            elementList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://www.w3.org/2001/XMLSchema", (String)"import");
            for (Element el : elementList) {
                sl = el.getAttribute("schemaLocation");
                if ((sl = this.mapUri(base, smp, sl)) == null) continue;
                el.setAttribute("schemaLocation", sl);
            }
            elementList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://www.w3.org/2001/XMLSchema", (String)"include");
            for (Element el : elementList) {
                sl = el.getAttribute("schemaLocation");
                if (!smp.containsKey(URLDecoder.decode(sl, "utf-8"))) continue;
                el.setAttribute("schemaLocation", base + "?xsd=" + sl.replace(" ", "%20"));
            }
            elementList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://www.w3.org/2001/XMLSchema", (String)"redefine");
            for (Element el : elementList) {
                sl = el.getAttribute("schemaLocation");
                if (!smp.containsKey(URLDecoder.decode(sl, "utf-8"))) continue;
                el.setAttribute("schemaLocation", base + "?xsd=" + sl.replace(" ", "%20"));
            }
            elementList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://schemas.xmlsoap.org/wsdl/", (String)"import");
            for (Element el : elementList) {
                sl = el.getAttribute("location");
                if (!mp.containsKey(URLDecoder.decode(sl, "utf-8"))) continue;
                el.setAttribute("location", base + "?wsdl=" + sl.replace(" ", "%20"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, new Object[]{base}), e);
        }
        boolean rewriteAllSoapAddress = MessageUtils.isTrue((Object)message.getContextualProperty(AUTO_REWRITE_ADDRESS_ALL));
        if (rewriteAllSoapAddress) {
            List portList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://schemas.xmlsoap.org/wsdl/", (String)"port");
            String basePath = (String)message.get((Object)"http.base.path");
            for (Element el : portList) {
                this.rewriteAddressProtocolHostPort(base, el, basePath, "http://schemas.xmlsoap.org/wsdl/soap/");
                this.rewriteAddressProtocolHostPort(base, el, basePath, "http://schemas.xmlsoap.org/wsdl/soap12/");
            }
        }
        if ((rewriteSoapAddress = message.getContextualProperty(AUTO_REWRITE_ADDRESS)) == null || MessageUtils.isTrue((Object)rewriteSoapAddress) || rewriteAllSoapAddress) {
            List serviceList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://schemas.xmlsoap.org/wsdl/", (String)"service");
            for (Element serviceEl : serviceList) {
                String serviceName = serviceEl.getAttribute("name");
                if (!serviceName.equals(message.getExchange().getService().getName().getLocalPart())) continue;
                elementList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://schemas.xmlsoap.org/wsdl/", (String)"port");
                for (Element el : elementList) {
                    String name = el.getAttribute("name");
                    if (!name.equals(message.getExchange().getEndpoint().getEndpointInfo().getName().getLocalPart())) continue;
                    this.rewriteAddress(base, el, "http://schemas.xmlsoap.org/wsdl/soap/");
                    this.rewriteAddress(base, el, "http://schemas.xmlsoap.org/wsdl/soap12/");
                }
            }
        }
        try {
            doc.setXmlStandalone(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "updateDoc");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void rewriteAddress(String base, Element el, String soapNS) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.frontend.WSDLGetUtils", "rewriteAddress", new Object[]{base, el, soapNS});
        }
        List sadEls = DOMUtils.findAllElementsByTagNameNS((Element)el, (String)soapNS, (String)"address");
        for (Element soapAddress : sadEls) {
            soapAddress.setAttribute("location", base);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "rewriteAddress");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void rewriteAddressProtocolHostPort(String base, Element el, String httpBasePathProp, String soapNS) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.frontend.WSDLGetUtils", "rewriteAddressProtocolHostPort", new Object[]{base, el, httpBasePathProp, soapNS});
        }
        List sadEls = DOMUtils.findAllElementsByTagNameNS((Element)el, (String)soapNS, (String)"address");
        for (Element soapAddress : sadEls) {
            String location = soapAddress.getAttribute("location").trim();
            try {
                URI locUri = new URI(location);
                if (locUri.isAbsolute()) {
                    URL baseUrl = new URL(base);
                    StringBuilder sb = new StringBuilder(baseUrl.getProtocol());
                    sb.append("://").append(baseUrl.getHost()).append(":").append(baseUrl.getPort()).append(locUri.getPath());
                    soapAddress.setAttribute("location", sb.toString());
                    continue;
                }
                if (httpBasePathProp == null) continue;
                soapAddress.setAttribute("location", httpBasePathProp + location);
            }
            catch (Exception exception) {}
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "rewriteAddressProtocolHostPort");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String resolveWithCatalogs(OASISCatalogManager catalogs, String start, String base) {
        String string;
        block4: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.frontend.WSDLGetUtils", "resolveWithCatalogs", new Object[]{catalogs, start, base});
            }
            try {
                string = new OASISCatalogManagerHelper().resolve(catalogs, start, base);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block4;
            }
            catch (Exception exception) {
                String string2 = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    string2 = string2;
                    LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "resolveWithCatalogs", string2);
                }
                return string2;
            }
            string = string;
            LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "resolveWithCatalogs", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void updateDefinition(Bus bus, Definition def, Map<String, Definition> done, Map<String, SchemaReference> doneSchemas, String base, EndpointInfo ei) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.frontend.WSDLGetUtils", "updateDefinition", new Object[]{bus, def, done, doneSchemas, base, ei});
        }
        OASISCatalogManager catalogs = OASISCatalogManager.getCatalogManager((Bus)bus);
        Collection imports = CastUtils.cast(def.getImports().values());
        for (List lst : imports) {
            List impLst = CastUtils.cast((List)lst);
            for (Import imp : impLst) {
                String start = imp.getLocationURI();
                String decodedStart = null;
                try {
                    decodedStart = URLDecoder.decode(start, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, new Object[]{start}), e);
                }
                String resolvedSchemaLocation = this.resolveWithCatalogs(catalogs, start, base);
                if (resolvedSchemaLocation == null) {
                    try {
                        new URL(start);
                    }
                    catch (MalformedURLException e) {
                        if (done.put(decodedStart, imp.getDefinition()) != null) continue;
                        this.updateDefinition(bus, imp.getDefinition(), done, doneSchemas, base, ei);
                    }
                    continue;
                }
                if (done.put(decodedStart, imp.getDefinition()) != null) continue;
                done.put(resolvedSchemaLocation, imp.getDefinition());
                this.updateDefinition(bus, imp.getDefinition(), done, doneSchemas, base, ei);
            }
        }
        Types types = def.getTypes();
        if (types != null) {
            for (ExtensibilityElement el : CastUtils.cast((List)types.getExtensibilityElements(), ExtensibilityElement.class)) {
                if (!(el instanceof Schema)) continue;
                Schema see = (Schema)el;
                this.updateSchemaImports(bus, see, doneSchemas, base);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "updateDefinition");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateWSDLPublishedEndpointAddress(Definition def, EndpointInfo endpointInfo) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.frontend.WSDLGetUtils", "updateWSDLPublishedEndpointAddress", new Object[]{def, endpointInfo});
        }
        Definition definition = def;
        synchronized (definition) {
            if (endpointInfo.getProperty(PUBLISHED_ENDPOINT_URL) != null) {
                String epurl = String.valueOf(endpointInfo.getProperty(PUBLISHED_ENDPOINT_URL));
                this.updatePublishedEndpointUrl(epurl, def, endpointInfo.getName());
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "updateWSDLPublishedEndpointAddress");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void updatePublishedEndpointUrl(String publishingUrl, Definition def, QName name) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.frontend.WSDLGetUtils", "updatePublishedEndpointUrl", new Object[]{publishingUrl, def, name});
        }
        Collection services = CastUtils.cast(def.getAllServices().values());
        for (Service service : services) {
            Collection ports = CastUtils.cast(service.getPorts().values());
            if (ports.isEmpty()) continue;
            if (name == null) {
                this.setSoapAddressLocationOn((Port)ports.iterator().next(), publishingUrl);
                break;
            }
            for (Port port : ports) {
                if (!name.getLocalPart().equals(port.getName())) continue;
                this.setSoapAddressLocationOn(port, publishingUrl);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "updatePublishedEndpointUrl");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setSoapAddressLocationOn(Port port, String url) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.frontend.WSDLGetUtils", "setSoapAddressLocationOn", new Object[]{port, url});
        }
        List extensions = port.getExtensibilityElements();
        for (Object extension : extensions) {
            if (extension instanceof SOAP12Address) {
                ((SOAP12Address)extension).setLocationURI(url);
                continue;
            }
            if (!(extension instanceof SOAPAddress)) continue;
            ((SOAPAddress)extension).setLocationURI(url);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "setSoapAddressLocationOn");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void updateSchemaImports(Bus bus, Schema schema, Map<String, SchemaReference> doneSchemas, String base) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.frontend.WSDLGetUtils", "updateSchemaImports", new Object[]{bus, schema, doneSchemas, base});
        }
        OASISCatalogManager catalogs = OASISCatalogManager.getCatalogManager((Bus)bus);
        Collection imports = CastUtils.cast(schema.getImports().values());
        for (Object lst : imports) {
            List impLst = CastUtils.cast((List)lst);
            for (SchemaImport imp : impLst) {
                String start = this.findSchemaLocation(doneSchemas, (SchemaReference)imp);
                if (start == null) continue;
                String decodedStart = null;
                try {
                    decodedStart = URLDecoder.decode(start, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, new Object[]{start}), e);
                }
                if (doneSchemas.containsKey(decodedStart)) continue;
                String resolvedSchemaLocation = this.resolveWithCatalogs(catalogs, start, base);
                if (resolvedSchemaLocation == null) {
                    try {
                        new URL(start);
                    }
                    catch (MalformedURLException e) {
                        if (doneSchemas.put(decodedStart, (SchemaReference)imp) != null) continue;
                        this.updateSchemaImports(bus, imp.getReferencedSchema(), doneSchemas, base);
                    }
                    continue;
                }
                if (doneSchemas.put(decodedStart, (SchemaReference)imp) != null) continue;
                doneSchemas.put(resolvedSchemaLocation, (SchemaReference)imp);
                this.updateSchemaImports(bus, imp.getReferencedSchema(), doneSchemas, base);
            }
        }
        List includes = CastUtils.cast((List)schema.getIncludes());
        for (SchemaReference included : includes) {
            String start = this.findSchemaLocation(doneSchemas, included);
            if (start == null) continue;
            String decodedStart = null;
            try {
                decodedStart = URLDecoder.decode(start, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, new Object[]{start}), e);
            }
            String resolvedSchemaLocation = this.resolveWithCatalogs(catalogs, start, base);
            if (resolvedSchemaLocation == null) {
                if (doneSchemas.containsKey(decodedStart)) continue;
                try {
                    new URL(start);
                }
                catch (MalformedURLException e) {
                    if (doneSchemas.put(decodedStart, included) != null) continue;
                    this.updateSchemaImports(bus, included.getReferencedSchema(), doneSchemas, base);
                }
                continue;
            }
            if (doneSchemas.containsKey(decodedStart) && doneSchemas.containsKey(resolvedSchemaLocation)) continue;
            doneSchemas.put(decodedStart, included);
            doneSchemas.put(resolvedSchemaLocation, included);
            this.updateSchemaImports(bus, included.getReferencedSchema(), doneSchemas, base);
        }
        List redefines = CastUtils.cast((List)schema.getRedefines());
        for (SchemaReference included : redefines) {
            String start = this.findSchemaLocation(doneSchemas, included);
            if (start == null) continue;
            String decodedStart = null;
            try {
                decodedStart = URLDecoder.decode(start, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, new Object[]{start}), e);
            }
            String resolvedSchemaLocation = this.resolveWithCatalogs(catalogs, start, base);
            if (resolvedSchemaLocation == null) {
                if (doneSchemas.containsKey(decodedStart)) continue;
                try {
                    new URL(start);
                }
                catch (MalformedURLException e) {
                    if (doneSchemas.put(decodedStart, included) != null) continue;
                    this.updateSchemaImports(bus, included.getReferencedSchema(), doneSchemas, base);
                }
                continue;
            }
            if (doneSchemas.containsKey(decodedStart) && doneSchemas.containsKey(resolvedSchemaLocation)) continue;
            doneSchemas.put(decodedStart, included);
            doneSchemas.put(resolvedSchemaLocation, included);
            this.updateSchemaImports(bus, included.getReferencedSchema(), doneSchemas, base);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "updateSchemaImports");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String findSchemaLocation(Map<String, SchemaReference> doneSchemas, SchemaReference imp) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.frontend.WSDLGetUtils", "findSchemaLocation", new Object[]{doneSchemas, imp});
        }
        if (imp.getReferencedSchema() != null) {
            for (Map.Entry<String, SchemaReference> e : doneSchemas.entrySet()) {
                if (e.getValue().getReferencedSchema().getElement() != imp.getReferencedSchema().getElement()) continue;
                doneSchemas.put(imp.getSchemaLocationURI(), imp);
                imp.setSchemaLocationURI(e.getKey());
                String string = e.getKey();
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    string = string;
                    LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "findSchemaLocation", string);
                }
                return string;
            }
        }
        String string = imp.getSchemaLocationURI();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.frontend.WSDLGetUtils", "findSchemaLocation", string);
        }
        return string;
    }
}

