/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.EJBPMICollaborator;
import com.ibm.ws.ejbcontainer.util.Pool;
import com.ibm.ws.ejbcontainer.util.PoolDiscardStrategy;
import com.ibm.ws.ejbcontainer.util.PoolImplBase;
import com.ibm.ws.ejbcontainer.util.PoolImplThreadSafe;
import com.ibm.ws.ejbcontainer.util.PoolManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class PoolManagerImpl
extends PoolManager
implements Runnable {
    private static final TraceComponent tc = Tr.register(PoolManagerImpl.class, (String)"EJBContainer", null);
    private final List<PoolImplBase> pools = new ArrayList<PoolImplBase>();
    private PoolImplBase[] poolArray = new PoolImplBase[10];
    private volatile long drainInterval = 30000L;
    private ScheduledFuture<?> ivScheduledFuture;
    private ScheduledExecutorService ivScheduledExecutorService;
    private boolean ivIsCanceled = false;
    private boolean ivIsRunning;

    @Override
    public void setDrainInterval(long di) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Setting drain interval to: " + di), (Object[])new Object[0]);
        }
        this.drainInterval = di;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"run", (Object[])new Object[0]);
        }
        PoolManagerImpl poolManagerImpl = this;
        synchronized (poolManagerImpl) {
            if (this.ivIsCanceled) {
                return;
            }
            this.ivIsRunning = true;
            int numPools = this.pools.size();
            if (numPools > 0) {
                if (numPools > this.poolArray.length) {
                    this.poolArray = new PoolImplBase[numPools];
                }
                this.pools.toArray(this.poolArray);
            }
        }
        try {
            for (int i = 0; i < this.poolArray.length && this.poolArray[i] != null; ++i) {
                if (this.poolArray[i].inactive) {
                    this.poolArray[i].periodicDrain();
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("setting inactive: " + this.poolArray[i]), (Object[])new Object[0]);
                    }
                    this.poolArray[i].inactive = true;
                }
                this.poolArray[i] = null;
            }
        }
        finally {
            PoolManagerImpl poolManagerImpl2 = this;
            synchronized (poolManagerImpl2) {
                this.ivIsRunning = false;
                if (this.ivIsCanceled) {
                    this.notify();
                } else if (!this.pools.isEmpty()) {
                    this.startAlarm();
                } else {
                    this.ivScheduledFuture = null;
                }
            }
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"run");
        }
    }

    synchronized void add(PoolImplBase p) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("add: " + p), (Object[])new Object[0]);
        }
        if (!this.ivIsCanceled) {
            if (this.pools.isEmpty()) {
                this.startAlarm();
            }
            this.pools.add(p);
        }
    }

    synchronized void remove(Pool p) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("remove: " + p), (Object[])new Object[0]);
        }
        this.pools.remove(p);
        if (this.pools.isEmpty()) {
            this.stopAlarm();
        }
    }

    @Override
    public Pool createThreadSafePool(int minimum, int maximum) {
        PoolImplThreadSafe result = new PoolImplThreadSafe(minimum, maximum, null, null, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createThreadSafePool: " + result), (Object[])new Object[0]);
        }
        return result;
    }

    @Override
    public Pool createThreadSafePool(int minimum, int maximum, EJBPMICollaborator beanPerf) {
        PoolImplThreadSafe result = new PoolImplThreadSafe(minimum, maximum, beanPerf, null, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createThreadSafePool: " + result), (Object[])new Object[0]);
        }
        return result;
    }

    @Override
    public Pool create(int minimum, int maximum, EJBPMICollaborator beanPerf, PoolDiscardStrategy d) {
        PoolImplThreadSafe result = new PoolImplThreadSafe(minimum, maximum, beanPerf, d, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("create: " + result), (Object[])new Object[0]);
        }
        return result;
    }

    private void startAlarm() {
        this.ivScheduledFuture = this.ivScheduledExecutorService.schedule(this, this.drainInterval, TimeUnit.MILLISECONDS);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("started alarm: " + this.ivScheduledFuture), (Object[])new Object[0]);
        }
    }

    private void stopAlarm() {
        if (this.ivScheduledFuture != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("stopping alarm: " + this.ivScheduledFuture), (Object[])new Object[0]);
            }
            this.ivScheduledFuture.cancel(false);
            this.ivScheduledFuture = null;
        }
    }

    @Override
    public synchronized void cancel() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"cancel", (Object[])new Object[0]);
        }
        this.ivIsCanceled = true;
        this.stopAlarm();
        while (this.ivIsRunning) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"cancel: interrupted", (Object[])new Object[]{ex});
                }
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutor) {
        this.ivScheduledExecutorService = scheduledExecutor;
    }
}

