/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.factory;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.WSDLException;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.apache.cxf.BusException;
import org.apache.cxf.annotations.EvaluateAllEndpoints;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.catalog.CatalogXmlSchemaURIResolver;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.common.xmlschema.XmlSchemaUtils;
import org.apache.cxf.common.xmlschema.XmlSchemaValidationManager;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.source.mime.MimeAttribute;
import org.apache.cxf.databinding.source.mime.MimeSerializer;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.endpoint.ServiceContractResolverRegistry;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.MethodComparator;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.FaultOutInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.ServiceImpl;
import org.apache.cxf.service.ServiceModelSchemaValidator;
import org.apache.cxf.service.factory.AbstractServiceConfiguration;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.factory.DefaultServiceConfiguration;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.factory.SimpleMethodDispatcher;
import org.apache.cxf.service.factory.WSDLBasedServiceConfiguration;
import org.apache.cxf.service.invoker.Factory;
import org.apache.cxf.service.invoker.FactoryInvoker;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.invoker.SingletonFactory;
import org.apache.cxf.service.model.AbstractMessageContainer;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.UnwrappedOperationInfo;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;
import org.apache.cxf.wsdl11.WSDLServiceFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;
import org.apache.ws.commons.schema.extensions.ExtensionSerializer;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class ReflectionServiceFactoryBean
extends AbstractServiceFactoryBean {
    public static final String ENDPOINT_CLASS = "endpoint.class";
    public static final String GENERIC_TYPE = "generic.type";
    public static final String RAW_CLASS = "rawclass";
    public static final String WRAPPERGEN_NEEDED = "wrapper.gen.needed";
    public static final String EXTRA_CLASS = "extra.class";
    public static final String MODE_OUT = "messagepart.mode.out";
    public static final String MODE_INOUT = "messagepart.mode.inout";
    public static final String HOLDER = "messagepart.isholder";
    public static final String HEADER = "messagepart.isheader";
    public static final String ELEMENT_NAME = "messagepart.elementName";
    public static final String METHOD = "operation.method";
    public static final String FORCE_TYPES = "operation.force.types";
    public static final String METHOD_PARAM_ANNOTATIONS = "method.parameters.annotations";
    public static final String METHOD_ANNOTATIONS = "method.return.annotations";
    public static final String PARAM_ANNOTATION = "parameter.annotations";
    private static final Logger LOG = LogUtils.getL7dLogger(ReflectionServiceFactoryBean.class);
    protected String wsdlURL;
    protected Class<?> serviceClass;
    protected ParameterizedType serviceType;
    protected Map<Type, Map<String, Class<?>>> parameterizedTypes;
    protected final Map<String, String> schemaLocationMapping;
    private List<AbstractServiceConfiguration> serviceConfigurations;
    private QName serviceName;
    private Invoker invoker;
    private Executor executor;
    private List<String> ignoredClasses;
    private List<Method> ignoredMethods;
    private MethodDispatcher methodDispatcher;
    private Boolean wrappedStyle;
    private Map<String, Object> properties;
    private QName endpointName;
    private boolean populateFromClass;
    private boolean anonymousWrappers;
    private boolean qualifiedSchemas;
    private boolean validate;
    private List<AbstractFeature> features;
    private Map<Method, Boolean> wrappedCache;
    private Map<Method, Boolean> isRpcCache;
    private String styleCache;
    private Boolean defWrappedCache;
    static final long serialVersionUID = -6100808313711350723L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ReflectionServiceFactoryBean() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "<init>", new Object[0]);
        }
        this.schemaLocationMapping = new HashMap<String, String>();
        this.serviceConfigurations = new ArrayList<AbstractServiceConfiguration>();
        this.ignoredClasses = new ArrayList<String>();
        this.ignoredMethods = new ArrayList<Method>();
        this.methodDispatcher = new SimpleMethodDispatcher();
        this.qualifiedSchemas = true;
        this.wrappedCache = new HashMap<Method, Boolean>();
        this.isRpcCache = new HashMap<Method, Boolean>();
        this.getServiceConfigurations().add(0, new DefaultServiceConfiguration());
        this.ignoredClasses.add("java.lang.Object");
        this.ignoredClasses.add("java.lang.Throwable");
        this.ignoredClasses.add("org.omg.CORBA_2_3.portable.ObjectImpl");
        this.ignoredClasses.add("org.omg.CORBA.portable.ObjectImpl");
        this.ignoredClasses.add("javax.ejb.EJBObject");
        this.ignoredClasses.add("javax.rmi.CORBA.Stub");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "<init>", this);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected DataBinding createDefaultDataBinding() {
        DataBinding dataBinding;
        Class cls;
        block17: {
            org.apache.cxf.annotations.DataBinding db2;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createDefaultDataBinding", new Object[0]);
            }
            Object obj = null;
            cls = null;
            if (this.getServiceClass() != null && (db2 = this.getServiceClass().getAnnotation(org.apache.cxf.annotations.DataBinding.class)) != null) {
                block15: {
                    DataBinding dataBinding2;
                    block16: {
                        if (StringUtils.isEmpty((String)db2.ref())) break block15;
                        dataBinding2 = (DataBinding)((ResourceManager)this.getBus().getExtension(ResourceManager.class)).resolveResource(db2.ref(), db2.value());
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block16;
                        dataBinding2 = dataBinding2;
                        LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createDefaultDataBinding", dataBinding2);
                    }
                    return dataBinding2;
                }
                try {
                    cls = db2.value();
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Could not create databinding " + db2.value().getName(), e);
                }
            }
            if (cls == null && this.getBus() != null) {
                obj = this.getBus().getProperty(DataBinding.class.getName());
            }
            if (obj == null) {
                obj = "org.apache.cxf.jaxb.JAXBDataBinding";
            }
            if (obj instanceof String) {
                cls = ClassLoaderUtils.loadClass((String)obj.toString(), this.getClass(), DataBinding.class);
            } else if (obj instanceof Class) {
                cls = ((Class)obj).asSubclass(DataBinding.class);
            }
            dataBinding = (DataBinding)cls.getConstructor(ReflectionServiceFactoryBean.class).newInstance(this);
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block17;
            dataBinding = dataBinding;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createDefaultDataBinding", dataBinding);
        }
        return dataBinding;
        {
            catch (NoSuchMethodException db2) {
                DataBinding dataBinding3;
                block18: {
                    try {
                        dataBinding3 = (DataBinding)cls.newInstance();
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block18;
                    }
                    catch (Exception e) {
                        throw new ServiceConstructionException(e);
                    }
                    dataBinding3 = dataBinding3;
                    LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createDefaultDataBinding", dataBinding3);
                }
                return dataBinding3;
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void reset() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "reset", new Object[0]);
        }
        if (!this.dataBindingSet) {
            this.setDataBinding(null);
        }
        this.setService(null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "reset");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized Service create() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "create", new Object[0]);
        }
        this.reset();
        this.sendEvent(FactoryBeanListener.Event.START_CREATE, new Object[0]);
        this.initializeServiceConfigurations();
        this.initializeServiceModel();
        this.initializeDefaultInterceptors();
        if (this.invoker != null) {
            this.getService().setInvoker(this.getInvoker());
        } else {
            this.getService().setInvoker(this.createInvoker());
        }
        if (this.getExecutor() != null) {
            this.getService().setExecutor(this.getExecutor());
        }
        if (this.getDataBinding() != null) {
            this.getService().setDataBinding(this.getDataBinding());
        }
        MethodDispatcher m = this.getMethodDispatcher();
        this.getService().put((Object)MethodDispatcher.class.getName(), (Object)m);
        this.createEndpoints();
        this.fillInSchemaCrossreferences();
        Service serv = this.getService();
        this.sendEvent(FactoryBeanListener.Event.END_CREATE, serv);
        Service service = serv;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            service = service;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "create", service);
        }
        return service;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void fillInSchemaCrossreferences() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "fillInSchemaCrossreferences", new Object[0]);
        }
        Service service = this.getService();
        for (ServiceInfo serviceInfo : service.getServiceInfos()) {
            SchemaCollection schemaCollection = serviceInfo.getXmlSchemaCollection();
            for (SchemaInfo schemaInfo : serviceInfo.getSchemas()) {
                Map elementsTable = schemaInfo.getSchema().getElements();
                for (XmlSchemaElement element : elementsTable.values()) {
                    QName typeName;
                    if (element.getSchemaType() != null || (typeName = element.getSchemaTypeName()) == null) continue;
                    XmlSchemaType type = schemaCollection.getTypeByQName(typeName);
                    if (type == null) {
                        Message message = new Message("REFERENCE_TO_UNDEFINED_TYPE", LOG, new Object[]{element.getQName(), typeName, service.getName()});
                        LOG.severe(message.toString());
                        continue;
                    }
                    element.setSchemaType(type);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "fillInSchemaCrossreferences");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void createEndpoints() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createEndpoints", new Object[0]);
        }
        Service service = this.getService();
        BindingFactoryManager bfm = (BindingFactoryManager)this.getBus().getExtension(BindingFactoryManager.class);
        for (ServiceInfo inf : service.getServiceInfos()) {
            for (EndpointInfo ei : inf.getEndpoints()) {
                for (BindingOperationInfo boi : ei.getBinding().getOperations()) {
                    this.updateBindingOperation(boi);
                }
                try {
                    bfm.getBindingFactory(ei.getBinding().getBindingId());
                }
                catch (BusException e1) {
                    continue;
                }
                try {
                    Endpoint ep = this.createEndpoint(ei);
                    service.getEndpoints().put(ei.getName(), ep);
                }
                catch (EndpointException e) {
                    throw new ServiceConstructionException(e);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createEndpoints");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateBindingOperation(BindingOperationInfo boi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "updateBindingOperation", new Object[]{boi});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "updateBindingOperation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Endpoint createEndpoint(EndpointInfo ei) throws EndpointException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createEndpoint", new Object[]{ei});
        }
        EndpointImpl ep = new EndpointImpl(this.getBus(), this.getService(), ei);
        this.sendEvent(FactoryBeanListener.Event.ENDPOINT_CREATED, ei, ep, this.getServiceClass());
        EndpointImpl endpointImpl = ep;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            endpointImpl = endpointImpl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createEndpoint", endpointImpl);
        }
        return endpointImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void initializeServiceConfigurations() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeServiceConfigurations", new Object[0]);
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            c.setServiceFactory(this);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeServiceConfigurations");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setServiceProperties() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setServiceProperties", new Object[0]);
        }
        MethodDispatcher md = this.getMethodDispatcher();
        this.getService().put((Object)MethodDispatcher.class.getName(), (Object)md);
        for (Class<?> c : md.getClass().getInterfaces()) {
            this.getService().put((Object)c.getName(), (Object)md);
        }
        if (this.properties != null) {
            this.getService().putAll(this.properties);
        }
        this.setOldMethodDispatcherProperty();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setServiceProperties");
        }
    }

    @Deprecated
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setOldMethodDispatcherProperty() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setOldMethodDispatcherProperty", new Object[0]);
        }
        MethodDispatcher md = this.getMethodDispatcher();
        if (this.getService().get((Object)"org.apache.cxf.frontend.MethodDispatcher") == null) {
            try {
                Class cls = ClassLoaderUtils.loadClass((String)"org.apache.cxf.frontend.MethodDispatcher", this.getClass());
                Object o = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{cls}, (InvocationHandler)new ReflectionInvokationHandler((Object)md));
                this.getService().put((Object)"org.apache.cxf.frontend.MethodDispatcher", o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setOldMethodDispatcherProperty");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void buildServiceFromWSDL(String url) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "buildServiceFromWSDL", new Object[]{url});
        }
        this.sendEvent(FactoryBeanListener.Event.CREATE_FROM_WSDL, url);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating Service " + this.getServiceQName() + " from WSDL: " + url);
        }
        this.populateFromClass = false;
        WSDLServiceFactory factory = new WSDLServiceFactory(this.getBus(), url, this.getServiceQName());
        boolean setEPName = true;
        if (this.features != null) {
            for (AbstractFeature f : this.features) {
                if (!f.getClass().isAnnotationPresent(EvaluateAllEndpoints.class)) continue;
                setEPName = false;
            }
        }
        if (setEPName) {
            factory.setEndpointName(this.getEndpointName(false));
        }
        this.sendEvent(FactoryBeanListener.Event.WSDL_LOADED, factory.getDefinition());
        this.setService(factory.create());
        this.setServiceProperties();
        this.sendEvent(FactoryBeanListener.Event.SERVICE_SET, this.getService());
        EndpointInfo epInfo = this.getEndpointInfo();
        if (epInfo != null) {
            this.serviceConfigurations.add(new WSDLBasedServiceConfiguration(this.getEndpointInfo().getBinding()));
        }
        this.initializeWSDLOperations();
        Set<Class<?>> cls = this.getExtraClass();
        for (ServiceInfo si : this.getService().getServiceInfos()) {
            if (cls == null || cls.isEmpty()) continue;
            si.setProperty(EXTRA_CLASS, cls);
        }
        this.initializeDataBindings();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "buildServiceFromWSDL");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void buildServiceFromClass() {
        boolean isWrapped;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "buildServiceFromClass", new Object[0]);
        }
        Object o = this.getBus().getProperty("requireExplicitContractLocation");
        if (o != null && ("true".equals(o) || Boolean.TRUE.equals(o))) {
            throw new ServiceConstructionException(new Message("NO_WSDL_PROVIDED", LOG, new Object[]{this.getServiceClass().getName()}));
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating Service " + this.getServiceQName() + " from class " + this.getServiceClass().getName());
        }
        this.populateFromClass = true;
        if (Proxy.isProxyClass(this.getServiceClass())) {
            LOG.log(Level.WARNING, "USING_PROXY_FOR_SERVICE", this.getServiceClass());
        }
        this.sendEvent(FactoryBeanListener.Event.CREATE_FROM_CLASS, this.getServiceClass());
        ServiceInfo serviceInfo = new ServiceInfo();
        SchemaCollection col = serviceInfo.getXmlSchemaCollection();
        col.getXmlSchemaCollection().setSchemaResolver((URIResolver)new CatalogXmlSchemaURIResolver(this.getBus()));
        col.getExtReg().registerSerializer(MimeAttribute.class, (ExtensionSerializer)new MimeSerializer());
        ServiceImpl service = new ServiceImpl(serviceInfo);
        this.setService((Service)service);
        this.setServiceProperties();
        serviceInfo.setName(this.getServiceQName());
        serviceInfo.setTargetNamespace(serviceInfo.getName().getNamespaceURI());
        this.sendEvent(FactoryBeanListener.Event.SERVICE_SET, this.getService());
        this.createInterface(serviceInfo);
        Set<Class<?>> wrapperClasses = this.getExtraClass();
        for (Object si : this.getService().getServiceInfos()) {
            if (wrapperClasses == null || wrapperClasses.isEmpty()) continue;
            si.setProperty(EXTRA_CLASS, wrapperClasses);
        }
        this.initializeDataBindings();
        boolean bl = isWrapped = this.isWrapped() || this.hasWrappedMethods(serviceInfo.getInterface());
        if (isWrapped) {
            this.initializeWrappedSchema(serviceInfo);
        }
        for (OperationInfo opInfo : serviceInfo.getInterface().getOperations()) {
            Method m = (Method)opInfo.getProperty(METHOD);
            if (!this.isWrapped(m) && !this.isRPC(m) && opInfo.getInput() != null) {
                this.createBareMessage(serviceInfo, opInfo, false);
            }
            if (!this.isWrapped(m) && !this.isRPC(m) && opInfo.getOutput() != null) {
                this.createBareMessage(serviceInfo, opInfo, true);
            }
            if (!opInfo.hasFaults()) continue;
            for (FaultInfo fault : opInfo.getFaults()) {
                QName qn = (QName)fault.getProperty("elementName");
                MessagePartInfo part = fault.getMessagePart(0);
                if (part.isElement()) continue;
                part.setElement(true);
                part.setElementQName(qn);
                this.checkForElement(serviceInfo, part);
            }
        }
        if (LOG.isLoggable(Level.FINE) || this.isValidate()) {
            ServiceModelSchemaValidator validator = new ServiceModelSchemaValidator(serviceInfo);
            validator.walk();
            String validationComplaints = validator.getComplaints();
            if (!"".equals(validationComplaints)) {
                if (this.isValidate()) {
                    LOG.warning(validationComplaints);
                } else {
                    LOG.fine(validationComplaints);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "buildServiceFromClass");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean hasWrappedMethods(InterfaceInfo interfaceInfo) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "hasWrappedMethods", new Object[]{interfaceInfo});
        }
        for (OperationInfo opInfo : interfaceInfo.getOperations()) {
            if (!opInfo.isUnwrappedCapable()) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "hasWrappedMethods", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "hasWrappedMethods", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isFromWsdl() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isFromWsdl", new Object[0]);
        }
        boolean bl = !this.populateFromClass && this.getWsdlURL() != null && !this.isEmptywsdl(this.getWsdlURL());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isFromWsdl", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void initializeServiceModel() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeServiceModel", new Object[0]);
        }
        String wsdlurl = this.getWsdlURL();
        if (this.isFromWsdl()) {
            this.buildServiceFromWSDL(wsdlurl);
        } else {
            this.buildServiceFromClass();
        }
        if (this.isValidate()) {
            this.validateServiceModel();
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeServiceModel");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void validateServiceModel() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "validateServiceModel", new Object[0]);
        }
        XmlSchemaValidationManager xsdValidator = (XmlSchemaValidationManager)this.getBus().getExtension(XmlSchemaValidationManager.class);
        for (ServiceInfo si : this.getService().getServiceInfos()) {
            if (xsdValidator != null) {
                this.validateSchemas(xsdValidator, si.getXmlSchemaCollection());
            }
            for (OperationInfo opInfo : si.getInterface().getOperations()) {
                for (MessagePartInfo mpi : opInfo.getInput().getMessageParts()) {
                    assert (mpi.getXmlSchema() != null);
                    if (mpi.isElement() ? !$assertionsDisabled && !(mpi.getXmlSchema() instanceof XmlSchemaElement) : !$assertionsDisabled && mpi.getXmlSchema() instanceof XmlSchemaElement) {
                        throw new AssertionError();
                    }
                }
                if (opInfo.hasOutput()) {
                    for (MessagePartInfo mpi : opInfo.getOutput().getMessageParts()) {
                        assert (mpi.getXmlSchema() != null);
                        if (mpi.isElement() ? !$assertionsDisabled && !(mpi.getXmlSchema() instanceof XmlSchemaElement) : !$assertionsDisabled && mpi.getXmlSchema() instanceof XmlSchemaElement) {
                            throw new AssertionError();
                        }
                    }
                }
                if (opInfo.isUnwrappedCapable()) {
                    opInfo = opInfo.getUnwrappedOperation();
                    for (MessagePartInfo mpi : opInfo.getInput().getMessageParts()) {
                        assert (mpi.getXmlSchema() != null);
                        if (mpi.isElement() ? !$assertionsDisabled && !(mpi.getXmlSchema() instanceof XmlSchemaElement) : !$assertionsDisabled && mpi.getXmlSchema() instanceof XmlSchemaElement) {
                            throw new AssertionError();
                        }
                    }
                    if (opInfo.hasOutput()) {
                        for (MessagePartInfo mpi : opInfo.getOutput().getMessageParts()) {
                            assert (mpi.getXmlSchema() != null);
                            if (mpi.isElement() ? !$assertionsDisabled && !(mpi.getXmlSchema() instanceof XmlSchemaElement) : !$assertionsDisabled && mpi.getXmlSchema() instanceof XmlSchemaElement) {
                                throw new AssertionError();
                            }
                        }
                    }
                }
                if (!opInfo.hasFaults()) continue;
                for (FaultInfo fault : opInfo.getFaults()) {
                    MessagePartInfo mpi = fault.getMessagePart(0);
                    assert (mpi != null);
                    assert (mpi.getXmlSchema() != null);
                    assert (mpi.isElement());
                    assert (mpi.getXmlSchema() instanceof XmlSchemaElement);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "validateServiceModel");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void validateSchemas(XmlSchemaValidationManager xsdValidator, SchemaCollection xmlSchemaCollection) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "validateSchemas", new Object[]{xsdValidator, xmlSchemaCollection});
        }
        final boolean[] anyErrors = new boolean[1];
        final StringBuilder errorBuilder = new StringBuilder();
        anyErrors[0] = false;
        xsdValidator.validateSchemas(xmlSchemaCollection.getXmlSchemaCollection(), new DOMErrorHandler(){
            static final long serialVersionUID = -6032448632145221721L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean handleError(DOMError error) {
                anyErrors[0] = true;
                errorBuilder.append(error.getMessage());
                LOG.warning(error.getMessage());
                return true;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.service.factory.ReflectionServiceFactoryBean$1", 1.class, null, null);
            }
        });
        if (anyErrors[0]) {
            throw new ServiceConstructionException(new Message("XSD_VALIDATION_ERROR", LOG, new Object[]{errorBuilder.toString()}));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "validateSchemas");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isPopulateFromClass() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isPopulateFromClass", new Object[0]);
        }
        boolean bl = this.populateFromClass;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isPopulateFromClass", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setPopulateFromClass(boolean fomClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setPopulateFromClass", new Object[]{fomClass});
        }
        this.populateFromClass = fomClass;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setPopulateFromClass");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected InterfaceInfo getInterfaceInfo() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getInterfaceInfo", new Object[0]);
        }
        if (this.getEndpointInfo() != null) {
            InterfaceInfo interfaceInfo = this.getEndpointInfo().getInterface();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                interfaceInfo = interfaceInfo;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getInterfaceInfo", interfaceInfo);
            }
            return interfaceInfo;
        }
        QName qn = this.getInterfaceName();
        for (ServiceInfo si : this.getService().getServiceInfos()) {
            if (!qn.equals(si.getInterface().getName())) continue;
            InterfaceInfo interfaceInfo = si.getInterface();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                interfaceInfo = interfaceInfo;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getInterfaceInfo", interfaceInfo);
            }
            return interfaceInfo;
        }
        throw new ServiceConstructionException(new Message("COULD_NOT_FIND_PORTTYPE", LOG, new Object[]{qn}));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void initializeWSDLOperations() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeWSDLOperations", new Object[0]);
        }
        ArrayList<OperationInfo> removes = new ArrayList<OperationInfo>();
        Method[] methods = this.serviceClass.getMethods();
        Arrays.sort(methods, new MethodComparator());
        InterfaceInfo intf = this.getInterfaceInfo();
        HashMap<QName, Method> validMethods = new HashMap<QName, Method>();
        for (Method m : methods) {
            if (!this.isValidMethod(m)) continue;
            QName qName = this.getOperationName(intf, m);
            validMethods.put(qName, m);
        }
        for (OperationInfo o : intf.getOperations()) {
            Method selected = null;
            for (Map.Entry entry : validMethods.entrySet()) {
                QName opName = (QName)entry.getKey();
                if (!o.getName().getNamespaceURI().equals(opName.getNamespaceURI()) || !this.isMatchOperation(o.getName().getLocalPart(), opName.getLocalPart())) continue;
                selected = (Method)entry.getValue();
                break;
            }
            if (selected == null) {
                LOG.log(Level.WARNING, "NO_METHOD_FOR_OP", o.getName());
                removes.add(o);
                continue;
            }
            this.initializeWSDLOperation(intf, o, selected);
        }
        for (OperationInfo op : removes) {
            intf.removeOperation(op);
        }
        for (ServiceInfo service : this.getService().getServiceInfos()) {
            for (BindingInfo bi : service.getBindings()) {
                ArrayList<BindingOperationInfo> arrayList = new ArrayList<BindingOperationInfo>();
                for (BindingOperationInfo binfo : bi.getOperations()) {
                    if (removes.contains(binfo.getOperationInfo())) {
                        arrayList.add(binfo);
                        continue;
                    }
                    binfo.updateUnwrappedOperation();
                }
                for (BindingOperationInfo binfo : arrayList) {
                    bi.removeOperation(binfo);
                }
            }
        }
        this.sendEvent(FactoryBeanListener.Event.INTERFACE_CREATED, intf, this.getServiceClass());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeWSDLOperations");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void initializeWSDLOperation(InterfaceInfo intf, OperationInfo o, Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeWSDLOperation", new Object[]{intf, o, method});
        }
        Operation op = (Operation)o.getProperty(WSDLServiceBuilder.WSDL_OPERATION);
        if (this.initializeClassInfo(o, method, op == null ? null : CastUtils.cast((List)op.getParameterOrdering(), String.class))) {
            this.bindOperation(o, method);
            o.setProperty(METHOD, (Object)method);
            this.sendEvent(FactoryBeanListener.Event.INTERFACE_OPERATION_BOUND, o, method);
        } else {
            LOG.log(Level.WARNING, "NO_METHOD_FOR_OP", o.getName());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeWSDLOperation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean initializeClassInfo(OperationInfo o, Method method, List<String> paramOrder) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeClassInfo", new Object[]{o, method, paramOrder});
        }
        OperationInfo origOp = o;
        if (this.isWrapped(method)) {
            if (o.getUnwrappedOperation() == null) {
                WSDLServiceBuilder.checkForWrapped(o, true);
            }
            if (o.getUnwrappedOperation() != null) {
                MessagePartInfo part;
                MessageInfo input;
                if (o.hasInput()) {
                    input = o.getInput();
                    part = (MessagePartInfo)input.getMessageParts().get(0);
                    part.setTypeClass(this.getRequestWrapper(method));
                    part.setProperty("REQUEST.WRAPPER.CLASSNAME", (Object)this.getRequestWrapperClassName(method));
                    part.setIndex(0);
                }
                if (o.hasOutput()) {
                    input = o.getOutput();
                    part = (MessagePartInfo)input.getMessageParts().get(0);
                    part.setTypeClass(this.getResponseWrapper(method));
                    part.setProperty("RESPONSE.WRAPPER.CLASSNAME", (Object)this.getResponseWrapperClassName(method));
                    part.setIndex(0);
                }
                this.setFaultClassInfo(o, method);
                o = o.getUnwrappedOperation();
            } else {
                LOG.warning(new Message("COULD_NOT_UNWRAP", LOG, new Object[]{o.getName(), method}).toString());
                this.setFaultClassInfo(o, method);
            }
        } else if (o.isUnwrappedCapable()) {
            o.setUnwrappedOperation(null);
            this.setFaultClassInfo(o, method);
        }
        o.setProperty(METHOD_PARAM_ANNOTATIONS, (Object)method.getParameterAnnotations());
        o.setProperty(METHOD_ANNOTATIONS, (Object)method.getAnnotations());
        Class<?>[] paramTypes = method.getParameterTypes();
        Type[] genericTypes = method.getGenericParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Type genericType;
            Class<?> paramType;
            if (Exchange.class.equals(paramTypes[i]) || this.initializeParameter(o, method, i, paramType = paramTypes[i], genericType = genericTypes[i])) continue;
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeClassInfo", bl);
            }
            return bl;
        }
        this.sendEvent(FactoryBeanListener.Event.OPERATIONINFO_IN_MESSAGE_SET, origOp, method, origOp.getInput());
        Class<?> paramType = method.getReturnType();
        Type genericType = method.getGenericReturnType();
        if (o.hasOutput() && !this.initializeParameter(o, method, -1, paramType, genericType)) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeClassInfo", bl);
            }
            return bl;
        }
        if (origOp.hasOutput()) {
            this.sendEvent(FactoryBeanListener.Event.OPERATIONINFO_OUT_MESSAGE_SET, origOp, method, origOp.getOutput());
        }
        this.setFaultClassInfo(o, method);
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeClassInfo", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean initializeParameter(OperationInfo o, Method method, int i, Class<?> paramType, Type genericType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeParameter", new Object[]{o, method, i, paramType, genericType});
        }
        boolean isIn = this.isInParam(method, i);
        boolean isOut = this.isOutParam(method, i);
        boolean isHeader = this.isHeader(method, i);
        Annotation[] paraAnnos = null;
        if (i != -1 && o.getProperty(METHOD_PARAM_ANNOTATIONS) != null) {
            Annotation[][] anns = (Annotation[][])o.getProperty(METHOD_PARAM_ANNOTATIONS);
            paraAnnos = anns[i];
        } else if (i == -1 && o.getProperty(METHOD_ANNOTATIONS) != null) {
            paraAnnos = (Annotation[])o.getProperty(METHOD_ANNOTATIONS);
        }
        MessagePartInfo part = null;
        if (isIn && !isOut) {
            QName name = this.getInPartName(o, method, i);
            part = o.getInput().getMessagePart(name);
            if (part == null && this.isFromWsdl()) {
                part = o.getInput().getMessagePartByIndex(i);
            }
            if (part == null && isHeader && o.isUnwrapped() && (part = ((UnwrappedOperationInfo)o).getWrappedOperation().getInput().getMessagePart(name)) != null) {
                MessagePartInfo inf = o.getInput().addMessagePart(part.getName());
                inf.setTypeQName(part.getTypeQName());
                inf.setElement(part.isElement());
                inf.setElementQName(part.getElementQName());
                inf.setConcreteName(part.getConcreteName());
                inf.setXmlSchema(part.getXmlSchema());
                part = inf;
                inf.setProperty(HEADER, (Object)Boolean.TRUE);
            }
            if (part == null) {
                boolean bl = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeParameter", bl);
                }
                return bl;
            }
            this.initializeParameter(part, paramType, genericType);
            part.setIndex(i);
        } else if (!isIn && isOut) {
            QName name = this.getOutPartName(o, method, i);
            part = o.getOutput().getMessagePart(name);
            if (part == null && this.isFromWsdl()) {
                part = o.getOutput().getMessagePartByIndex(i + 1);
            }
            if (part == null) {
                boolean bl = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeParameter", bl);
                }
                return bl;
            }
            part.setProperty(MODE_OUT, (Object)Boolean.TRUE);
            this.initializeParameter(part, paramType, genericType);
            part.setIndex(i + 1);
        } else if (isIn && isOut) {
            QName name = this.getInPartName(o, method, i);
            part = o.getInput().getMessagePart(name);
            if (part == null && this.isFromWsdl()) {
                part = o.getInput().getMessagePartByIndex(i);
            }
            if (part == null && isHeader && o.isUnwrapped()) {
                part = o.getUnwrappedOperation().getInput().getMessagePart(name);
            }
            if (part == null) {
                boolean bl = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeParameter", bl);
                }
                return bl;
            }
            part.setProperty(MODE_INOUT, (Object)Boolean.TRUE);
            this.initializeParameter(part, paramType, genericType);
            part.setIndex(i);
            QName inName = part.getConcreteName();
            part = o.getOutput().getMessagePart(name);
            if (part == null) {
                part = o.getOutput().getMessagePart(inName);
            }
            if (part == null && isHeader && o.isUnwrapped() && (part = o.getUnwrappedOperation().getOutput().getMessagePart(name)) == null) {
                part = o.getUnwrappedOperation().getOutput().getMessagePart(inName);
            }
            if (part == null) {
                boolean bl = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeParameter", bl);
                }
                return bl;
            }
            part.setProperty(MODE_INOUT, (Object)Boolean.TRUE);
            this.initializeParameter(part, paramType, genericType);
            part.setIndex(i + 1);
        }
        if (paraAnnos != null && part != null) {
            part.setProperty(PARAM_ANNOTATION, (Object)paraAnnos);
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeParameter", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setFaultClassInfo(OperationInfo o, Method selected) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setFaultClassInfo", new Object[]{o, selected});
        }
        Class<?>[] types = selected.getExceptionTypes();
        for (int i = 0; i < types.length; ++i) {
            Class<?> exClass = types[i];
            Class<?> beanClass = this.getBeanClass(exClass);
            if (beanClass == null) continue;
            QName name = this.getFaultName(o.getInterface(), o, exClass, beanClass);
            for (FaultInfo fi : o.getFaults()) {
                List mpis = fi.getMessageParts();
                if (mpis.size() != 1) {
                    Message message = new Message("NO_FAULT_PART", LOG, new Object[]{fi.getFaultName()});
                    LOG.log(Level.WARNING, message.toString());
                }
                for (MessagePartInfo mpi : mpis) {
                    String ns = null;
                    ns = mpi.isElement() ? mpi.getElementQName().getNamespaceURI() : mpi.getTypeQName().getNamespaceURI();
                    if (!mpi.getConcreteName().getLocalPart().equals(name.getLocalPart()) || !name.getNamespaceURI().equals(ns)) continue;
                    fi.setProperty(Class.class.getName(), exClass);
                    mpi.setTypeClass(beanClass);
                    this.sendEvent(FactoryBeanListener.Event.OPERATIONINFO_FAULT, o, exClass, fi);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setFaultClassInfo");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Invoker createInvoker() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createInvoker", new Object[0]);
        }
        Class<?> cls = this.getServiceClass();
        if (cls.isInterface()) {
            Invoker invoker = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                invoker = invoker;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createInvoker", invoker);
            }
            return invoker;
        }
        FactoryInvoker factoryInvoker = new FactoryInvoker((Factory)new SingletonFactory(this.getServiceClass()));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            factoryInvoker = factoryInvoker;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createInvoker", factoryInvoker);
        }
        return factoryInvoker;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ServiceInfo createServiceInfo(InterfaceInfo intf) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createServiceInfo", new Object[]{intf});
        }
        ServiceInfo svcInfo = new ServiceInfo();
        svcInfo.setInterface(intf);
        ServiceInfo serviceInfo = svcInfo;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            serviceInfo = serviceInfo;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createServiceInfo", serviceInfo);
        }
        return serviceInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected InterfaceInfo createInterface(ServiceInfo serviceInfo) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createInterface", new Object[]{serviceInfo});
        }
        QName intfName = this.getInterfaceName();
        InterfaceInfo intf = new InterfaceInfo(serviceInfo, intfName);
        Method[] methods = this.getServiceClass().getMethods();
        Arrays.sort(methods, new MethodComparator());
        for (Method m : methods) {
            if (!this.isValidMethod(m)) continue;
            this.createOperation(serviceInfo, intf, m);
        }
        this.sendEvent(FactoryBeanListener.Event.INTERFACE_CREATED, intf, this.getServiceClass());
        InterfaceInfo interfaceInfo = intf;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            interfaceInfo = interfaceInfo;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createInterface", interfaceInfo);
        }
        return interfaceInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected OperationInfo createOperation(ServiceInfo serviceInfo, InterfaceInfo intf, Method m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createOperation", new Object[]{serviceInfo, intf, m});
        }
        OperationInfo op = intf.addOperation(this.getOperationName(intf, m));
        op.setProperty(m.getClass().getName(), (Object)m);
        op.setProperty("action", (Object)this.getAction(op, m));
        op.setProperty(METHOD_ANNOTATIONS, (Object)m.getAnnotations());
        op.setProperty(METHOD_PARAM_ANNOTATIONS, (Object)m.getParameterAnnotations());
        boolean isrpc = this.isRPC(m);
        if (!isrpc && this.isWrapped(m)) {
            UnwrappedOperationInfo uOp = new UnwrappedOperationInfo(op);
            uOp.setProperty(METHOD_ANNOTATIONS, (Object)m.getAnnotations());
            uOp.setProperty(METHOD_PARAM_ANNOTATIONS, (Object)m.getParameterAnnotations());
            op.setUnwrappedOperation((OperationInfo)uOp);
            this.createMessageParts(intf, (OperationInfo)uOp, m);
            if (uOp.hasInput()) {
                MessageInfo msg = new MessageInfo(op, MessageInfo.Type.INPUT, uOp.getInput().getName());
                op.setInput(uOp.getInputName(), msg);
                this.createInputWrappedMessageParts((OperationInfo)uOp, m, msg);
                for (MessagePartInfo p : uOp.getInput().getMessageParts()) {
                    p.setConcreteName(p.getName());
                }
            }
            if (uOp.hasOutput()) {
                QName name = uOp.getOutput().getName();
                MessageInfo msg = new MessageInfo(op, MessageInfo.Type.OUTPUT, name);
                op.setOutput(uOp.getOutputName(), msg);
                this.createOutputWrappedMessageParts((OperationInfo)uOp, m, msg);
                for (MessagePartInfo p : uOp.getOutput().getMessageParts()) {
                    p.setConcreteName(p.getName());
                }
            }
        } else {
            if (isrpc) {
                op.setProperty(FORCE_TYPES, (Object)Boolean.TRUE);
            }
            this.createMessageParts(intf, op, m);
        }
        this.bindOperation(op, m);
        this.sendEvent(FactoryBeanListener.Event.INTERFACE_OPERATION_BOUND, op, m);
        OperationInfo operationInfo = op;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            operationInfo = operationInfo;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createOperation", operationInfo);
        }
        return operationInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void bindOperation(OperationInfo op, Method m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "bindOperation", new Object[]{op, m});
        }
        this.getMethodDispatcher().bind(op, new Method[]{m});
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "bindOperation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void initializeWrappedSchema(ServiceInfo serviceInfo) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeWrappedSchema", new Object[]{serviceInfo});
        }
        for (OperationInfo op : serviceInfo.getInterface().getOperations()) {
            Object qn;
            XmlSchemaElement e;
            Object wrapperBeanName;
            if (op.getUnwrappedOperation() == null) continue;
            if (op.hasInput()) {
                if (((MessagePartInfo)op.getInput().getMessageParts().get(0)).getTypeClass() == null) {
                    wrapperBeanName = ((MessagePartInfo)op.getInput().getMessageParts().get(0)).getElementQName();
                    e = null;
                    for (SchemaInfo s : serviceInfo.getSchemas()) {
                        e = s.getElementByQName((QName)wrapperBeanName);
                        if (e == null) continue;
                        ((MessagePartInfo)op.getInput().getMessageParts().get(0)).setXmlSchema((XmlSchemaAnnotated)e);
                        break;
                    }
                    if (e == null) {
                        this.createWrappedSchema(serviceInfo, (AbstractMessageContainer)op.getInput(), (AbstractMessageContainer)op.getUnwrappedOperation().getInput(), (QName)wrapperBeanName);
                    }
                }
                for (MessagePartInfo mpi : op.getInput().getMessageParts()) {
                    if (!Boolean.TRUE.equals(mpi.getProperty(HEADER))) continue;
                    qn = (QName)mpi.getProperty(ELEMENT_NAME);
                    mpi.setElement(true);
                    mpi.setElementQName((QName)qn);
                    this.checkForElement(serviceInfo, mpi);
                }
            }
            if (!op.hasOutput()) continue;
            if (((MessagePartInfo)op.getOutput().getMessageParts().get(0)).getTypeClass() == null) {
                SchemaInfo s;
                wrapperBeanName = ((MessagePartInfo)op.getOutput().getMessageParts().get(0)).getElementQName();
                e = null;
                qn = serviceInfo.getSchemas().iterator();
                while (qn.hasNext() && (e = (s = (SchemaInfo)qn.next()).getElementByQName((QName)wrapperBeanName)) == null) {
                }
                if (e == null) {
                    this.createWrappedSchema(serviceInfo, (AbstractMessageContainer)op.getOutput(), (AbstractMessageContainer)op.getUnwrappedOperation().getOutput(), (QName)wrapperBeanName);
                }
            }
            for (MessagePartInfo mpi : op.getOutput().getMessageParts()) {
                if (!Boolean.TRUE.equals(mpi.getProperty(HEADER))) continue;
                qn = (QName)mpi.getProperty(ELEMENT_NAME);
                mpi.setElement(true);
                mpi.setElementQName((QName)qn);
                this.checkForElement(serviceInfo, mpi);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeWrappedSchema");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void checkForElement(ServiceInfo serviceInfo, MessagePartInfo mpi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "checkForElement", new Object[]{serviceInfo, mpi});
        }
        SchemaInfo si = this.getOrCreateSchema(serviceInfo, mpi.getElementQName().getNamespaceURI(), this.getQualifyWrapperSchema());
        XmlSchemaElement e = si.getElementByQName(mpi.getElementQName());
        e = si.getSchema().getElementByName(mpi.getElementQName().getLocalPart());
        if (e != null) {
            mpi.setXmlSchema((XmlSchemaAnnotated)e);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "checkForElement");
            }
            return;
        }
        XmlSchema schema = si.getSchema();
        si.setElement(null);
        XmlSchemaElement el = new XmlSchemaElement(schema, true);
        el.setName(mpi.getElementQName().getLocalPart());
        el.setNillable(true);
        XmlSchemaType tp = (XmlSchemaType)mpi.getXmlSchema();
        if (tp == null) {
            throw new ServiceConstructionException(new Message("INTRACTABLE_PART", LOG, new Object[]{mpi.getName(), mpi.getMessageInfo().getName()}));
        }
        el.setSchemaTypeName(tp.getQName());
        mpi.setXmlSchema((XmlSchemaAnnotated)el);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "checkForElement");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean getAnonymousWrapperTypes() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getAnonymousWrapperTypes", new Object[0]);
        }
        boolean bl = this.anonymousWrappers;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getAnonymousWrapperTypes", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isAnonymousWrapperTypes() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isAnonymousWrapperTypes", new Object[0]);
        }
        boolean bl = this.anonymousWrappers;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isAnonymousWrapperTypes", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setAnonymousWrapperTypes(boolean b) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setAnonymousWrapperTypes", new Object[]{b});
        }
        this.anonymousWrappers = b;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setAnonymousWrapperTypes");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final boolean getQualifyWrapperSchema() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getQualifyWrapperSchema", new Object[0]);
        }
        boolean bl = this.qualifiedSchemas;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getQualifyWrapperSchema", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isQualifyWrapperSchema() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isQualifyWrapperSchema", new Object[0]);
        }
        boolean bl = this.qualifiedSchemas;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isQualifyWrapperSchema", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setQualifyWrapperSchema(boolean b) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setQualifyWrapperSchema", new Object[]{b});
        }
        this.qualifiedSchemas = b;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setQualifyWrapperSchema");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void createWrappedSchema(ServiceInfo serviceInfo, AbstractMessageContainer wrappedMessage, AbstractMessageContainer unwrappedMessage, QName wrapperBeanName) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createWrappedSchema", new Object[]{serviceInfo, wrappedMessage, unwrappedMessage, wrapperBeanName});
        }
        SchemaInfo schemaInfo = this.getOrCreateSchema(serviceInfo, wrapperBeanName.getNamespaceURI(), this.getQualifyWrapperSchema());
        this.createWrappedMessageSchema(serviceInfo, wrappedMessage, unwrappedMessage, schemaInfo, wrapperBeanName);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createWrappedSchema");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void createBareMessage(ServiceInfo serviceInfo, OperationInfo opInfo, boolean isOut) {
        MessageInfo message;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createBareMessage", new Object[]{serviceInfo, opInfo, isOut});
        }
        MessageInfo messageInfo = message = isOut ? opInfo.getOutput() : opInfo.getInput();
        if (message.getMessageParts().size() == 0) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createBareMessage");
            }
            return;
        }
        Method method = (Method)opInfo.getProperty(METHOD);
        int paraNumber = 0;
        for (MessagePartInfo mpi : message.getMessageParts()) {
            SchemaInfo schemaInfo = null;
            XmlSchema schema = null;
            QName qname = (QName)mpi.getProperty(ELEMENT_NAME);
            if (message.getMessageParts().size() == 1 && qname == null) {
                QName qName = qname = !isOut ? this.getInParameterName(opInfo, method, -1) : this.getOutParameterName(opInfo, method, -1);
                if (qname.getLocalPart().startsWith("arg") || qname.getLocalPart().startsWith("return")) {
                    qname = isOut ? new QName(qname.getNamespaceURI(), method.getName() + "Response") : new QName(qname.getNamespaceURI(), method.getName());
                }
            } else if (isOut && message.getMessageParts().size() > 1 && qname == null) {
                while (!this.isOutParam(method, paraNumber)) {
                    ++paraNumber;
                }
                qname = this.getOutParameterName(opInfo, method, paraNumber);
            } else if (qname == null) {
                qname = this.getInParameterName(opInfo, method, paraNumber);
            }
            for (SchemaInfo s : serviceInfo.getSchemas()) {
                if (!s.getNamespaceURI().equals(qname.getNamespaceURI())) continue;
                schemaInfo = s;
                break;
            }
            if (schemaInfo == null) {
                schemaInfo = this.getOrCreateSchema(serviceInfo, qname.getNamespaceURI(), true);
                schema = schemaInfo.getSchema();
            } else {
                schema = schemaInfo.getSchema();
                if (schema != null && schema.getElementByName(qname) != null) {
                    mpi.setElement(true);
                    mpi.setElementQName(qname);
                    mpi.setXmlSchema((XmlSchemaAnnotated)schema.getElementByName(qname));
                    ++paraNumber;
                    continue;
                }
            }
            schemaInfo.setElement(null);
            XmlSchemaElement el = new XmlSchemaElement(schema, true);
            el.setName(qname.getLocalPart());
            el.setNillable(true);
            if (mpi.isElement()) {
                XmlSchemaElement oldEl = (XmlSchemaElement)mpi.getXmlSchema();
                if (null != oldEl && !oldEl.getQName().equals(qname)) {
                    el.setSchemaTypeName(oldEl.getSchemaTypeName());
                    el.setSchemaType(oldEl.getSchemaType());
                    if (oldEl.getSchemaTypeName() != null) {
                        this.addImport(schema, oldEl.getSchemaTypeName().getNamespaceURI());
                    }
                }
                mpi.setElement(true);
                mpi.setXmlSchema((XmlSchemaAnnotated)el);
                mpi.setElementQName(qname);
                mpi.setConcreteName(qname);
                continue;
            }
            if (null == mpi.getTypeQName() && mpi.getXmlSchema() == null) {
                throw new ServiceConstructionException(new Message("UNMAPPABLE_PORT_TYPE", LOG, new Object[]{method.getDeclaringClass().getName(), method.getName(), mpi.getName()}));
            }
            if (mpi.getTypeQName() != null) {
                el.setSchemaTypeName(mpi.getTypeQName());
            } else {
                el.setSchemaType((XmlSchemaType)mpi.getXmlSchema());
            }
            mpi.setXmlSchema((XmlSchemaAnnotated)el);
            mpi.setConcreteName(qname);
            if (mpi.getTypeQName() != null) {
                this.addImport(schema, mpi.getTypeQName().getNamespaceURI());
            }
            mpi.setElement(true);
            mpi.setElementQName(qname);
            ++paraNumber;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createBareMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addImport(XmlSchema schema, String ns) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "addImport", new Object[]{schema, ns});
        }
        if (!(ns.equals(schema.getTargetNamespace()) || ns.equals("http://www.w3.org/2001/XMLSchema") || this.isExistImport(schema, ns))) {
            XmlSchemaImport is = new XmlSchemaImport(schema);
            is.setNamespace(ns);
            if (this.schemaLocationMapping.get(ns) != null) {
                is.setSchemaLocation(this.schemaLocationMapping.get(ns));
            }
            if (!schema.getItems().contains(is)) {
                schema.getItems().add(is);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "addImport");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isExistImport(XmlSchema schema, String ns) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isExistImport", new Object[]{schema, ns});
        }
        boolean isExist = false;
        for (XmlSchemaExternal ext : schema.getExternals()) {
            XmlSchemaImport xsImport;
            if (!(ext instanceof XmlSchemaImport) || !(xsImport = (XmlSchemaImport)ext).getNamespace().equals(ns)) continue;
            isExist = true;
            break;
        }
        boolean bl = isExist;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isExistImport", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private XmlSchemaElement getExistingSchemaElement(XmlSchema schema, QName qn) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getExistingSchemaElement", new Object[]{schema, qn});
        }
        XmlSchemaElement xmlSchemaElement = (XmlSchemaElement)schema.getElements().get(qn);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            xmlSchemaElement = xmlSchemaElement;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getExistingSchemaElement", xmlSchemaElement);
        }
        return xmlSchemaElement;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isExistSchemaElement(XmlSchema schema, QName qn) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isExistSchemaElement", new Object[]{schema, qn});
        }
        boolean bl = this.getExistingSchemaElement(schema, qn) != null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isExistSchemaElement", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void createWrappedMessageSchema(ServiceInfo serviceInfo, AbstractMessageContainer wrappedMessage, AbstractMessageContainer unwrappedMessage, SchemaInfo info, QName wrapperName) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createWrappedMessageSchema", new Object[]{serviceInfo, wrappedMessage, unwrappedMessage, info, wrapperName});
        }
        XmlSchema schema = info.getSchema();
        info.setElement(null);
        XmlSchemaElement el = new XmlSchemaElement(schema, true);
        el.setName(wrapperName.getLocalPart());
        ((MessagePartInfo)wrappedMessage.getMessageParts().get(0)).setXmlSchema((XmlSchemaAnnotated)el);
        XmlSchemaComplexType ct = new XmlSchemaComplexType(schema, true);
        if (!this.isAnonymousWrapperTypes()) {
            ct.setName(wrapperName.getLocalPart());
            el.setSchemaTypeName(wrapperName);
        }
        el.setSchemaType((XmlSchemaType)ct);
        XmlSchemaSequence seq = new XmlSchemaSequence();
        ct.setParticle((XmlSchemaParticle)seq);
        for (MessagePartInfo mpi : unwrappedMessage.getMessageParts()) {
            el = new XmlSchemaElement(schema, Boolean.TRUE.equals(mpi.getProperty(HEADER)));
            el.setName(mpi.getName().getLocalPart());
            Map<Class<?>, Boolean> jaxbAnnoMap = this.getJaxbAnnoMap(mpi);
            if (mpi.isElement()) {
                this.addImport(schema, mpi.getElementQName().getNamespaceURI());
                el.setName(null);
                XmlSchemaUtils.setElementRefName((XmlSchemaElement)el, (QName)mpi.getElementQName());
            } else {
                if (mpi.getTypeQName() != null && !jaxbAnnoMap.containsKey(XmlList.class)) {
                    el.setSchemaTypeName(mpi.getTypeQName());
                    this.addImport(schema, mpi.getTypeQName().getNamespaceURI());
                }
                el.setSchemaType((XmlSchemaType)mpi.getXmlSchema());
                if (schema.getElementFormDefault().equals((Object)XmlSchemaForm.UNQUALIFIED)) {
                    mpi.setConcreteName(new QName(null, mpi.getName().getLocalPart()));
                } else {
                    mpi.setConcreteName(mpi.getName());
                }
            }
            if (!Boolean.TRUE.equals(mpi.getProperty(HEADER))) {
                Type type;
                boolean wasType;
                boolean bl = wasType = !mpi.isElement();
                if (wasType) {
                    QName concreteName = mpi.getConcreteName();
                    mpi.setElement(true);
                    mpi.setElementQName(el.getQName());
                    mpi.setConcreteName(concreteName);
                }
                this.addMimeType(el, this.getMethodParameterAnnotations(mpi));
                Annotation[] methodAnnotations = this.getMethodAnnotations(mpi);
                if (methodAnnotations != null) {
                    this.addMimeType(el, methodAnnotations);
                }
                long min = this.getWrapperPartMinOccurs(mpi);
                long max = this.getWrapperPartMaxOccurs(mpi);
                boolean nillable = this.isWrapperPartNillable(mpi);
                Boolean qualified = this.isWrapperPartQualified(mpi);
                if (qualified == null) {
                    qualified = this.isQualifyWrapperSchema();
                }
                if (qualified.booleanValue() && StringUtils.isEmpty((String)mpi.getConcreteName().getNamespaceURI())) {
                    QName newName = new QName(wrapperName.getNamespaceURI(), mpi.getConcreteName().getLocalPart());
                    mpi.setElement(true);
                    mpi.setElementQName(newName);
                    mpi.setConcreteName(newName);
                    el.setName(newName.getLocalPart());
                    el.setForm(XmlSchemaForm.QUALIFIED);
                }
                if (Collection.class.isAssignableFrom(mpi.getTypeClass()) && mpi.getTypeClass().isInterface() && !((type = (Type)mpi.getProperty(GENERIC_TYPE)) instanceof ParameterizedType) && el.getSchemaTypeName() == null && el.getSchemaType() == null) {
                    max = Long.MAX_VALUE;
                    el.setSchemaTypeName(Constants.XSD_ANYTYPE);
                }
                el.setMinOccurs(min);
                el.setMaxOccurs(max);
                if (nillable) {
                    el.setNillable(nillable);
                }
                seq.getItems().add(el);
                mpi.setXmlSchema((XmlSchemaAnnotated)el);
            }
            if (!Boolean.TRUE.equals(mpi.getProperty(HEADER))) continue;
            QName qn = (QName)mpi.getProperty(ELEMENT_NAME);
            el.setName(qn.getLocalPart());
            SchemaInfo headerSchemaInfo = this.getOrCreateSchema(serviceInfo, qn.getNamespaceURI(), this.getQualifyWrapperSchema());
            if (this.isExistSchemaElement(headerSchemaInfo.getSchema(), qn)) continue;
            headerSchemaInfo.getSchema().getItems().add(el);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createWrappedMessageSchema");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Annotation[] getMethodParameterAnnotations(MessagePartInfo mpi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getMethodParameterAnnotations", new Object[]{mpi});
        }
        Annotation[][] paramAnno = (Annotation[][])mpi.getProperty(METHOD_PARAM_ANNOTATIONS);
        int index = mpi.getIndex();
        if (paramAnno != null && index < paramAnno.length && index >= 0) {
            Annotation[] annotationArray = paramAnno[index];
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                annotationArray = annotationArray;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getMethodParameterAnnotations", annotationArray);
            }
            return annotationArray;
        }
        Annotation[] annotationArray = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            annotationArray = annotationArray;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getMethodParameterAnnotations", annotationArray);
        }
        return annotationArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Annotation[] getMethodAnnotations(MessagePartInfo mpi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getMethodAnnotations", new Object[]{mpi});
        }
        Annotation[] annotationArray = (Annotation[])mpi.getProperty(METHOD_ANNOTATIONS);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            annotationArray = annotationArray;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getMethodAnnotations", annotationArray);
        }
        return annotationArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addMimeType(XmlSchemaElement element, Annotation[] annotations) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "addMimeType", new Object[]{element, annotations});
        }
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof XmlMimeType)) continue;
                MimeAttribute attr = new MimeAttribute();
                attr.setValue(((XmlMimeType)annotation).value());
                element.addMetaInfo((Object)MimeAttribute.MIME_QNAME, (Object)attr);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "addMimeType");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Map<Class<?>, Boolean> getJaxbAnnoMap(MessagePartInfo mpi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getJaxbAnnoMap", new Object[]{mpi});
        }
        ConcurrentHashMap map = new ConcurrentHashMap(4, 0.75f, 1);
        Annotation[] anns = this.getMethodParameterAnnotations(mpi);
        if (anns != null) {
            for (Annotation anno : anns) {
                if (anno instanceof XmlList) {
                    map.put(XmlList.class, true);
                }
                if (anno instanceof XmlAttachmentRef) {
                    map.put(XmlAttachmentRef.class, true);
                }
                if (anno instanceof XmlJavaTypeAdapter) {
                    map.put(XmlJavaTypeAdapter.class, true);
                }
                if (!(anno instanceof XmlElementWrapper)) continue;
                map.put(XmlElementWrapper.class, true);
            }
        }
        ConcurrentHashMap concurrentHashMap = map;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            concurrentHashMap = concurrentHashMap;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getJaxbAnnoMap", concurrentHashMap);
        }
        return concurrentHashMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private SchemaInfo getOrCreateSchema(ServiceInfo serviceInfo, String namespaceURI, boolean qualified) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getOrCreateSchema", new Object[]{serviceInfo, namespaceURI, qualified});
        }
        for (SchemaInfo s : serviceInfo.getSchemas()) {
            if (!s.getNamespaceURI().equals(namespaceURI)) continue;
            SchemaInfo schemaInfo = s;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                schemaInfo = schemaInfo;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getOrCreateSchema", schemaInfo);
            }
            return schemaInfo;
        }
        SchemaInfo schemaInfo = new SchemaInfo(namespaceURI);
        SchemaCollection col = serviceInfo.getXmlSchemaCollection();
        XmlSchema schema = col.getSchemaByTargetNamespace(namespaceURI);
        if (schema != null) {
            schemaInfo.setSchema(schema);
            serviceInfo.addSchema(schemaInfo);
            SchemaInfo schemaInfo2 = schemaInfo;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                schemaInfo2 = schemaInfo2;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getOrCreateSchema", schemaInfo2);
            }
            return schemaInfo2;
        }
        schema = col.newXmlSchemaInCollection(namespaceURI);
        if (qualified) {
            schema.setElementFormDefault(XmlSchemaForm.QUALIFIED);
        }
        schemaInfo.setSchema(schema);
        Map explicitNamespaceMappings = this.getDataBinding().getDeclaredNamespaceMappings();
        if (explicitNamespaceMappings == null) {
            explicitNamespaceMappings = Collections.emptyMap();
        }
        NamespaceMap nsMap = new NamespaceMap();
        for (Map.Entry mapping : explicitNamespaceMappings.entrySet()) {
            nsMap.add((String)mapping.getValue(), (String)mapping.getKey());
        }
        if (!explicitNamespaceMappings.containsKey("http://www.w3.org/2001/XMLSchema")) {
            nsMap.add("xsd", "http://www.w3.org/2001/XMLSchema");
        }
        if (!explicitNamespaceMappings.containsKey(serviceInfo.getTargetNamespace())) {
            nsMap.add("tns", serviceInfo.getTargetNamespace());
        }
        schema.setNamespaceContext((NamespacePrefixList)nsMap);
        serviceInfo.addSchema(schemaInfo);
        SchemaInfo schemaInfo3 = schemaInfo;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            schemaInfo3 = schemaInfo3;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getOrCreateSchema", schemaInfo3);
        }
        return schemaInfo3;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void createMessageParts(InterfaceInfo intf, OperationInfo op, Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createMessageParts", new Object[]{intf, op, method});
        }
        Class<?>[] paramClasses = method.getParameterTypes();
        op.setProperty(METHOD, (Object)method);
        MessageInfo inMsg = op.createMessage(this.getInputMessageName(op, method), MessageInfo.Type.INPUT);
        op.setInput(inMsg.getName().getLocalPart(), inMsg);
        for (int j = 0; j < paramClasses.length; ++j) {
            if (Exchange.class.equals(paramClasses[j]) || !this.isInParam(method, j)) continue;
            QName q = this.getInParameterName(op, method, j);
            QName partName = this.getInPartName(op, method, j);
            if (!this.isRPC(method) && !this.isWrapped(method) && inMsg.getMessagePartsMap().containsKey(partName)) {
                LOG.log(Level.WARNING, "INVALID_BARE_METHOD", this.getServiceClass() + "." + method.getName());
                partName = new QName(partName.getNamespaceURI(), partName.getLocalPart() + j);
                q = new QName(q.getNamespaceURI(), q.getLocalPart() + j);
            }
            MessagePartInfo part = inMsg.addMessagePart(partName);
            this.initializeParameter(part, paramClasses[j], method.getGenericParameterTypes()[j]);
            part.setProperty(METHOD_PARAM_ANNOTATIONS, (Object)method.getParameterAnnotations());
            part.setProperty(PARAM_ANNOTATION, (Object)method.getParameterAnnotations()[j]);
            if (this.getJaxbAnnoMap(part).size() > 0) {
                op.setProperty(WRAPPERGEN_NEEDED, (Object)true);
            }
            if (!this.isWrapped(method) && !this.isRPC(method)) {
                part.setProperty(ELEMENT_NAME, (Object)q);
            }
            if (this.isHeader(method, j)) {
                part.setProperty(HEADER, (Object)Boolean.TRUE);
                if (this.isRPC(method) || !this.isWrapped(method)) {
                    part.setElementQName(q);
                } else {
                    part.setProperty(ELEMENT_NAME, (Object)q);
                }
            }
            part.setIndex(j);
        }
        this.sendEvent(FactoryBeanListener.Event.OPERATIONINFO_IN_MESSAGE_SET, op, method, inMsg);
        boolean hasOut = this.hasOutMessage(method);
        if (hasOut) {
            MessageInfo outMsg = op.createMessage(this.createOutputMessageName(op, method), MessageInfo.Type.OUTPUT);
            op.setOutput(outMsg.getName().getLocalPart(), outMsg);
            Class<Void> returnType = method.getReturnType();
            if (!returnType.isAssignableFrom(Void.TYPE)) {
                QName q = this.getOutPartName(op, method, -1);
                QName q2 = this.getOutParameterName(op, method, -1);
                MessagePartInfo part = outMsg.addMessagePart(q);
                this.initializeParameter(part, method.getReturnType(), method.getGenericReturnType());
                if (!this.isRPC(method) && !this.isWrapped(method)) {
                    part.setProperty(ELEMENT_NAME, (Object)q2);
                }
                part.setProperty(METHOD_ANNOTATIONS, (Object)method.getAnnotations());
                part.setProperty(PARAM_ANNOTATION, (Object)method.getAnnotations());
                if (this.isHeader(method, -1)) {
                    part.setProperty(HEADER, (Object)Boolean.TRUE);
                    if (this.isRPC(method) || !this.isWrapped(method)) {
                        part.setElementQName(q2);
                    } else {
                        part.setProperty(ELEMENT_NAME, (Object)q2);
                    }
                }
                part.setIndex(0);
            }
            for (int j = 0; j < paramClasses.length; ++j) {
                if (Exchange.class.equals(paramClasses[j]) || !this.isOutParam(method, j)) continue;
                if (outMsg == null) {
                    outMsg = op.createMessage(this.createOutputMessageName(op, method), MessageInfo.Type.OUTPUT);
                }
                QName q = this.getOutPartName(op, method, j);
                QName q2 = this.getOutParameterName(op, method, j);
                if (this.isInParam(method, j)) {
                    q = op.getInput().getMessagePartByIndex(j).getName();
                    q2 = (QName)op.getInput().getMessagePartByIndex(j).getProperty(ELEMENT_NAME);
                    if (q2 == null) {
                        q2 = op.getInput().getMessagePartByIndex(j).getElementQName();
                    }
                }
                MessagePartInfo part = outMsg.addMessagePart(q);
                part.setProperty(METHOD_PARAM_ANNOTATIONS, (Object)method.getParameterAnnotations());
                part.setProperty(PARAM_ANNOTATION, (Object)method.getParameterAnnotations()[j]);
                this.initializeParameter(part, paramClasses[j], method.getGenericParameterTypes()[j]);
                part.setIndex(j + 1);
                if (!this.isRPC(method) && !this.isWrapped(method)) {
                    part.setProperty(ELEMENT_NAME, (Object)q2);
                }
                if (this.isInParam(method, j)) {
                    part.setProperty(MODE_INOUT, (Object)Boolean.TRUE);
                }
                if (!this.isHeader(method, j)) continue;
                part.setProperty(HEADER, (Object)Boolean.TRUE);
                if (this.isRPC(method) || !this.isWrapped(method)) {
                    part.setElementQName(q2);
                    continue;
                }
                part.setProperty(ELEMENT_NAME, (Object)q2);
            }
            this.sendEvent(FactoryBeanListener.Event.OPERATIONINFO_OUT_MESSAGE_SET, op, method, outMsg);
        }
        this.setParameterOrder(method, paramClasses, op);
        if (hasOut) {
            this.initializeFaults(intf, op, method);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createMessageParts");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setParameterOrder(Method method, Class<?>[] paramClasses, OperationInfo op) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setParameterOrder", new Object[]{method, paramClasses, op});
        }
        if (this.isRPC(method) || !this.isWrapped(method)) {
            LinkedList<String> paramOrdering = new LinkedList<String>();
            boolean hasOut = false;
            for (int j = 0; j < paramClasses.length; ++j) {
                if (Exchange.class.equals(paramClasses[j])) continue;
                if (this.isInParam(method, j)) {
                    paramOrdering.add(this.getInPartName(op, method, j).getLocalPart());
                    if (!this.isOutParam(method, j)) continue;
                    hasOut = true;
                    continue;
                }
                if (!this.isOutParam(method, j)) continue;
                hasOut = true;
                paramOrdering.add(this.getOutPartName(op, method, j).getLocalPart());
            }
            if (!paramOrdering.isEmpty() && hasOut) {
                op.setParameterOrdering(paramOrdering);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setParameterOrder");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void createInputWrappedMessageParts(OperationInfo op, Method method, MessageInfo inMsg) {
        Object c;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createInputWrappedMessageParts", new Object[]{op, method, inMsg});
        }
        String partName = null;
        Iterator<AbstractServiceConfiguration> iterator = this.serviceConfigurations.iterator();
        while (iterator.hasNext() && (partName = ((AbstractServiceConfiguration)(c = iterator.next())).getRequestWrapperPartName(op, method)) == null) {
        }
        if (partName == null) {
            partName = "parameters";
        }
        MessagePartInfo part = inMsg.addMessagePart(partName);
        part.setElement(true);
        for (AbstractServiceConfiguration c2 : this.serviceConfigurations) {
            QName q = c2.getRequestWrapperName(op, method);
            if (q == null) continue;
            part.setElementQName(q);
        }
        if (part.getElementQName() == null) {
            part.setElementQName(inMsg.getName());
        } else if (!part.getElementQName().equals(op.getInput().getName())) {
            op.getInput().setName(part.getElementQName());
        }
        if (this.getRequestWrapper(method) != null) {
            part.setTypeClass(this.getRequestWrapper(method));
        } else if (this.getRequestWrapperClassName(method) != null) {
            part.setProperty("REQUEST.WRAPPER.CLASSNAME", (Object)this.getRequestWrapperClassName(method));
        }
        int partIdx = 0;
        int maxIdx = 0;
        for (MessagePartInfo mpart : op.getInput().getMessageParts()) {
            if (!Boolean.TRUE.equals(mpart.getProperty(HEADER))) continue;
            int idx = mpart.getIndex();
            inMsg.addMessagePart(mpart);
            mpart.setIndex(idx);
            if (maxIdx < idx) {
                maxIdx = idx;
            }
            if (idx != partIdx) continue;
            partIdx = ++maxIdx;
        }
        part.setIndex(partIdx);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createInputWrappedMessageParts");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void createOutputWrappedMessageParts(OperationInfo op, Method method, MessageInfo outMsg) {
        AbstractServiceConfiguration c;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createOutputWrappedMessageParts", new Object[]{op, method, outMsg});
        }
        String partName = null;
        Iterator<AbstractServiceConfiguration> iterator = this.serviceConfigurations.iterator();
        while (iterator.hasNext() && (partName = (c = iterator.next()).getResponseWrapperPartName(op, method)) == null) {
        }
        for (MessagePartInfo mpart : op.getOutput().getMessageParts()) {
            if (!Boolean.TRUE.equals(mpart.getProperty(HEADER))) continue;
            partName = "result";
            break;
        }
        if (partName == null) {
            partName = "parameters";
        }
        MessagePartInfo part = outMsg.addMessagePart(partName);
        part.setElement(true);
        part.setIndex(0);
        for (AbstractServiceConfiguration c2 : this.serviceConfigurations) {
            QName q = c2.getResponseWrapperName(op, method);
            if (q == null) continue;
            part.setElementQName(q);
            break;
        }
        if (part.getElementQName() == null) {
            part.setElementQName(outMsg.getName());
        } else if (!part.getElementQName().equals(op.getOutput().getName())) {
            op.getOutput().setName(part.getElementQName());
        }
        if (this.getResponseWrapper(method) != null) {
            part.setTypeClass(this.getResponseWrapper(method));
        } else if (this.getResponseWrapperClassName(method) != null) {
            part.setProperty("RESPONSE.WRAPPER.CLASSNAME", (Object)this.getResponseWrapperClassName(method));
        }
        for (MessagePartInfo mpart : op.getOutput().getMessageParts()) {
            if (!Boolean.TRUE.equals(mpart.getProperty(HEADER))) continue;
            int idx = mpart.getIndex();
            outMsg.addMessagePart(mpart);
            mpart.setIndex(idx);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createOutputWrappedMessageParts");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Class<?> createArrayClass(GenericArrayType atp) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createArrayClass", new Object[]{atp});
        }
        Type tp = atp.getGenericComponentType();
        Class<?> rawClass = null;
        if (tp instanceof Class) {
            rawClass = (Class<?>)tp;
        } else if (tp instanceof GenericArrayType) {
            rawClass = ReflectionServiceFactoryBean.createArrayClass((GenericArrayType)tp);
        } else if (tp instanceof ParameterizedType && List.class.isAssignableFrom(rawClass = (Class<?>)((ParameterizedType)tp).getRawType())) {
            rawClass = ReflectionServiceFactoryBean.getClass(tp);
            rawClass = Array.newInstance(rawClass, 0).getClass();
        }
        Class<?> clazz = Array.newInstance(rawClass, 0).getClass();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createArrayClass", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Class<?> getClass(Type paramType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getClass", new Object[]{paramType});
        }
        Class rawClass = null;
        if (paramType instanceof Class) {
            rawClass = (Class)paramType;
        } else if (paramType instanceof GenericArrayType) {
            rawClass = ReflectionServiceFactoryBean.createArrayClass((GenericArrayType)paramType);
        } else if (paramType instanceof ParameterizedType) {
            rawClass = (Class)((ParameterizedType)paramType).getRawType();
        }
        Class clazz = rawClass;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getClass", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void initializeParameter(MessagePartInfo part, Class<?> rawClass, Type type) {
        Type c;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeParameter", new Object[]{part, rawClass, type});
        }
        if (this.isHolder(rawClass, type) && (c = this.getHolderType(rawClass, type)) != null) {
            type = c;
            rawClass = ReflectionServiceFactoryBean.getClass(type);
        }
        if (type instanceof TypeVariable) {
            Class<?> c2;
            TypeVariable var;
            Map<String, Class<?>> mp;
            if (this.parameterizedTypes == null) {
                this.processParameterizedTypes();
            }
            if ((mp = this.parameterizedTypes.get((var = (TypeVariable)((Object)type)).getGenericDeclaration())) != null && (c2 = this.parameterizedTypes.get(var.getGenericDeclaration()).get(var.getName())) != null) {
                rawClass = c2;
                type = c2;
                part.getMessageInfo().setProperty("parameterized", (Object)Boolean.TRUE);
            }
        }
        part.setProperty(GENERIC_TYPE, (Object)type);
        if (Collection.class.isAssignableFrom(rawClass)) {
            part.setProperty(RAW_CLASS, rawClass);
        }
        part.setTypeClass(rawClass);
        if (part.getMessageInfo().getOperation().isUnwrapped() && Boolean.TRUE.equals(part.getProperty(HEADER))) {
            MessagePartInfo mpi;
            OperationInfo o = ((UnwrappedOperationInfo)part.getMessageInfo().getOperation()).getWrappedOperation();
            if ((Boolean.TRUE.equals(part.getProperty(MODE_OUT)) || Boolean.TRUE.equals(part.getProperty(MODE_INOUT))) && (mpi = o.getOutput().getMessagePart(part.getName())) != null) {
                mpi.setTypeClass(rawClass);
                mpi.setProperty(GENERIC_TYPE, type);
                if (Collection.class.isAssignableFrom(rawClass)) {
                    mpi.setProperty(RAW_CLASS, type);
                }
            }
            if (!Boolean.TRUE.equals(part.getProperty(MODE_OUT)) && (mpi = o.getInput().getMessagePart(part.getName())) != null) {
                mpi.setTypeClass(rawClass);
                mpi.setProperty(GENERIC_TYPE, type);
                if (Collection.class.isAssignableFrom(rawClass)) {
                    mpi.setProperty(RAW_CLASS, type);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeParameter");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getServiceQName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getServiceQName", new Object[0]);
        }
        QName qName = this.getServiceQName(true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getServiceQName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getServiceQName(boolean lookup) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getServiceQName", new Object[]{lookup});
        }
        if (this.serviceName == null && lookup) {
            this.serviceName = new QName(this.getServiceNamespace(), this.getServiceName());
        }
        QName qName = this.serviceName;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getServiceQName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getEndpointName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getEndpointName", new Object[0]);
        }
        QName qName = this.getEndpointName(true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getEndpointName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getEndpointName(boolean lookup) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getEndpointName", new Object[]{lookup});
        }
        if (this.endpointName != null || !lookup) {
            QName qName = this.endpointName;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getEndpointName", qName);
            }
            return qName;
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName name = c.getEndpointName();
            if (name == null) continue;
            this.endpointName = name;
            QName qName = name;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getEndpointName", qName);
            }
            return qName;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EndpointInfo getEndpointInfo() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getEndpointInfo", new Object[0]);
        }
        EndpointInfo endpointInfo = this.getService().getEndpointInfo(this.getEndpointName());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            endpointInfo = endpointInfo;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getEndpointInfo", endpointInfo);
        }
        return endpointInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setEndpointName(QName en) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setEndpointName", new Object[]{en});
        }
        this.endpointName = en;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setEndpointName");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getServiceName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getServiceName", new Object[0]);
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            String name = c.getServiceName();
            if (name == null) continue;
            String string = name;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getServiceName", string);
            }
            return string;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getServiceNamespace() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getServiceNamespace", new Object[0]);
        }
        if (this.serviceName != null) {
            String string = this.serviceName.getNamespaceURI();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getServiceNamespace", string);
            }
            return string;
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            String name = c.getServiceNamespace();
            if (name == null) continue;
            String string = name;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getServiceNamespace", string);
            }
            return string;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getInterfaceName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getInterfaceName", new Object[0]);
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName name = c.getInterfaceName();
            if (name == null) continue;
            QName qName = name;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getInterfaceName", qName);
            }
            return qName;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isValidMethod(Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isValidMethod", new Object[]{method});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isOperation(method);
            if (b == null) continue;
            boolean bl = b;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isValidMethod", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isValidMethod", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isHolder(Class<?> cls, Type type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isHolder", new Object[]{cls, type});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isHolder(cls, type);
            if (b == null) continue;
            boolean bl = b;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isHolder", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isHolder", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Type getHolderType(Class<?> cls, Type type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getHolderType", new Object[]{cls, type});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Type b = c.getHolderType(cls, type);
            if (b == null) continue;
            Type type2 = b;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                type2 = type2;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getHolderType", type2);
            }
            return type2;
        }
        Type type3 = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            type3 = type3;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getHolderType", type3);
        }
        return type3;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isWrapped(Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isWrapped", new Object[]{method});
        }
        Boolean b = this.wrappedCache.get(method);
        if (b == null) {
            if (this.isRPC(method)) {
                this.wrappedCache.put(method, Boolean.FALSE);
                boolean bl = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isWrapped", bl);
                }
                return bl;
            }
            for (AbstractServiceConfiguration c : this.serviceConfigurations) {
                b = c.isWrapped(method);
                if (b == null) continue;
                this.wrappedCache.put(method, b);
                boolean bl = b;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isWrapped", bl);
                }
                return bl;
            }
            this.wrappedCache.put(method, Boolean.TRUE);
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isWrapped", bl);
            }
            return bl;
        }
        boolean bl = b;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isWrapped", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isMatchOperation(String methodNameInClass, String methodNameInWsdl) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isMatchOperation", new Object[]{methodNameInClass, methodNameInWsdl});
        }
        boolean ret = false;
        String initOfMethodInClass = methodNameInClass.substring(0, 1);
        String initOfMethodInWsdl = methodNameInWsdl.substring(0, 1);
        if (initOfMethodInClass.equalsIgnoreCase(initOfMethodInWsdl) && methodNameInClass.substring(1, methodNameInClass.length()).equals(methodNameInWsdl.substring(1, methodNameInWsdl.length()))) {
            ret = true;
        }
        boolean bl = ret;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isMatchOperation", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isOutParam(Method method, int j) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isOutParam", new Object[]{method, j});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isOutParam(method, j);
            if (b == null) continue;
            boolean bl = b;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isOutParam", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isOutParam", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isInParam(Method method, int j) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isInParam", new Object[]{method, j});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isInParam(method, j);
            if (b == null) continue;
            boolean bl = b;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isInParam", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isInParam", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected QName getInputMessageName(OperationInfo op, Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getInputMessageName", new Object[]{op, method});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getInputMessageName(op, method);
            if (q == null) continue;
            QName qName = q;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getInputMessageName", qName);
            }
            return qName;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected QName createOutputMessageName(OperationInfo op, Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createOutputMessageName", new Object[]{op, method});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getOutputMessageName(op, method);
            if (q == null) continue;
            QName qName = q;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createOutputMessageName", qName);
            }
            return qName;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean hasOutMessage(Method m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "hasOutMessage", new Object[]{m});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.hasOutMessage(m);
            if (b == null) continue;
            boolean bl = b;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "hasOutMessage", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "hasOutMessage", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void initializeFaults(InterfaceInfo service, OperationInfo op, Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeFaults", new Object[]{service, op, method});
        }
        Class<?>[] exceptionClasses = method.getExceptionTypes();
        for (int i = 0; i < exceptionClasses.length; ++i) {
            Class<?> exClazz = exceptionClasses[i];
            if (Fault.class.isAssignableFrom(exClazz) || exClazz.equals(RuntimeException.class) || exClazz.equals(Throwable.class)) continue;
            this.addFault(service, op, exClazz);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeFaults");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void initializeDefaultInterceptors() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeDefaultInterceptors", new Object[0]);
        }
        super.initializeDefaultInterceptors();
        this.initializeFaultInterceptors();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeDefaultInterceptors");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void initializeFaultInterceptors() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeFaultInterceptors", new Object[0]);
        }
        this.getService().getOutFaultInterceptors().add(new FaultOutInterceptor());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "initializeFaultInterceptors");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected FaultInfo addFault(InterfaceInfo service, OperationInfo op, Class<?> exClass) {
        AbstractServiceConfiguration c;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "addFault", new Object[]{service, op, exClass});
        }
        Class<?> beanClass = this.getBeanClass(exClass);
        if (beanClass == null) {
            FaultInfo faultInfo = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                faultInfo = faultInfo;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "addFault", faultInfo);
            }
            return faultInfo;
        }
        String faultMsgName = null;
        Iterator<AbstractServiceConfiguration> iterator = this.serviceConfigurations.iterator();
        while (iterator.hasNext() && (faultMsgName = (c = iterator.next()).getFaultMessageName(op, exClass, beanClass)) == null) {
        }
        if (faultMsgName == null) {
            faultMsgName = exClass.getSimpleName();
        }
        QName faultName = this.getFaultName(service, op, exClass, beanClass);
        FaultInfo fi = op.addFault(new QName(op.getName().getNamespaceURI(), faultMsgName), new QName(op.getName().getNamespaceURI(), faultMsgName));
        fi.setProperty(Class.class.getName(), exClass);
        fi.setProperty("elementName", (Object)faultName);
        MessagePartInfo mpi = fi.addMessagePart(new QName(faultName.getNamespaceURI(), exClass.getSimpleName()));
        mpi.setElementQName(faultName);
        mpi.setTypeClass(beanClass);
        this.sendEvent(FactoryBeanListener.Event.OPERATIONINFO_FAULT, op, exClass, fi);
        FaultInfo faultInfo = fi;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            faultInfo = faultInfo;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "addFault", faultInfo);
        }
        return faultInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void createFaultForException(Class<?> exClass, FaultInfo fi) {
        Field[] fields;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createFaultForException", new Object[]{exClass, fi});
        }
        for (Field field : fields = exClass.getDeclaredFields()) {
            MessagePartInfo mpi = fi.addMessagePart(new QName(fi.getName().getNamespaceURI(), field.getName()));
            mpi.setProperty(Class.class.getName(), field.getType());
        }
        MessagePartInfo mpi = fi.addMessagePart(new QName(fi.getName().getNamespaceURI(), "message"));
        mpi.setProperty(Class.class.getName(), String.class);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "createFaultForException");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Class<?> getBeanClass(Class<?> exClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getBeanClass", new Object[]{exClass});
        }
        if (RemoteException.class.isAssignableFrom(exClass)) {
            Class<?> clazz = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getBeanClass", clazz);
            }
            return clazz;
        }
        if (FaultOutInterceptor.FaultInfoException.class.isAssignableFrom(exClass)) {
            Class<?> clazz;
            try {
                Method m = exClass.getMethod("getFaultInfo", new Class[0]);
                clazz = m.getReturnType();
            }
            catch (SecurityException e) {
                throw new ServiceConstructionException(e);
            }
            catch (NoSuchMethodException e) {
                throw new ServiceConstructionException(e);
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getBeanClass", clazz);
            }
            return clazz;
        }
        Class<?> clazz = exClass;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getBeanClass", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected QName getFaultName(InterfaceInfo service, OperationInfo o, Class<?> exClass, Class<?> beanClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getFaultName", new Object[]{service, o, exClass, beanClass});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getFaultName(service, o, exClass, beanClass);
            if (q == null) continue;
            QName qName = q;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getFaultName", qName);
            }
            return qName;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getAction(OperationInfo op, Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getAction", new Object[]{op, method});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            String s = c.getAction(op, method);
            if (s == null) continue;
            String string = s;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getAction", string);
            }
            return string;
        }
        String string = "";
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getAction", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isHeader(Method method, int j) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isHeader", new Object[]{method, j});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isHeader(method, j);
            if (b == null) continue;
            boolean bl = b;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isHeader", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isHeader", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected QName getOperationName(InterfaceInfo service, Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getOperationName", new Object[]{service, method});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName s = c.getOperationName(service, method);
            if (s == null) continue;
            QName qName = s;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getOperationName", qName);
            }
            return qName;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isAsync(Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isAsync", new Object[]{method});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isAsync(method);
            if (b == null) continue;
            boolean bl = b;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isAsync", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isAsync", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected QName getInPartName(OperationInfo op, Method method, int paramNumber) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getInPartName", new Object[]{op, method, paramNumber});
        }
        if (paramNumber == -1) {
            QName qName = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getInPartName", qName);
            }
            return qName;
        }
        if (this.isWrapped(method) && !this.isHeader(method, paramNumber)) {
            QName qName = this.getInParameterName(op, method, paramNumber);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getInPartName", qName);
            }
            return qName;
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getInPartName(op, method, paramNumber);
            if (q == null) continue;
            QName qName = q;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getInPartName", qName);
            }
            return qName;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected QName getInParameterName(OperationInfo op, Method method, int paramNumber) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getInParameterName", new Object[]{op, method, paramNumber});
        }
        if (paramNumber == -1) {
            QName qName = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getInParameterName", qName);
            }
            return qName;
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getInParameterName(op, method, paramNumber);
            if (q == null) continue;
            QName qName = q;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getInParameterName", qName);
            }
            return qName;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected QName getOutParameterName(OperationInfo op, Method method, int paramNumber) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getOutParameterName", new Object[]{op, method, paramNumber});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getOutParameterName(op, method, paramNumber);
            if (q == null) continue;
            QName qName = q;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getOutParameterName", qName);
            }
            return qName;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected QName getOutPartName(OperationInfo op, Method method, int paramNumber) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getOutPartName", new Object[]{op, method, paramNumber});
        }
        if (this.isWrapped(method)) {
            QName qName = this.getOutParameterName(op, method, paramNumber);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getOutPartName", qName);
            }
            return qName;
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getOutPartName(op, method, paramNumber);
            if (q == null) continue;
            QName qName = q;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getOutPartName", qName);
            }
            return qName;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Class<?> getResponseWrapper(Method selected) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getResponseWrapper", new Object[]{selected});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Class<?> cls = c.getResponseWrapper(selected);
            if (cls == null) continue;
            Class<?> clazz = cls;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getResponseWrapper", clazz);
            }
            return clazz;
        }
        Class<?> clazz = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getResponseWrapper", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getResponseWrapperClassName(Method selected) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getResponseWrapperClassName", new Object[]{selected});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            String cls = c.getResponseWrapperClassName(selected);
            if (cls == null) continue;
            String string = cls;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getResponseWrapperClassName", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getResponseWrapperClassName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Class<?> getRequestWrapper(Method selected) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getRequestWrapper", new Object[]{selected});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Class<?> cls = c.getRequestWrapper(selected);
            if (cls == null) continue;
            Class<?> clazz = cls;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getRequestWrapper", clazz);
            }
            return clazz;
        }
        Class<?> clazz = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getRequestWrapper", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getRequestWrapperClassName(Method selected) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getRequestWrapperClassName", new Object[]{selected});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            String cls = c.getRequestWrapperClassName(selected);
            if (cls == null) continue;
            String string = cls;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getRequestWrapperClassName", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getRequestWrapperClassName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isWrapperPartQualified(MessagePartInfo mpi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isWrapperPartQualified", new Object[]{mpi});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isWrapperPartQualified(mpi);
            if (b == null) continue;
            boolean bl = b;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isWrapperPartQualified", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isWrapperPartQualified", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isWrapperPartNillable(MessagePartInfo mpi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isWrapperPartNillable", new Object[]{mpi});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isWrapperPartNillable(mpi);
            if (b == null) continue;
            boolean bl = b;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isWrapperPartNillable", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isWrapperPartNillable", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getWrapperPartMaxOccurs(MessagePartInfo mpi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getWrapperPartMaxOccurs", new Object[]{mpi});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Long b = c.getWrapperPartMaxOccurs(mpi);
            if (b == null) continue;
            long l = b;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                l = l;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getWrapperPartMaxOccurs", l);
            }
            return l;
        }
        long l = 1L;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            l = l;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getWrapperPartMaxOccurs", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getWrapperPartMinOccurs(MessagePartInfo mpi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getWrapperPartMinOccurs", new Object[]{mpi});
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Long b = c.getWrapperPartMinOccurs(mpi);
            if (b == null) continue;
            long l = b;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                l = l;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getWrapperPartMinOccurs", l);
            }
            return l;
        }
        long l = 1L;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            l = l;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getWrapperPartMinOccurs", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected MethodDispatcher getMethodDispatcher() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getMethodDispatcher", new Object[0]);
        }
        MethodDispatcher methodDispatcher = this.methodDispatcher;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            methodDispatcher = methodDispatcher;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getMethodDispatcher", methodDispatcher);
        }
        return methodDispatcher;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setMethodDispatcher(MethodDispatcher m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setMethodDispatcher", new Object[]{m});
        }
        this.methodDispatcher = m;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setMethodDispatcher");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<AbstractServiceConfiguration> getConfigurations() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getConfigurations", new Object[0]);
        }
        List<AbstractServiceConfiguration> list = this.serviceConfigurations;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getConfigurations", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setConfigurations(List<AbstractServiceConfiguration> configurations) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setConfigurations", new Object[]{configurations});
        }
        this.serviceConfigurations = configurations;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setConfigurations");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Class<?> getServiceClass() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getServiceClass", new Object[0]);
        }
        Class<?> clazz = this.serviceClass;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getServiceClass", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void processParameterizedTypes() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "processParameterizedTypes", new Object[0]);
        }
        this.parameterizedTypes = new HashMap();
        if (this.serviceClass.isInterface()) {
            this.processTypes(this.serviceClass, this.serviceType);
        } else {
            for (int x = 0; x < this.serviceClass.getInterfaces().length; ++x) {
                this.processTypes(this.serviceClass.getInterfaces()[x], this.serviceClass.getGenericInterfaces()[x]);
            }
            this.processTypes(this.serviceClass.getSuperclass(), this.serviceClass.getGenericSuperclass());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "processParameterizedTypes");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void processTypes(Class<?> sc, Type tp) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "processTypes", new Object[]{sc, tp});
        }
        if (tp instanceof ParameterizedType) {
            ParameterizedType ptp = (ParameterizedType)tp;
            Type c = ptp.getRawType();
            HashMap<String, Class> m = new HashMap<String, Class>();
            this.parameterizedTypes.put(c, m);
            for (int x = 0; x < ptp.getActualTypeArguments().length; ++x) {
                Type t = ptp.getActualTypeArguments()[x];
                TypeVariable<Class<?>> tv = sc.getTypeParameters()[x];
                if (!(t instanceof Class)) continue;
                m.put(tv.getName(), (Class)t);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "processTypes");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setServiceType(ParameterizedType servicetype) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setServiceType", new Object[]{servicetype});
        }
        this.serviceType = servicetype;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setServiceType");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setServiceClass(Class<?> serviceClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setServiceClass", new Object[]{serviceClass});
        }
        this.serviceClass = serviceClass;
        this.checkServiceClassAnnotations(serviceClass);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setServiceClass");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void checkServiceClassAnnotations(Class<?> sc) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "checkServiceClassAnnotations", new Object[]{sc});
        }
        Annotation[] anns = this.serviceClass.getAnnotations();
        if (anns != null) {
            for (Annotation ann : anns) {
                String pkg = ann.annotationType().getPackage().getName();
                if (!"javax.xml.ws".equals(pkg) && !"javax.jws".equals(pkg)) continue;
                LOG.log(Level.WARNING, "JAXWS_ANNOTATION_FOUND", this.serviceClass.getName());
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "checkServiceClassAnnotations");
                }
                return;
            }
        }
        for (Method m : this.serviceClass.getMethods()) {
            anns = m.getAnnotations();
            if (anns == null) continue;
            for (Annotation ann : anns) {
                String pkg = ann.annotationType().getPackage().getName();
                if (!"javax.xml.ws".equals(pkg) && !"javax.jws".equals(pkg)) continue;
                LOG.log(Level.WARNING, "JAXWS_ANNOTATION_FOUND", this.serviceClass.getName());
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "checkServiceClassAnnotations");
                }
                return;
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "checkServiceClassAnnotations");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getWsdlURL() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getWsdlURL", new Object[0]);
        }
        if (this.wsdlURL == null) {
            URI uri;
            ServiceContractResolverRegistry registry;
            for (AbstractServiceConfiguration c : this.serviceConfigurations) {
                this.wsdlURL = c.getWsdlURL();
                if (this.wsdlURL == null) continue;
                break;
            }
            if (null == this.wsdlURL && this.getBus() != null && null != (registry = (ServiceContractResolverRegistry)this.getBus().getExtension(ServiceContractResolverRegistry.class)) && null != (uri = registry.getContractLocation(this.getServiceQName()))) {
                try {
                    this.wsdlURL = uri.toURL().toString();
                }
                catch (MalformedURLException e) {
                    LOG.log(Level.FINE, "resolve qname failed", this.getServiceQName());
                }
            }
            if (this.wsdlURL != null) {
                this.wsdlURL = new String(this.wsdlURL);
            }
        }
        String string = this.wsdlURL;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getWsdlURL", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setWsdlURL(String wsdlURL) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setWsdlURL", new Object[]{wsdlURL});
        }
        this.wsdlURL = new String(wsdlURL);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setWsdlURL");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setWsdlURL(URL wsdlURL) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setWsdlURL", new Object[]{wsdlURL});
        }
        this.wsdlURL = wsdlURL.toString();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setWsdlURL");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<AbstractServiceConfiguration> getServiceConfigurations() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getServiceConfigurations", new Object[0]);
        }
        List<AbstractServiceConfiguration> list = this.serviceConfigurations;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getServiceConfigurations", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setServiceConfigurations(List<AbstractServiceConfiguration> serviceConfigurations) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setServiceConfigurations", new Object[]{serviceConfigurations});
        }
        this.serviceConfigurations = serviceConfigurations;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setServiceConfigurations");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setServiceName(QName serviceName) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setServiceName", new Object[]{serviceName});
        }
        this.serviceName = serviceName;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setServiceName");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Invoker getInvoker() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getInvoker", new Object[0]);
        }
        Invoker invoker = this.invoker;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            invoker = invoker;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getInvoker", invoker);
        }
        return invoker;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setInvoker(Invoker invoker) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setInvoker", new Object[]{invoker});
        }
        this.invoker = invoker;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setInvoker");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Executor getExecutor() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getExecutor", new Object[0]);
        }
        Executor executor = this.executor;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            executor = executor;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getExecutor", executor);
        }
        return executor;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setExecutor(Executor executor) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setExecutor", new Object[]{executor});
        }
        this.executor = executor;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setExecutor");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<String> getIgnoredClasses() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getIgnoredClasses", new Object[0]);
        }
        List<String> list = this.ignoredClasses;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getIgnoredClasses", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setIgnoredClasses(List<String> ignoredClasses) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setIgnoredClasses", new Object[]{ignoredClasses});
        }
        this.ignoredClasses = ignoredClasses;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setIgnoredClasses");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Set<Class<?>> getExtraClass() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getExtraClass", new Object[0]);
        }
        Set<Class<?>> set = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getExtraClass", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isWrapped() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isWrapped", new Object[0]);
        }
        if (this.wrappedStyle != null) {
            this.defWrappedCache = this.wrappedStyle;
        }
        if (this.defWrappedCache == null) {
            for (AbstractServiceConfiguration c : this.serviceConfigurations) {
                this.defWrappedCache = c.isWrapped();
                if (this.defWrappedCache == null) continue;
                boolean bl = this.defWrappedCache;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isWrapped", bl);
                }
                return bl;
            }
            this.defWrappedCache = Boolean.TRUE;
        }
        boolean bl = this.defWrappedCache;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isWrapped", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getStyle() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getStyle", new Object[0]);
        }
        if (this.styleCache == null) {
            for (AbstractServiceConfiguration c : this.serviceConfigurations) {
                this.styleCache = c.getStyle();
                if (this.styleCache == null) continue;
                String string = this.styleCache;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    string = string;
                    LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getStyle", string);
                }
                return string;
            }
            this.styleCache = "document";
        }
        String string = this.styleCache;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getStyle", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isRPC(Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isRPC", new Object[]{method});
        }
        Boolean b = this.isRpcCache.get(method);
        if (b == null) {
            for (AbstractServiceConfiguration c : this.serviceConfigurations) {
                b = c.isRPC(method);
                if (b == null) continue;
                this.isRpcCache.put(method, b);
                boolean bl = b;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isRPC", bl);
                }
                return bl;
            }
            b = "rpc".equals(this.getStyle());
            this.isRpcCache.put(method, b);
        }
        boolean bl = b;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isRPC", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setWrapped(boolean style) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setWrapped", new Object[]{style});
        }
        this.wrappedStyle = style;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setWrapped");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Boolean getWrapped() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getWrapped", new Object[0]);
        }
        Boolean bl = this.wrappedStyle;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getWrapped", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Object> getProperties() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getProperties", new Object[0]);
        }
        Map<String, Object> map = this.properties;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getProperties", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setProperties(Map<String, Object> properties) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setProperties", new Object[]{properties});
        }
        this.properties = properties;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setProperties");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Method> getIgnoredMethods() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getIgnoredMethods", new Object[0]);
        }
        List<Method> list = this.ignoredMethods;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getIgnoredMethods", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setIgnoredMethods(List<Method> ignoredMethods) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setIgnoredMethods", new Object[]{ignoredMethods});
        }
        this.ignoredMethods = ignoredMethods;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setIgnoredMethods");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<AbstractFeature> getFeatures() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getFeatures", new Object[0]);
        }
        List<AbstractFeature> list = this.features;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "getFeatures", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setFeatures(List<AbstractFeature> f) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setFeatures", new Object[]{f});
        }
        this.features = f;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setFeatures");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isValidate() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isValidate", new Object[0]);
        }
        boolean bl = this.validate || SystemPropertyAction.getProperty((String)"cxf.validateServiceSchemas", (String)"false").equals("true");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isValidate", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setValidate(boolean validate) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setValidate", new Object[]{validate});
        }
        this.validate = validate;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setValidate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setSchemaLocations(List<String> schemaLocations) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setSchemaLocations", new Object[]{schemaLocations});
        }
        this.schemaLocations = schemaLocations;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "setSchemaLocations");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isEmptywsdl(String wsdlUrl) {
        Definition definition;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isEmptywsdl", new Object[]{wsdlUrl});
        }
        try {
            definition = ((WSDLManager)this.getBus().getExtension(WSDLManager.class)).getDefinition(wsdlUrl);
        }
        catch (WSDLException e) {
            LOG.log(Level.WARNING, "Failed to parse WSDL", e);
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isEmptywsdl", bl);
            }
            return bl;
        }
        if (definition.getPortTypes().isEmpty() && definition.getImports().isEmpty()) {
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isEmptywsdl", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.service.factory.ReflectionServiceFactoryBean", "isEmptywsdl", bl);
        }
        return bl;
    }
}

