/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaConnectorException;
import com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaInput;
import com.ibm.ws.microprofile.reactive.messaging.kafka.PartitionTracker;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaAdapterFactory;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.OffsetAndMetadata;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.TopicPartition;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CommittingPartitionTracker
extends PartitionTracker {
    private static final TraceComponent tc = Tr.register(CommittingPartitionTracker.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
    private final KafkaAdapterFactory factory;
    private final ScheduledExecutorService executor;
    private final KafkaInput<?, ?> kafkaInput;
    private final int maxCommitBatchSize;
    private final Duration maxCommitBatchInterval;
    private final SortedSet<CompletedWork> completedWork = new TreeSet<CompletedWork>();
    private int outstandingUncommittedWork = 0;
    private long committedOffset;
    private Future<?> pendingCommitTask = null;
    static final long serialVersionUID = -6191053165273479598L;

    public CommittingPartitionTracker(TopicPartition topicPartition, KafkaAdapterFactory factory, KafkaInput<?, ?> kafkaInput, long initialCommittedOffset, ScheduledExecutorService executor, int maxCommitBatchSize, Duration maxCommitBatchInterval) {
        super(topicPartition);
        this.factory = factory;
        this.kafkaInput = kafkaInput;
        this.executor = executor;
        this.committedOffset = initialCommittedOffset;
        this.maxCommitBatchSize = maxCommitBatchSize;
        this.maxCommitBatchInterval = maxCommitBatchInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public CompletionStage<Void> recordDone(long offset, Optional<Integer> leaderEpoch) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            SortedSet<CompletedWork> sortedSet = this.completedWork;
            synchronized (sortedSet) {
                boolean isNewOffset = offset < this.committedOffset ? false : this.completedWork.add(new CompletedWork(offset, leaderEpoch, result));
                if (isNewOffset) {
                    ++this.outstandingUncommittedWork;
                    this.requestCommit();
                } else {
                    result.completeExceptionally(new IllegalStateException("recordDone called more than once for offset " + offset));
                }
            }
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.CommittingPartitionTracker", (String)"131", (Object)this, (Object[])new Object[]{offset, leaderEpoch});
            Tr.error((TraceComponent)tc, (String)"internal.kafka.connector.error.CWMRX1000E", (Object[])new Object[]{t});
            result.completeExceptionally(new KafkaConnectorException(Tr.formatMessage((TraceComponent)tc, (String)"internal.kafka.connector.error.CWMRX1000E", (Object[])new Object[0]), (Throwable)t));
        }
        return result;
    }

    private void requestCommit() {
        if (this.maxCommitBatchSize > 0 && this.outstandingUncommittedWork > this.maxCommitBatchSize) {
            if (this.pendingCommitTask != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Cancelling scheduled commit task because we're committing right now", (Object[])new Object[]{this});
                }
                this.pendingCommitTask.cancel(true);
            }
            this.commitCompletedWork();
        } else if (this.pendingCommitTask == null && !this.maxCommitBatchInterval.isZero()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Scheduling deferred commit task", (Object[])new Object[]{this});
            }
            this.pendingCommitTask = this.executor.schedule(this::commitCompletedWork, this.maxCommitBatchInterval.toNanos(), TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitCompletedWork() {
        SortedSet<CompletedWork> sortedSet = this.completedWork;
        synchronized (sortedSet) {
            if (Thread.interrupted()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Commit task running but has been cancelled", (Object[])new Object[]{this});
                }
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Checking for new work to commit, last committed offset is " + this.committedOffset), (Object[])new Object[]{this});
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Current completed work", (Object[])new Object[]{this.completedWork});
            }
            long newCommitOffset = this.committedOffset;
            CompletedWork newestWork = null;
            for (CompletedWork work : this.completedWork) {
                if (work.offset < newCommitOffset) continue;
                if (work.offset != newCommitOffset) break;
                ++newCommitOffset;
                newestWork = work;
            }
            if (newestWork != null) {
                long originalCommitOffset = this.committedOffset;
                long finalCommitOffset = newCommitOffset;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Committing from " + originalCommitOffset + " to " + finalCommitOffset), (Object[])new Object[]{this});
                }
                this.commitUpTo(newestWork).whenCompleteAsync((r, t) -> this.processCommittedWork(originalCommitOffset, finalCommitOffset, (Throwable)t), this.executor);
            }
            this.outstandingUncommittedWork = (int)((long)this.outstandingUncommittedWork - (newCommitOffset - this.committedOffset));
            this.pendingCommitTask = null;
            this.committedOffset = newCommitOffset;
        }
    }

    private CompletionStage<Void> commitUpTo(CompletedWork work) {
        if (this.isClosed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Rejecting commit attempt because partition is closed", (Object[])new Object[]{this});
            }
            CompletableFuture<Void> result = new CompletableFuture<Void>();
            result.completeExceptionally(new Exception("Partition is closed"));
            return result;
        }
        OffsetAndMetadata offsetAndMetadata = this.factory.newOffsetAndMetadata(work.offset + 1L, work.leaderEpoch, null);
        return this.kafkaInput.commitOffsets(this.topicPartition, offsetAndMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommittedWork(long originalOffset, long committedOffset, Throwable exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (exception == null) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Commit from " + originalOffset + " to " + committedOffset + " completed successfully"), (Object[])new Object[]{this});
            } else {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Commit from " + originalOffset + " to " + committedOffset + " failed"), (Object[])new Object[]{this, exception});
            }
        }
        ArrayList<CompletedWork> committedWork = new ArrayList<CompletedWork>();
        Iterator iterator = this.completedWork;
        synchronized (iterator) {
            Iterator i = this.completedWork.iterator();
            while (i.hasNext()) {
                CompletedWork work = (CompletedWork)i.next();
                if (work.offset < originalOffset) continue;
                if (work.offset >= committedOffset) break;
                committedWork.add(work);
                i.remove();
            }
        }
        if (exception == null) {
            for (CompletedWork work : committedWork) {
                work.completion.complete(null);
            }
        } else {
            for (CompletedWork work : committedWork) {
                work.completion.completeExceptionally(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SortedSet<CompletedWork> sortedSet = this.completedWork;
        synchronized (sortedSet) {
            try {
                if (!this.completedWork.isEmpty()) {
                    this.commitCompletedWork();
                }
            }
            finally {
                super.close();
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class CompletedWork
    implements Comparable<CompletedWork> {
        private final long offset;
        private final CompletableFuture<Void> completion;
        private final Optional<Integer> leaderEpoch;
        static final long serialVersionUID = 4117644519278210751L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CompletedWork(long offset, Optional<Integer> leaderEpoch, CompletableFuture<Void> completion) {
            this.offset = offset;
            this.leaderEpoch = leaderEpoch;
            this.completion = completion;
        }

        public CompletableFuture<Void> getCompletion() {
            return this.completion;
        }

        public Optional<Integer> getLeaderEpoch() {
            return this.leaderEpoch;
        }

        @Override
        public int compareTo(CompletedWork o) {
            return Long.compare(this.offset, o.offset);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.reactive.messaging.kafka.CommittingPartitionTracker$CompletedWork", CompletedWork.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
        }
    }
}

