/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.util.stub;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;

class Util {
    private static Method defineClassMethod;

    Util() {
    }

    static String getPackageName(Class clazz) {
        String class_name = clazz.getName();
        int idx = class_name.lastIndexOf(46);
        if (idx == -1) {
            return null;
        }
        return class_name.substring(0, idx);
    }

    static String getClassName(Class clazz) {
        String class_name = clazz.getName();
        int idx = class_name.lastIndexOf(46);
        if (idx == -1) {
            return class_name;
        }
        return class_name.substring(idx + 1);
    }

    static Class defineClass(final ClassLoader loader, String className, byte[] data, int off, int len) {
        final Object[] args = new Object[5];
        try {
            args[0] = className;
            args[1] = data;
            args[2] = new Integer(off);
            args[3] = new Integer(len);
            args[4] = new CodeSource(new URL("file:stub"), new Certificate[0]);
        }
        catch (MalformedURLException ex) {
            throw new Error(ex.getMessage(), ex);
        }
        return (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecureClassLoader the_loader = loader == null ? (SecureClassLoader)Thread.currentThread().getContextClassLoader() : (SecureClassLoader)loader;
                defineClassMethod.setAccessible(true);
                try {
                    return defineClassMethod.invoke((Object)the_loader, args);
                }
                catch (IllegalAccessException ex) {
                    throw new Error("internal error", ex);
                }
                catch (IllegalArgumentException ex) {
                    throw new Error("internal error", ex);
                }
                catch (InvocationTargetException ex) {
                    Throwable th = ex.getTargetException();
                    if (th instanceof Error) {
                        throw (Error)th;
                    }
                    if (th instanceof RuntimeException) {
                        throw (RuntimeException)th;
                    }
                    throw new Error("unexpected exception: " + ex.getMessage(), ex);
                }
            }
        });
    }

    static String methodFieldName(int i) {
        return "__method$" + i;
    }

    static String handlerFieldName() {
        return "__handler";
    }

    static String initializerFieldName() {
        return "__initializer";
    }

    static String handlerDataFieldName() {
        return "__data";
    }

    static String getSuperMethodName(String name) {
        return "__super_" + name + "$" + Integer.toHexString(name.hashCode() & 0xFFFF);
    }

    static {
        try {
            defineClassMethod = SecureClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, CodeSource.class);
        }
        catch (Error ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new Error("unexpected exception: " + ex.getMessage(), ex);
        }
    }
}

