/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.ws.tcpchannel.internal.FilterCell;

public class FilterList {
    private static final int IP_ADDR_NUMBERS = 8;
    protected boolean active = false;
    FilterCell firstCell = new FilterCell();

    protected void setActive(boolean value) {
        this.active = value;
    }

    protected boolean getActive() {
        return this.active;
    }

    protected void buildData(String[] data, boolean validateOnly) {
        if (data == null) {
            return;
        }
        int length = data.length;
        for (int i = 0; i < length; ++i) {
            this.addAddressToList(data[i], validateOnly);
        }
    }

    private void addAddressToList(String newAddress, boolean validateOnly) {
        int start = 0;
        int delimiter = 46;
        int radix = 10;
        int[] addressToAdd = new int[8];
        for (int i = 0; i < 8; ++i) {
            addressToAdd[i] = 0;
        }
        int slot = 7;
        if (newAddress.indexOf(46) == -1) {
            delimiter = 58;
            radix = 16;
        }
        String addr = newAddress;
        while (true) {
            if ((start = addr.lastIndexOf(delimiter)) != -1) {
                String sub = addr.substring(start + 1);
                addressToAdd[slot] = sub.trim().equals("*") ? -1 : Integer.parseInt(sub, radix);
            } else {
                if (addr.trim().equals("*")) {
                    addressToAdd[slot] = -1;
                    break;
                }
                addressToAdd[slot] = Integer.parseInt(addr, radix);
                break;
            }
            --slot;
            addr = addr.substring(0, start);
        }
        if (!validateOnly) {
            this.putInList(addressToAdd);
        }
    }

    private void putInList(int[] address) {
        FilterCell currentCell = this.firstCell;
        FilterCell nextCell = null;
        for (int i = 0; i < address.length; ++i) {
            nextCell = address[i] != -1 ? currentCell.findNextCell(address[i]) : currentCell.getWildcardCell();
            if (nextCell == null) {
                for (int j = i; j < address.length; ++j) {
                    currentCell = currentCell.addNewCell(address[j]);
                }
                return;
            }
            currentCell = nextCell;
        }
    }

    public boolean findInList(byte[] address) {
        int len = address.length;
        int[] a = new int[len];
        for (int i = 0; i < len; ++i) {
            a[i] = address[i] & 0xFF;
        }
        return this.findInList(a);
    }

    public boolean findInList6(byte[] address) {
        int len = address.length;
        int[] a = new int[len / 2];
        int j = 0;
        int highOrder = 0;
        int lowOrder = 0;
        for (int i = 0; i < len; i += 2) {
            highOrder = address[i] & 0xFF;
            lowOrder = address[i + 1] & 0xFF;
            a[j] = highOrder * 256 + lowOrder;
            ++j;
        }
        return this.findInList(a);
    }

    public boolean findInList(int[] address) {
        int len = address.length;
        if (len < 8) {
            int j = 7;
            int[] a = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
            int i = len;
            while (i > 0) {
                a[j] = address[i - 1];
                --i;
                --j;
            }
            return this.findInList(a, 0, this.firstCell, 7);
        }
        return this.findInList(address, 0, this.firstCell, address.length - 1);
    }

    private boolean findInList(int[] address, int index, FilterCell cell, int endIndex) {
        if (cell.getWildcardCell() != null) {
            if (index == endIndex) {
                return true;
            }
            FilterCell newcell = cell.getWildcardCell();
            if (this.findInList(address, index + 1, newcell, endIndex)) {
                return true;
            }
            FilterCell nextCell = cell.findNextCell(address[index]);
            if (nextCell != null) {
                if (index == endIndex) {
                    return true;
                }
                return this.findInList(address, index + 1, nextCell, endIndex);
            }
            return false;
        }
        FilterCell nextCell = cell.findNextCell(address[index]);
        if (nextCell != null) {
            if (index == endIndex) {
                return true;
            }
            return this.findInList(address, index + 1, nextCell, endIndex);
        }
        return false;
    }
}

