/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.channelfw.objectpool;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.channelfw.objectpool.ObjectDestroyer;
import com.ibm.wsspi.channelfw.objectpool.ObjectFactory;
import com.ibm.wsspi.channelfw.objectpool.ObjectPool;

public class LocalThreadObjectPool
implements ObjectPool {
    private Object[] free = null;
    private ObjectFactory factory = null;
    private ObjectDestroyer destroyer = null;
    private long[] timeFreed = null;
    private int firstEntry = -1;
    private int lastEntry = -1;
    private final int maxPoolSize;
    private int poolSize;
    private int putCount = 0;
    private int getCount = 0;
    private int underflowCount = 0;
    private int overflowCount = 0;
    private int minElements = 0;
    private static final int adjustThreshold = 1000;
    private int minPoolSize;
    private int batchSize;
    private int adjustSize;
    private boolean cleanUpOld = true;
    private static final TraceComponent tc = Tr.register(LocalThreadObjectPool.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");

    public LocalThreadObjectPool(int size, ObjectFactory fact) {
        this(size, fact, null);
    }

    public LocalThreadObjectPool(int size, ObjectFactory fact, ObjectDestroyer dest) {
        this.destroyer = dest;
        this.factory = fact;
        this.poolSize = this.maxPoolSize = size;
        if (this.maxPoolSize > 10) {
            this.minPoolSize = this.maxPoolSize / 5;
            this.batchSize = this.minPoolSize / 2;
            if (this.batchSize < 2) {
                this.batchSize = this.minPoolSize;
            }
            this.adjustSize = this.minPoolSize / 2;
        } else {
            this.minPoolSize = this.maxPoolSize / 2;
            if (this.minPoolSize == 0) {
                this.minPoolSize = 1;
            }
            this.batchSize = this.minPoolSize >= 3 ? 3 : this.minPoolSize;
            this.adjustSize = 0;
        }
        this.free = new Object[this.poolSize];
        this.timeFreed = new long[this.poolSize];
        for (int i = 0; i < this.poolSize; ++i) {
            this.free[i] = null;
            this.timeFreed[i] = 0L;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Object Pool " + this + " created, max size: " + this.maxPoolSize + ", minPoolSize: " + this.minPoolSize), (Object[])new Object[0]);
        }
    }

    public LocalThreadObjectPool(int size) {
        this(size, null);
    }

    @Override
    public Object get() {
        Object oObject = null;
        ++this.getCount;
        if (this.lastEntry > -1) {
            oObject = this.free[this.lastEntry];
            this.free[this.lastEntry] = null;
            if (this.lastEntry == this.firstEntry) {
                this.lastEntry = -1;
                this.firstEntry = -1;
            } else {
                this.lastEntry = this.lastEntry > 0 ? --this.lastEntry : this.poolSize - 1;
            }
        }
        if (oObject == null) {
            ++this.underflowCount;
        }
        if (this.getCurrentNumElements() < this.minElements) {
            this.minElements = this.getCurrentNumElements();
        }
        if (this.getCount + this.putCount > 1000) {
            this.adjustPoolSize();
        }
        if (oObject == null && this.factory != null) {
            oObject = this.factory.create();
        }
        return oObject;
    }

    @Override
    public Object put(Object object) {
        ++this.putCount;
        long currentTime = CHFWBundle.getApproxTime();
        ++this.lastEntry;
        if (this.lastEntry == this.poolSize) {
            this.lastEntry = 0;
        }
        Object returnVal = this.free[this.lastEntry];
        this.free[this.lastEntry] = object;
        this.timeFreed[this.lastEntry] = currentTime;
        if (this.lastEntry == this.firstEntry) {
            ++this.firstEntry;
            if (this.firstEntry == this.poolSize) {
                this.firstEntry = 0;
            }
        }
        if (this.firstEntry == -1) {
            this.firstEntry = this.lastEntry;
        }
        if (returnVal != null) {
            ++this.overflowCount;
        }
        if (this.cleanUpOld) {
            while (this.firstEntry != this.lastEntry && currentTime > this.timeFreed[this.firstEntry] + 60000L) {
                if (this.destroyer != null && this.free[this.firstEntry] != null) {
                    this.destroyer.destroy(this.free[this.firstEntry]);
                }
                this.free[this.firstEntry] = null;
                ++this.firstEntry;
                if (this.firstEntry != this.poolSize) continue;
                this.firstEntry = 0;
            }
        }
        if (this.getCount + this.putCount > 1000) {
            this.adjustPoolSize();
        }
        return returnVal;
    }

    public void setCleanUpOld(boolean flag) {
        this.cleanUpOld = flag;
    }

    protected Object[] getBatch() {
        Object[] objectArray = new Object[this.batchSize];
        objectArray[0] = this.get();
        int numElements = this.getCurrentNumElements();
        for (int i = 1; i <= numElements && i < this.batchSize; ++i) {
            objectArray[i] = this.get();
        }
        return objectArray;
    }

    protected void putBatch(Object[] objectArray) {
        for (int index = 0; index < objectArray.length && objectArray[index] != null; ++index) {
            this.put(objectArray[index]);
        }
    }

    private int getCurrentNumElements() {
        if (this.lastEntry == -1) {
            return 0;
        }
        if (this.lastEntry >= this.firstEntry) {
            return this.lastEntry - this.firstEntry + 1;
        }
        return this.lastEntry + 1 + (this.poolSize - this.firstEntry);
    }

    protected Object[] purge() {
        Object[] data = new Object[this.getCurrentNumElements()];
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("LocalPool is purging " + data.length + " items.  firstEntry: " + this.firstEntry + " lastEntry: " + this.lastEntry + " poolSize: " + this.poolSize), (Object[])new Object[0]);
        }
        if (0 < data.length) {
            int out = 0;
            if (this.lastEntry >= this.firstEntry) {
                for (int i = this.firstEntry; i <= this.lastEntry; ++i) {
                    data[out] = this.free[i];
                    this.free[i] = null;
                    ++out;
                }
            } else {
                int i;
                for (i = this.firstEntry; i < this.poolSize; ++i) {
                    data[out] = this.free[i];
                    this.free[i] = null;
                    ++out;
                }
                for (i = 0; i <= this.lastEntry; ++i) {
                    data[out] = this.free[i];
                    this.free[i] = null;
                    ++out;
                }
            }
            this.lastEntry = -1;
            this.firstEntry = -1;
        }
        return data;
    }

    private void adjustPoolSize() {
        int oldPoolSize = this.poolSize;
        if (this.underflowCount == 0 && this.poolSize > 10 && this.minElements > this.minPoolSize / 2 && this.poolSize > this.minPoolSize) {
            this.poolSize = this.poolSize - this.minPoolSize > this.adjustSize * 2 ? (this.poolSize - this.minPoolSize) / 2 + this.minPoolSize : (this.poolSize -= this.adjustSize);
            if (this.poolSize < this.minPoolSize) {
                this.poolSize = this.minPoolSize;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Object Pool " + this + " reduced, old size: " + oldPoolSize + " new pool size: " + this.poolSize), (Object[])new Object[0]);
            }
            while (oldPoolSize > this.poolSize) {
                if (this.destroyer != null && this.free[oldPoolSize - 1] != null) {
                    this.destroyer.destroy(this.free[oldPoolSize - 1]);
                }
                this.free[oldPoolSize - 1] = null;
                if (this.lastEntry == oldPoolSize - 1) {
                    --this.lastEntry;
                }
                if (this.firstEntry == oldPoolSize - 1) {
                    --this.firstEntry;
                }
                --oldPoolSize;
            }
        } else if (this.underflowCount > 0 && this.overflowCount > 0 && this.poolSize < this.maxPoolSize) {
            this.poolSize += this.adjustSize;
            if (this.poolSize > this.maxPoolSize) {
                this.poolSize = this.maxPoolSize;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Object Pool " + this + " enlarged, old size: " + oldPoolSize + " new pool size: " + this.poolSize), (Object[])new Object[0]);
            }
            if (this.firstEntry > this.lastEntry) {
                while (oldPoolSize < this.poolSize) {
                    if (this.firstEntry > this.lastEntry) {
                        if (this.destroyer != null && this.free[oldPoolSize - 1] != null) {
                            this.destroyer.destroy(this.free[oldPoolSize - 1]);
                        }
                        this.free[oldPoolSize - 1] = this.free[this.lastEntry];
                        this.free[this.lastEntry] = null;
                        this.lastEntry = this.lastEntry > 0 ? --this.lastEntry : oldPoolSize - 1;
                    }
                    ++oldPoolSize;
                }
            }
        }
        this.minElements = this.getCurrentNumElements();
        this.getCount = 0;
        this.putCount = 0;
        this.underflowCount = 0;
        this.overflowCount = 0;
    }
}

