/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.connmgmt;

import com.ibm.ws.channelfw.internal.InboundVirtualConnection;
import com.ibm.wsspi.channelfw.OutboundVirtualConnection;
import com.ibm.wsspi.channelfw.VirtualConnection;
import java.util.Map;

public final class ConnectionType {
    protected static final String CONNECTION_TYPE_VC_KEY = "CFW_CONNECTION_TYPE";
    private static final byte TYPE_OUTBOUND_MIN = 0;
    private static final byte TYPE_OUTBOUND = 1;
    private static final byte TYPE_OUTBOUND_CR_TO_REMOTE = 3;
    private static final byte TYPE_OUTBOUND_SR_TO_CR_REMOTE = 4;
    private static final byte TYPE_OUTBOUND_MAX = 10;
    private static final byte TYPE_INTERNAL_CR_SR = -1;
    private static final byte TYPE_INBOUND_MIN = 20;
    private static final byte TYPE_INBOUND = 21;
    private static final byte TYPE_INBOUND_CR = 23;
    private static final byte TYPE_INBOUND_MAX = 30;
    public static final ConnectionType OUTBOUND = new ConnectionType(1, "OUT:REMOTE");
    public static final ConnectionType OUTBOUND_CR_TO_REMOTE = new ConnectionType(3, "OUT:CR");
    public static final ConnectionType OUTBOUND_SR_TO_CR_REMOTE = new ConnectionType(4, "OUT:SR-CR");
    public static final ConnectionType INTERNAL_CR_SR = new ConnectionType(-1, "INTERNAL:CR-SR");
    public static final ConnectionType INBOUND = new ConnectionType(21, "IN:REMOTE");
    public static final ConnectionType INBOUND_CR = new ConnectionType(23, "IN:CR");
    private final byte type;
    private final String typeString;

    public static ConnectionType getVCConnectionType(VirtualConnection vc) {
        if (vc == null) {
            return null;
        }
        return (ConnectionType)vc.getStateMap().get(CONNECTION_TYPE_VC_KEY);
    }

    public static void setVCConnectionType(VirtualConnection vc, ConnectionType connType) {
        if (vc == null || connType == null) {
            return;
        }
        Map<Object, Object> map = vc.getStateMap();
        if (vc instanceof InboundVirtualConnection && ConnectionType.isOutbound(connType.type)) {
            throw new IllegalStateException("Cannot set outbound ConnectionType on inbound VirtualConnection");
        }
        if (vc instanceof OutboundVirtualConnection && ConnectionType.isInbound(connType.type)) {
            throw new IllegalStateException("Cannot set inbound ConnectionType on outbound VirtualConnection");
        }
        map.put(CONNECTION_TYPE_VC_KEY, connType);
    }

    public static void setDefaultVCConnectionType(VirtualConnection vc) {
        if (vc == null) {
            return;
        }
        Map<Object, Object> map = vc.getStateMap();
        if (map.get(CONNECTION_TYPE_VC_KEY) == null) {
            if (vc instanceof InboundVirtualConnection) {
                map.put(CONNECTION_TYPE_VC_KEY, INBOUND);
            } else {
                map.put(CONNECTION_TYPE_VC_KEY, OUTBOUND);
            }
        }
    }

    public static ConnectionType getConnectionType(byte type) {
        switch (type) {
            case 1: {
                return OUTBOUND;
            }
            case 3: {
                return OUTBOUND_CR_TO_REMOTE;
            }
            case 4: {
                return OUTBOUND_SR_TO_CR_REMOTE;
            }
            case 21: {
                return INBOUND;
            }
            case 23: {
                return INBOUND_CR;
            }
            case -1: {
                return INTERNAL_CR_SR;
            }
        }
        return null;
    }

    static final boolean isOutbound(byte type) {
        return type > 0 && type < 10;
    }

    static final boolean isInbound(byte type) {
        return type > 20 && type < 30;
    }

    static final boolean isInternal(byte type) {
        return type < 0;
    }

    private ConnectionType(byte type, String typeString) {
        this.type = type;
        this.typeString = typeString;
    }

    public byte export() {
        return this.type;
    }

    public boolean equals(Object that) {
        if (that == null || that.getClass() != this.getClass()) {
            return false;
        }
        return ((ConnectionType)that).type == this.type;
    }

    public int hashCode() {
        return this.typeString.hashCode();
    }

    public String toString() {
        return this.typeString;
    }
}

