/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.util.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils;
import com.ibm.ws.annocache.util.internal.UtilImpl_ReadBuffer;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class UtilImpl_ReadBufferFull
implements UtilImpl_ReadBuffer {
    private final File file;
    private final byte[] buffer;
    private int bufferFill;
    private int bufferPos;
    private int bufferAvail;
    private final String encoding;
    private final Charset charset;
    public static final String UTF_8 = "UTF-8";
    private final byte[] smallIntBytes = new byte[2];
    private final byte[] largeIntBytes = new byte[4];
    private final int MAX_STRING = 512;
    private final int MAX_WIDTH = 60;
    private final byte[] stringBytes = new byte[512];
    private final byte[] nullBytes = new byte[60];
    static final long serialVersionUID = 9066645182542683597L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public File getFile() {
        return this.file;
    }

    @Override
    public String getPath() {
        return this.getFile().getPath();
    }

    @Override
    @Trivial
    public String getEncoding() {
        return this.encoding;
    }

    public UtilImpl_ReadBufferFull(String path, String encoding) throws IOException {
        this.file = new File(path);
        this.buffer = UtilImpl_FileUtils.readFully(this.file);
        this.bufferFill = this.buffer.length;
        this.encoding = encoding;
        this.charset = Charset.forName(encoding);
        this.bufferPos = 0;
        this.bufferAvail = this.bufferFill;
    }

    @Override
    public void close() throws IOException {
    }

    @Trivial
    public static int asInt(byte[] b) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value <<= 8;
            value |= b[i] & 0xFF;
        }
        return value;
    }

    @Override
    @Trivial
    public int readSmallInt() throws IOException {
        this.read(this.smallIntBytes, 0, 2);
        return (this.smallIntBytes[0] & 0xFF) << 8 | (this.smallIntBytes[1] & 0xFF) << 0;
    }

    @Trivial
    public static int convertLargeInt(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | (bytes[3] & 0xFF) << 0;
    }

    @Override
    @Trivial
    public int readLargeInt() throws IOException {
        this.read(this.largeIntBytes, 0, 4);
        return UtilImpl_ReadBufferFull.convertLargeInt(this.largeIntBytes);
    }

    @Override
    @Trivial
    public int read() throws IOException {
        if (this.bufferAvail == 0) {
            throw new IOException("Read past end of file on [ " + this.getPath() + " ]");
        }
        byte readByte = this.buffer[this.bufferPos];
        ++this.bufferPos;
        --this.bufferAvail;
        return readByte;
    }

    @Override
    @Trivial
    public void read(byte[] bytes) throws IOException {
        this.read(bytes, 0, bytes.length);
    }

    @Override
    @Trivial
    public void read(byte[] bytes, int offset, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (len < 0) {
            throw new IOException("Disallowed read of [ " + len + " ] bytes  from [ " + this.getPath() + " ]");
        }
        if (len > this.bufferAvail) {
            throw new IOException("Read past end of file. Requested [ " + len + " ] bytes ; available [ " + this.bufferAvail + " ] bytes  from [ " + this.getPath() + " ]");
        }
        System.arraycopy(this.buffer, this.bufferPos, bytes, offset, len);
        this.bufferPos += len;
        this.bufferAvail -= len;
    }

    @Override
    @Trivial
    public int getFileLength() {
        return this.bufferFill;
    }

    @Override
    public void seekEnd(int offset) throws IOException {
        this.seek(this.getFileLength() + offset);
    }

    @Override
    public void seek(int offset) throws IOException {
        if (offset < 0) {
            throw new IOException("Offset [ " + offset + " ] past beginning of [ " + this.getPath() + " ]");
        }
        if (offset > this.bufferFill) {
            throw new IOException("Offset [ " + offset + " ] past end [ " + this.bufferFill + " ] of [ " + this.getPath() + " ]");
        }
        this.bufferPos = offset;
        this.bufferAvail = this.bufferFill - this.bufferPos;
    }

    @Override
    @Trivial
    public int validSmallInt() throws IOException {
        this.read(this.smallIntBytes, 0, 2);
        int smallInt = (this.smallIntBytes[0] & 0xFF) << 8 | (this.smallIntBytes[1] & 0xFF) << 0;
        if (smallInt > 512) {
            throw new IOException("String width [ " + smallInt + " ] greater than allowed [ " + 512 + " ] for [ " + this.getPath() + " ]");
        }
        return smallInt;
    }

    @Override
    @Trivial
    public String readString() throws IOException {
        int valueLength = this.validSmallInt();
        this.read(this.stringBytes, 0, valueLength);
        return new String(this.stringBytes, 0, valueLength, this.charset);
    }

    @Override
    @Trivial
    public String readString(int width) throws IOException {
        int valueLength = this.validSmallInt();
        this.read(this.stringBytes, 0, valueLength);
        int nullCount = width - 3 - valueLength;
        if (nullCount > 0) {
            this.read(this.nullBytes, 0, nullCount);
        }
        return new String(this.stringBytes, 0, valueLength, this.charset);
    }

    @Override
    @Trivial
    public void requireByte(byte fieldByte) throws IOException {
        byte actualByte = (byte)this.read();
        if (actualByte != fieldByte) {
            throw new IOException("Failed read of [ " + this.getPath() + " ]: Expected field byte [ " + fieldByte + " ] actual field byte [ " + actualByte + " ]");
        }
    }

    @Override
    @Trivial
    public String requireField(byte fieldByte) throws IOException {
        this.requireByte(fieldByte);
        return this.readString();
    }

    @Override
    @Trivial
    public String requireField(byte fieldByte, int width) throws IOException {
        this.requireByte(fieldByte);
        return this.readString(width);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_ReadBufferFull", UtilImpl_ReadBufferFull.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    }
}

