/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.cdi.internal;

import com.ibm.jbatch.container.cdi.BatchXMLMapper;
import com.ibm.jbatch.container.cdi.CDIBatchArtifactFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class CDIBatchArtifactFactoryImpl
implements CDIBatchArtifactFactory {
    private static final Logger logger = Logger.getLogger(CDIBatchArtifactFactoryImpl.class.getName());
    static final long serialVersionUID = -3829449424819023500L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public CDIBatchArtifactFactoryImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object load(String batchId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "load", new Object[]{batchId});
        }
        Object loadedArtifact = this.getArtifactById(batchId);
        if (loadedArtifact != null && logger.isLoggable(Level.FINEST)) {
            logger.finest("load: batchId: " + batchId + ", artifact: " + loadedArtifact + ", artifact class: " + loadedArtifact.getClass().getCanonicalName());
        }
        Object object = loadedArtifact;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            object = object;
            logger.exiting("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "load", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Object getArtifactById(String id) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getArtifactById", new Object[]{id});
        }
        BeanManager bm = this.getBeanManager();
        Bean<?> bean = bm != null ? this.getBeanById(bm, id) : null;
        Object object = bean != null ? bm.getReference(bean, (Type)bean.getBeanClass(), bm.createCreationalContext(bean)) : null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            object = object;
            logger.exiting("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getArtifactById", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={NameNotFoundException.class})
    protected BeanManager getBeanManager() {
        BeanManager beanManager;
        block6: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getBeanManager", new Object[0]);
            }
            try {
                InitialContext initialContext = new InitialContext();
                beanManager = (BeanManager)initialContext.lookup("java:comp/BeanManager");
                if (logger == null || !logger.isLoggable(Level.FINER)) break block6;
            }
            catch (NameNotFoundException nnfe) {
                BeanManager beanManager2 = null;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    beanManager2 = beanManager2;
                    logger.exiting("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getBeanManager", beanManager2);
                }
                return beanManager2;
            }
            catch (NamingException nnfe) {
                FFDCFilter.processException((Throwable)nnfe, (String)"com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", (String)"101", (Object)this, (Object[])new Object[0]);
                BeanManager beanManager3 = null;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    beanManager3 = beanManager3;
                    logger.exiting("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getBeanManager", beanManager3);
                }
                return beanManager3;
            }
            beanManager = beanManager;
            logger.exiting("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getBeanManager", beanManager);
        }
        return beanManager;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Bean<?> getBeanById(BeanManager bm, String id) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getBeanById", new Object[]{bm, id});
        }
        Bean<?> match = this.getUniqueBeanByBeanName(bm, id);
        if (match == null) {
            match = this.getUniqueBeanForBatchXMLEntry(bm, id);
        }
        if (match == null) {
            match = this.getUniqueBeanForClassName(bm, id);
        }
        Bean<?> bean = match;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bean = bean;
            logger.exiting("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getBeanById", bean);
        }
        return bean;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Bean<?> getUniqueBeanByBeanName(BeanManager bm, String batchId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getUniqueBeanByBeanName", new Object[]{bm, batchId});
        }
        Bean match = null;
        Set beans = bm.getBeans(batchId);
        try {
            match = bm.resolve(beans);
        }
        catch (AmbiguousResolutionException ambiguousResolutionException) {
            FFDCFilter.processException((Throwable)ambiguousResolutionException, (String)"com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", (String)"142", (Object)this, (Object[])new Object[]{bm, batchId});
            Bean<?> bean = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bean = bean;
                logger.exiting("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getUniqueBeanByBeanName", bean);
            }
            return bean;
        }
        Bean bean = match;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bean = bean;
            logger.exiting("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getUniqueBeanByBeanName", bean);
        }
        return bean;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={BatchCDIAmbiguousResolutionCheckedException.class})
    protected Bean<?> getUniqueBeanForBatchXMLEntry(BeanManager bm, String batchId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getUniqueBeanForBatchXMLEntry", new Object[]{bm, batchId});
        }
        ClassLoader loader = this.getContextClassLoader();
        BatchXMLMapper batchXMLMapper = new BatchXMLMapper(loader);
        Class clazz = batchXMLMapper.getArtifactById(batchId);
        if (clazz != null) {
            Bean<?> bean;
            block7: {
                try {
                    bean = this.findUniqueBeanForClass(bm, clazz);
                    if (logger == null || !logger.isLoggable(Level.FINER)) break block7;
                }
                catch (BatchCDIAmbiguousResolutionCheckedException e) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("getBeanForBatchXML: BatchCDIAmbiguousResolutionCheckedException: " + e.getMessage());
                    }
                    Bean<?> bean2 = null;
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        bean2 = bean2;
                        logger.exiting("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getUniqueBeanForBatchXMLEntry", bean2);
                    }
                    return bean2;
                }
                bean = bean;
                logger.exiting("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getUniqueBeanForBatchXMLEntry", bean);
            }
            return bean;
        }
        Bean<?> bean = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bean = bean;
            logger.exiting("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getUniqueBeanForBatchXMLEntry", bean);
        }
        return bean;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={ClassNotFoundException.class, BatchCDIAmbiguousResolutionCheckedException.class})
    protected Bean<?> getUniqueBeanForClassName(BeanManager bm, String className) {
        Bean<?> bean;
        block8: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getUniqueBeanForClassName", new Object[]{bm, className});
            }
            try {
                Class<?> clazz = this.getContextClassLoader().loadClass(className);
                bean = this.findUniqueBeanForClass(bm, clazz);
                if (logger == null || !logger.isLoggable(Level.FINER)) break block8;
            }
            catch (BatchCDIAmbiguousResolutionCheckedException e) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("getBeanForClassName: BatchCDIAmbiguousResolutionCheckedException: " + e.getMessage());
                }
                Bean<?> bean2 = null;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bean2 = bean2;
                    logger.exiting("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getUniqueBeanForClassName", bean2);
                }
                return bean2;
            }
            catch (ClassNotFoundException cnfe) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("getBeanForClassName: ClassNotFoundException for " + className + ": " + cnfe);
                }
                Bean<?> bean3 = null;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bean3 = bean3;
                    logger.exiting("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getUniqueBeanForClassName", bean3);
                }
                return bean3;
            }
            bean = bean;
            logger.exiting("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getUniqueBeanForClassName", bean);
        }
        return bean;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Bean<?> findUniqueBeanForClass(BeanManager beanManager, Class<?> clazz) throws BatchCDIAmbiguousResolutionCheckedException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "findUniqueBeanForClass", new Object[]{beanManager, clazz});
        }
        Bean match = null;
        Set beans = beanManager.getBeans(clazz, new Annotation[0]);
        if (beans == null || beans.isEmpty()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("In findBeanForClass: found empty set or null for class: " + clazz);
            }
            Bean<?> bean = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bean = bean;
                logger.exiting("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "findUniqueBeanForClass", bean);
            }
            return bean;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("In findBeanForClass: found non-empty set: " + beans + " for class: " + clazz);
        }
        for (Bean bean : beans) {
            if (!bean.getBeanClass().equals(clazz)) continue;
            if (match != null) {
                throw new BatchCDIAmbiguousResolutionCheckedException("Found both bean = " + match + ", and also bean = " + bean + " with beanClass = " + bean.getBeanClass());
            }
            match = bean;
        }
        Bean bean = match;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bean = bean;
            logger.exiting("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "findUniqueBeanForClass", bean);
        }
        return bean;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ClassLoader getContextClassLoader() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getContextClassLoader", new Object[0]);
        }
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = 2536769594833481079L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl$1", 1.class, (String)"wsbatch", null);
            }
        });
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classLoader = classLoader;
            logger.exiting("com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl", "getContextClassLoader", classLoader);
        }
        return classLoader;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class BatchCDIAmbiguousResolutionCheckedException
    extends Exception {
        static final long serialVersionUID = -2714645095726948814L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public BatchCDIAmbiguousResolutionCheckedException() {
        }

        public BatchCDIAmbiguousResolutionCheckedException(String message) {
            super(message);
        }

        public BatchCDIAmbiguousResolutionCheckedException(String message, Throwable cause) {
            super(message, cause);
        }

        public BatchCDIAmbiguousResolutionCheckedException(Throwable cause) {
            super(cause);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.cdi.internal.CDIBatchArtifactFactoryImpl$BatchCDIAmbiguousResolutionCheckedException", BatchCDIAmbiguousResolutionCheckedException.class, (String)"wsbatch", null);
        }
    }
}

