/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.DBPlatformHelper;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingFactory;
import org.eclipse.persistence.internal.sequencing.SequencingHome;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.platform.database.events.DatabaseEventListener;
import org.eclipse.persistence.platform.server.NoServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatformBase;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryResultsCachePolicy;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.SequencingControl;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.tools.tuning.SessionTuner;

public class DatabaseSessionImpl
extends AbstractSession
implements DatabaseSession {
    protected DatabaseEventListener databaseEventListener;
    protected SequencingHome sequencingHome;
    protected ServerPlatform serverPlatform;
    protected SessionTuner tuner;
    protected long connectedTime;
    protected volatile boolean isLoggedIn;

    protected void setSequencingHome(SequencingHome sequencingHome) {
        this.sequencingHome = sequencingHome;
    }

    protected SequencingHome getSequencingHome() {
        if (this.sequencingHome == null) {
            this.setSequencingHome(SequencingFactory.createSequencingHome(this));
        }
        return this.sequencingHome;
    }

    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    @Override
    public DatabaseEventListener getDatabaseEventListener() {
        return this.databaseEventListener;
    }

    @Override
    public void setDatabaseEventListener(DatabaseEventListener databaseEventListener) {
        this.databaseEventListener = databaseEventListener;
    }

    public void setDatasourceAndInitialize() throws DatabaseException {
        this.preConnectDatasource();
        this.setOrDetectDatasource(false);
        this.postConnectDatasource();
    }

    protected void setOrDetectDatasource(boolean throwException) {
        String driverName;
        String majorVersion;
        String minorVersion;
        String vendorName;
        block23: {
            vendorName = null;
            minorVersion = null;
            majorVersion = null;
            driverName = null;
            if (this.getProperties().containsKey("javax.persistence.database-product-name")) {
                vendorName = (String)this.getProperties().get("javax.persistence.database-product-name");
                minorVersion = (String)this.getProperties().get("javax.persistence.database-minor-version");
                majorVersion = (String)this.getProperties().get("javax.persistence.database-major-version");
            } else {
                Connection conn = null;
                try {
                    try {
                        conn = (Connection)this.getReadLogin().connectToDatasource(null, this);
                        DatabaseMetaData dmd = conn.getMetaData();
                        vendorName = dmd.getDatabaseProductName();
                        minorVersion = dmd.getDatabaseProductVersion();
                        majorVersion = Integer.toString(dmd.getDatabaseMajorVersion());
                        driverName = conn.getMetaData().getDriverName();
                    }
                    catch (SQLException ex) {
                        if (throwException) {
                            DatabaseException dbEx = DatabaseException.errorRetrieveDbMetadataThroughJDBCConnection();
                            dbEx.initCause(ex);
                            throw dbEx;
                        }
                        if (conn == null) break block23;
                        try {
                            conn.close();
                            break block23;
                        }
                        catch (SQLException ex2) {
                            if (throwException) {
                                DatabaseException dbEx = DatabaseException.errorRetrieveDbMetadataThroughJDBCConnection();
                                dbEx.initCause(ex2);
                                throw dbEx;
                            }
                            break block23;
                        }
                    }
                }
                catch (Throwable throwable) {
                    block24: {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (SQLException ex) {
                                if (!throwException) break block24;
                                DatabaseException dbEx = DatabaseException.errorRetrieveDbMetadataThroughJDBCConnection();
                                dbEx.initCause(ex);
                                throw dbEx;
                            }
                        }
                    }
                    throw throwable;
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {
                        if (!throwException) break block23;
                        DatabaseException dbEx = DatabaseException.errorRetrieveDbMetadataThroughJDBCConnection();
                        dbEx.initCause(ex);
                        throw dbEx;
                    }
                }
            }
        }
        String platformName = null;
        try {
            this.platform = null;
            platformName = DBPlatformHelper.getDBPlatform(vendorName, minorVersion, majorVersion, this.getSessionLog());
            this.getLogin().setPlatformClassName(platformName);
        }
        catch (EclipseLinkException classNotFound) {
            if (platformName.indexOf("Oracle") != -1) {
                try {
                    platformName = DBPlatformHelper.getDBPlatform("core." + vendorName, minorVersion, majorVersion, this.getSessionLog());
                    this.getLogin().setPlatformClassName(platformName);
                }
                catch (EclipseLinkException eclipseLinkException) {
                    this.getLogin().setPlatformClassName(OraclePlatform.class.getName());
                }
            }
            throw classNotFound;
        }
        if (driverName != null) {
            this.getLogin().getPlatform().setDriverName(driverName);
        }
    }

    @Override
    public SequencingControl getSequencingControl() {
        return this.getSequencingHome().getSequencingControl();
    }

    @Override
    public Sequencing getSequencing() {
        return this.getSequencingHome().getSequencing();
    }

    public boolean isSequencingCallbackRequired() {
        return this.getSequencingHome().isSequencingCallbackRequired();
    }

    public void initializeSequencing() {
        this.getSequencingHome().onDisconnect();
        this.getSequencingHome().onConnect();
    }

    public void addDescriptorsToSequencing(Collection descriptors) {
        this.getSequencingHome().onAddDescriptors(descriptors);
    }

    @Override
    public void releaseJTSConnection() {
        this.getAccessor().closeJTSConnection();
    }

    public DatabaseSessionImpl() {
        this.setServerPlatform(new NoServerPlatform(this));
        this.shouldOptimizeResultSetAccess = ObjectLevelReadQuery.isResultSetAccessOptimizedQueryDefault;
    }

    public DatabaseSessionImpl(Login login) {
        this(new Project(login));
    }

    public DatabaseSessionImpl(Project project) {
        super(project);
        this.setServerPlatform(new NoServerPlatform(this));
        this.shouldOptimizeResultSetAccess = ObjectLevelReadQuery.isResultSetAccessOptimizedQueryDefault;
    }

    @Override
    public void addDescriptor(ClassDescriptor descriptor) {
        this.lastDescriptorAccessed = null;
        this.getProject().addDescriptor(descriptor, this);
    }

    @Override
    public void addDescriptors(Collection descriptors) {
        this.lastDescriptorAccessed = null;
        this.getProject().addDescriptors(descriptors, this);
    }

    @Override
    public void addDescriptors(Project project) {
        this.lastDescriptorAccessed = null;
        this.getProject().addDescriptors(project, this);
    }

    @Override
    public void addSequence(Sequence sequence) {
        this.getProject().getLogin().getDatasourcePlatform().addSequence(sequence, this.getSequencingHome().isConnected());
    }

    public void connect() throws DatabaseException {
        this.getAccessor().connect(this.getDatasourceLogin(), this);
    }

    public void disconnect() throws DatabaseException {
        this.getSequencingHome().onDisconnect();
        this.getAccessor().disconnect(this);
    }

    @Override
    public ServerPlatform getServerPlatform() {
        return this.serverPlatform;
    }

    @Override
    public void setServerPlatform(ServerPlatform newServerPlatform) {
        if (this.isLoggedIn) {
            throw ValidationException.serverPlatformIsReadOnlyAfterLogin(newServerPlatform.getClass().getName());
        }
        this.serverPlatform = newServerPlatform;
    }

    protected void finalize() throws DatabaseException {
        if (this.isConnected()) {
            this.logout();
        }
    }

    @Override
    public DatabasePlatform getPlatform() {
        if (this.platform == null) {
            if (this.isLoggedIn) {
                this.platform = this.getDatasourceLogin().getPlatform();
            } else {
                return this.getDatasourceLogin().getPlatform();
            }
        }
        return (DatabasePlatform)this.platform;
    }

    @Override
    public Platform getDatasourcePlatform() {
        if (this.platform == null) {
            if (this.isLoggedIn) {
                this.platform = this.getDatasourceLogin().getDatasourcePlatform();
            } else {
                return this.getDatasourceLogin().getDatasourcePlatform();
            }
        }
        return this.platform;
    }

    @Override
    public Platform getPlatform(Class domainClass) {
        if (this.platform == null) {
            if (this.isLoggedIn) {
                this.platform = this.getDatasourceLogin().getDatasourcePlatform();
            } else {
                return this.getDatasourceLogin().getDatasourcePlatform();
            }
        }
        return this.platform;
    }

    public void initializeDescriptorIfSessionAlive(ClassDescriptor descriptor) {
        if (this.isConnected() && descriptor.requiresInitialization(this)) {
            try {
                try {
                    ArrayList<ClassDescriptor> descriptorsToAdd = new ArrayList<ClassDescriptor>(1);
                    descriptorsToAdd.add(descriptor);
                    this.addDescriptorsToSequencing(descriptorsToAdd);
                    descriptor.preInitialize(this);
                    descriptor.initialize(this);
                    descriptor.postInitialize(this);
                    this.getCommitManager().initializeCommitOrder();
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
                if (this.getIntegrityChecker().hasErrors()) {
                    this.handleException(new IntegrityException(this.getIntegrityChecker()));
                }
            }
            finally {
                this.clearIntegrityChecker();
            }
        }
    }

    public void initializeDescriptors() {
        this.initializeDescriptors((Map)((HashMap)this.getDescriptors()).clone(), true);
        if (this.serializer != null) {
            this.serializer.initialize(null, null, this);
        }
        for (PartitioningPolicy policy : this.getProject().getPartitioningPolicies().values()) {
            policy.initialize(this);
        }
        if (this.getProject().getMultitenantPolicy() != null) {
            this.getProject().getMultitenantPolicy().initialize(this);
        }
        this.processJPAQueries();
        QueryResultsCachePolicy defaultQueryCachePolicy = this.getProject().getDefaultQueryResultsCachePolicy();
        if (defaultQueryCachePolicy != null) {
            for (List list : this.getQueries().values()) {
                for (DatabaseQuery query : list) {
                    ReadQuery readQuery;
                    if (!query.isReadQuery() || query.getDescriptor() == null || query.getDescriptor().getCachePolicy().isIsolated() || (readQuery = (ReadQuery)query).shouldCacheQueryResults()) continue;
                    readQuery.setQueryResultsCachePolicy(defaultQueryCachePolicy.clone());
                }
            }
        }
        for (AttributeGroup attributeGroup : this.getProject().getAttributeGroups().values()) {
            this.getAttributeGroups().put(attributeGroup.getName(), attributeGroup);
            this.getDescriptor(attributeGroup.getType()).addAttributeGroup(attributeGroup);
        }
    }

    public void initializeDescriptors(Map descriptors) {
        this.initializeDescriptors(descriptors.values(), false);
    }

    public void initializeDescriptors(Collection descriptors) {
        this.initializeDescriptors(descriptors, false);
    }

    public void initializeDescriptors(Map descriptors, boolean shouldInitializeSequencing) {
        this.initializeDescriptors(descriptors.values(), shouldInitializeSequencing);
    }

    public void initializeDescriptors(Collection descriptors, boolean shouldInitializeSequencing) {
        if (shouldInitializeSequencing) {
            this.initializeSequencing();
        } else {
            this.addDescriptorsToSequencing(descriptors);
        }
        try {
            AbstractSession session;
            for (ClassDescriptor descriptor : descriptors) {
                try {
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (descriptor.requiresInitialization(session)) {
                        descriptor.preInitialize(session);
                    } else if (descriptor.hasTablePerMultitenantPolicy()) {
                        this.addTablePerTenantDescriptor(descriptor);
                    }
                    if (!descriptor.isDescriptorTypeAggregate() || !descriptor.isChildDescriptor()) continue;
                    descriptor.initializeAggregateInheritancePolicy(session);
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
            }
            for (ClassDescriptor descriptor : descriptors) {
                try {
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (!descriptor.requiresInitialization(session)) continue;
                    descriptor.initialize(session);
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
            }
            for (ClassDescriptor descriptor : descriptors) {
                try {
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (!descriptor.requiresInitialization(session)) continue;
                    descriptor.postInitialize(session);
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
            }
            if (this.getIntegrityChecker().hasErrors()) {
                this.handleSevere(new IntegrityException(this.getIntegrityChecker()));
            }
        }
        finally {
            this.clearIntegrityChecker();
        }
        this.getCommitManager().initializeCommitOrder();
    }

    @Override
    public boolean isDatabaseSession() {
        return true;
    }

    @Override
    public boolean isProtectedSession() {
        return false;
    }

    protected Login getReadLogin() {
        return this.getDatasourceLogin();
    }

    public void loginAndDetectDatasource() throws DatabaseException {
        this.preConnectDatasource();
        this.setOrDetectDatasource(true);
        this.connect();
        this.postConnectDatasource();
    }

    @Override
    public void login() throws DatabaseException {
        this.preConnectDatasource();
        this.connect();
        this.postConnectDatasource();
    }

    protected void preConnectDatasource() {
        if (this.isLoggedIn) {
            throw ValidationException.alreadyLoggedIn(this.getName());
        }
        this.platform = null;
        if (this.isInProfile()) {
            this.getProfiler().initialize();
        }
        this.updateProfile("Info:LoginTime", new Date(System.currentTimeMillis()));
        this.updateProfile("Info:SessionName", this.getName());
        if (this.eventManager != null) {
            this.eventManager.preLogin(this);
        }
        if (!this.hasBroker()) {
            this.getServerPlatform().initializeExternalTransactionController();
            this.log(5, null, "topLink_version", DatasourceLogin.getVersion());
            if (this.getServerPlatform().getServerNameAndVersion() != null && !this.getServerPlatform().getServerNameAndVersion().equals(ServerPlatformBase.DEFAULT_SERVER_NAME_AND_VERSION)) {
                this.log(5, null, "application_server_name_and_version", this.getServerPlatform().getServerNameAndVersion());
            }
        }
        this.isLoggingOff = this.getLogLevel() == 8;
    }

    protected void postConnectDatasource() {
        String value;
        if (!this.hasBroker()) {
            this.initializeDescriptors();
            if (this.getCommandManager() != null) {
                this.getCommandManager().initialize();
            }
        }
        if (this.getProperties().containsKey("eclipselink.multitenant.tenants-share-emf") && !new Boolean(value = (String)this.getProperties().get("eclipselink.multitenant.tenants-share-emf")).booleanValue()) {
            for (String property : this.getMultitenantContextProperties()) {
                if (this.getProperties().containsKey(property)) continue;
                throw ValidationException.multitenantContextPropertyForNonSharedEMFNotSpecified(property);
            }
            this.project.setAllowTablePerMultitenantDDLGeneration(true);
        }
        this.log(5, "connection", "login_successful", this.getName());
        if (!this.hasBroker()) {
            this.postLogin();
        }
        this.initializeConnectedTime();
        this.isLoggedIn = true;
        this.platform = null;
        if (!this.hasBroker()) {
            this.getServerPlatform().registerMBean();
        }
        this.descriptors = this.getDescriptors();
        if (!this.isBroker()) {
            this.getDatasourcePlatform().initialize();
            this.getIdentityMapAccessorInstance().getIdentityMapManager().checkIsCacheAccessPreCheckRequired();
        }
        if (this.databaseEventListener != null) {
            this.databaseEventListener.register(this);
        }
        if (this.getDatasourcePlatform() instanceof DatabasePlatform && this.getPlatform().getBatchWritingMechanism() != null) {
            this.getPlatform().getBatchWritingMechanism().initialize(this);
        }
    }

    public void postLogin() {
        if (this.eventManager != null) {
            this.eventManager.postLogin(this);
        }
    }

    @Override
    public void login(String userName, String password) throws DatabaseException {
        this.getDatasourceLogin().setUserName(userName);
        this.getDatasourceLogin().setPassword(password);
        this.login();
    }

    @Override
    public void login(Login login) throws DatabaseException {
        this.setLogin(login);
        this.login();
    }

    @Override
    public void logout() throws DatabaseException {
        if (this.eventManager != null) {
            this.eventManager.preLogout(this);
        }
        this.cleanUpEntityListenerInjectionManager();
        this.lastDescriptorAccessed = null;
        if (this.isInTransaction()) {
            throw DatabaseException.logoutWhileTransactionInProgress();
        }
        if (this.getAccessor() == null) {
            return;
        }
        if (this.databaseEventListener != null) {
            this.databaseEventListener.remove(this);
        }
        this.setShouldPropagateChanges(false);
        if (!this.hasBroker()) {
            if (this.getCommandManager() != null) {
                this.getCommandManager().shutdown();
            }
            this.getServerPlatform().shutdown();
        }
        this.disconnect();
        this.getIdentityMapAccessor().initializeIdentityMaps();
        this.isLoggedIn = false;
        if (this.eventManager != null) {
            this.eventManager.postLogout(this);
        }
        this.log(5, "connection", "logout_successful", this.getName());
    }

    public void initializeConnectedTime() {
        this.connectedTime = System.currentTimeMillis();
    }

    public long getConnectedTime() {
        return this.connectedTime;
    }

    @Override
    public void writeAllObjects(Collection domainObjects) throws DatabaseException, OptimisticLockException {
        Iterator objectsEnum = domainObjects.iterator();
        while (objectsEnum.hasNext()) {
            this.writeObject(objectsEnum.next());
        }
    }

    public void writeAllObjects(Vector domainObjects) throws DatabaseException, OptimisticLockException {
        Enumeration objectsEnum = domainObjects.elements();
        while (objectsEnum.hasMoreElements()) {
            this.writeObject(objectsEnum.nextElement());
        }
    }

    @Override
    public Object retryQuery(DatabaseQuery query, AbstractRecord row, DatabaseException databaseException, int retryCount, AbstractSession executionSession) {
        if (this.getClass() != DatabaseSessionImpl.class) {
            return super.retryQuery(query, row, databaseException, retryCount, executionSession);
        }
        int count = this.getLogin().getQueryRetryAttemptCount();
        while (retryCount < count) {
            try {
                databaseException.getAccessor().reestablishConnection(this);
            }
            catch (DatabaseException databaseException2) {
                ++retryCount;
                try {
                    Thread.currentThread();
                    Thread.sleep(this.getLogin().getDelayBetweenConnectionAttempts());
                    this.log(5, "query", "communication_failure_attempting_query_retry", null, null);
                    continue;
                }
                catch (InterruptedException interruptedException) {}
            }
            break;
        }
        return executionSession.executeQuery(query, row, retryCount);
    }

    public SessionTuner getTuner() {
        return this.tuner;
    }

    public void setTuner(SessionTuner tuner) {
        this.tuner = tuner;
    }
}

