/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.impl;

import com.ibm.ws.sib.matchspace.SearchResults;
import com.ibm.ws.sib.matchspace.impl.ContentMatcher;
import com.ibm.ws.sib.matchspace.utils.Trace;
import com.ibm.ws.sib.matchspace.utils.TraceUtils;
import java.util.ArrayList;
import java.util.List;

class CacheingSearchResults
implements SearchResults {
    private static final Class cclass = CacheingSearchResults.class;
    private static Trace tc = TraceUtils.getTrace(CacheingSearchResults.class, (String)"SIBMatchSpace");
    private SearchResults delegate;
    private List wildMatchers;
    boolean hasContent;

    CacheingSearchResults(SearchResults delegate) {
        if (tc.isEntryEnabled()) {
            tc.entry(cclass, "CacheingMatcher", (Object)("delegate: " + delegate));
        }
        this.delegate = delegate;
        this.wildMatchers = new ArrayList();
        if (tc.isEntryEnabled()) {
            tc.exit(cclass, "CacheingSearchResults", (Object)this);
        }
    }

    public void addObjects(List[] objects) {
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "addObjects", (Object)("objects: " + objects));
        }
        if (this.delegate != null) {
            this.delegate.addObjects(objects);
        }
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "addObjects");
        }
    }

    public Object provideCacheable(Object key) {
        if (tc.isDebugEnabled()) {
            tc.debug((Object)this, cclass, "provideCacheable", key);
        }
        return null;
    }

    public boolean acceptCacheable(Object cached) {
        if (tc.isDebugEnabled()) {
            tc.debug((Object)this, cclass, "acceptCacheable", cached);
        }
        return false;
    }

    void setMatcher(ContentMatcher m) {
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "setMatcher", (Object)("matcher: " + m + ", hasContent: " + new Boolean(this.hasContent)));
        }
        this.wildMatchers.add(m);
        this.hasContent |= m.hasTests();
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "setMatcher");
        }
    }

    public void reset() {
    }

    ContentMatcher[] getMatchers() {
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "getMatchers");
        }
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "getMatchers");
        }
        return this.wildMatchers.toArray(new ContentMatcher[0]);
    }
}

