/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.LikeOperator;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.selector.impl.OperatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.Pattern;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class LikeOperatorImpl
extends OperatorImpl
implements LikeOperator {
    public String strPattern;
    public char escape;
    public boolean escaped = false;
    public Pattern pattern;

    public LikeOperatorImpl(int op, Selector operand, Pattern pattern, String strPattern, boolean escaped, char escape) {
        super(op, operand);
        this.pattern = pattern;
        this.strPattern = strPattern;
        this.escaped = escaped;
        this.escape = escape;
    }

    public LikeOperatorImpl(ObjectInput buf) throws ClassNotFoundException, IOException {
        super(buf);
        this.strPattern = buf.readUTF();
        this.escaped = buf.readBoolean();
        if (this.escaped) {
            this.escape = buf.readChar();
        }
        this.pattern = (Pattern)Pattern.parsePattern(this.strPattern, this.escaped, this.escape);
    }

    @Override
    public void encodeSelf(ObjectOutput buf) throws IOException {
        super.encodeSelf(buf);
        buf.writeBoolean(this.escaped);
        if (this.escaped) {
            buf.writeChar(this.escape);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LikeOperator) {
            LikeOperator other = (LikeOperator)o;
            return super.equals(o) && this.getPattern().equals(other.getPattern()) && this.escaped == other.isEscaped() && this.escape == other.getEscape();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.pattern.hashCode();
    }

    @Override
    public String toString() {
        return this.operands[0] + " LIKE '" + this.strPattern + "'" + (this.escaped ? " ESCAPE '" + this.escape + "'" : "");
    }

    public char getEscape() {
        return this.escape;
    }

    public boolean isEscaped() {
        return this.escaped;
    }

    public String getPattern() {
        return this.strPattern;
    }

    public Pattern getInternalPattern() {
        return this.pattern;
    }
}

