/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPIncorrectCallException;
import com.ibm.ws.sib.processor.exceptions.SIMPInvalidRuntimeIDException;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.impl.indexes.SubscriptionIndex;
import com.ibm.ws.sib.processor.impl.indexes.SubscriptionTypeFilter;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableSubscription;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPLocalSubscriptionControllable;
import com.ibm.ws.sib.processor.runtime.SIMPLocalTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.SIMPTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.anycast.AttachedRemoteSubscriberIterator;
import com.ibm.ws.sib.processor.runtime.impl.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.ControllableIterator;
import com.ibm.ws.sib.processor.runtime.impl.MediatedMessageHandlerControl;
import com.ibm.ws.sib.processor.runtime.impl.RemoteTopicSpaceControl;
import com.ibm.ws.sib.processor.runtime.impl.RemoteTopicSpaceIterator;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Topicspace
extends MediatedMessageHandlerControl
implements SIMPTopicSpaceControllable {
    private static TraceComponent tc = SibTr.register(Topicspace.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private SubscriptionIndex _subIndex;

    public Topicspace(MessageProcessor messageProcessor, BaseDestinationHandler destination) {
        super(messageProcessor, destination);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"Topicspace");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"Topicspace", (Object)this);
        }
    }

    public SIMPIterator getAttachedRemoteSubscriberIterator() throws SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAttachedRemoteSubscriberIterator");
        }
        this.assertMessageHandlerNotCorrupt();
        Collection anycastInputHandlers = this.baseDest.getPseudoDurableAIHMap().values();
        AttachedRemoteSubscriberIterator remoteSubscriberItr = new AttachedRemoteSubscriberIterator(anycastInputHandlers);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAttachedRemoteSubscriberIterator", (Object)remoteSubscriberItr);
        }
        return remoteSubscriberItr;
    }

    private SubscriptionIndex getSubscriptionIndex() {
        if (this._subIndex == null) {
            this._subIndex = this.baseDest.getSubscriptionIndex();
        }
        return this._subIndex;
    }

    protected SIMPIterator getDurableSubscriptionIterator() throws SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDurableSubscriptionIterator");
        }
        this.assertMessageHandlerNotCorrupt();
        SubscriptionTypeFilter filter = new SubscriptionTypeFilter();
        filter.DURABLE = Boolean.TRUE;
        ControllableIterator itr = new ControllableIterator((Iterator)this.getSubscriptionIndex().iterator(filter));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDurableSubscriptionIterator", (Object)itr);
        }
        return itr;
    }

    public SIMPIterator getLocalSubscriptionIterator() throws SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalSubscriptionIterator");
        }
        this.assertMessageHandlerNotCorrupt();
        SubscriptionTypeFilter filter = new SubscriptionTypeFilter();
        filter.LOCAL = Boolean.TRUE;
        ControllableIterator itr = new ControllableIterator((Iterator)this.getSubscriptionIndex().iterator(filter));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalSubscriptionIterator", (Object)itr);
        }
        return itr;
    }

    protected SIMPIterator getInternalLocalSubscriptionIterator() throws SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getInternalLocalSubscriptionIterator");
        }
        this.assertMessageHandlerNotCorrupt();
        SubscriptionTypeFilter filter = new SubscriptionTypeFilter();
        filter.LOCAL = Boolean.TRUE;
        BasicSIMPIterator itr = new BasicSIMPIterator((Iterator)this.getSubscriptionIndex().iterator(filter));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getInternalLocalSubscriptionIterator", (Object)itr);
        }
        return itr;
    }

    public SIMPLocalSubscriptionControllable getLocalSubscriptionControlByID(String id) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalSubscriptionControlByID", (Object)id);
        }
        this.assertMessageHandlerNotCorrupt();
        ControllableSubscription sub = this.getSubscription(id);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalSubscriptionControlByID", (Object)sub.getControlAdapter());
        }
        return (SIMPLocalSubscriptionControllable)sub.getControlAdapter();
    }

    private ControllableSubscription getSubscription(String id) throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscription", (Object)id);
        }
        SIBUuid12 uuid = new SIBUuid12(id);
        SubscriptionTypeFilter filter = new SubscriptionTypeFilter();
        filter.LOCAL = Boolean.TRUE;
        ControllableSubscription sub = this.getSubscriptionIndex().findByUuid(uuid, filter);
        if (sub == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getLocalSubscriptionControlByID", (Object)"SIMPControllableNotFoundException");
            }
            throw new SIMPControllableNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_NOT_FOUND_ERROR_CWSIP0271", new Object[]{id}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscription", (Object)sub);
        }
        return sub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLocalSubscriptionControlByID(String id) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException, SIDurableSubscriptionNotFoundException, SIDestinationLockedException, SIResourceException, SIIncorrectCallException {
        HashMap durableSubs;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteLocalSubscriptionControlByID", (Object)id);
        }
        this.assertMessageHandlerNotCorrupt();
        ControllableSubscription sub = this.getSubscription(id);
        if (!sub.isDurable()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteLocalSubscriptionControlByID", (Object)"SIMPIncorrectCallException");
            }
            throw new SIMPIncorrectCallException(nls.getFormattedMessage("SUBSCRIPTION_DELETE_ERROR_CWSIP0272", new Object[]{id}, null));
        }
        HashMap hashMap = durableSubs = this.destinationManager.getDurableSubscriptionsTable();
        synchronized (hashMap) {
            ConsumerDispatcher cd = (ConsumerDispatcher)durableSubs.get(sub.getConsumerDispatcherState().getSubscriberID());
            if (cd == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteSubscription", (Object)"SIMPControllableNotFoundException");
                }
                throw new SIMPControllableNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0146", new Object[]{sub.getConsumerDispatcherState().getSubscriberID(), this.messageProcessor.getMessagingEngineName()}, null));
            }
            BaseDestinationHandler destination = cd.getDestination();
            destination.deleteDurableSubscription(sub.getConsumerDispatcherState().getSubscriberID(), this.messageProcessor.getMessagingEngineName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteLocalSubscriptionControlByID");
        }
    }

    public SIMPLocalTopicSpaceControllable getLocalTopicSpaceControl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalTopicSpaceControl");
        }
        SIMPLocalTopicSpaceControllable control = null;
        PubSubMessageItemStream is = this.baseDest.getPublishPoint();
        if (is != null) {
            control = (SIMPLocalTopicSpaceControllable)is.getControlAdapter();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalTopicSpaceControl", (Object)control);
        }
        return control;
    }

    public SIMPLocalSubscriptionControllable getLocalSubscriptionControlByName(String subscriptionName) throws SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalSubscriptionControlByName", (Object)subscriptionName);
        }
        this.assertMessageHandlerNotCorrupt();
        HashMap durableSubs = this.messageProcessor.getDestinationManager().getDurableSubscriptionsTable();
        ConsumerDispatcher cd = (ConsumerDispatcher)durableSubs.get(subscriptionName);
        SIMPLocalSubscriptionControllable controlAdapter = null;
        if (cd != null) {
            controlAdapter = (SIMPLocalSubscriptionControllable)cd.getControlAdapter();
        }
        if (controlAdapter == null) {
            SIMPControllableNotFoundException exception = new SIMPControllableNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_NOT_FOUND_ERROR_CWSIP0271", new Object[]{subscriptionName}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getLocalSubscriptionControlByName", (Object)((Object)exception));
            }
            throw exception;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalSubscriptionControlByName", (Object)controlAdapter);
        }
        return controlAdapter;
    }

    public SIMPIterator getRemoteTopicSpaceIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteTopicSpaceIterator");
        }
        HashMap pubsubOutHandlers = this.baseDest.cloneAllPubSubOutputHandlers();
        Map aihMap = this.baseDest.getPseudoDurableAIHMap();
        HashMap<SIBUuid8, RemoteTopicSpaceIterator.PublishConsumePairing> pairings = new HashMap<SIBUuid8, RemoteTopicSpaceIterator.PublishConsumePairing>();
        for (PubSubOutputHandler psoh : pubsubOutHandlers.values()) {
            SIBUuid8 uuid = psoh.getTargetMEUuid();
            RemoteTopicSpaceIterator.PublishConsumePairing pairing = new RemoteTopicSpaceIterator.PublishConsumePairing(psoh, null);
            pairings.put(uuid, pairing);
        }
        for (AnycastInputHandler aih : aihMap.values()) {
            SIBUuid8 uuid = aih.getLocalisationUuid();
            Object existingPairing = pairings.get(uuid);
            if (existingPairing != null) {
                ((RemoteTopicSpaceIterator.PublishConsumePairing)existingPairing).setAnycastInputHandler(aih);
                continue;
            }
            RemoteTopicSpaceIterator.PublishConsumePairing pairing = new RemoteTopicSpaceIterator.PublishConsumePairing(null, aih);
            pairings.put(uuid, pairing);
        }
        RemoteTopicSpaceIterator itr = new RemoteTopicSpaceIterator(pairings.values().iterator());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteTopicSpaceIterator", (Object)itr);
        }
        return itr;
    }

    public SIMPRemoteTopicSpaceControllable getRemoteTopicSpaceControlByID(String id) throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteTopicSpaceControlByID", (Object)id);
        }
        SIMPIterator remoteTopicSpaces = this.getRemoteTopicSpaceIterator();
        RemoteTopicSpaceControl returnControl = null;
        while (remoteTopicSpaces.hasNext()) {
            RemoteTopicSpaceControl topicSpace = (RemoteTopicSpaceControl)remoteTopicSpaces.next();
            if (!topicSpace.getId().equals(id)) continue;
            returnControl = topicSpace;
        }
        if (returnControl == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getRemoteTopicSpaceControlByID", (Object)"SIMPControllableNotFoundException");
            }
            throw new SIMPControllableNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_NOT_FOUND_ERROR_CWSIP0271", new Object[]{id}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteTopicSpaceControlByID", (Object)returnControl);
        }
        return returnControl;
    }
}

