/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.osgi.internal;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.EARApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.ModuleStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jpa.JPAComponent;
import com.ibm.ws.jpa.JPAExPcBindingContextAccessor;
import com.ibm.ws.jpa.JPAProviderIntegration;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.ws.jpa.container.osgi.internal.JPAResourceBindingImpl;
import com.ibm.ws.jpa.container.osgi.internal.OSGiJPAApplInfo;
import com.ibm.ws.jpa.container.osgi.internal.OSGiJPAPXml;
import com.ibm.ws.jpa.container.osgi.jndi.JPAJndiLookupInfo;
import com.ibm.ws.jpa.container.osgi.jndi.JPAJndiLookupInfoRefAddr;
import com.ibm.ws.jpa.container.osgi.jndi.JPAJndiLookupObjectFactory;
import com.ibm.ws.jpa.management.AbstractJPAComponent;
import com.ibm.ws.jpa.management.JPAApplInfo;
import com.ibm.ws.jpa.management.JPAEMFPropertyProvider;
import com.ibm.ws.jpa.management.JPAIntrospection;
import com.ibm.ws.jpa.management.JPAPuScope;
import com.ibm.ws.jpa.management.JPARuntime;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleCoordinator;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.ServiceAndServiceReferencePair;
import com.ibm.wsspi.logging.Introspector;
import com.ibm.wsspi.resource.ResourceBindingListener;
import java.io.File;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.naming.Reference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.jpacomponent"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={JPAComponent.class, ApplicationStateListener.class, ModuleStateListener.class, Introspector.class}, property={"service.vendor=IBM", "service.ranking:Integer=1000"})
public class JPAComponentImpl
extends AbstractJPAComponent
implements ApplicationStateListener,
ModuleStateListener,
Introspector {
    private static final TraceComponent tc = Tr.register(JPAComponentImpl.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    private static final String REFERENCE_JPA_RUNTIME = "jpaRuntime";
    private static final String REFERENCE_TRANSACTION_MANAGER = "transactionManager";
    private static final String REFERENCE_CONTEXT_ACCESSOR = "contextAccessor";
    private static final String REFERENCE_RESOURCE_BINDING_LISTENERS = "resourceBindingListeners";
    private static final String REFERENCE_JPA_PROVIDER = "jpaProvider";
    private static final String REFERENCE_JPA_PROPS_PROVIDER = "jpaPropsProvider";
    private static final String REFERENCE_APP_COORD = "appCoord";
    private static final String REFERENCE_CLASSLOADING_SERVICE = "classLoadingService";
    private ComponentContext context;
    private Dictionary<String, Object> props;
    private boolean server = false;
    private static final Set<String> stuckApps = new ConcurrentSkipListSet<String>();
    private final AtomicServiceReference<JPARuntime> jpaRuntime = new AtomicServiceReference("jpaRuntime");
    private final AtomicServiceReference<EmbeddableWebSphereTransactionManager> ivTransactionManagerSR = new AtomicServiceReference("transactionManager");
    private final AtomicServiceReference<JPAExPcBindingContextAccessor> ivContextAccessorSR = new AtomicServiceReference("contextAccessor");
    private final ConcurrentServiceReferenceSet<ResourceBindingListener> resourceBindingListeners = new ConcurrentServiceReferenceSet("resourceBindingListeners");
    private final AtomicServiceReference<JPAProviderIntegration> providerIntegrationSR = new AtomicServiceReference("jpaProvider");
    private final ConcurrentServiceReferenceSet<JPAEMFPropertyProvider> propProviderSRs = new ConcurrentServiceReferenceSet("jpaPropsProvider");
    private ClassLoadingService classLoadingService;
    static final long serialVersionUID = -2715630672488503940L;

    @Activate
    protected void activate(ComponentContext cc) {
        this.props = cc.getProperties();
        this.jpaRuntime.activate(cc);
        this.ivTransactionManagerSR.activate(cc);
        this.ivContextAccessorSR.activate(cc);
        this.resourceBindingListeners.activate(cc);
        this.providerIntegrationSR.activate(cc);
        this.propProviderSRs.activate(cc);
        this.context = cc;
        this.initialize();
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.jpaRuntime.deactivate(cc);
        this.ivTransactionManagerSR.deactivate(cc);
        this.ivContextAccessorSR.deactivate(cc);
        this.resourceBindingListeners.deactivate(cc);
        this.providerIntegrationSR.deactivate(cc);
        this.propProviderSRs.deactivate(cc);
    }

    @Modified
    protected void modified(Map<?, ?> newProperties) {
        String originalProvider = (String)this.props.get("defaultPersistenceProvider");
        String originalDefaultJtaDataSourceJndiName = (String)this.props.get("defaultJtaDataSourceJndiName");
        String originalDefaultNonJtaDataSourceJndiName = (String)this.props.get("defaultNonJtaDataSourceJndiName");
        this.props = newProperties instanceof Dictionary ? (Dictionary<Object, Object>)((Object)newProperties) : new Hashtable(newProperties);
        String curProvider = (String)newProperties.get("defaultPersistenceProvider");
        String curDefaultJtaDataSourceJndiName = (String)newProperties.get("defaultJtaDataSourceJndiName");
        String curDefaultNonJtaDataSourceJndiName = (String)newProperties.get("defaultNonJtaDataSourceJndiName");
        boolean recycleJPAApplications = false;
        if (!Objects.equals(originalProvider, curProvider)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Detected change in defaultPersistenceProvider of the <jpa> element.  Restarting all JPA applications.", (Object[])new Object[]{originalProvider + " -> " + curProvider});
            }
            recycleJPAApplications = true;
        } else if (!Objects.equals(originalDefaultJtaDataSourceJndiName, curDefaultJtaDataSourceJndiName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Detected change in defaultJtaDataSourceJndiName of the <jpa> element.  Restarting all JPA applications.", (Object[])new Object[]{originalProvider + " -> " + curProvider});
            }
            recycleJPAApplications = true;
        } else if (!Objects.equals(originalDefaultNonJtaDataSourceJndiName, curDefaultNonJtaDataSourceJndiName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Detected change in defaultNonJtaDataSourceJndiName of the <jpa> element.  Restarting all JPA applications.", (Object[])new Object[]{originalProvider + " -> " + curProvider});
            }
            recycleJPAApplications = true;
        }
        if (recycleJPAApplications) {
            this.recycleJPAApplications();
        }
    }

    private Reference createReference(boolean ejbInWar, JPAJndiLookupInfo info) {
        boolean ejbFeatureEnabled = this.getExPcBindingContext() != null;
        String objectFactory = ejbFeatureEnabled && ejbInWar ? "com.ibm.ws.ejbcontainer.jpa.injection.factory.HybridJPAObjectFactory" : JPAJndiLookupObjectFactory.class.getName();
        return new Reference("javax.persistence.EntityManager", new JPAJndiLookupInfoRefAddr(info), objectFactory, null);
    }

    @Override
    public Reference createPersistenceUnitReference(boolean ejbInWar, JPAPuId puId, J2EEName j2eeName, String refName, boolean isSFSB) {
        JPAJndiLookupInfo info = new JPAJndiLookupInfo(puId, j2eeName, refName, isSFSB);
        return this.createReference(ejbInWar, info);
    }

    @Override
    public Reference createPersistenceContextReference(boolean ejbInWar, JPAPuId puId, J2EEName j2eeName, String refName, boolean isExtendedContextType, boolean isSFSB, Properties properties, boolean isUnsynchronized) {
        JPAJndiLookupInfo info = new JPAJndiLookupInfo(puId, j2eeName, refName, isExtendedContextType, isSFSB, properties, isUnsynchronized);
        return this.createReference(ejbInWar, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    public void applicationStarting(ApplicationInfo appInfo) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        String applName = appInfo.getDeploymentName();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("applicationStarting : " + applName), (Object[])new Object[0]);
        }
        OSGiJPAApplInfo applInfo = new OSGiJPAApplInfo(this, applName, appInfo);
        ClassLoader appClassLoader = null;
        Container appLibContainer = null;
        if (appInfo instanceof EARApplicationInfo) {
            appClassLoader = ((EARApplicationInfo)appInfo).getApplicationClassLoader();
            appLibContainer = ((EARApplicationInfo)appInfo).getLibraryDirectoryContainer();
        }
        try {
            NonPersistentCache cache;
            JPAIntrospection.beginJPAIntrospection();
            JPAIntrospection.beginApplicationVisit(applName, applInfo);
            if (appLibContainer != null && appClassLoader != null) {
                this.processLibraryJarPersistenceXml(applInfo, appLibContainer, applName, "lib/", JPAPuScope.EAR_Scope, appClassLoader);
            }
            Container container = appInfo.getContainer();
            try {
                cache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.jpa.container.osgi.internal.JPAComponentImpl", (String)"270", (Object)this, (Object[])new Object[]{appInfo});
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("applicationStarting : " + e), (Object[])new Object[0]);
                }
                throw new RuntimeException("Failed to get NonPersistentCache for application ", (Throwable)e);
            }
            ApplicationClassesContainerInfo applicationClassesContainerInfo = (ApplicationClassesContainerInfo)cache.getFromCache(ApplicationClassesContainerInfo.class);
            if (applicationClassesContainerInfo != null) {
                List mcci = applicationClassesContainerInfo.getModuleClassesContainerInfo();
                for (ModuleClassesContainerInfo m : mcci) {
                    List moduleContainerInfos = m.getClassesContainerInfo();
                    if (moduleContainerInfos == null || moduleContainerInfos.isEmpty()) continue;
                    ContainerInfo moduleContainerInfo = (ContainerInfo)moduleContainerInfos.get(0);
                    ContainerInfo.Type t = moduleContainerInfo.getType();
                    ClassLoader moduleLoader = null;
                    try {
                        Container cc = moduleContainerInfo.getContainer();
                        NonPersistentCache npc = (NonPersistentCache)cc.adapt(NonPersistentCache.class);
                        ModuleInfo wmi = (ModuleInfo)npc.getFromCache(ModuleInfo.class);
                        moduleLoader = wmi.getClassLoader();
                    }
                    catch (Exception cc) {
                        void e;
                        FFDCFilter.processException((Throwable)cc, (String)"com.ibm.ws.jpa.container.osgi.internal.JPAComponentImpl", (String)"292", (Object)this, (Object[])new Object[]{appInfo});
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("applicationStarting : " + e), (Object[])new Object[0]);
                        }
                        throw new RuntimeException("Failed to get ModuleInfo for application ", (Throwable)e);
                    }
                    try {
                        boolean serverRT = this.isServerRuntime();
                        if (t == ContainerInfo.Type.EJB_MODULE && serverRT) {
                            this.processEJBModulePersistenceXml(applInfo, moduleContainerInfo, moduleLoader);
                            continue;
                        }
                        if (t == ContainerInfo.Type.WEB_MODULE && serverRT) {
                            this.processWebModulePersistenceXml(applInfo, moduleContainerInfo, moduleLoader);
                            continue;
                        }
                        if (t != ContainerInfo.Type.CLIENT_MODULE || serverRT) continue;
                        this.processClientModulePersistenceXml(applInfo, moduleContainerInfo, moduleLoader);
                    }
                    catch (RuntimeException serverRT) {
                        void e;
                        FFDCFilter.processException((Throwable)serverRT, (String)"com.ibm.ws.jpa.container.osgi.internal.JPAComponentImpl", (String)"308", (Object)this, (Object[])new Object[]{appInfo});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"App failed to start due to JPA", (Object[])new Object[]{applInfo.getApplName()});
                        }
                        stuckApps.add(applInfo.getApplName());
                        throw e;
                    }
                }
            }
            try {
                this.startingApplication(applInfo);
            }
            catch (RuntimeWarning mcci) {
                void e;
                FFDCFilter.processException((Throwable)mcci, (String)"com.ibm.ws.jpa.container.osgi.internal.JPAComponentImpl", (String)"320", (Object)this, (Object[])new Object[]{appInfo});
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"457");
            }
        }
        finally {
            JPAIntrospection.endApplicationVisit();
            JPAIntrospection.executeTraceAnalysis();
            JPAIntrospection.endJPAIntrospection();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("applicationStarting : " + applName));
        }
    }

    public void applicationStarted(ApplicationInfo appInfo) {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    @ManualTrace
    public void applicationStopped(ApplicationInfo appInfo) {
        JPAApplInfo applInfo;
        String applName = appInfo.getDeploymentName();
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("applicationStopped : " + applName), (Object[])new Object[0]);
        }
        if ((applInfo = (JPAApplInfo)this.applList.get(applName)) != null) {
            this.destroyingApplication(applInfo);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Application " + applName + " not found during destroyingDeployedApplication call."), (Object[])new Object[0]);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("applicationStopped : " + applName));
        }
    }

    public void moduleStarting(ModuleInfo moduleInfo) throws StateChangeException {
        this.getJPAProviderIntegration().moduleStarting(moduleInfo);
    }

    public void moduleStarted(ModuleInfo moduleInfo) throws StateChangeException {
        this.getJPAProviderIntegration().moduleStarted(moduleInfo);
    }

    public void moduleStopping(ModuleInfo moduleInfo) {
        this.getJPAProviderIntegration().moduleStopping(moduleInfo);
    }

    public void moduleStopped(ModuleInfo moduleInfo) {
        this.getJPAProviderIntegration().moduleStopped(moduleInfo);
    }

    @Override
    public JPAProviderIntegration getJPAProviderIntegration() {
        return (JPAProviderIntegration)this.providerIntegrationSR.getService();
    }

    /*
     * WARNING - void declaration
     */
    private URL getPXmlRootURL(String appName, String archiveName, Entry pxml) {
        URL pxmlUrl = pxml.getResource();
        String pxmlStr = pxmlUrl.toString();
        String pxmlRootStr = pxmlStr.substring(0, pxmlStr.length() - "META-INF/persistence.xml".length());
        URL pxmlRootUrl = null;
        try {
            pxmlRootUrl = new URL(pxmlRootStr);
        }
        catch (MalformedURLException malformedURLException) {
            void e;
            FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.jpa.container.osgi.internal.JPAComponentImpl", (String)"426", (Object)this, (Object[])new Object[]{appName, archiveName, pxml});
            e.getClass();
            Tr.error((TraceComponent)tc, (String)"INCORRECT_PU_ROOT_URL_SPEC_CWWJP0025E", (Object[])new Object[]{pxmlRootStr, appName, archiveName});
        }
        return pxmlRootUrl;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void processLibraryJarPersistenceXml(JPAApplInfo applInfo, Container libContainer, String archiveName, String rootPrefix, JPAPuScope scope, ClassLoader classLaoder) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processLibraryJarPersistenceXml : " + applInfo.getApplName() + ", " + (libContainer != null ? libContainer.getName() : "null") + ", " + archiveName + ", " + rootPrefix + ", " + (Object)((Object)scope)), (Object[])new Object[0]);
        }
        if (libContainer != null) {
            String puArchiveName = archiveName;
            for (Entry entry : libContainer) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processing : " + entry.getName()), (Object[])new Object[0]);
                }
                if (!entry.getName().endsWith(".jar")) continue;
                try {
                    Container jarContainer = (Container)entry.adapt(Container.class);
                    Entry pxml = jarContainer.getEntry("META-INF/persistence.xml");
                    if (pxml == null) continue;
                    String appName = applInfo.getApplName();
                    if (rootPrefix != null) {
                        puArchiveName = rootPrefix + entry.getName();
                    }
                    URL puRoot = this.getPXmlRootURL(appName, archiveName, pxml);
                    applInfo.addPersistenceUnits(new OSGiJPAPXml(applInfo, puArchiveName, scope, puRoot, classLaoder, pxml));
                }
                catch (UnableToAdaptException jarContainer) {
                    void ex;
                    FFDCFilter.processException((Throwable)jarContainer, (String)"com.ibm.ws.jpa.container.osgi.internal.JPAComponentImpl", (String)"472", (Object)this, (Object[])new Object[]{applInfo, libContainer, archiveName, rootPrefix, scope, classLaoder});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("processLibraryJarPersistenceXml: ignoring " + entry.getName()), (Object[])new Object[]{ex});
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("processLibraryJarPersistenceXml : " + applInfo.getApplName() + ", " + rootPrefix));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void processWebModulePersistenceXml(JPAApplInfo applInfo, ContainerInfo warContainerInfo, ClassLoader warClassLoader) {
        Entry webInfLib;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processWebModulePersistenceXml : " + applInfo.getApplName() + "#" + warContainerInfo), (Object[])new Object[0]);
        }
        String archiveName = warContainerInfo.getName();
        Container warContainer = warContainerInfo.getContainer();
        Entry pxml = warContainer.getEntry("WEB-INF/classes/META-INF/persistence.xml");
        if (pxml != null) {
            String appName = applInfo.getApplName();
            URL puRoot = this.getPXmlRootURL(appName, archiveName, pxml);
            applInfo.addPersistenceUnits(new OSGiJPAPXml(applInfo, archiveName, JPAPuScope.Web_Scope, puRoot, warClassLoader, pxml));
        }
        if ((webInfLib = warContainer.getEntry("WEB-INF/lib/")) != null) {
            try {
                Container webInfLibContainer = (Container)webInfLib.adapt(Container.class);
                this.processLibraryJarPersistenceXml(applInfo, webInfLibContainer, archiveName, null, JPAPuScope.Web_Scope, warClassLoader);
            }
            catch (UnableToAdaptException webInfLibContainer) {
                void ex;
                FFDCFilter.processException((Throwable)webInfLibContainer, (String)"com.ibm.ws.jpa.container.osgi.internal.JPAComponentImpl", (String)"529", (Object)this, (Object[])new Object[]{applInfo, warContainerInfo, warClassLoader});
                throw new RuntimeException("Failure locating persistence.xml", (Throwable)ex);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("processWebModulePersistenceXml : " + applInfo.getApplName() + "#" + warContainer));
        }
    }

    @ManualTrace
    private void processEJBModulePersistenceXml(JPAApplInfo applInfo, ContainerInfo module, ClassLoader appClassloader) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processEJBModulePersistenceXml : " + applInfo.getApplName() + "#" + module.getName()), (Object[])new Object[0]);
        }
        String archiveName = module.getName();
        Container ejbContainer = module.getContainer();
        ClassLoader ejbClassLoader = appClassloader;
        Entry pxml = ejbContainer.getEntry("META-INF/persistence.xml");
        if (pxml != null) {
            String appName = applInfo.getApplName();
            URL puRoot = this.getPXmlRootURL(appName, archiveName, pxml);
            applInfo.addPersistenceUnits(new OSGiJPAPXml(applInfo, archiveName, JPAPuScope.EJB_Scope, puRoot, ejbClassLoader, pxml));
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("processEJBModulePersistenceXml : " + applInfo.getApplName() + "#" + module.getName()));
        }
    }

    @ManualTrace
    private void processClientModulePersistenceXml(JPAApplInfo applInfo, ContainerInfo module, ClassLoader loader) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processClientModulePersistenceXml : " + applInfo.getApplName() + "#" + module.getName()), (Object[])new Object[0]);
        }
        String archiveName = module.getName();
        Container clientContainer = module.getContainer();
        ClassLoader clientClassLoader = loader;
        Entry pxml = clientContainer.getEntry("META-INF/persistence.xml");
        if (pxml != null) {
            String appName = applInfo.getApplName();
            URL puRoot = this.getPXmlRootURL(appName, archiveName, pxml);
            applInfo.addPersistenceUnits(new OSGiJPAPXml(applInfo, archiveName, JPAPuScope.Client_Scope, puRoot, clientClassLoader, pxml));
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("processClientModulePersistenceXml : " + applInfo.getApplName() + "#" + module.getName()));
        }
    }

    @Override
    public void addIntegrationProperties(String xmlSchemaVersion, Map<String, Object> integrationProperties, ClassLoader applicationClassLoader) {
        for (JPAEMFPropertyProvider propProvider : this.propProviderSRs.services()) {
            propProvider.updateProperties(integrationProperties, applicationClassLoader);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("addIntegrationProperties " + propProvider + " props: {0}"), (Object[])new Object[]{integrationProperties});
        }
    }

    @Override
    public String getDefaultJPAProviderClassName() {
        String def = (String)this.props.get("defaultPersistenceProvider");
        if (def == null || def.isEmpty()) {
            def = this.getJPAProviderIntegration().getProviderClassName();
        }
        return def;
    }

    @Override
    public boolean getCaptureEnhancedEntityClassBytecode() {
        Object ceecbProp = this.props.get("captureEnhancedEntityClassBytecode");
        if (ceecbProp != null && ceecbProp instanceof String) {
            return Boolean.parseBoolean((String)ceecbProp);
        }
        return false;
    }

    private String getEffectiveDefaultJTADataSourceJNDIName() {
        return this.convertBlanksToNull((String)this.props.get("defaultJtaDataSourceJndiName"));
    }

    private String getEffectiveDefaultNonJTADataSourceJNDIName() {
        return this.convertBlanksToNull((String)this.props.get("defaultNonJtaDataSourceJndiName"));
    }

    @Override
    public String getDataSourceBindingName(String bindingName, boolean transactional) {
        if (bindingName == null) {
            String string = bindingName = transactional ? this.getEffectiveDefaultJTADataSourceJNDIName() : this.getEffectiveDefaultNonJTADataSourceJNDIName();
        }
        if (bindingName != null && !bindingName.startsWith("java:")) {
            JPAResourceBindingImpl binding = null;
            Iterator it = this.resourceBindingListeners.getServicesWithReferences();
            while (it.hasNext()) {
                if (binding == null) {
                    Map<String, Object> properties = Collections.singletonMap("transactional", transactional);
                    binding = new JPAResourceBindingImpl(bindingName, properties);
                }
                binding.notify((ServiceAndServiceReferencePair<ResourceBindingListener>)((ServiceAndServiceReferencePair)it.next()));
            }
            if (binding != null && binding.bindingNameSet) {
                bindingName = binding.bindingName;
            }
        }
        return bindingName;
    }

    @Override
    public boolean isIgnoreDataSourceErrors() {
        Boolean value = (Boolean)this.props.get("ignoreDataSourceErrors");
        return this.getJPARuntime().isIgnoreDataSourceErrors(value);
    }

    private String convertBlanksToNull(String string) {
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return null;
    }

    @Override
    public int getEntityManagerPoolCapacity() {
        int poolCapacity = (Integer)this.props.get("entityManagerPoolCapacity");
        if (poolCapacity >= 0 || poolCapacity <= 500) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("EMPoolCapacity = " + poolCapacity), (Object[])new Object[0]);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("EMPoolCapacity out of range (0,500) : " + poolCapacity), (Object[])new Object[0]);
            }
            poolCapacity = -1;
        }
        return poolCapacity;
    }

    public Set<String> getExcludedAppNames() {
        List<String> list = Arrays.asList((String[])this.props.get("excludedApplication"));
        return new HashSet<String>(list);
    }

    @org.osgi.service.component.annotations.Reference(name="transactionManager", service=EmbeddableWebSphereTransactionManager.class)
    protected void setEmbeddableWebSphereTransactionManager(ServiceReference<EmbeddableWebSphereTransactionManager> ref) {
        this.ivTransactionManagerSR.setReference(ref);
    }

    protected void unsetEmbeddableWebSphereTransactionManager(ServiceReference<EmbeddableWebSphereTransactionManager> ref) {
        this.ivTransactionManagerSR.unsetReference(ref);
    }

    @org.osgi.service.component.annotations.Reference(name="jpaProvider", service=JPAProviderIntegration.class)
    protected void setJPAProvider(ServiceReference<JPAProviderIntegration> jpaSR) {
        this.providerIntegrationSR.setReference(jpaSR);
    }

    protected void unsetJPAProvider(ServiceReference<JPAProviderIntegration> jpaSR) {
        this.providerIntegrationSR.unsetReference(jpaSR);
    }

    @Override
    public JPARuntime getJPARuntime() {
        return (JPARuntime)this.jpaRuntime.getServiceWithException();
    }

    @org.osgi.service.component.annotations.Reference(name="jpaRuntime", service=JPARuntime.class)
    protected void setJpaRuntime(ServiceReference<JPARuntime> reference) {
        this.jpaRuntime.setReference(reference);
    }

    protected void unsetJpaRuntime(ServiceReference<JPARuntime> reference) {
        this.jpaRuntime.unsetReference(reference);
    }

    @org.osgi.service.component.annotations.Reference(name="classLoadingService", service=ClassLoadingService.class)
    protected void setClassLoadingService(ClassLoadingService ref) {
        this.classLoadingService = ref;
    }

    protected void unsetClassLoadingService(ClassLoadingService ref) {
        this.classLoadingService = null;
    }

    @Override
    public ClassLoader createThreadContextClassLoader(final ClassLoader appClassloader) {
        final ClassLoadingService cls = this.classLoadingService;
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = 8568869993188115749L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return cls.createThreadContextClassLoader(appClassloader);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jpa.container.osgi.internal.JPAComponentImpl$1", 1.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
            }
        });
    }

    @Override
    public void destroyThreadContextClassLoader(final ClassLoader tcclassloader) {
        final ClassLoadingService cls = this.classLoadingService;
        AccessController.doPrivileged(new PrivilegedAction(){
            static final long serialVersionUID = -8673585408578620647L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Object run() {
                cls.destroyThreadContextClassLoader(tcclassloader);
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jpa.container.osgi.internal.JPAComponentImpl$2", 2.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
            }
        });
    }

    @Override
    public boolean isServerRuntime() {
        return this.server;
    }

    @org.osgi.service.component.annotations.Reference(service=LibertyProcess.class, target="(wlp.process.type=server)", cardinality=ReferenceCardinality.OPTIONAL)
    protected void setLibertyProcess(ServiceReference<LibertyProcess> reference) {
        this.server = true;
    }

    protected void unsetLibertyProcess(ServiceReference<LibertyProcess> reference) {
    }

    @org.osgi.service.component.annotations.Reference(name="contextAccessor", service=JPAExPcBindingContextAccessor.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setContextAccessor(ServiceReference<JPAExPcBindingContextAccessor> reference) {
        this.ivContextAccessorSR.setReference(reference);
    }

    protected void unsetContextAccessor(ServiceReference<JPAExPcBindingContextAccessor> reference) {
        this.ivContextAccessorSR.unsetReference(reference);
    }

    @org.osgi.service.component.annotations.Reference(name="resourceBindingListeners", service=ResourceBindingListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addResourceBindingListener(ServiceReference<ResourceBindingListener> reference) {
        this.resourceBindingListeners.addReference(reference);
    }

    protected void removeResourceBindingListener(ServiceReference<ResourceBindingListener> reference) {
        this.resourceBindingListeners.removeReference(reference);
    }

    @org.osgi.service.component.annotations.Reference(name="jpaPropsProvider", service=JPAEMFPropertyProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addJPAEMFPropertyProvider(ServiceReference<JPAEMFPropertyProvider> reference) {
        this.propProviderSRs.addReference(reference);
    }

    protected void removeJPAEMFPropertyProvider(ServiceReference<JPAEMFPropertyProvider> reference) {
        this.propProviderSRs.removeReference(reference);
    }

    @org.osgi.service.component.annotations.Reference(name="appCoord")
    protected void setAppRecycleCoordinator(ServiceReference<ApplicationRecycleCoordinator> ref) {
    }

    protected void unsetAppRecycleCoordinator(ServiceReference<ApplicationRecycleCoordinator> ref) {
    }

    @Override
    public void registerJPAExPcBindingContextAccessor(JPAExPcBindingContextAccessor accessor) {
        throw new UnsupportedOperationException("Not supported in Liberty");
    }

    @Override
    public JPAExPcBindingContextAccessor getExPcBindingContext() {
        return (JPAExPcBindingContextAccessor)this.ivContextAccessorSR.getService();
    }

    @Override
    public UOWCurrent getUOWCurrent() {
        return (UOWCurrent)this.ivTransactionManagerSR.getService();
    }

    @Override
    public EmbeddableWebSphereTransactionManager getEmbeddableWebSphereTransactionManager() {
        return (EmbeddableWebSphereTransactionManager)this.ivTransactionManagerSR.getService();
    }

    @Override
    public File getServerLogDirectory() {
        String logLocation = TrConfigurator.getLogLocation();
        if (logLocation != null) {
            return new File(logLocation);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycleJPAApplications() {
        if (FrameworkState.isStopping()) {
            return;
        }
        HashMap appsToRestartMap = new HashMap();
        HashSet<String> appsToRestart = new HashSet<String>();
        Map map = this.applList;
        synchronized (map) {
            appsToRestartMap.putAll(this.applList);
        }
        for (Map.Entry entry : appsToRestartMap.entrySet()) {
            if (!((JPAApplInfo)entry.getValue()).hasPersistenceUnitsDefined()) continue;
            appsToRestart.add((String)entry.getKey());
        }
        appsToRestart.addAll(stuckApps);
        stuckApps.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Recycling JPA applications", (Object[])new Object[]{appsToRestart});
        }
        ApplicationRecycleCoordinator appCoord = (ApplicationRecycleCoordinator)priv.locateService(this.context, REFERENCE_APP_COORD);
        appCoord.recycleApplications(appsToRestart);
    }

    public String getIntrospectorName() {
        return "JPARuntimeInspector";
    }

    public String getIntrospectorDescription() {
        return "JPA Runtime Internal State Information";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void introspect(PrintWriter out) throws Exception {
        out.println("JPA Component State:");
        out.println();
        out.println("Service Properties:");
        Enumeration<String> keysEnum = this.props.keys();
        while (keysEnum.hasMoreElements()) {
            String key = keysEnum.nextElement();
            Object o = this.props.get(key);
            if (o != null && o.getClass().isArray()) {
                out.print("  " + key + " = [ ");
                Object[] objArr = (Object[])o;
                if (objArr.length != 0) {
                    boolean bl = true;
                    for (Object obj : objArr) {
                        if (bl) {
                            bl = false;
                        } else {
                            out.print(", ");
                        }
                        out.print(obj);
                    }
                }
                out.println(" ]");
                continue;
            }
            out.println("  " + key + " = " + o);
        }
        out.println();
        out.println("jpaRuntime = " + this.jpaRuntime.getService());
        out.println("Provider Runtime Integration Service = " + this.providerIntegrationSR.getService());
        out.println("Registered JPAEMFPropertyProvider Services:");
        Iterator servicesIter = this.propProviderSRs.getServices();
        while (servicesIter.hasNext()) {
            out.println("   " + servicesIter.next());
        }
        out.println();
        HashMap appMap = new HashMap();
        Map map = this.applList;
        synchronized (map) {
            appMap.putAll(this.applList);
        }
        JPAIntrospection.beginJPAIntrospection();
        try {
            for (Map.Entry entry : appMap.entrySet()) {
                String appName = (String)entry.getKey();
                OSGiJPAApplInfo appl = (OSGiJPAApplInfo)entry.getValue();
                JPAIntrospection.beginApplicationVisit(appName, appl);
                try {
                    appl.introspect(out);
                }
                finally {
                    JPAIntrospection.endApplicationVisit();
                }
            }
            JPAIntrospection.executeIntrospectionAnalysis(out);
        }
        finally {
            JPAIntrospection.endJPAIntrospection();
        }
    }
}

