/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaas.common.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.classloading.ClassProvider;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.EARApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.NestedConfigHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jaas.common.JAASLoginModuleConfig;
import com.ibm.ws.security.jaas.common.internal.ModuleConfig;
import com.ibm.ws.security.jaas.common.modules.WSLoginModuleProxy;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.library.Library;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.security.authentication.internal.jaas.jaasLoginModuleConfig"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class JAASLoginModuleConfigImpl
implements JAASLoginModuleConfig {
    private static final TraceComponent tc = Tr.register(JAASLoginModuleConfigImpl.class, (String)"security", (String)"com.ibm.ws.security.jaas.common.internal.resources.JAASCommonMessages");
    public static final String CERTIFICATE = "certificate";
    public static final String HASHTABLE = "hashtable";
    public static final String IDENTITY_ASSERTION = "identityAssertion";
    public static final String TOKEN = "token";
    public static final String USERNAME_AND_PASSWORD = "userNameAndPassword";
    public static final String DELEGATE = "delegate";
    public static final Class<WSLoginModuleProxy> WSLOGIN_MODULE_PROXY_CLASS = WSLoginModuleProxy.class;
    public static final String WSLOGIN_MODULE_PROXY = WSLOGIN_MODULE_PROXY_CLASS.getName();
    public static final List<String> defaultLoginModuleIds = Collections.unmodifiableList(Arrays.asList("hashtable", "userNameAndPassword", "certificate", "token", "hashtable", "proxy", "identityAssertion"));
    static final String CFG_KEY_ID = "id";
    static final String CFG_KEY_CLASSNAME = "className";
    static final String CFG_KEY_CONTROL_FLAG = "controlFlag";
    static final String CFG_KEY_OPTION_PID = "optionsRef";
    public static final String WAS_LM_SHARED_LIB = "WAS_LM_SHAREDLIB";
    private ModuleConfig moduleConfig;
    private AppConfigurationEntry.LoginModuleControlFlag controlFlag = null;
    private Map<String, Object> options = Collections.emptyMap();
    private ApplicationInfo classProviderAppInfo;
    private Library sharedLibrary;
    private ClassLoadingService classLoadingService;
    static final long serialVersionUID = 8599489822980329620L;

    @Activate
    protected void activate(ModuleConfig moduleConfig, Map<String, Object> props) {
        this.moduleConfig = moduleConfig;
        this.processConfigProps(props);
    }

    private void processConfigProps(Map<String, Object> props) {
        this.controlFlag = JAASLoginModuleConfigImpl.setControlFlag(this.moduleConfig.controlFlag());
        Map<String, Object> options = this.extractOptions(props);
        String originalLoginModuleClassName = this.moduleConfig.className();
        if (this.isDefaultLoginModule()) {
            String target = JAASLoginModuleConfigImpl.getTargetClassName(originalLoginModuleClassName, options);
            Class<?> cl = this.getTargetClassForName(target);
            options.put("kernelDelegate", cl);
        } else {
            if (this.sharedLibrary == null && this.classProviderAppInfo == null) {
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKS1147_JAAS_CUSTOM_LOGIN_MODULE_CP_LIB_MISSING", (Object[])new Object[]{originalLoginModuleClassName, props.get("config.displayId")}));
            }
            if (this.sharedLibrary != null && this.classProviderAppInfo != null) {
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKS1146_JAAS_CUSTOM_LOGIN_MODULE_CP_LIB_CONFLICT", (Object[])new Object[]{originalLoginModuleClassName, props.get("config.displayId")}));
            }
            options = JAASLoginModuleConfigImpl.processDelegateOptions(options, originalLoginModuleClassName, this.classProviderAppInfo, this.classLoadingService, this.sharedLibrary, false);
        }
        this.options = options;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={ClassNotFoundException.class})
    public static Map<String, Object> processDelegateOptions(Map<String, Object> inOptions, String originalLoginModuleClassName, ApplicationInfo classProviderAppInfo, ClassLoadingService classLoadingService, Library sharedLibrary, boolean jaasConfigFile) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.putAll(inOptions);
        String target = JAASLoginModuleConfigImpl.getTargetClassName(originalLoginModuleClassName, options);
        options.put("kernelDelegate", WSLOGIN_MODULE_PROXY_CLASS);
        if (target != null) {
            Class<?> cl;
            block23: {
                ClassLoader loader;
                if (classProviderAppInfo == null) {
                    loader = classLoadingService == null ? null : classLoadingService.getSharedLibraryClassLoader(sharedLibrary);
                } else if (classProviderAppInfo instanceof EARApplicationInfo) {
                    loader = ((EARApplicationInfo)classProviderAppInfo).getApplicationClassLoader();
                } else {
                    NestedConfigHelper config = classProviderAppInfo.getConfigHelper();
                    if ("rar".equals(config.get("type"))) {
                        Collection classProviderRefs;
                        String classProviderId = (String)classProviderAppInfo.getConfigHelper().get(CFG_KEY_ID);
                        String classProviderFilter = "(&" + FilterUtils.createPropertyFilter((String)"objectClass", (String)ClassProvider.class.getName()) + FilterUtils.createPropertyFilter((String)CFG_KEY_ID, (String)classProviderId) + ")";
                        BundleContext bundleContext = FrameworkUtil.getBundle(JAASLoginModuleConfigImpl.class).getBundleContext();
                        try {
                            classProviderRefs = bundleContext.getServiceReferences(ClassProvider.class, classProviderFilter);
                        }
                        catch (InvalidSyntaxException invalidSyntaxException) {
                            void x;
                            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.security.jaas.common.internal.JAASLoginModuleConfigImpl", (String)"166", null, (Object[])new Object[]{inOptions, originalLoginModuleClassName, classProviderAppInfo, classLoadingService, sharedLibrary, jaasConfigFile});
                            throw new RuntimeException((Throwable)x);
                        }
                        ClassProvider classProvider = (ClassProvider)bundleContext.getService((ServiceReference)classProviderRefs.iterator().next());
                        loader = classProvider.getDelegateLoader();
                    } else {
                        ModuleInfo moduleInfo;
                        NonPersistentCache cache;
                        Container container = classProviderAppInfo.getContainer();
                        if (container == null) {
                            cache = null;
                        } else {
                            try {
                                cache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
                            }
                            catch (UnableToAdaptException bundleContext) {
                                void x;
                                FFDCFilter.processException((Throwable)bundleContext, (String)"com.ibm.ws.security.jaas.common.internal.JAASLoginModuleConfigImpl", (String)"180", null, (Object[])new Object[]{inOptions, originalLoginModuleClassName, classProviderAppInfo, classLoadingService, sharedLibrary, jaasConfigFile});
                                throw new IllegalStateException(classProviderAppInfo.getName(), (Throwable)x);
                            }
                        }
                        ModuleInfo moduleInfo2 = moduleInfo = cache == null ? null : (ModuleInfo)cache.getFromCache(ModuleInfo.class);
                        if (moduleInfo != null) {
                            loader = moduleInfo.getClassLoader();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("loading from standalone module " + moduleInfo.getName()), (Object[])new Object[]{loader});
                            }
                        } else {
                            throw new IllegalArgumentException();
                        }
                    }
                }
                cl = null;
                try {
                    if (JAASLoginModuleConfigImpl.isIBMJdk18Lower() || !"com.ibm.security.auth.module.Krb5LoginModule".equalsIgnoreCase(target)) {
                        cl = Class.forName(target, false, loader);
                    }
                }
                catch (ClassNotFoundException e) {
                    if (classProviderAppInfo instanceof EARApplicationInfo) {
                        cl = JAASLoginModuleConfigImpl.loadFromWebModules(target, (EARApplicationInfo)classProviderAppInfo);
                    }
                    if (cl != null) break block23;
                    if (classProviderAppInfo == null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Exception performing class for name.", (Object[])new Object[]{e});
                        }
                        if (jaasConfigFile) {
                            Tr.error((TraceComponent)tc, (String)"JAAS_CUSTOM_LOGIN_MODULE_CLASS_NOT_FOUND", (Object[])new Object[]{originalLoginModuleClassName, e});
                        }
                    }
                    String displayId = (String)classProviderAppInfo.getConfigHelper().get("config.displayId");
                    throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKS1148_JAAS_CUSTOM_LOGIN_MODULE_NOT_FOUND_BY_CP", (Object[])new Object[]{originalLoginModuleClassName, classProviderAppInfo.getName(), displayId == null ? "application" : displayId}));
                }
            }
            options.put(DELEGATE, cl);
        }
        return options;
    }

    private static String getTargetClassName(String className, Map<String, Object> options) {
        String target;
        if (WSLOGIN_MODULE_PROXY.equals(className)) {
            target = (String)options.get(DELEGATE);
            if (target == null || target.length() == 0) {
                Tr.error((TraceComponent)tc, (String)"JAAS_WSLOGIN_MODULE_PROXY_DELEGATE_NOT_SET", (Object[])new Object[0]);
            }
        } else {
            target = className;
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={ClassNotFoundException.class})
    private Class<?> getTargetClassForName(String tg) {
        Class<?> cl = null;
        ClassLoader contextClassLoader = null;
        try {
            ClassLoader bundleClassLoader = JAASLoginModuleConfigImpl.class.getClassLoader();
            contextClassLoader = this.classLoadingService.createThreadContextClassLoader(bundleClassLoader);
            cl = Class.forName(tg, true, contextClassLoader);
        }
        catch (ClassNotFoundException e) {
            block4: {
                try {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)"Exception performing class for name.", (Object[])new Object[]{e});
                }
                catch (Throwable throwable) {
                    this.classLoadingService.destroyThreadContextClassLoader(contextClassLoader);
                    throw throwable;
                }
            }
            this.classLoadingService.destroyThreadContextClassLoader(contextClassLoader);
        }
        this.classLoadingService.destroyThreadContextClassLoader(contextClassLoader);
        return cl;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={ClassNotFoundException.class})
    private static Class<?> loadFromWebModules(String className, EARApplicationInfo appInfo) {
        List moduleClassesInfoList;
        NonPersistentCache cache;
        Container appContainer = appInfo.getContainer();
        if (appContainer == null) {
            cache = null;
        } else {
            try {
                cache = (NonPersistentCache)appContainer.adapt(NonPersistentCache.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void x;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.security.jaas.common.internal.JAASLoginModuleConfigImpl", (String)"275", null, (Object[])new Object[]{className, appInfo});
                throw new IllegalStateException(appInfo.getName(), (Throwable)x);
            }
        }
        ApplicationClassesContainerInfo appClassesInfo = cache == null ? null : (ApplicationClassesContainerInfo)cache.getFromCache(ApplicationClassesContainerInfo.class);
        List list = moduleClassesInfoList = appClassesInfo == null ? null : appClassesInfo.getModuleClassesContainerInfo();
        if (moduleClassesInfoList != null) {
            for (ModuleClassesContainerInfo moduleClassesInfo : moduleClassesInfoList) {
                List moduleContainerInfoList = moduleClassesInfo.getClassesContainerInfo();
                if (moduleContainerInfoList == null) continue;
                for (ContainerInfo moduleContainerInfo : moduleContainerInfoList) {
                    ModuleInfo moduleInfo;
                    Container webContainer;
                    ContainerInfo.Type containerType = moduleContainerInfo.getType();
                    if (ContainerInfo.Type.WEB_MODULE == containerType) {
                        webContainer = moduleContainerInfo.getContainer();
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("skipping " + containerType), (Object[])new Object[0]);
                        }
                        webContainer = null;
                    }
                    if (webContainer == null) {
                        cache = null;
                    } else {
                        try {
                            cache = (NonPersistentCache)webContainer.adapt(NonPersistentCache.class);
                        }
                        catch (UnableToAdaptException unableToAdaptException) {
                            void x;
                            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.security.jaas.common.internal.JAASLoginModuleConfigImpl", (String)"299", null, (Object[])new Object[]{className, appInfo});
                            throw new IllegalStateException(webContainer.getName(), (Throwable)x);
                        }
                    }
                    if ((moduleInfo = cache == null ? null : (ModuleInfo)cache.getFromCache(ModuleInfo.class)) == null) continue;
                    ClassLoader loader = moduleInfo.getClassLoader();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("loading from web module " + moduleInfo.getName()), (Object[])new Object[]{loader});
                    }
                    try {
                        return Class.forName(className, false, loader);
                    }
                    catch (ClassNotFoundException x) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("not found in web module " + moduleInfo.getName()), (Object[])new Object[0]);
                    }
                }
            }
        }
        return null;
    }

    private Map<String, Object> extractOptions(Map<String, Object> props) {
        List<Map<String, Object>> optionsList = Nester.nest("options", props);
        if (!optionsList.isEmpty()) {
            HashMap<String, Object> options = new HashMap<String, Object>(optionsList.get(0).size());
            for (Map.Entry<String, Object> option : optionsList.get(0).entrySet()) {
                String key = option.getKey();
                if (key.startsWith(".") || key.startsWith("config.") || key.startsWith("service.") || key.equals(CFG_KEY_ID)) continue;
                options.put(key, option.getValue());
            }
            return options;
        }
        return new HashMap<String, Object>(2);
    }

    @Override
    public String getId() {
        return this.moduleConfig.id();
    }

    @Override
    public String getClassName() {
        return "com.ibm.ws.kernel.boot.security.LoginModuleProxy";
    }

    static AppConfigurationEntry.LoginModuleControlFlag setControlFlag(String flag) {
        if ("REQUISITE".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        if ("SUFFICIENT".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        if ("OPTIONAL".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }
        return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
    }

    @Override
    public AppConfigurationEntry.LoginModuleControlFlag getControlFlag() {
        return this.controlFlag;
    }

    @Override
    public Map<String, ?> getOptions() {
        return this.options;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    protected void setClassProvider(ApplicationInfo classProviderAppInfo) {
        this.classProviderAppInfo = classProviderAppInfo;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    protected void setSharedLib(Library svc) {
        this.sharedLibrary = svc;
    }

    @Override
    public boolean isDefaultLoginModule() {
        return defaultLoginModuleIds.contains(this.moduleConfig.id());
    }

    @Reference
    protected void setClassLoadingSvc(ClassLoadingService classLoadingService) {
        this.classLoadingService = classLoadingService;
    }

    private static boolean isIBMJdk18Lower() {
        return JavaInfo.vendor() == JavaInfo.Vendor.IBM && JavaInfo.majorVersion() <= 8;
    }
}

