/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jain.protocol.ip.sip.ListeningPointImpl;
import com.ibm.ws.jain.protocol.ip.sip.SipProviderImpl;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.properties.SipPropertiesMap;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import jain.protocol.ip.sip.ListeningPoint;
import jain.protocol.ip.sip.ListeningPointUnavailableException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.SipStack;
import jain.protocol.ip.sip.UnableToDeleteProviderException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;

@Component(service={SipStack.class}, configurationPolicy=ConfigurationPolicy.OPTIONAL, configurationPid={"com.ibm.ws.jain.protocol.ip.sip"}, name="com.ibm.ws.jain.protocol.ip.sip", property={"service.vendor=IBM"})
public class SipStackImpl
implements SipStack {
    private static final LogMgr c_logger = Log.get(SipStackImpl.class);
    private static final String STACK_NAME = "TEMP_NAME";
    private String m_stackName;
    private List<SipProvider> m_providers;
    private static final TraceComponent tc = Tr.register(SipStackImpl.class);
    private SIPTransactionStack m_stack;

    public void activate(Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SipStackImpl activated", (Object[])new Object[]{properties});
        }
        SipPropertiesMap props = PropertiesStore.getInstance().getProperties();
        props.updateProperties(properties);
        this.init();
    }

    @Modified
    public void modified(Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SipStackImpl modified", (Object[])new Object[]{properties});
        }
    }

    public void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SipStackImpl deactivated, reason=" + reason), (Object[])new Object[0]);
        }
    }

    private void init() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "SipStackImpl", "trying to load sip stack");
        }
        try {
            this.m_providers = new ArrayList<SipProvider>(16);
            this.m_stack = SIPTransactionStack.instance();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "SipStackImpl", "sip stack loaded!!!");
            }
        }
        catch (Throwable t) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.exception.stack", "Create", null, t);
            }
            throw new RuntimeException("SIP stack failed to start", t);
        }
    }

    @Override
    public SipProvider createSipProvider(ListeningPoint listeningPoint) throws IllegalArgumentException, ListeningPointUnavailableException {
        ListeningPointImpl lp = (ListeningPointImpl)listeningPoint;
        if (!this.m_stack.getTransportCommLayerMgr().getListeningPoints().contains(lp)) {
            try {
                this.m_stack.getTransportCommLayerMgr().createSIPListenningConnection(lp);
            }
            catch (IOException e2) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "createSipProvider", e2.getMessage(), e2);
                }
                throw new ListeningPointUnavailableException("cannot listen on " + lp);
            }
        }
        SipProviderImpl provider = new SipProviderImpl();
        provider.setListeningPoint(lp);
        provider.setSipStack(this);
        lp.setProvider(provider);
        this.m_providers.add(provider);
        return provider;
    }

    @Override
    public void deleteSipProvider(SipProvider sipProvider) throws UnableToDeleteProviderException, IllegalArgumentException {
        SipProviderImpl providerImpl = (SipProviderImpl)sipProvider;
        providerImpl.stop();
        this.m_providers.remove(providerImpl);
    }

    @Override
    public Iterator getListeningPoints() {
        return this.m_stack.getTransportCommLayerMgr().getListeningPoints().iterator();
    }

    @Override
    public Iterator getSipProviders() {
        return this.m_providers.iterator();
    }

    @Override
    public String getStackName() {
        return this.m_stackName == null ? STACK_NAME : this.m_stackName;
    }

    @Override
    public void setStackName(String stackName) {
        if (stackName == null) {
            throw new IllegalArgumentException("stack namecannot be null");
        }
        this.m_stackName = stackName;
    }

    public SIPTransactionStack getTransactionStack() {
        return this.m_stack;
    }

    public Timer getTimer() {
        return this.m_stack.getTimer();
    }
}

