/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.extensions;

import com.ibm.ws.jain.protocol.ip.sip.extensions.MimeVersionHeader;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;

public class MimeVersionHeaderImpl
extends HeaderImpl
implements MimeVersionHeader {
    private static final long serialVersionUID = -8581656462086659946L;
    private short m_major;
    private short m_minor;

    @Override
    public short getMajorVersion() {
        return this.m_major;
    }

    @Override
    public short getMinorVersion() {
        return this.m_minor;
    }

    @Override
    public void setMajorVersion(short major) throws IllegalArgumentException {
        if (major < 0 || major > 9) {
            throw new IllegalArgumentException("Mime version - major must be digit");
        }
        this.m_major = major;
    }

    @Override
    public void setMinorVersion(short minor) throws IllegalArgumentException {
        if (minor < 0 || minor > 9) {
            throw new IllegalArgumentException("Mime version - minor must be digit");
        }
        this.m_minor = minor;
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        this.setMajorVersion(parser.shortNumber());
        parser.match('.');
        this.setMinorVersion(parser.shortNumber());
    }

    @Override
    protected void encodeValue(CharsBuffer ret) {
        ret.append(this.m_major);
        ret.append('.');
        ret.append(this.m_minor);
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!(other instanceof MimeVersionHeaderImpl)) {
            return false;
        }
        MimeVersionHeaderImpl o = (MimeVersionHeaderImpl)other;
        return this.m_major == o.m_major && this.m_minor == o.m_minor;
    }

    @Override
    public String getName() {
        return "MIME-Version";
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean isNested() {
        return true;
    }
}

