/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.jain.protocol.ip.sip.header.ContentTypeHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.AcceptHeader;

public class AcceptHeaderImpl
extends ContentTypeHeaderImpl
implements AcceptHeader {
    private static final long serialVersionUID = 4541816839432951359L;
    private float m_qValue = -1.0f;

    @Override
    public boolean allowsAllContentTypes() {
        return this.getContentType().equals("*");
    }

    @Override
    public boolean allowsAllContentSubTypes() {
        return this.getContentSubType().equals("*");
    }

    @Override
    public void setQValue(float qValue) throws SipParseException {
        if ((double)qValue < 0.0) {
            throw new SipParseException("AcceptHeader: Q Value < 0", "");
        }
        if ((double)qValue > 1.0) {
            throw new SipParseException("AcceptHeader: Q value > 1.0", "");
        }
        this.m_qValue = qValue;
    }

    @Override
    public float getQValue() {
        return this.m_qValue;
    }

    @Override
    public boolean hasQValue() {
        return this.m_qValue != -1.0f;
    }

    @Override
    public void removeQValue() {
        this.m_qValue = -1.0f;
        this.removeParameter("q");
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        super.parseValue(parser);
        String qValue = this.getParameter("q");
        if (qValue != null) {
            this.setQValue(Float.parseFloat(qValue));
        }
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!super.valueEquals(other)) {
            return false;
        }
        if (!(other instanceof AcceptHeaderImpl)) {
            return false;
        }
        AcceptHeaderImpl o = (AcceptHeaderImpl)other;
        return this.m_qValue != o.m_qValue;
    }

    @Override
    public String getName() {
        return "Accept";
    }

    @Override
    public String getName(boolean isUseCompactHeaders) {
        return this.getName();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean isNested() {
        return true;
    }
}

