/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.impl;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class SipResolverEventsCounter {
    private static final LogMgr c_logger = Log.get(SipResolverEventsCounter.class);
    private final AtomicIntegerArray _events;
    private final int _windowSize;
    private final int _arrayWindowSize;
    private final int _interval;
    private AtomicInteger _lastUpdate;
    private AtomicInteger _totalEvents;
    private static boolean usePreciseSystemTimer = false;

    public static void setUsePreciseSystemTimer(boolean tempUsePreciseSystemTimer) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverEventsCounter: setUsePreciseSystemTimer = " + tempUsePreciseSystemTimer);
        }
        usePreciseSystemTimer = tempUsePreciseSystemTimer;
    }

    public SipResolverEventsCounter(int windowSize, int interval) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverEventsCounter: entry");
        }
        this._windowSize = windowSize;
        this._interval = interval;
        this._arrayWindowSize = windowSize + interval;
        this._events = new AtomicIntegerArray(this._arrayWindowSize / this._interval);
        for (int i = 0; i < this._events.length(); ++i) {
            this._events.set(i, 0);
        }
        this._lastUpdate = usePreciseSystemTimer ? new AtomicInteger((int)(System.nanoTime() / 1000000000L)) : new AtomicInteger((int)(System.currentTimeMillis() / 1000L));
        this._totalEvents = new AtomicInteger(0);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverEventsCounter: initialized, window size: " + this._windowSize + " interval size: " + this._interval + " array size: " + this._events.length());
        }
    }

    public int reportEvent() {
        int last;
        int current = 0;
        current = usePreciseSystemTimer ? (int)(System.nanoTime() / 1000000000L) : (int)(System.currentTimeMillis() / 1000L);
        if (current - (last = this._lastUpdate.get()) > this._interval && this._lastUpdate.compareAndSet(last, current)) {
            this.eraseOldValues(current, last);
        }
        int loc = current % this._arrayWindowSize / this._interval;
        int val = this._events.incrementAndGet(loc);
        int total = this._totalEvents.incrementAndGet();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverEventsCounter: reportEvent: setting location: " + loc + " to: " + val + " total: " + total);
        }
        return total;
    }

    public void reset() {
        this._totalEvents.set(0);
        for (int i = 0; i < this._events.length(); ++i) {
            this._events.set(i, 0);
        }
    }

    private void eraseOldValues(int current, int last) {
        int num;
        int startLoc;
        if (current - last > this._windowSize) {
            startLoc = current % this._arrayWindowSize / this._interval;
            num = this._events.length();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverEventsCounter: eraseOldValues: erasing all values.");
            }
        } else {
            startLoc = (last - this._windowSize + this._interval) % this._arrayWindowSize / this._interval;
            num = current / this._interval - last / this._interval;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverEventsCounter: eraseOldValues: erasing " + num);
            }
        }
        if (num > 0) {
            int total = 0;
            for (int i = 0; i < num; ++i) {
                int loc = (i + startLoc) % this._events.length();
                int old = this._events.getAndSet(loc, 0);
                total += old;
            }
            int now = this._totalEvents.addAndGet(-total);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverEventsCounter: eraseOldValues: erasing from " + startLoc + ", " + num + " cells. New total: " + now + " Old total: " + total);
            }
        } else {
            this._lastUpdate.set(last);
        }
    }
}

