/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.asynch;

import com.ibm.ws.sip.container.asynch.AsynchronousWorkTask;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletsFactoryImpl;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AsynchronousWorkTasksManager {
    private static final AsynchronousWorkTasksManager _instance = new AsynchronousWorkTasksManager();
    private Map<String, AsynchronousWorkTask> _asynchWorkTasks = new ConcurrentHashMap<String, AsynchronousWorkTask>();
    private SipApplicationSessionImpl _asynchSipApp = (SipApplicationSessionImpl)SipServletsFactoryImpl.getInstance().createApplicationSession();

    private AsynchronousWorkTasksManager() {
        this._asynchSipApp.setExpires(0);
        this._asynchSipApp.setInvalidateWhenReady(false);
    }

    public static AsynchronousWorkTasksManager instance() {
        return _instance;
    }

    public AsynchronousWorkTask getAsynchronousWorkTask(String key) {
        return this._asynchWorkTasks.get(key);
    }

    public Collection<AsynchronousWorkTask> getAllAsynchronousWorkTasks() {
        LinkedList<AsynchronousWorkTask> allAsynchronousWorkTasks = new LinkedList<AsynchronousWorkTask>(this._asynchWorkTasks.values());
        return allAsynchronousWorkTasks;
    }

    public void putAsynchronousWorkTask(String key, AsynchronousWorkTask value) {
        if (this.getAsynchronousWorkTask(key) == null) {
            this._asynchWorkTasks.put(key, value);
        }
    }

    public void removeAsynchronousWorkTask(String key) {
        if (key != null) {
            this._asynchWorkTasks.remove(key);
        }
    }

    public SipApplicationSessionImpl getAsynchSipApp() {
        return this._asynchSipApp;
    }
}

