/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.failover.repository;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.failover.repository.SASAttrRepository;
import com.ibm.ws.sip.container.failover.repository.SASRepository;
import com.ibm.ws.sip.container.failover.repository.SKBTRepository;
import com.ibm.ws.sip.container.failover.repository.SSAttrRepository;
import com.ibm.ws.sip.container.failover.repository.SSRepository;
import com.ibm.ws.sip.container.failover.repository.TUWrapperRepositoryRfc3261;
import com.ibm.ws.sip.container.failover.repository.TimerRepository;
import com.ibm.ws.sip.container.failover.repository.TuBaseRepository;
import com.ibm.ws.sip.container.failover.repository.TuImplRepository;
import com.ibm.ws.sip.container.failover.repository.TuWrapperRepository;
import com.ibm.ws.sip.container.failover.repository.ctor.SASAttrRepositoryFactoryImpl;
import com.ibm.ws.sip.container.failover.repository.ctor.SASRepositoryFactoryImpl;
import com.ibm.ws.sip.container.failover.repository.ctor.SKBTRepositoryFactory;
import com.ibm.ws.sip.container.failover.repository.ctor.SSAttrRepositoryFactoryImpl;
import com.ibm.ws.sip.container.failover.repository.ctor.SSRepositoryFactoryImpl;
import com.ibm.ws.sip.container.failover.repository.ctor.TimersRepositoryFactoryImpl;
import com.ibm.ws.sip.container.failover.repository.ctor.TuBaseRepoFactoryImpl;
import com.ibm.ws.sip.container.failover.repository.ctor.TuImplRepoFactoryImpl;
import com.ibm.ws.sip.container.failover.repository.ctor.TuWrapperRepositoryFactory;
import com.ibm.ws.sip.container.failover.repository.ctor.TuWrapperRfc3261RepositoryFactory;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipSessionImplementation;
import com.ibm.ws.sip.container.timer.BaseTimer;
import com.ibm.ws.sip.container.tu.SessionKeyBase;
import com.ibm.ws.sip.container.tu.TUKey;
import com.ibm.ws.sip.container.tu.TransactionUserBase;
import com.ibm.ws.sip.container.tu.TransactionUserImpl;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import java.util.List;
import java.util.Map;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipSession;

public class SessionRepository {
    private static final LogMgr c_logger = Log.get(SessionRepository.class);
    private TimerRepository m_timersRepository;
    private SASRepository m_SASrepo;
    private SASAttrRepository m_SASAttrrepo;
    private SSRepository m_SSrepo;
    private SSAttrRepository m_SSAttrrepo;
    private TuWrapperRepository m_tuWrappperRepo;
    private TuImplRepository m_tuImplRepo;
    private TuBaseRepository m_tuBaseRepo;
    private SKBTRepository m_SKBTrepo;
    private TUWrapperRepositoryRfc3261 m_tuWrappperRepoRfc3261;
    private static SessionRepository s_singleton = new SessionRepository();

    public static SessionRepository getInstance() {
        return s_singleton;
    }

    private void init() {
        try {
            this.m_SASrepo = new SASRepositoryFactoryImpl().createRepository();
            this.m_timersRepository = new TimersRepositoryFactoryImpl().createRepository();
            this.m_SASAttrrepo = new SASAttrRepositoryFactoryImpl().createRepository();
            this.m_SSrepo = new SSRepositoryFactoryImpl().createRepository();
            this.m_SSAttrrepo = new SSAttrRepositoryFactoryImpl().createRepository();
            this.m_tuImplRepo = new TuImplRepoFactoryImpl().createRepository();
            this.m_tuWrappperRepo = TuWrapperRepositoryFactory.createRepository();
            this.m_tuWrappperRepoRfc3261 = TuWrapperRfc3261RepositoryFactory.createRepository();
            this.m_tuBaseRepo = new TuBaseRepoFactoryImpl().createRepository();
            this.m_SKBTrepo = new SKBTRepositoryFactory().createRepository();
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (InstantiationException e3) {
            e3.printStackTrace();
        }
        catch (IllegalAccessException e4) {
            e4.printStackTrace();
        }
    }

    private SessionRepository() {
        this.init();
    }

    public BaseTimer put(SipApplicationSession sipAppSession, BaseTimer timer) {
        if (c_logger.isTraceDebugEnabled() && this.m_SASrepo.get(sipAppSession.getId()) == null) {
            c_logger.traceDebug("SessionRepository#put(BaseTimer) adding attribute to Appsession which is not in repository.");
        }
        BaseTimer result = this.m_timersRepository.put(sipAppSession, timer);
        if (c_logger.isTraceDebugEnabled() && result != null && result != timer) {
            c_logger.traceDebug("SessionRepository#put(timer) overriding value");
        }
        return result;
    }

    public BaseTimer getTimer(String sipAppSessionId, Integer timerId) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)null, "getTimer", sipAppSessionId, timerId);
        }
        BaseTimer timer = this.m_timersRepository.get(sipAppSessionId, timerId);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(null, "getTimer", timer);
        }
        return timer;
    }

    public BaseTimer removeTimer(String appSessionId, BaseTimer timer) {
        return this.m_timersRepository.remove(appSessionId, timer.getTimerId());
    }

    public SipApplicationSession put(SipApplicationSession sipAppSession) {
        SipApplicationSession oldVal = this.m_SASrepo.put(sipAppSession.getId(), sipAppSession);
        return oldVal;
    }

    public SipApplicationSession getAppSession(String appSessionId) {
        SipApplicationSession sas = this.m_SASrepo.get(appSessionId);
        return sas;
    }

    public SipApplicationSession remove(SipApplicationSession sipAppSession) {
        SipApplicationSession result = this.m_SASrepo.remove(sipAppSession);
        if (result == null && c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SAS was already removed. check flow");
        }
        return result;
    }

    public Object putSASAttr(SipApplicationSession appSession, String name, Object value) {
        if (c_logger.isTraceDebugEnabled() && this.m_SASrepo.get(appSession.getId()) == null) {
            c_logger.traceDebug("SessionRepository#putSASAttr() adding attribute to Appsession which is not in repository.");
        }
        Object previousVal = this.m_SASAttrrepo.put(appSession, name, value);
        if (c_logger.isTraceDebugEnabled() && previousVal != null && previousVal.equals(value)) {
            c_logger.traceDebug("putSASAttr put an attribute which was already there. check flow");
        }
        return previousVal;
    }

    public Object getSASAttr(SipApplicationSession appSession, String name) {
        return this.m_SASAttrrepo.get(appSession, name);
    }

    public Object getSipSessAttr(SipSession session, String name) {
        return this.m_SSAttrrepo.get(session, name);
    }

    public Map getAttributes(String session) {
        return this.m_SSAttrrepo.getAttributes(session);
    }

    public Map getAttributes(SipApplicationSession appSession) {
        return this.m_SASAttrrepo.getAttributes(appSession.getId());
    }

    public Object putSSAttr(SipSession session, String attrName, Object value) {
        if (c_logger.isTraceDebugEnabled() && session.getId() != null && this.m_SSrepo.get(session.getId()) == null) {
            c_logger.traceDebug(this, "putSSAttr", " adding attribute to session " + session.getId() + " which is not in repository.");
        }
        return this.m_SSAttrrepo.put(session, attrName, value);
    }

    public Object put(String sessionId, TransactionUserWrapper wrapper) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{sessionId};
            c_logger.traceEntry((Object)this, "SessionRepository: put by sessionId", params);
        }
        if (sessionId == null) {
            throw new NullPointerException("session ID is null");
        }
        if (wrapper == null) {
            throw new NullPointerException("wrapper object is null");
        }
        TransactionUserWrapper result = this.m_tuWrappperRepo.put(sessionId, wrapper);
        if (c_logger.isTraceDebugEnabled() && result != null && result != wrapper) {
            c_logger.traceDebug("SessionRepository#put(wrapper) overriding value. check flow.");
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "SessionRepository: put by sessionId", result);
        }
        return result;
    }

    public Object put(TUKey key, TransactionUserWrapper wrapper, boolean addToSessionsTbl) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{key, wrapper.getId(), addToSessionsTbl};
            c_logger.traceEntry((Object)this, "SessionRepository: put by key", params);
        }
        if (key == null) {
            throw new NullPointerException("session ID is null");
        }
        if (wrapper == null) {
            throw new NullPointerException("wrapper object is null");
        }
        TransactionUserWrapper result = this.m_tuWrappperRepoRfc3261.put(key, wrapper);
        if (c_logger.isTraceDebugEnabled() && result != null && result != wrapper) {
            c_logger.traceDebug("SessionRepository#put(wrapper) overriding value. check flow.");
        }
        if (addToSessionsTbl) {
            this.put(wrapper.getId(), wrapper);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{key, wrapper.getId(), addToSessionsTbl};
            c_logger.traceExit((Object)this, "SessionRepository", result);
        }
        return result;
    }

    public TransactionUserWrapper getTuWrapper(TUKey key) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{key};
            c_logger.traceEntry((Object)this, "SessionRepository: getTuWrapper by Key", params);
        }
        TransactionUserWrapper result = this.m_tuWrappperRepoRfc3261.get(key);
        return result;
    }

    public TransactionUserWrapper removeTuWrapper(TUKey key, boolean removeFromSessionTbl) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{key, removeFromSessionTbl};
            c_logger.traceEntry((Object)this, "SessionRepository: removeTuWrapper by Key", params);
        }
        TransactionUserWrapper result = this.m_tuWrappperRepoRfc3261.remove(key);
        if (c_logger.isTraceDebugEnabled() && result == null) {
            c_logger.traceDebug(this, "removeTuWrapper", " TuWrapper was already removed:" + key);
        }
        if (removeFromSessionTbl && result != null) {
            this.removeTuWrapper(result.getId());
        }
        return result;
    }

    public TransactionUserWrapper getTuWrapper(String tuId) {
        TransactionUserWrapper result = this.m_tuWrappperRepo.get(tuId);
        return result;
    }

    public TransactionUserWrapper removeTuWrapper(String sessionId) {
        TransactionUserWrapper result = this.m_tuWrappperRepo.remove(sessionId);
        if (c_logger.isTraceDebugEnabled() && result == null) {
            c_logger.traceDebug(this, "removeTuWrapper", " TuWrapper was already removed:" + sessionId);
        }
        return result;
    }

    public List getAllTuWrappers() {
        List list = this.m_tuWrappperRepoRfc3261.getAll();
        return list;
    }

    public SipSession put(SipSession session) {
        SipSession result = null;
        result = this.m_SSrepo.put(session.getId(), session);
        if (c_logger.isTraceDebugEnabled() && result != null && result != session) {
            c_logger.traceDebug("SessionRepository#put(sipsession) overriding value.check flow");
        }
        return result;
    }

    public SipSession getSipSession(String sessionId) {
        return this.m_SSrepo.get(sessionId);
    }

    public void commitAll() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "commitAll");
        }
        this.m_SASrepo.commitTx(null);
        this.m_SASAttrrepo.commitTx(null);
        this.m_SSAttrrepo.commitTx(null);
        this.m_SSrepo.commitTx(null);
        this.m_timersRepository.commitTx(null);
        this.m_tuBaseRepo.commitTx(null);
        this.m_tuImplRepo.commitTx(null);
        this.m_tuWrappperRepo.commitTx(null);
        this.m_tuWrappperRepoRfc3261.commitTx(null);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "commitAll");
        }
    }

    public void commitSingleType(Object typeToCommit) {
        this.commitSingleType(typeToCommit.getClass());
    }

    public void commitSingleType(Class typeToCommit) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "commitSingleType", (Object)typeToCommit.getName());
        }
        if (SipApplicationSession.class.isAssignableFrom(typeToCommit)) {
            this.m_SASrepo.commitTx(null);
        } else if (TransactionUserBase.class.isAssignableFrom(typeToCommit)) {
            this.m_tuBaseRepo.commitTx(null);
        } else if (TransactionUserImpl.class.isAssignableFrom(typeToCommit)) {
            this.m_tuImplRepo.commitTx(null);
        } else {
            throw new IllegalStateException(" unable to commit type:" + typeToCommit.getClass().getName());
        }
    }

    public Object removeAttribute(SipApplicationSessionImpl impl, String name) {
        return this.m_SASAttrrepo.remove(impl, name);
    }

    public void removeTuImpl(TransactionUserImpl impl) {
        this.m_tuImplRepo.remove(impl);
    }

    public void removeTuBase(TransactionUserBase base) {
        this.m_tuBaseRepo.remove(base);
    }

    public Object removeAttribute(SipSessionImplementation sipSession, String attrName) {
        Object value = this.m_SSAttrrepo.remove(sipSession, attrName);
        return value;
    }

    public void removeSipSession(SipSessionImplementation session) {
        session.removeAllAttributes();
        this.m_SSrepo.remove(session);
    }

    public void put(String sessionId, TransactionUserBase base) {
        TransactionUserBase result = this.m_tuBaseRepo.put(sessionId, base);
        if (c_logger.isTraceDebugEnabled() && result != null && result != base) {
            c_logger.traceDebug("SessionRepository#put(tubase) overriding value.check flow");
        }
    }

    public void put(String sessionId, TransactionUserImpl tuimpl) {
        TransactionUserImpl result = this.m_tuImplRepo.put(sessionId, tuimpl);
        if (c_logger.isTraceDebugEnabled() && result != null && result != tuimpl) {
            c_logger.traceDebug("SessionRepository#put(tuimpl) overriding value.check flow");
        }
    }

    public List<SipApplicationSessionImpl> getAllAppSessions() {
        List<SipApplicationSessionImpl> list = this.m_SASrepo.getAll();
        return list;
    }

    public TransactionUserImpl getTuImpl(String sessionId) {
        return this.m_tuImplRepo.get(sessionId);
    }

    public TransactionUserBase getTuBase(String sessionId) {
        return this.m_tuBaseRepo.get(sessionId);
    }

    public void setSessionKeyBase(String keyBaseTargeting, String sessionId) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setSessionKeyBase", "Session key based adding key:" + keyBaseTargeting + " value: " + sessionId);
        }
        SessionKeyBase result = this.m_SKBTrepo.put(keyBaseTargeting, new SessionKeyBase(keyBaseTargeting, sessionId));
        if (c_logger.isTraceDebugEnabled() && result != null && !result.getSipApplicationSessionID().equals(sessionId)) {
            c_logger.traceDebug("SessionRepository#setSessionKeyBase(keyBaseTargeting) overriding value.check flow");
        }
    }

    public String getKeyBaseAppSession(String keyBaseTargeting) {
        SessionKeyBase sas = this.m_SKBTrepo.get(keyBaseTargeting);
        String ret = null;
        if (sas != null) {
            ret = sas.getSipApplicationSessionID();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getKeyBaseAppSession", "retrieving key:" + keyBaseTargeting + " value: " + ret);
        }
        return ret;
    }

    public void removeKeyBaseAppSession(String keyBaseTargeting) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "removeKeyBaseAppSession", "removing key:" + keyBaseTargeting);
        }
        this.m_SKBTrepo.remove(keyBaseTargeting);
    }
}

