/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.failover.repository;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.failover.repository.SASRepository;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.sip.SipApplicationSession;

public class StandAloneSASRepoMgr
implements SASRepository {
    private static final LogMgr c_logger = Log.get(StandAloneSASRepoMgr.class);
    private Hashtable<String, SipApplicationSession> m_appSessions = new Hashtable(19);

    @Override
    public SipApplicationSession get(String appSessionId) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "get", new Object[]{appSessionId});
        }
        return this.m_appSessions.get(appSessionId);
    }

    @Override
    public SipApplicationSession put(String appSessionId, SipApplicationSession appsession) {
        SipApplicationSessionImpl ourapp;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "put", appSessionId, appsession);
        }
        if ((ourapp = (SipApplicationSessionImpl)appsession).isDuringInvalidate() || !ourapp.isValid()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "put", appSessionId + " was invalidated. request ignored");
            }
            return null;
        }
        return this.m_appSessions.put(appSessionId, appsession);
    }

    @Override
    public SipApplicationSession remove(SipApplicationSession appSession) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "remove", appSession.getId());
        }
        return this.m_appSessions.remove(appSession.getId());
    }

    @Override
    public Object beginTx() {
        return null;
    }

    @Override
    public Object commitTx(Object txKey) {
        return null;
    }

    @Override
    public Object rollback(Object txKey) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAll() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "getAll");
        }
        if (this.m_appSessions.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<SipApplicationSession> result = new ArrayList<SipApplicationSession>(this.m_appSessions.size());
        Hashtable<String, SipApplicationSession> hashtable = this.m_appSessions;
        synchronized (hashtable) {
            result.addAll(this.m_appSessions.values());
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getAll", result.size());
        }
        return result;
    }
}

