/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.pmi;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.load.Weighable;
import com.ibm.ws.sip.container.pmi.PerfUtil;
import com.ibm.ws.sip.container.properties.PropertiesStore;

public class LoadManager {
    private static final LogMgr c_logger = Log.get(LoadManager.class);
    private int _lowWaterMarkSize = PropertiesStore.getInstance().getProperties().getInt("lowWaterMarkSizePercent");
    private int _weightOverloadMark = PropertiesStore.getInstance().getProperties().getInt("weightOverloadWatermark");
    private int _lastLoad = 10;
    private boolean _isOverloaded = false;
    private boolean _throwMessagedInOverload;
    private static LoadManager s_singelton;
    public static final int QUIESCE_MODE = 0;
    public static final int SET_REAL_CURRENT_WEIGHT = -1;

    public static LoadManager getInstance() {
        if (s_singelton == null) {
            s_singelton = new LoadManager();
        }
        return s_singelton;
    }

    private LoadManager() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "LoadManager", "Low watermark size that will used is = " + this._lowWaterMarkSize);
        }
        this._lastLoad = 11;
    }

    public synchronized boolean updateNewWeight(Weighable counter, int newWeight, long currentLoad) {
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Try to update new weight from ");
            buff.append(PerfUtil.getTypeStr(counter.getCounterID()));
            buff.append(" New Weight = ");
            buff.append(newWeight);
            buff.append(" Was overloaded = ");
            buff.append(this._isOverloaded);
            c_logger.traceDebug(this, "updateNewWeight", buff.toString());
        }
        if (newWeight != this._lastLoad) {
            this._lastLoad = newWeight;
            boolean stateChaged = this.changeOverloadWithWaterMark();
            if (stateChaged) {
                if (this._isOverloaded) {
                    if (c_logger.isErrorEnabled()) {
                        c_logger.error(PerfUtil.getOverloadedMsgByType(counter.getCounterID()), "Report.STATUS", currentLoad);
                    }
                } else {
                    if (c_logger.isInfoEnabled()) {
                        c_logger.info("info.server.overload.cleared", (Object)"Report.STATUS", currentLoad);
                    }
                    this.setThrowMsgInOverload(false);
                }
            }
            return stateChaged;
        }
        return false;
    }

    private boolean changeOverloadWithWaterMark() {
        if (this._isOverloaded && this._lastLoad >= this._weightOverloadMark) {
            this._isOverloaded = false;
            return true;
        }
        if (!this._isOverloaded && this._lastLoad == 0) {
            this._isOverloaded = true;
            return true;
        }
        return false;
    }

    public int getLastWeight() {
        return this._lastLoad;
    }

    public int getCurrentWeight() {
        return this._lastLoad;
    }

    public int getLowWaterMarkSize() {
        return this._lowWaterMarkSize;
    }

    public void setThrowMsgInOverload(boolean throwMsg) {
        this._throwMessagedInOverload = throwMsg;
    }

    public boolean shouldThrowMsgs() {
        return this._throwMessagedInOverload;
    }
}

