/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.proxy;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import com.ibm.ws.sip.stack.transport.virtualhost.SipVirtualHostAdapter;
import jain.protocol.ip.sip.ListeningPoint;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.address.SipURL;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;

public class SipProxyInfo {
    public static final String PEREFERED_OUTBOUND_HDR_NAME = "IBM-PO";
    public static final String PROXY_OUTBOUND_HDR_NAME = "OutboundIfList";
    public static final String IBM_DOUBLE_RECORD_ROUTE_PARAMETER = "ibmdrr";
    private static final LogMgr c_logger = Log.get(SipProxyInfo.class);
    private static final SipProxyInfo s_singleton = new SipProxyInfo();
    private List<SipURI> m_udpOutboundIfList = new ArrayList<SipURI>();
    private List<SipURI> m_tcpOutboundIfList = new ArrayList<SipURI>();
    private List<SipURI> m_tlsOutboundIfList = new ArrayList<SipURI>();
    private List<SipURI> m_fullOutboundIfList = null;
    private boolean firstProxyStartupReceived = false;
    SipURI m_udpDefault = null;
    SipURI m_tcpDefault = null;
    SipURI m_tlsDefault = null;

    private SipProxyInfo() {
    }

    public static SipProxyInfo getInstance() {
        return s_singleton;
    }

    public synchronized void addUdpInterface(SipURI newUri) {
        this.m_udpOutboundIfList.add(newUri);
        this.m_fullOutboundIfList = null;
    }

    public synchronized void addTcpInterface(SipURI newUri) {
        this.m_tcpOutboundIfList.add(newUri);
        this.m_fullOutboundIfList = null;
    }

    public synchronized void addTlsInterface(SipURI newUri) {
        this.m_tlsOutboundIfList.add(newUri);
        this.m_fullOutboundIfList = null;
    }

    public synchronized List<SipURI> getOutboundInterfaceList() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("getOutboundInterfaceList");
        }
        if (this.m_fullOutboundIfList == null) {
            this.buildFullOutboundIfList(this.m_udpOutboundIfList, this.m_tcpOutboundIfList, this.m_tcpOutboundIfList);
        }
        return this.m_fullOutboundIfList;
    }

    public synchronized SipURI getOutboundInterface(int index, String transport) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "getOutboundInterface", index, transport);
        }
        SipURI returnValue = null;
        if (transport == null && this.m_udpOutboundIfList != null) {
            returnValue = this.m_udpOutboundIfList.get(index);
        } else if (transport.equalsIgnoreCase("udp") && this.m_udpOutboundIfList != null) {
            returnValue = this.m_udpOutboundIfList.get(index);
        } else if (transport.equalsIgnoreCase("tcp") && this.m_tcpOutboundIfList != null) {
            returnValue = this.m_tcpOutboundIfList.get(index);
        } else if (transport.equalsIgnoreCase("tls") && this.m_tlsOutboundIfList != null) {
            returnValue = this.m_tlsOutboundIfList.get(index);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getOutboundInterface", returnValue);
        }
        return returnValue;
    }

    public synchronized int getNumberOfInterfaces(String transport) {
        int returnValue = 0;
        if (transport.equalsIgnoreCase("tcp") && this.m_tcpOutboundIfList != null) {
            returnValue = this.m_tcpOutboundIfList.size();
        } else if (transport.equalsIgnoreCase("udp") && this.m_udpOutboundIfList != null) {
            returnValue = this.m_udpOutboundIfList.size();
        } else if (transport.equalsIgnoreCase("tls") && this.m_tlsOutboundIfList != null) {
            returnValue = this.m_tlsOutboundIfList.size();
        }
        return returnValue;
    }

    public SipURI getDefaultOutboundIface(String transport) {
        SipURI returnValue = null;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "getDefaultOutboundIface", (Object)transport);
        }
        if (transport.equalsIgnoreCase("tcp")) {
            returnValue = this.m_tcpDefault;
        } else if (transport.equalsIgnoreCase("udp")) {
            returnValue = this.m_udpDefault;
        } else if (transport.equalsIgnoreCase("tls")) {
            returnValue = this.m_tlsDefault;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getDefaultOutboundIface", returnValue);
        }
        return returnValue;
    }

    public int getDefaultOutboundIfaceIndex(String transport) {
        int returnValue = -1;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "getDefaultOutboundIface", (Object)transport);
        }
        if (transport.equalsIgnoreCase("tcp")) {
            returnValue = this.getIndexOfIface(this.m_tcpDefault);
        } else if (transport.equalsIgnoreCase("udp")) {
            returnValue = this.getIndexOfIface(this.m_udpDefault);
        } else if (transport.equalsIgnoreCase("tls")) {
            returnValue = this.getIndexOfIface(this.m_tlsDefault);
        }
        if (returnValue == -1 && c_logger.isTraceDebugEnabled()) {
            c_logger.traceExit(this, "getDefaultOutboundIface: No default found");
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getDefaultOutboundIface", returnValue);
        }
        return returnValue;
    }

    public synchronized int getIndexOfIface(String transport, String host, int port) {
        List<SipURI> outboundIfList;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "getIndexOfIface for transport = " + transport + ", " + host + ":" + port);
        }
        if ((outboundIfList = transport.equalsIgnoreCase("udp") ? this.m_udpOutboundIfList : (transport.equalsIgnoreCase("tcp") ? this.m_tcpOutboundIfList : (transport.equalsIgnoreCase("tls") ? this.m_tlsOutboundIfList : null))) == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("getIndexOfIface: outboundIfList is null");
            }
            return -1;
        }
        int size = outboundIfList.size();
        for (int i = 0; i < size; ++i) {
            SipURI iface = outboundIfList.get(i);
            int ifacePort = iface.getPort();
            if (ifacePort == port) {
                String ifaceHost = iface.getHost();
                String ifaceHostAddress = SIPStackUtil.getHostAddress(ifaceHost);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("getIndexOfIface: comparing: " + host + " to host:" + ifaceHost + " and to host addr:" + ifaceHostAddress);
                }
                if (!ifaceHost.equalsIgnoreCase(host) && !ifaceHostAddress.equalsIgnoreCase(host)) continue;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceExit((Object)this, "getIndexOfIface", i);
                }
                return i;
            }
            if (!c_logger.isTraceDebugEnabled()) continue;
            c_logger.traceDebug("getIndexOfIface: port wasn't found");
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceExit(this, "getIndexOfIface: No index found");
        }
        return -1;
    }

    public synchronized int getIndexOfIface(InetSocketAddress socketAddress, String transport) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "getIndexOfIface", (Object)(socketAddress + ":" + transport));
        }
        int result = -1;
        List<SipURI> outboundIfList = null;
        if (transport.equalsIgnoreCase("udp")) {
            outboundIfList = this.m_udpOutboundIfList;
        } else if (transport.equalsIgnoreCase("tcp")) {
            outboundIfList = this.m_tcpOutboundIfList;
        } else if (transport.equalsIgnoreCase("tls")) {
            outboundIfList = this.m_tlsOutboundIfList;
        }
        if (outboundIfList != null) {
            int size = outboundIfList.size();
            for (int i = 0; i < size; ++i) {
                SipURI current = outboundIfList.get(i);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("getIndexOfIface: comparing: " + current.getHost() + " to host:" + socketAddress.getHostName() + " and to host addr:" + InetAddressCache.getHostAddress(socketAddress.getAddress()));
                }
                if (!current.getHost().equalsIgnoreCase(socketAddress.getHostName()) && !current.getHost().equals(InetAddressCache.getHostAddress(socketAddress.getAddress())) || current.getPort() != socketAddress.getPort()) continue;
                result = i;
                break;
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("getIndexOfIface: outboundIfList is null");
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getIndexOfIface", result);
        }
        return result;
    }

    public synchronized int getIndexOfIface(InetAddress address, String transport) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "getIndexOfIface", (Object)address);
        }
        int result = -1;
        List<SipURI> outboundIfList = null;
        if (transport.equalsIgnoreCase("udp")) {
            outboundIfList = this.m_udpOutboundIfList;
        } else if (transport.equalsIgnoreCase("tcp")) {
            outboundIfList = this.m_tcpOutboundIfList;
        } else if (transport.equalsIgnoreCase("tls")) {
            outboundIfList = this.m_tlsOutboundIfList;
        }
        if (outboundIfList != null) {
            int size = outboundIfList.size();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("getIndexOfIface: searching for address:" + address + " list size:" + size);
            }
            for (int i = 0; i < size; ++i) {
                SipURI current = outboundIfList.get(i);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("getIndexOfIface: comparing: " + current.getHost() + " to host:" + address.getHostName() + " and to host addr:" + InetAddressCache.getHostAddress(address));
                }
                if (!current.getHost().equals(InetAddressCache.getHostAddress(address)) && !current.getHost().equals(address.getHostName())) continue;
                result = i;
                break;
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("getIndexOfIface: outboundIfList is null");
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getIndexOfIface", result);
        }
        return result;
    }

    public synchronized int getIndexOfIface(SipURI uri) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "getIndexOfIface", (Object)uri);
        }
        int result = -1;
        List<SipURI> outboundIfList = null;
        if (uri != null) {
            if (uri.getTransportParam().equalsIgnoreCase("udp")) {
                outboundIfList = this.m_udpOutboundIfList;
            } else if (uri.getTransportParam().equalsIgnoreCase("tcp")) {
                outboundIfList = this.m_tcpOutboundIfList;
            } else if (uri.getTransportParam().equalsIgnoreCase("tls")) {
                outboundIfList = this.m_tlsOutboundIfList;
            }
            if (outboundIfList != null) {
                int size = outboundIfList.size();
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("getIndexOfIface: searching for uri:" + uri + " list size:" + size);
                }
                for (int i = 0; i < size; ++i) {
                    SipURI current = outboundIfList.get(i);
                    if (!current.equals(uri)) continue;
                    result = i;
                    break;
                }
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("getIndexOfIface: outboundIfList is null");
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getIndexOfIface", result);
        }
        return result;
    }

    public synchronized int getIndexOfIface(SipURL uri) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "getIndexOfIface", (Object)uri);
        }
        int result = -1;
        List<SipURI> outboundIfList = null;
        if (uri.getTransport().equalsIgnoreCase("udp")) {
            outboundIfList = this.m_udpOutboundIfList;
        } else if (uri.getTransport().equalsIgnoreCase("tcp")) {
            outboundIfList = this.m_tcpOutboundIfList;
        } else if (uri.getTransport().equalsIgnoreCase("tls")) {
            outboundIfList = this.m_tlsOutboundIfList;
        }
        if (outboundIfList != null) {
            int size = outboundIfList.size();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("getIndexOfIface: searching for uri:" + uri + " list size:" + size);
            }
            String host = uri.getHost();
            int port = uri.getPort();
            for (int i = 0; i < size; ++i) {
                SipURI current = outboundIfList.get(i);
                if (!current.getHost().equals(host) || current.getPort() != port) continue;
                result = i;
                break;
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("getIndexOfIface: outboundIfList is null");
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getIndexOfIface", result);
        }
        return result;
    }

    public synchronized void addPreferedOutboundHeader(SipServletRequest request, int indexOfInterface) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("addPreferedOutboundHeader: indexOfInterface = " + indexOfInterface);
        }
        if (indexOfInterface >= 0) {
            request.setHeader(PEREFERED_OUTBOUND_HDR_NAME, Integer.toString(indexOfInterface));
        }
    }

    public synchronized void resetList() {
        if (this.m_udpOutboundIfList != null) {
            this.m_udpOutboundIfList.clear();
        }
        if (this.m_tcpOutboundIfList != null) {
            this.m_tcpOutboundIfList.clear();
        }
        if (this.m_tlsOutboundIfList != null) {
            this.m_tlsOutboundIfList.clear();
        }
        this.m_udpDefault = null;
        this.m_tcpDefault = null;
        this.m_tlsDefault = null;
    }

    private void setNewDefaultInterfaces(SipURI newUri) {
        String currentTransport;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "setNewDefaultInterfaces");
        }
        if ((currentTransport = newUri.getTransportParam()).equalsIgnoreCase("tcp")) {
            this.m_tcpDefault = newUri;
            return;
        }
        if (currentTransport.equalsIgnoreCase("tls")) {
            this.m_tlsDefault = newUri;
            return;
        }
        if (currentTransport.equalsIgnoreCase("udp")) {
            this.m_udpDefault = newUri;
            return;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "setNewDefaultInterfaces");
        }
    }

    private void buildFullOutboundIfList(List<SipURI> udpOutboundIfList, List<SipURI> tcpOutboundIfList, List<SipURI> tlsOutboundIfList) {
        LinkedList<SipAppDesc> apps;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "buildFullOutboundIfList", Arrays.toString(udpOutboundIfList.toArray()), Arrays.toString(tcpOutboundIfList.toArray()), Arrays.toString(tlsOutboundIfList.toArray()));
        }
        this.m_fullOutboundIfList = new ArrayList<SipURI>();
        if (udpOutboundIfList != null) {
            this.m_fullOutboundIfList.addAll(udpOutboundIfList);
        }
        if (tcpOutboundIfList != null) {
            this.m_fullOutboundIfList.addAll(tcpOutboundIfList);
        }
        if (tlsOutboundIfList != null) {
            this.m_fullOutboundIfList.addAll(tlsOutboundIfList);
        }
        if ((apps = SipContainer.getInstance().getRouter().getAllApps()) != null) {
            for (SipAppDesc app : apps) {
                app.getServletContext().setAttribute("javax.servlet.sip.outboundInterfaces", this.m_fullOutboundIfList);
            }
        }
        Iterator<SipURI> itr = this.m_fullOutboundIfList.iterator();
        while (itr.hasNext()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("buildFullOutboundIfList: removing SIP connector interfaces, if any exists");
            }
            SipURI uri = itr.next();
            try {
                if (!SipVirtualHostAdapter.isSipUriAConnectorInterface(uri)) continue;
                itr.remove();
            }
            catch (UnknownHostException e2) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug((Object)null, "buildFullOutboundIfList", "e.getLocalizedMessage()=" + e2.getLocalizedMessage() + ", uri=" + uri);
                }
                FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sip.container.proxy.SipVirtualHostAdapter", (String)"1", (Object)this);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "buildFullOutboundIfList", Arrays.toString(this.m_fullOutboundIfList.toArray()));
        }
    }

    public synchronized SipURI extractReceivedOnInterface(SipServletRequest req) {
        SipServletMessageImpl msgImpl;
        SipProvider provider;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "extractReceivedOnInterface", (Object)req);
        }
        List<SipURI> outboundIfList = null;
        SipURI returnValue = null;
        if (req == null) {
            return null;
        }
        SipURI defaultInterface = null;
        String transport = req.getTransport();
        String host = req.getLocalAddr();
        boolean standalone = true;
        if (standalone && (provider = (msgImpl = (SipServletMessageImpl)((Object)req)).getSipProvider()) != null) {
            ListeningPoint listeningPoint = provider.getListeningPoint();
            host = listeningPoint.getSentBy();
        }
        if (transport != null) {
            if (transport.equalsIgnoreCase("tcp")) {
                outboundIfList = this.m_tcpOutboundIfList;
                defaultInterface = this.m_tcpDefault;
            } else if (transport.equalsIgnoreCase("udp")) {
                outboundIfList = this.m_udpOutboundIfList;
                defaultInterface = this.m_udpDefault;
            } else if (transport.equalsIgnoreCase("tls")) {
                outboundIfList = this.m_tlsOutboundIfList;
                defaultInterface = this.m_tlsDefault;
            }
            if (outboundIfList != null) {
                Iterator<SipURI> iterator = outboundIfList.iterator();
                String hostAddress = SIPStackUtil.getHostAddress(host);
                while (iterator.hasNext()) {
                    SipURI interfaceURI = iterator.next();
                    String ifaceHost = interfaceURI.getHost();
                    String ifaceHostAddress = SIPStackUtil.getHostAddress(ifaceHost);
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("extractReceivedOnInterface: comparing <" + ifaceHostAddress + "> to <" + hostAddress + ">, host = " + host);
                    }
                    if (!ifaceHostAddress.equalsIgnoreCase(hostAddress) || interfaceURI.getPort() != req.getLocalPort()) continue;
                    returnValue = interfaceURI;
                    break;
                }
            }
            if (returnValue == null) {
                returnValue = defaultInterface;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("extractReceivedOnInterface: Returning default value since received on interface was NOT found for: " + req.toString());
                }
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("extractReceivedOnInterface: Transport is null. Can't extract interface for: " + req.toString());
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "extractReceivedOnInterface", returnValue);
        }
        return returnValue;
    }
}

