/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.resolver;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sip.resolver.DomainResolver;
import com.ibm.websphere.sip.resolver.DomainResolverListener;
import com.ibm.websphere.sip.resolver.exception.SipURIResolveException;
import com.ibm.ws.sip.channel.resolver.impl.SipResolverService;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.resolver.SipURILookupCallbackImpl;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;
import com.ibm.ws.sip.properties.SipPropertiesMap;
import com.ibm.ws.sip.stack.internalapi.NaptrRequestListener;
import com.ibm.ws.sip.stack.internalapi.SipStackDomainResolver;
import com.ibm.wsspi.sip.channel.resolver.SIPUri;
import com.ibm.wsspi.sip.channel.resolver.SipURILookup;
import com.ibm.wsspi.sip.channel.resolver.SipURILookupException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={DomainResolverImpl.class}, configurationPolicy=ConfigurationPolicy.OPTIONAL, configurationPid={"com.ibm.ws.sip.container.resolver.DomainResolverImpl"}, name="com.ibm.ws.sip.container.resolver.DomainResolverImpl", property={"service.vendor=IBM"})
public class DomainResolverImpl
implements DomainResolver,
SipStackDomainResolver {
    private static final TraceComponent tc = Tr.register(DomainResolverImpl.class);
    private static final LogMgr c_logger = Log.get(DomainResolverImpl.class);
    private boolean _initialized = false;
    private boolean _naptrAutoResolve = false;
    private CHFWBundle m_chfw;

    protected void activate(Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"DomainResolverImpl activated", (Object[])new Object[]{properties});
        }
        PropertiesStore.getInstance().getProperties().updateProperties(properties);
        this.init();
    }

    protected void unsetChfwBundle(CHFWBundle bundle) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"unsetChfwBundle", (Object[])new Object[0]);
        }
        this.m_chfw = null;
    }

    @Reference(policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)
    protected void setChfwBundle(CHFWBundle bundle) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"setChfwBundle", (Object[])new Object[0]);
        }
        this.m_chfw = bundle;
    }

    @Modified
    public void modified(ComponentContext context, Map<String, Object> properties) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"DomainResolverImpl modified", (Object[])new Object[]{properties});
        }
    }

    public void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DomainResolverImpl deactivated, reason=" + reason), (Object[])new Object[0]);
        }
    }

    private void init() {
        SipPropertiesMap sipProp = PropertiesStore.getInstance().getProperties();
        String[] dnsServersArray = (String[])sipProp.getObject("dnsServers");
        String dnsServers = "";
        for (String s : dnsServersArray) {
            dnsServers = dnsServers.concat(s);
            dnsServers = dnsServers.concat(" ");
        }
        if (dnsServers != null && !dnsServers.isEmpty()) {
            int singleQueryTimeout;
            int cacheTimeout;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "DomainResolverImpl", "DNS found: " + dnsServers);
            }
            if ((cacheTimeout = sipProp.getDuration("dnsRequestCacheTimeoutMin")) < 10) {
                cacheTimeout = 10;
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "DomainResolverImpl", "DNS Cache timeout: " + cacheTimeout);
            }
            if ((singleQueryTimeout = sipProp.getDuration("dnsSingleQueryTimeoutSec")) == -1) {
                singleQueryTimeout = 5;
            }
            int allowedFailures = sipProp.getInt("dnsAllowedFailures");
            int windowSize = sipProp.getInt("dnsWindowSizeMin");
            int interval = sipProp.getInt("dnsWindowSizeInterval");
            boolean addTTL = sipProp.getBoolean("addTtl");
            long queryTimeoutDuration = sipProp.getLong("SIP_DNS_QUERY_TIMEOUT");
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "DomainResolverImpl", "DNS Failover parameters. single query timeout " + singleQueryTimeout + " allowed failures: " + allowedFailures + " window size: " + windowSize + " interval: " + interval);
            }
            Properties dsProps = new Properties();
            dsProps.put("dnsServers", dnsServers);
            dsProps.put("dnsEdns", sipProp.getString("dnsEdns", true));
            dsProps.put("dnsUdpPayloadSize", (Object)sipProp.getShort("dnsUdpPayloadSize"));
            dsProps.put("dnsRequestCacheTimeoutMin", (Object)cacheTimeout);
            dsProps.put("dnsSingleQueryTimeoutSec", (Object)singleQueryTimeout);
            dsProps.put("dnsAllowedFailures", (Object)allowedFailures);
            dsProps.put("dnsWindowSizeMin", (Object)windowSize);
            dsProps.put("dnsWindowSizeInterval", (Object)interval);
            dsProps.put("addTtl", (Object)addTTL);
            dsProps.put("SIP_DNS_QUERY_TIMEOUT", (Object)queryTimeoutDuration);
            SipResolverService.initialize(dsProps, this.m_chfw);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "DomainResolverImpl", "SipResolverService initialized.");
            }
            this._naptrAutoResolve = sipProp.getBoolean("dnsAutoResolve");
            this._initialized = true;
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "DomainResolverImpl", "SipResolverService not initialized.");
        }
    }

    @Override
    public List<SipURI> locate(SipURI sipUri) throws SipURIResolveException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "locate", (Object)sipUri);
        }
        if (!this._initialized) {
            throw new SipURIResolveException("Resolver service not initialized.");
        }
        SipURILookupCallbackImpl callback = ThreadLocalStorage.getURILookupCallback();
        SIPUri sipUrlToSend = this.convertURI(sipUri);
        boolean fix = this.fixNonStandardURI(sipUrlToSend);
        callback.init(sipUri, fix);
        List<SipURI> results = null;
        try {
            this.lookupDestination(sipUrlToSend, callback);
            callback.waitForResults();
            if (!callback.isErrorResponse()) {
                results = callback.getResults();
                if (c_logger.isTraceDebugEnabled()) {
                    int num = results != null ? results.size() : 0;
                    c_logger.traceDebug(this, "locate", "Retrieved " + num + " results.");
                }
            } else {
                throw new SipURIResolveException("Failed to retrieve DNS result");
            }
            List<SipURI> num = results;
            return num;
        }
        catch (InterruptedException e2) {
            throw new SipURIResolveException("Failed to retrieve DNS result", e2);
        }
        catch (IllegalArgumentException e3) {
            throw new SipURIResolveException("Failed to retrieve DNS result", e3);
        }
        finally {
            callback.reset();
        }
    }

    @Override
    public void locate(SipURI sipUri, DomainResolverListener drListener, SipSession sipSession) throws SipURIResolveException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "locate", sipUri, drListener, sipSession);
        }
        if (!this._initialized) {
            throw new SipURIResolveException("Resolver service not initialized.");
        }
        SIPUri sipUrlToSend = this.convertURI(sipUri);
        boolean fix = this.fixNonStandardURI(sipUrlToSend);
        SipURILookupCallbackImpl callback = new SipURILookupCallbackImpl(sipUri, fix, drListener, sipSession);
        try {
            this.lookupDestination(sipUrlToSend, callback);
        }
        catch (IllegalArgumentException e2) {
            throw new SipURIResolveException("Failed to retrieve DNS result", e2);
        }
    }

    private final SIPUri convertURI(SipURI sipUrlToSend) {
        SIPUri suri = SIPUri.createSIPUri(sipUrlToSend.toString());
        suri.setHost(sipUrlToSend.getHost());
        suri.setScheme(sipUrlToSend.getScheme());
        suri.setPortInt(sipUrlToSend.getPort());
        suri.setTransport(sipUrlToSend.getTransportParam());
        return suri;
    }

    private void lookupDestination(SIPUri sipUri, SipURILookupCallbackImpl callback) throws SipURIResolveException {
        SipURILookup request = SipResolverService.getInstance(callback, sipUri);
        try {
            if (request.lookup()) {
                ArrayList<SIPUri> response = request.getAnswer();
                if (response == null || response.size() < 1) {
                    throw new SipURIResolveException("Failed to retrieve DNS result");
                }
                callback.complete(request, true);
            }
        }
        catch (SipURILookupException e2) {
            throw new SipURIResolveException("Failed to retrieve DNS result", e2);
        }
    }

    @Override
    public void lookupDestination(SIPUri suri, NaptrRequestListener listener) {
        if (!this._naptrAutoResolve) {
            listener.error(new SipURIResolveException("Resolver service not initialized."));
            return;
        }
        boolean fix = this.fixNonStandardURI(suri);
        SipURILookupCallbackImpl callback = new SipURILookupCallbackImpl(listener, fix);
        SipURILookup request = SipResolverService.getInstance(callback, suri);
        if (c_logger.isTraceDebugEnabled()) {
            StringBuilder buff = new StringBuilder();
            buff.append(" Requested Uri = <").append(suri.toString()).append(">").append(" NaptrRequestListener = <").append(listener).append(">").append(" SipURILookup object = <").append(request.getSipURI().toString()).append(">");
            c_logger.traceDebug(this, "lookupDestination", buff.toString());
        }
        try {
            if (request.lookup()) {
                ArrayList<SIPUri> response = request.getAnswer();
                if (response == null || response.size() < 1) {
                    callback.error(request, new SipURILookupException());
                } else {
                    callback.complete(request);
                }
            }
        }
        catch (SipURILookupException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "lookupDestination", "SipURILookupException when lookup = " + e2.getMessage());
            }
            callback.error(request, e2);
        }
    }

    private boolean fixNonStandardURI(SIPUri suri) {
        boolean corrected = false;
        if ("sip".equalsIgnoreCase(suri.getScheme()) && "tls".equalsIgnoreCase(suri.getTransport())) {
            corrected = true;
            suri.setScheme("sips");
            suri.setTransport("tcp");
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "fixMalformedURI", "correcting target to [" + suri + ']');
            }
        } else if ("tls".equalsIgnoreCase(suri.getTransport())) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "fixMalformedURI", "Modifying transport to TCP.");
            }
            suri.setTransport("tcp");
        }
        return corrected;
    }

    public boolean isNaptrAutoResolveEnabled() {
        return this._naptrAutoResolve;
    }
}

