/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.servlets.ParameterableImpl;
import com.ibm.ws.sip.container.servlets.SipURIImpl;
import com.ibm.ws.sip.container.servlets.TelURLImpl;
import com.ibm.ws.sip.container.servlets.URIImpl;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.address.URI;
import jain.protocol.ip.sip.header.ContactHeader;
import jain.protocol.ip.sip.header.NameAddressHeader;
import javax.servlet.sip.Address;

public class AddressImpl
extends ParameterableImpl
implements Address {
    private static final long serialVersionUID = -205267488174013471L;
    private static final LogMgr c_logger = Log.get(AddressImpl.class);
    private static final String Q = "q";
    public static final String TAG = "tag";
    private static final String EXPIRES = "expires";

    protected AddressImpl(NameAddressHeader nameAddressHeader) {
        super(nameAddressHeader);
    }

    public Object clone(boolean isProtectedInstance) {
        if (isProtectedInstance) {
            return super.clone();
        }
        AddressImpl cloned = new AddressImpl((NameAddressHeader)this._parametersHeader.clone());
        this.setURIcopy(cloned);
        return cloned;
    }

    @Override
    public Object clone() {
        return this.clone(false);
    }

    private void setURIcopy(AddressImpl cloned) {
        if (null != this._parametersHeader && !this.isWildcard()) {
            URIImpl rUri = null;
            URI jainUri = ((NameAddressHeader)this._parametersHeader).getNameAddress().getAddress();
            if (null != jainUri) {
                String scheme = jainUri.getScheme();
                rUri = SipURIImpl.isSchemeSupported(scheme) ? new SipURIImpl((SipURL)jainUri.clone()) : (TelURLImpl.isSchemeSupported(scheme) ? new TelURLImpl(jainUri) : new URIImpl((URI)jainUri.clone()));
            }
            if (rUri != null) {
                cloned.setURI(rUri);
            }
        }
    }

    @Override
    public String getDisplayName() {
        String displayName = null;
        if (null != this._parametersHeader) {
            displayName = ((NameAddressHeader)this._parametersHeader).getNameAddress().getDisplayName();
        }
        return displayName;
    }

    @Override
    public int getExpires() {
        int rc;
        block5: {
            rc = -1;
            String expires = this.getParameter(EXPIRES);
            if (null != expires) {
                try {
                    rc = Integer.parseInt(expires);
                    if (rc < 0) {
                        rc = 3600;
                        if (c_logger.isErrorEnabled()) {
                            Object[] args = new Object[]{expires};
                            c_logger.error("error.get.expires", "Request", args);
                        }
                    }
                }
                catch (NumberFormatException e2) {
                    rc = 3600;
                    if (!c_logger.isErrorEnabled()) break block5;
                    Object[] args = new Object[]{expires};
                    c_logger.error("error.get.expires", "Request", args, (Throwable)e2);
                }
            }
        }
        return rc;
    }

    @Override
    public float getQ() {
        float rValue = -1.0f;
        String value = this.getParameter(Q);
        if (null != value) {
            rValue = Float.parseFloat(value);
        }
        return rValue;
    }

    @Override
    public javax.servlet.sip.URI getURI() {
        URI jainUri;
        URIImpl rUri = null;
        if (null != this._parametersHeader && !this.isWildcard() && null != (jainUri = ((NameAddressHeader)this._parametersHeader).getNameAddress().getAddress())) {
            String scheme = jainUri.getScheme();
            rUri = SipURIImpl.isSchemeSupported(scheme) ? new SipURIImpl((SipURL)jainUri) : (TelURLImpl.isSchemeSupported(scheme) ? new TelURLImpl(jainUri) : new URIImpl(jainUri));
        }
        return rUri;
    }

    @Override
    public boolean isWildcard() {
        if (this._parametersHeader instanceof ContactHeader) {
            ContactHeader contact = (ContactHeader)this._parametersHeader;
            return contact.isWildCard();
        }
        return false;
    }

    @Override
    public void setDisplayName(String name) {
        block4: {
            try {
                ((NameAddressHeader)this._parametersHeader).getNameAddress().setDisplayName(name);
            }
            catch (IllegalArgumentException e2) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{name};
                    c_logger.error("error.set.display.name", "Request", args, (Throwable)e2);
                }
            }
            catch (SipParseException e3) {
                if (!c_logger.isErrorEnabled()) break block4;
                Object[] args = new Object[]{name};
                c_logger.error("error.set.display.name", "Request", args, (Throwable)e3);
            }
        }
    }

    @Override
    public void setExpires(int seconds) {
        if (seconds < 0) {
            this.removeParameter(EXPIRES);
        } else {
            this.setParameter(EXPIRES, Integer.toString(seconds));
        }
    }

    @Override
    public void setQ(float q) {
        if (q == -1.0f) {
            this.removeParameter(Q);
        } else if (q >= 0.0f && q <= 1.0f) {
            this.setParameter(Q, Float.toString(q));
        } else {
            throw new IllegalArgumentException("Illegal Q Value");
        }
    }

    @Override
    public void setURI(javax.servlet.sip.URI uri) {
        block2: {
            try {
                URI jainURI = ((URIImpl)uri).getJainURI();
                ((NameAddressHeader)this._parametersHeader).getNameAddress().setAddress(jainURI);
            }
            catch (IllegalArgumentException e2) {
                if (!c_logger.isErrorEnabled()) break block2;
                Object[] args = new Object[]{uri};
                c_logger.error("error.set.uri", "Request", args, (Throwable)e2);
            }
        }
    }

    public String getTag() {
        return this.getParameter(TAG);
    }

    public void setTag(String tagValue) {
        if (tagValue == null) {
            this.removeParameter(TAG);
        } else {
            this.setParameter(TAG, tagValue);
        }
    }

    public NameAddressHeader getNameAddressHeader() {
        return (NameAddressHeader)this._parametersHeader;
    }

    @Override
    public boolean equals(Object obj) {
        boolean rc = false;
        if (obj instanceof AddressImpl) {
            AddressImpl other = (AddressImpl)obj;
            SipURL urlObj = (SipURL)other.getNameAddressHeader().getNameAddress().getAddress();
            SipURL localURI = (SipURL)this.getNameAddressHeader().getNameAddress().getAddress();
            if (localURI.getPort() == urlObj.getPort() && (localURI.getUserName() != null && localURI.getUserName().equals(urlObj.getUserName()) || localURI.getUserName() == null && urlObj.getUserName() == null) && localURI.getHost().equalsIgnoreCase(urlObj.getHost()) && this.compareParameters(other)) {
                rc = true;
            }
        }
        return rc;
    }

    public void removeTag() {
        super.removeParameter(TAG);
    }
}

