/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.servlets.AddressImpl;
import com.ibm.ws.sip.container.servlets.IncomingSipServletRequest;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletRequest;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletResponse;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletsFactoryImpl;
import com.ibm.ws.sip.container.servlets.SipSessionImplementation;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.sip.Address;
import javax.servlet.sip.B2buaHelper;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.UAMode;

public class B2buaHelperImpl
implements B2buaHelper {
    private static B2buaHelperImpl _instance;
    private static Object _lock;
    private static final transient LogMgr c_logger;

    private B2buaHelperImpl() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(B2buaHelperImpl.class.getName(), "B2buaHelperImpl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static B2buaHelperImpl getInstance() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(B2buaHelperImpl.class.getName(), "getInstance");
        }
        if (_instance == null) {
            Object object = _lock;
            synchronized (object) {
                if (_instance == null) {
                    _instance = new B2buaHelperImpl();
                }
            }
        }
        return _instance;
    }

    @Override
    public SipServletRequest createRequest(SipServletRequest origRequest, boolean linked, Map<String, List<String>> headerMap) throws IllegalArgumentException, TooManyHopsException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{origRequest.getClass().getName() + "@" + Integer.toHexString(origRequest.hashCode()), linked, headerMap};
            c_logger.traceEntry((Object)B2buaHelperImpl.class.getName(), "createRequest", params);
        }
        this.verifyNotTooManyHops(origRequest);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createRequest", "passed validation, creating new request");
        }
        OutgoingSipServletRequest outRequest = this.createOutgoingRequest(origRequest);
        outRequest.getTransactionUser().setIsB2bua(true);
        if (linked) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createRequest", "linking newly created session with old one.");
            }
            this.linkSipSessions(origRequest.getSession(), outRequest.getSession());
            this.linkSipRequests((SipServletRequestImpl)origRequest, outRequest);
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createRequest", "NOT linking newly created session with old one.");
        }
        this.decrementMaxForwards(origRequest, outRequest);
        this.copyHeadersMap(headerMap, outRequest, true);
        this.copyBody(origRequest, outRequest);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)B2buaHelperImpl.class.getName(), "createRequest", outRequest);
        }
        return outRequest;
    }

    private void decrementMaxForwards(SipServletRequest origRequest, SipServletRequest outRequest) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(B2buaHelperImpl.class.getName(), "decrementMaxForwards");
        }
        outRequest.setMaxForwards(origRequest.getMaxForwards() - 1);
    }

    @Override
    public SipServletRequest createRequest(SipSession session, SipServletRequest origRequest, Map<String, List<String>> headerMap) throws IllegalArgumentException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{session, origRequest.getClass().getName() + "@" + Integer.toHexString(origRequest.hashCode()), headerMap};
            c_logger.traceEntry((Object)B2buaHelperImpl.class.getName(), "createRequest", params);
        }
        this.verifySameAppSession(session.getApplicationSession().getId(), origRequest.getSession().getApplicationSession().getId());
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createRequest", "passed validation, creating new request");
        }
        OutgoingSipServletRequest outRequest = (OutgoingSipServletRequest)session.createRequest(origRequest.getMethod());
        if (!this.isSessionsLinked(origRequest.getSession(), outRequest.getSession())) {
            this.linkSipSessions(origRequest.getSession(), outRequest.getSession());
        }
        this.linkSipRequests((SipServletRequestImpl)origRequest, outRequest);
        SipServletsFactoryImpl.getInstance().copyNonSystemHeaders(origRequest, outRequest);
        this.copyHeadersMap(headerMap, outRequest, false);
        this.copyBody(origRequest, outRequest);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)B2buaHelperImpl.class.getName(), "createRequest", outRequest);
        }
        return outRequest;
    }

    private boolean isRequestsLinked(SipServletRequestImpl req1, SipServletRequestImpl req2) {
        boolean isRequestsLinked = false;
        if (req1 != null && req2 != null && req1.getLinkedRequest() == req2) {
            isRequestsLinked = true;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)B2buaHelperImpl.class.getName(), "isRequestsLinked", isRequestsLinked);
        }
        return isRequestsLinked;
    }

    private boolean isSessionsLinked(SipSession sessionImpl1, SipSession sessionImpl2) {
        boolean isSessionsLinked = false;
        if (sessionImpl1 != null && sessionImpl2 != null) {
            SipSessionImplementation sess1 = (SipSessionImplementation)sessionImpl1;
            SipSessionImplementation sess2 = (SipSessionImplementation)sessionImpl2;
            if (sess1.getLinkedSession() == sess2) {
                isSessionsLinked = true;
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)B2buaHelperImpl.class.getName(), "isSessionsLinked", isSessionsLinked);
        }
        return isSessionsLinked;
    }

    @Override
    public SipServletResponse createResponseToOriginalRequest(SipSession session, int status, String reasonPhrase) throws IllegalStateException, IllegalArgumentException {
        TransactionUserWrapper derivedTU;
        SipServletRequestImpl origRequest;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{session, status, reasonPhrase};
            c_logger.traceEntry((Object)B2buaHelperImpl.class.getName(), "createResponseToOriginalRequest", params);
        }
        this.verifyValid(session);
        this.verifyOriginal(session);
        SipSessionImplementation origSession = (SipSessionImplementation)session;
        this.verifyConsistentResponse(origSession, status);
        TransactionUserWrapper tuToUseForUpdate = origSession.getTransactionUser();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceDebug(this, "createResponseToOriginalRequest", "B2BHelper have created DerivedSession and Application is responsible to link it to the correct UAC session");
        }
        if ((origRequest = (tuToUseForUpdate = (derivedTU = tuToUseForUpdate.createDerivedTU(null, "B2BuaHelperImpl - createResponse to original request"))).getSipMessage()) == null || !(origRequest instanceof IncomingSipServletRequest)) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createResponseToOriginalRequest", "ERROR, can't get the original request");
            }
            throw new NullPointerException("Can not retrieve the original request");
        }
        OutgoingSipServletResponse outResponse = ((IncomingSipServletRequest)origRequest).createResponseForCommitedRequest(status, reasonPhrase);
        return outResponse;
    }

    @Override
    public SipSession getLinkedSession(SipSession session) throws IllegalArgumentException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{session};
            c_logger.traceEntry((Object)B2buaHelperImpl.class.getName(), "getLinkedSession", params);
        }
        this.verifyValid(session);
        SipSessionImplementation linkedSession = ((SipSessionImplementation)session).getLinkedSession();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)B2buaHelperImpl.class.getName(), "getLinkedSession", linkedSession);
        }
        return linkedSession;
    }

    @Override
    public SipServletRequest getLinkedSipServletRequest(SipServletRequest req) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{req.getClass().getName() + "@" + Integer.toHexString(req.hashCode())};
            c_logger.traceEntry((Object)B2buaHelperImpl.class.getName(), "getLinkedSipServletRequest", params);
        }
        SipServletRequestImpl linkedReq = ((SipServletRequestImpl)req).getLinkedRequest();
        if (c_logger.isTraceEntryExitEnabled()) {
            if (linkedReq != null) {
                c_logger.traceExit((Object)B2buaHelperImpl.class.getName(), "getLinkedSipServletRequest", linkedReq.getClass().getName() + "@" + Integer.toHexString(linkedReq.hashCode()));
            } else {
                c_logger.traceExit((Object)B2buaHelperImpl.class.getName(), "getLinkedSipServletRequest", linkedReq);
            }
        }
        return linkedReq;
    }

    @Override
    public List<SipServletMessage> getPendingMessages(SipSession session, UAMode mode) throws IllegalArgumentException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{session, mode};
            c_logger.traceEntry((Object)B2buaHelperImpl.class.getName(), "getPendingMessages", params);
        }
        this.verifyValid(session);
        SipSessionImplementation sessionImpl = (SipSessionImplementation)session;
        List<SipServletMessage> messages = sessionImpl.getPendingMessages(mode);
        List clonedMessages = null;
        if (messages != null) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)B2buaHelperImpl.class.getName(), "getPendingMessages", "cloneing pending messages " + messages);
            }
            clonedMessages = (List)((LinkedList)messages).clone();
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)B2buaHelperImpl.class.getName(), "getPendingMessages", clonedMessages);
        }
        return clonedMessages;
    }

    @Override
    public void linkSipSessions(SipSession session1, SipSession session2) throws IllegalArgumentException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{session1, session2};
            c_logger.traceEntry((Object)B2buaHelperImpl.class.getName(), "linkSipSessions", params);
        }
        if (session1.getState() == SipSession.State.TERMINATED || session2.getState() == SipSession.State.TERMINATED) {
            throw new IllegalArgumentException("The session: " + session1 + " is terminated");
        }
        SipSessionImplementation sessionImpl1 = (SipSessionImplementation)session1;
        SipSessionImplementation sessionImpl2 = (SipSessionImplementation)session2;
        this.verifySameAppSession(sessionImpl1.getApplicationSessionId(), sessionImpl2.getApplicationSessionId());
        this.verifyNotTerminated(sessionImpl1, sessionImpl2);
        this.verifyNotAlreadyLinked(sessionImpl1, sessionImpl2);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "linkSipSessions", "linking the 2 sessions");
        }
        sessionImpl1.linkSipSession(sessionImpl2);
        sessionImpl2.linkSipSession(sessionImpl1);
        this.linkSipRequests((SipServletRequestImpl)sessionImpl1.getTransactionUser().getSipServletRequest(), (SipServletRequestImpl)sessionImpl2.getTransactionUser().getSipServletRequest());
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(B2buaHelperImpl.class.getName(), "linkSipSessions");
        }
    }

    private void linkSipRequests(SipServletRequestImpl req1, SipServletRequestImpl req2) {
        if (req1 == null || req2 == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("linkSipRequest for a null request invoked");
            }
            return;
        }
        if (this.isRequestsLinked(req1, req2)) {
            return;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{req1.getClass().getName() + "@" + Integer.toHexString(req1.hashCode()), req2.getClass().getName() + "@" + Integer.toHexString(req2.hashCode())};
            c_logger.traceEntry((Object)B2buaHelperImpl.class.getName(), "linkSipRequests", params);
        }
        req1.linkSipRequest(req2);
        req2.linkSipRequest(req1);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(B2buaHelperImpl.class.getName(), "linkSipRequests");
        }
    }

    private void unlinkSipRequest(SipServletRequestImpl req) {
        if (req == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("unlinkSipRequest for a null request invoked");
            }
            return;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{req.getClass().getName() + "@" + Integer.toHexString(req.hashCode())};
            c_logger.traceEntry((Object)B2buaHelperImpl.class.getName(), "unlinkSipRequests", params);
        }
        req.unLinkSipRequest();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(B2buaHelperImpl.class.getName(), "unlinkSipRequests");
        }
    }

    @Override
    public void unlinkSipSessions(SipSession session) throws IllegalArgumentException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{session};
            c_logger.traceEntry((Object)B2buaHelperImpl.class.getName(), "unlinkSipSessions", params);
        }
        if (session.getState() == SipSession.State.TERMINATED) {
            throw new IllegalArgumentException("The session: " + session + " is terminated");
        }
        SipSessionImplementation session1 = (SipSessionImplementation)session;
        SipSessionImplementation session2 = session1.getLinkedSession();
        if (session2 == null) {
            throw new IllegalArgumentException("The session: " + session1 + " is not currently linked to another session");
        }
        if (session2.isValid()) {
            session2.unlinkSipSession();
            if (!session2.getTransactionUser().isInvalidating()) {
                this.unlinkSipRequest((SipServletRequestImpl)session2.getTransactionUser().getSipServletRequest());
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "unlinkSipSession was not invoked for session: ", session2.getId());
        }
        session1.unlinkSipSession();
        this.unlinkSipRequest((SipServletRequestImpl)session1.getTransactionUser().getSipServletRequest());
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(B2buaHelperImpl.class.getName(), "unlinkSipSessions");
        }
    }

    private void copyHeadersMap(Map<String, List<String>> headerMap, OutgoingSipServletRequest outMsg, boolean isToFromAllowed) {
        if (headerMap == null) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : headerMap.entrySet()) {
            String headerName = entry.getKey();
            List<String> values = entry.getValue();
            if (!"Contact".equalsIgnoreCase(headerName)) {
                if (values == null || values.size() <= 0) continue;
                outMsg.addHeaderToFromAllowed(headerName, values, isToFromAllowed);
                continue;
            }
            String contact = values.get(0);
            try {
                AddressImpl addr = (AddressImpl)outMsg.getAddressHeader("Contact");
                Address receivedContact = SipServletsFactoryImpl.getInstance().createAddress(contact);
                addr.setURI(receivedContact.getURI());
            }
            catch (ServletParseException e2) {
                if (!c_logger.isTraceDebugEnabled()) continue;
                c_logger.traceDebug(this, "Error: B2buaHelperImpl copyHeadersMap could not create contact header ", e2.getMessage());
            }
        }
    }

    private void copyBody(SipServletMessage src, SipServletMessage dst) {
        block5: {
            if (src.getContentLength() > 0) {
                try {
                    dst.setContent(src.getContent(), src.getContentType());
                    return;
                }
                catch (UnsupportedEncodingException e2) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "B2buaHelperImpl copyBody got UnsupportedEncodingException: ", e2.getMessage());
                    }
                }
                catch (IOException e3) {
                    if (!c_logger.isTraceDebugEnabled()) break block5;
                    c_logger.traceDebug(this, "B2buaHelperImpl copyBody got IOException: ", e3.getMessage());
                }
            }
        }
    }

    private void verifyValid(SipSession session) throws IllegalArgumentException {
        if (!((SipSessionImplementation)session).isValid()) {
            throw new IllegalArgumentException("The session is invalid");
        }
    }

    private void verifyOriginal(SipSession session) throws IllegalArgumentException {
        TransactionUserWrapper tu = ((SipSessionImplementation)session).getTransactionUser();
        if (tu != null && tu.isDerived()) {
            throw new IllegalArgumentException("The passed session is not the original one");
        }
    }

    private void verifyNotTooManyHops(SipServletRequest origRequest) throws TooManyHopsException {
        if (origRequest.getMaxForwards() == 0) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "verifyNotTooManyHops", "loop detected");
            }
            throw new TooManyHopsException();
        }
    }

    private void verifySameAppSession(String id1, String id2) throws IllegalStateException {
        if (!id1.equals(id2)) {
            throw new IllegalStateException("The objects are not belong to the same SipApplicationSession");
        }
    }

    private void verifyConsistentResponse(SipSessionImplementation sessionImpl, int status) throws IllegalStateException {
        if (sessionImpl.isFailedResponseSent()) {
            throw new IllegalStateException("The subsequent response is inconsistent with an already sent response.");
        }
        if (sessionImpl.getState() == SipSession.State.CONFIRMED && status >= 300) {
            throw new IllegalStateException("The subsequent response is inconsistent with an already sent response. The session was already confirmed.");
        }
        TransactionUserWrapper tu = sessionImpl.getTransactionUser();
        if (tu.getSipMessage() == null) {
            throw new IllegalStateException("The subsequent response is inconsistent with an already sent response. ACK was already received.");
        }
    }

    private void verifyNotTerminated(SipSessionImplementation sessionImpl1, SipSessionImplementation sessionImpl2) throws IllegalArgumentException {
        if (sessionImpl1.isTerminated() || sessionImpl2.isTerminated()) {
            throw new IllegalArgumentException("The specified sessions\thas been terminated");
        }
    }

    private void verifyNotAlreadyLinked(SipSessionImplementation sessionImpl1, SipSessionImplementation sessionImpl2) throws IllegalArgumentException {
        SipSessionImplementation alreadyLinked1 = sessionImpl1.getLinkedSession();
        SipSessionImplementation alreadyLinked2 = sessionImpl2.getLinkedSession();
        if ((alreadyLinked1 != null || alreadyLinked2 != null) && alreadyLinked1 != alreadyLinked2) {
            throw new IllegalArgumentException("one or both the sessions are already linked with some other session(s) ");
        }
    }

    @Override
    public SipServletRequest createCancel(SipSession sipSession) throws NullPointerException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{sipSession};
            c_logger.traceEntry((Object)null, "createCancel", params);
        }
        if (sipSession == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createCancel", "null session was passed in.  Throwing NullPointerException");
            }
            throw new NullPointerException("SipSession is null");
        }
        SipSessionImplementation session = (SipSessionImplementation)sipSession;
        SipServletRequest request = (SipServletRequest)session.getTransactionUser().getSipServletRequest();
        SipServletRequest cancel = request.createCancel();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(null, "createCancel");
        }
        return cancel;
    }

    @Override
    public SipServletRequest createRequest(SipServletRequest origRequest) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{origRequest};
            c_logger.traceEntry((Object)null, "createRequest", params);
        }
        OutgoingSipServletRequest req = this.createOutgoingRequest(origRequest);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)B2buaHelperImpl.class.getName(), "createRequest", req);
        }
        return req;
    }

    private OutgoingSipServletRequest createOutgoingRequest(SipServletRequest origRequest) {
        boolean useInboundCallID = PropertiesStore.getInstance().getProperties().getBoolean("b2bUuseInCallidForOutRequest");
        SipServletsFactoryImpl factory = SipServletsFactoryImpl.getInstance();
        OutgoingSipServletRequest req = (OutgoingSipServletRequest)factory.createRequest(origRequest, useInboundCallID);
        return req;
    }

    static {
        _lock = new Object();
        c_logger = Log.get(B2buaHelperImpl.class);
    }
}

