/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.sessions;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.failover.repository.SessionRepository;
import com.ibm.ws.sip.container.proxy.RecordRouteProxy;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.tu.TUKey;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.util.SipUtil;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.ParametersHeader;
import jain.protocol.ip.sip.header.RouteHeader;
import jain.protocol.ip.sip.header.ViaHeader;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;
import java.util.List;

public class SipTransactionUserTable {
    private static final LogMgr c_logger = Log.get(SipTransactionUserTable.class);
    private static SipTransactionUserTable c_sipTransactionUserTable = new SipTransactionUserTable();

    private SipTransactionUserTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TransactionUserWrapper getTransactionUserForInboundRequest(SipServletRequestImpl request) {
        String sessionId;
        TransactionUserWrapper transactionUser;
        block23: {
            TUKey key;
            block22: {
                Object savedTag2;
                block21: {
                    transactionUser = null;
                    if (c_logger.isTraceEntryExitEnabled()) {
                        c_logger.traceEntry((Object)this, "getTransactionUserForInboundRequest", (Object)request);
                    }
                    try {
                        sessionId = SipTransactionUserTable.geTransactionnUserIdAccordingToRoute(request);
                        key = ThreadLocalStorage.getTUKey();
                        if (sessionId != null) {
                            key.setParams(request, sessionId, SipServletMessageImpl.MessageType.INCOMING_REQUEST);
                        } else {
                            key.setParams(request, SipServletMessageImpl.MessageType.INCOMING_REQUEST);
                        }
                        transactionUser = SessionRepository.getInstance().getTuWrapper(key);
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "getTransactionUserForInboundRequest", "Request received=" + request.getMethod() + ", sessionId=" + sessionId + ", TransactionUser=" + transactionUser);
                        }
                        if (transactionUser == null) break block21;
                        TransactionUserWrapper transactionUserWrapper = transactionUser;
                        if (c_logger.isTraceEntryExitEnabled()) {
                            c_logger.traceExit((Object)this, "getTransactionUserForInboundRequest", transactionUser);
                        }
                        return transactionUserWrapper;
                    }
                    catch (Throwable throwable) {
                        if (c_logger.isTraceEntryExitEnabled()) {
                            c_logger.traceExit((Object)this, "getTransactionUserForInboundRequest", transactionUser);
                        }
                        throw throwable;
                    }
                }
                if (request.getMethod().equals("UPDATE") || request.getMethod().equals("ACK")) {
                    savedTag2 = key.get_tag_2();
                    key.setTag_2(null);
                    transactionUser = SessionRepository.getInstance().getTuWrapper(key);
                    key.setTag_2((String)savedTag2);
                }
                if (transactionUser == null) break block22;
                savedTag2 = transactionUser;
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceExit((Object)this, "getTransactionUserForInboundRequest", transactionUser);
                }
                return savedTag2;
            }
            Object tag_2 = null;
            if (!request.getMethod().equals("NOTIFY")) break block23;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getTransactionUserForInboundRequest", "Trying to find TU without RemoteTag");
            }
            key.setTag_2(null);
            transactionUser = SessionRepository.getInstance().getTuWrapper(key);
            if (transactionUser == null) break block23;
            TransactionUserWrapper transactionUserWrapper = transactionUser;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)this, "getTransactionUserForInboundRequest", transactionUser);
            }
            return transactionUserWrapper;
        }
        if (sessionId == null) {
            sessionId = this.getTransactionUserdIDFrom_ToTag(request);
        }
        if (sessionId != null && (!SipUtil.hasBothTags(request.getRequest()) || request.getMethod().equals("NOTIFY"))) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getTransactionUserForInboundRequest", "Trying to find TU by session ID = " + sessionId + " for method = " + request.getMethod());
            }
            transactionUser = SessionRepository.getInstance().getTuWrapper(sessionId);
        }
        if (transactionUser != null) {
            TransactionUserWrapper transactionUserWrapper = transactionUser;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)this, "getTransactionUserForInboundRequest", transactionUser);
            }
            return transactionUserWrapper;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getTransactionUserForInboundRequest", transactionUser);
        }
        return transactionUser;
    }

    public final TransactionUserWrapper getTransactionUserForOutboundRequest(SipServletRequestImpl request) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "getTransactionUserForOutboundRequest", (Object)request.getMethod());
        }
        TransactionUserWrapper transactionUser = null;
        String sessionId = SipTransactionUserTable.geTransactionnUserIdAccordingToRoute(request);
        TUKey key = ThreadLocalStorage.getTUKey();
        if (sessionId != null) {
            key.setParams(request, sessionId, SipServletMessageImpl.MessageType.OUTGOING_REQUEST);
        }
        if (null == sessionId) {
            RouteHeader topRoute = RecordRouteProxy.getTopRoute(request);
            if (topRoute == null) {
                key.setParams(request, SipServletMessageImpl.MessageType.OUTGOING_REQUEST);
            } else {
                key = null;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getTransactionUserForOutboundRequest", "Patch is working! - do not look for loopback");
                }
            }
        }
        if (key != null) {
            transactionUser = SessionRepository.getInstance().getTuWrapper(key);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getTransactionUserForOutboundRequest", "Request received=" + request.getMethod() + ", sessionId=" + sessionId + ", TransactionUser=" + transactionUser);
            }
            if (transactionUser == null && request.getMethod().equals("NOTIFY")) {
                String tag2 = key.get_tag_2();
                key.setTag_2(null);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getTransactionUserForOutboundRequest", "looking up TU by key " + key);
                }
                transactionUser = SessionRepository.getInstance().getTuWrapper(key);
                key.setTag_2(tag2);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getTransactionUserForOutboundRequest", transactionUser);
        }
        return transactionUser;
    }

    private String getTransactionUserdIDFrom_ToTag(SipServletRequestImpl request) {
        String id = null;
        Request req = request.getRequest();
        String tag = req.getToHeader().getTag();
        id = this.extractTransactionUserIDByTag(tag);
        return id;
    }

    private String extractTransactionUserIDByTag(String tag) {
        String id = null;
        if (tag != null) {
            for (int i = 0; i < tag.length(); ++i) {
                if (tag.charAt(i) != '_') continue;
                id = tag.substring(i + 1);
                if (!c_logger.isTraceDebugEnabled()) break;
                c_logger.traceDebug(this, "extractSessionIdFromTag", "Id" + id);
                break;
            }
        }
        return id;
    }

    private static final String geTransactionnUserIdAccordingToRoute(SipServletRequestImpl request) {
        RouteHeader topRoute;
        String transactionUserId = null;
        transactionUserId = SipTransactionUserTable.geTransactionnUserIdAccordingToUri(request);
        if (null == transactionUserId && (topRoute = RecordRouteProxy.getTopRoute(request)) != null) {
            transactionUserId = RecordRouteProxy.getSessionIdParamFromRoute(topRoute);
        }
        return transactionUserId;
    }

    private static final String geTransactionnUserIdAccordingToUri(SipServletRequestImpl request) {
        String transactionUserId = null;
        Request jainReq = request.getRequest();
        try {
            transactionUserId = RecordRouteProxy.getSessionIdParamFromURI(jainReq.getRequestURI());
        }
        catch (SipParseException e2) {
            SipTransactionUserTable.logException(e2);
        }
        return transactionUserId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TransactionUserWrapper geTUFromJoinReplace(ParametersHeader val) {
        TUKey key;
        TransactionUserWrapper transactionUser;
        block8: {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)this, "geTUFromJoinReplace", (Object)val);
            }
            transactionUser = null;
            try {
                key = new TUKey();
                if (val.getValue() != null) break block8;
                TransactionUserWrapper transactionUserWrapper = null;
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceExit((Object)this, "geTUFromJoinReplace", transactionUser);
                }
                return transactionUserWrapper;
            }
            catch (Throwable throwable) {
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceExit((Object)this, "geTUFromJoinReplace", transactionUser);
                }
                throw throwable;
            }
        }
        int firstSemicolon = val.getValue().indexOf(59);
        String callId = val.getValue().substring(0, firstSemicolon);
        key.setup(val.getParameter("to-Tag"), val.getParameter("from-Tag"), callId, false);
        transactionUser = SessionRepository.getInstance().getTuWrapper(key);
        if (transactionUser == null) {
            key.setup(val.getParameter("from-Tag"), val.getParameter("to-Tag"), callId, false);
            transactionUser = SessionRepository.getInstance().getTuWrapper(key);
        }
        TransactionUserWrapper transactionUserWrapper = transactionUser;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "geTUFromJoinReplace", transactionUser);
        }
        return transactionUserWrapper;
    }

    public final TransactionUserWrapper getTuAccordingToUri(SipServletRequestImpl request) {
        String sessionId = SipTransactionUserTable.geTransactionnUserIdAccordingToUri(request);
        TransactionUserWrapper tu = null;
        if (sessionId != null) {
            tu = SessionRepository.getInstance().getTuWrapper(sessionId);
        }
        return tu;
    }

    public TransactionUserWrapper getTransactionUserInboundResponse(Response response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            try {
                c_logger.traceEntry((Object)this, "getTransactionUserInboundResponse", (Object)("response=" + response.getStatusCode() + response.getReasonPhrase()));
            }
            catch (SipParseException e2) {
                c_logger.error(null, "getTransactionUserInboundResponse", e2);
            }
        }
        TransactionUserWrapper transactionUser = null;
        String sessionId = null;
        TUKey key = ThreadLocalStorage.getTUKey();
        sessionId = this.getTransactionUserIdAccordingToTopVia(response);
        key.setParams(response, sessionId, true);
        transactionUser = SessionRepository.getInstance().getTuWrapper(key);
        if (transactionUser == null) {
            key.setParams(response, response.getCallIdHeader().getCallId(), false);
            transactionUser = SessionRepository.getInstance().getTuWrapper(key);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getTransactionUserInboundResponse", "Getting Session For Id: " + sessionId + " TransactionUser = " + transactionUser);
        }
        return transactionUser;
    }

    public TransactionUserWrapper getBaseTUForDerived(Response response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            try {
                c_logger.traceEntry((Object)this, "getBaseTUForDerived", (Object)("response=" + response.getStatusCode() + response.getReasonPhrase()));
            }
            catch (SipParseException e2) {
                c_logger.error(null, "getBaseTUForDerived", e2);
            }
        }
        TransactionUserWrapper transactionUser = null;
        String sessionId = null;
        sessionId = this.getTransactionUserIdAccordingToTopVia(response);
        if (sessionId != null) {
            transactionUser = SessionRepository.getInstance().getTuWrapper(sessionId);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getBaseTUForDerived", "Getting Session For Id: " + sessionId + " TransactionUser = " + transactionUser);
        }
        return transactionUser;
    }

    public String getTransactionUserIdAccordingToTopVia(Response response) {
        String sid = null;
        if (c_logger.isTraceEntryExitEnabled()) {
            try {
                c_logger.traceEntry((Object)this, "getTransactionUserIdAccordingToTopVia", (Object)("response=" + response.getStatusCode() + response.getReasonPhrase()));
            }
            catch (SipParseException e2) {
                c_logger.error(null, "getTransactionUserIdAccordingToTopVia", e2);
            }
        }
        try {
            ViaHeader topVia = (ViaHeader)response.getHeader("Via", true);
            if (topVia != null) {
                sid = topVia.getParameter("ibmsid");
            }
        }
        catch (HeaderParseException e3) {
            SipTransactionUserTable.logException(e3);
        }
        catch (IllegalArgumentException e4) {
            SipTransactionUserTable.logException(e4);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getTransactionUserIdAccordingToTopVia", sid);
        }
        return sid;
    }

    public final TransactionUserWrapper createTransactionUserWrapper(SipServletRequestImpl request, boolean isServerTransaction, SipApplicationSessionImpl appSession, boolean pendingMessageExists) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{request.getMethod(), new Boolean(isServerTransaction), appSession};
            c_logger.traceEntry((Object)this, "createTransactionUserWrapper", params);
        }
        TransactionUserWrapper transactionUser = new TransactionUserWrapper(request, isServerTransaction, appSession, pendingMessageExists);
        transactionUser.setSubscriberUri(request.getSubscriberURI());
        transactionUser.setRegion(request.getRegion());
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "createTransactionUserWrapper", transactionUser);
        }
        return transactionUser;
    }

    public static final SipTransactionUserTable getInstance() {
        return c_sipTransactionUserTable;
    }

    public final void removeTransactionUserForOutgoingRequest(SipServletRequestImpl req) {
        TUKey key = ThreadLocalStorage.getTUKey();
        key.setParams(req, SipServletMessageImpl.MessageType.OUTGOING_REQUEST);
        SessionRepository.getInstance().removeTuWrapper(key, true);
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer b = new StringBuffer(64);
            b.append("Session removed from Sessions Table, id: ");
            b.append(" transactionUserId =");
            b.append(req.getTransactionUser().getId());
            c_logger.traceDebug(this, "removeTransactionUser", b.toString());
        }
    }

    protected static void logException(Exception e2) {
        if (c_logger.isErrorEnabled()) {
            c_logger.error("error.exception", "Create", null, (Throwable)e2);
        }
    }

    public void getSnapshotView(List list) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipTransactionUserTable.getSnapshotView");
        }
        List l = SessionRepository.getInstance().getAllTuWrappers();
        for (int i = 0; i < l.size(); ++i) {
            list.add(l.get(i));
        }
    }
}

