/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.timer;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.timer.BaseTimer;
import com.ibm.ws.sip.container.timer.BaseTimerService;
import com.ibm.ws.sip.container.timer.SipTimerTask;
import com.ibm.ws.sip.properties.SipPropertiesMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(service={BaseTimerService.class}, immediate=false, configurationPolicy=ConfigurationPolicy.OPTIONAL, property={"service.vendor=IBM"})
public class TimerServiceImpl
implements BaseTimerService {
    private static final LogMgr c_logger = Log.get(TimerServiceImpl.class);
    private static ScheduledExecutorService s_timerService;
    private boolean _enableTimers = true;

    @Activate
    protected void activate(Map<String, Object> properties) {
        SipPropertiesMap props = PropertiesStore.getInstance().getProperties();
        props.updateProperties(properties);
        this._enableTimers = props.getBoolean("enableTimers");
        if (!this._enableTimers && c_logger.isErrorEnabled()) {
            c_logger.error("warning.timer.unavailable", "Available", null);
        }
    }

    @Deactivate
    protected void deactivate(int reason) {
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        SipPropertiesMap props = PropertiesStore.getInstance().getProperties();
        props.updateProperties(properties);
        this._enableTimers = props.getBoolean("enableTimers");
    }

    @Override
    public void schedule(BaseTimer timer, boolean isPersistent, long delay, long period, boolean fixedDelay) {
        if (!this._enableTimers) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "schedule", "timer service is disabled");
            }
            return;
        }
        timer.initTimer(isPersistent, delay, period, fixedDelay);
        SipTimerTask task = timer.getTimerTask();
        if (fixedDelay) {
            task.setScheduledFuture(s_timerService.scheduleWithFixedDelay(task, delay, period, TimeUnit.MILLISECONDS));
        } else {
            task.setScheduledFuture(s_timerService.scheduleAtFixedRate(task, delay, period, TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public void schedule(BaseTimer timer, boolean isPersistent, long delay) {
        if (!this._enableTimers) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "schedule", "timer service is disabled");
            }
            return;
        }
        timer.initTimer(isPersistent, delay);
        SipTimerTask task = timer.getTimerTask();
        task.setScheduledFuture(s_timerService.schedule(timer.getTimerTask(), delay, TimeUnit.MILLISECONDS));
    }

    @Reference
    public void setTimerService(ScheduledExecutorService timerService) {
        s_timerService = timerService;
    }

    public static ScheduledExecutorService getTimerSerivce() {
        return s_timerService;
    }
}

