/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.tu;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.sip.IBMSipSession;
import com.ibm.ws.sip.container.failover.ReplicatableImpl;
import com.ibm.ws.sip.container.failover.repository.SessionRepository;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.servlets.SIPSessionFactory;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipSessionImplementation;
import com.ibm.ws.sip.container.servlets.SipSessionSeqLog;
import com.ibm.ws.sip.container.servlets.WASXSipApplicationSessionFactory;
import com.ibm.ws.sip.container.timer.TransactionUserTimerListener;
import com.ibm.ws.sip.container.tu.DialogState;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.util.wlm.DialogAux;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;

public class TransactionUserBase
extends ReplicatableImpl {
    private static final long serialVersionUID = 1L;
    private static final LogMgr c_logger = Log.get(TransactionUserBase.class);
    private transient SipServletDesc m_sipServletDesc;
    private static transient long c_nextAppSessionId = 1L;
    private long m_expires = 0L;
    private transient String m_applicationId;
    private transient SipSessionImplementation _sipSession = null;
    private static transient String serverIdentifier = "wlp";
    private transient TransactionUserTimerListener _tUserTimer = null;
    private transient TransactionUserWrapper _tuWrapper = null;
    private boolean _isInvalidated = false;
    private transient SipSessionSeqLog m_contextLog;
    private DialogState _dialogState = new DialogState();
    private Object _synchronizer;
    private Object _serviceSynchronizer;
    private boolean _canCreateDerivedSessions = false;
    private transient String _sessionKeyBase = null;
    private static Map<String, Counter> s_nextTransactionIdPerLogicalName = new HashMap<String, Counter>(5);
    private transient SipApplicationSession m_sipAppSession = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(TransactionUserWrapper tuWrapper, SipServletRequestImpl sipMessage, SipApplicationSessionImpl sipApp) {
        Object[] params;
        if (c_logger.isTraceEntryExitEnabled()) {
            if (sipMessage != null && sipApp != null) {
                params = new Object[]{tuWrapper, sipMessage.getMethod(), sipApp.getId()};
                c_logger.traceEntry((Object)this, "initialize", params);
            } else {
                c_logger.traceEntry(this, "initialize");
            }
        }
        this._tuWrapper = tuWrapper;
        if (sipApp != null) {
            params = sipApp.getSynchronizer();
            synchronized (params) {
                if (sipApp.isValid()) {
                    this.m_applicationId = sipApp.getSharedId();
                    this.setSynchronizer(sipApp.getSynchronizer());
                    this.setServiceSynchronizer(sipApp.getServiceSynchronizer());
                } else {
                    sipApp = null;
                }
            }
        }
        if (this._synchronizer == null) {
            this.setSynchronizer(new Object());
            this.setServiceSynchronizer(new Object());
        }
        this.createTUId(sipApp);
        if (SipSessionSeqLog.isEnabled()) {
            this.m_contextLog = SipSessionSeqLog.getInstance();
            this.m_contextLog.setId(this.getSharedId());
        }
        String method = sipMessage.getMethod();
        this._dialogState.reset();
        this._dialogState.setDialogState(method);
        if (this.isDialog() && (method.equals("INVITE") || method.equals("SUBSCRIBE"))) {
            this.setCanCreateDS(true);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "initialize", "New BaseTU was created. ID = " + this.getSharedId());
        }
        this.logToContext(257, this.getSharedId());
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "initialize");
        }
    }

    public void reinitilize() {
        this._synchronizer = new Object();
        this._serviceSynchronizer = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachToSipAppSession() {
        Object object = this.getSynchronizer();
        synchronized (object) {
            SipApplicationSessionImpl sipApp = (SipApplicationSessionImpl)this.getSipApplicationSession();
            if (sipApp != null && sipApp.isValid()) {
                sipApp.addTransctionUser(this._tuWrapper);
            }
        }
    }

    public void initialize(TransactionUserWrapper wrapper, TransactionUserWrapper originalTU) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{wrapper, originalTU};
            c_logger.traceEntry((Object)this, "initialize", params);
        }
        TransactionUserBase originalBaseTU = originalTU.getTuBase();
        this._tuWrapper = wrapper;
        this._synchronizer = originalBaseTU.getSynchronizer();
        this._serviceSynchronizer = originalBaseTU.getServiceSynchronizer();
        SipApplicationSessionImpl originalApp = (SipApplicationSessionImpl)originalTU.getApplicationSession(true);
        this.m_applicationId = originalApp.getSharedId();
        ((SipApplicationSessionImpl)this.getSipApplicationSession()).addTransctionUser(this._tuWrapper);
        this.createTUId(originalApp);
        if (SipSessionSeqLog.isEnabled()) {
            this.m_contextLog = SipSessionSeqLog.getInstance();
            this.m_contextLog.setId(this.getSharedId());
        }
        this._dialogState.reset();
        this._dialogState.setDialogState(originalTU.getInitialDialogMethod());
        this.setCanCreateDS(true);
        this.m_sipServletDesc = originalBaseTU.getSipServletDesc();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "initialize", "New BaseTU for Derived was created. ID = " + this.getSharedId());
        }
        this.logToContext(257, this.getSharedId());
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "initialize");
        }
    }

    boolean shouldInvokeInvalidateWhenReady() {
        boolean tryToInvalidateLater = false;
        SipApplicationSession as = null;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this.getAppName(), this.getSharedId()};
            c_logger.traceEntry((Object)this, "shouldInvokeInvalidateWhenReady", params);
        }
        if (this._sipSession != null) {
            if (this._sipSession.getInvalidateWhenReady()) {
                if (this._sipSession.isReadyToInvalidate()) {
                    tryToInvalidateLater = true;
                }
            } else if (this.m_applicationId != null && (as = this.getSipApplicationSession()) != null && as.getInvalidateWhenReady()) {
                tryToInvalidateLater = true;
            }
        } else if (this.getWrapper().isJSR289Application() && this.getWrapper().isReadyToInvalidate()) {
            tryToInvalidateLater = true;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "shouldInvokeInvalidateWhenReady", tryToInvalidateLater);
        }
        return tryToInvalidateLater;
    }

    private void invalidateProxyDerivedSessions() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "invalidateProxyDerivedSessions");
        }
        if (this.getWrapper().isProxingErrorResponse()) {
            Iterator<TransactionUserWrapper> iter = this.getWrapper().getBranch().getRelatedTUs();
            while (iter != null && iter.hasNext()) {
                TransactionUserWrapper tuw = iter.next();
                if (!tuw.isValid() || tuw.isInvalidating() || tuw.getId().equals(this.getWrapper().getId())) continue;
                SipSession session = tuw.getSipSession(false);
                if (session == null) {
                    tuw.invalidateTU(true, true);
                    if (!c_logger.isTraceDebugEnabled()) continue;
                    c_logger.traceDebug((Object)null, "invalidateProxyDerivedSessions", "Derived session invalidated");
                    continue;
                }
                if (!session.getInvalidateWhenReady()) continue;
                session.invalidate();
                if (!c_logger.isTraceDebugEnabled()) continue;
                c_logger.traceDebug((Object)null, "invalidateProxyDerivedSessions", "Derived session invalidated");
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "invalidateProxyDerivedSessions");
        }
    }

    void callInvalidateWhenReady() {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this.getAppName(), this.getSharedId()};
            c_logger.traceEntry((Object)this, "callInvalidateWhenReady", params);
        }
        SipApplicationSession applicationSession = this.getSipApplicationSession();
        this.invalidateProxyDerivedSessions();
        if (this._sipSession != null) {
            if (this._sipSession.getInvalidateWhenReady()) {
                this._sipSession.readyToInvalidate();
            } else if (applicationSession != null && applicationSession.isReadyToInvalidate()) {
                ((SipApplicationSessionImpl)applicationSession).readyToInvalidate();
            }
        } else {
            this.readyToInvalidate();
        }
    }

    private void readyToInvalidate() {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this.getSharedId(), this.isValid()};
            c_logger.traceEntry((Object)this, "readyToInvalidate", params);
        }
        if (this.isValid()) {
            SipApplicationSessionImpl appSession;
            block7: {
                appSession = (SipApplicationSessionImpl)this.getSipApplicationSession();
                try {
                    this.getWrapper().invalidateTU(true, true);
                }
                catch (IllegalStateException e2) {
                    if (!c_logger.isTraceDebugEnabled()) break block7;
                    c_logger.traceDebug(this, "readyToInvalidate", "SipApplication session was already invalidated");
                }
            }
            if (appSession != null && appSession.getInvalidateWhenReady() && appSession.isReadyToInvalidate()) {
                appSession.readyToInvalidate();
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "readyToInvalidate", "TU has already been invalidated. Just ignore.");
        }
    }

    void continueDerivedInitalization(TransactionUserWrapper originalTU) {
        SipSessionImplementation baseSS;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this.getAppName(), this.getSharedId()};
            c_logger.traceEntry((Object)this, "continueDerivedInitalization", params);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "continueDerivedInitalization", "Base TU = " + originalTU);
        }
        if ((baseSS = (SipSessionImplementation)originalTU.getTuBase().getSipSession(false)) != null) {
            this._sipSession = SIPSessionFactory.createDerivedSIPSession(this._tuWrapper, baseSS);
        } else if (this._tuWrapper.isB2B() && c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "initialize", "Original UAS not linked so Application MUST explicitly link original and derived sessions");
        }
    }

    public void setCanCreateDS(boolean flag) {
        this._canCreateDerivedSessions = flag;
    }

    public boolean canCreateDS() {
        return this._canCreateDerivedSessions;
    }

    public void rescheduleExpTimer() {
        this.cancelExpirationTimer();
        this._tUserTimer = new TransactionUserTimerListener(this._tuWrapper);
        this._tUserTimer.schedule(false, 31000L);
    }

    private void createTranscationUserTimer() {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this.getAppName(), this.getSharedId()};
            c_logger.traceEntry((Object)this, "createTranscationUserTimer", params);
        }
        if (this.getSipApplicationSession() != null) {
            return;
        }
        int sessionTimeout = 1;
        if (this.m_sipServletDesc != null) {
            sessionTimeout = this.m_sipServletDesc.getSipApp().getAppSessionTTL();
        }
        if (sessionTimeout < 1) {
            this.m_expires = -1L;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createTranscationUserTimer", "WARNING: According to sip.xml settings, this dialog will never expire. ApplicationSession must be explicitly invalidated when dialog finished, or else it will stay in memory forever!");
            }
            return;
        }
        long deltaMilis = sessionTimeout * 1000 * 60;
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer();
            buff.append("TransactionUser = " + this.getSharedId());
            buff.append(" will die in = ");
            buff.append(deltaMilis);
            buff.append("MS");
            c_logger.traceDebug(this, "createTranscationUserTimer", buff.toString());
        }
        this.m_expires = System.currentTimeMillis() + deltaMilis;
        this._tUserTimer = new TransactionUserTimerListener(this._tuWrapper);
        this._tUserTimer.schedule(false, deltaMilis);
    }

    private static synchronized long getNextApplicationSessionId() {
        return c_nextAppSessionId++;
    }

    private static String createApplicationId(String srvrid) {
        StringBuffer buff = new StringBuffer(srvrid);
        buff.append("_");
        buff.append(TransactionUserBase.getNextApplicationSessionId());
        return buff.toString();
    }

    List<IBMSipSession> getAllSipSessions(List<IBMSipSession> sessions, boolean create) {
        if (this._sipSession == null) {
            this.getSipSession(create);
        }
        if (this._sipSession != null) {
            sessions.add(this._sipSession);
        }
        return sessions;
    }

    protected void invalidateBase(boolean removeFromAppSession) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this.getAppName(), this.getSharedId()};
            c_logger.traceEntry((Object)this, "invalidateBase", params);
        }
        if (this._isInvalidated) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "invalidate", "Base TU is invalid, " + this);
            }
            this.logToContext(0x100001);
            throw new IllegalStateException("Invalid Session: " + this);
        }
        try {
            this._tuWrapper.logToContext(4097);
            this.cancelExpirationTimer();
            if (this._sipSession == null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "invalidate", "SipSession doesn't exist  " + this);
                }
            } else {
                this._sipSession.invalidateSipSession();
            }
            if (this._sessionKeyBase != null) {
                SessionRepository.getInstance().removeKeyBaseAppSession(this._sessionKeyBase);
            }
            this._isInvalidated = true;
            if (removeFromAppSession && this.m_applicationId != null) {
                SipApplicationSessionImpl as = (SipApplicationSessionImpl)this.getSipApplicationSession();
                if (as != null) {
                    as.removeTransactionUser(this._tuWrapper);
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "invalidate", "removed TUWrapper " + this._tuWrapper + " from SAS " + as);
                    }
                } else if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "invalidate", "SAS is null, was not created by application. asID=" + this.m_applicationId);
                }
            }
            if (null != this.m_contextLog) {
                SipSessionSeqLog tmp = this.m_contextLog;
                this.m_contextLog = null;
                tmp.returnToPool();
            }
        }
        finally {
            this.removeFromStorage();
        }
    }

    public void applicationSessionIvalidated(SipApplicationSession appSession) {
        this.m_sipAppSession = appSession;
    }

    void isBaseTUActive() throws IllegalStateException {
        if (this._isInvalidated) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "isSessionValid", "Session is invalid, Operation not allowed,  " + this);
            }
            throw new IllegalStateException("This SipSession was invalidated: " + this);
        }
    }

    SipApplicationSession getApplicationSession(boolean create) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this.getAppName(), this.getSharedId()};
            c_logger.traceEntry((Object)this, "getApplicationSession", params);
        }
        if (this.m_sipAppSession != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getApplicationSession", "SipApplicationSession was invalidated, returning the local reference");
            }
            return this.m_sipAppSession;
        }
        SipApplicationSession result = this.getSipApplicationSession();
        if (this._isInvalidated) {
            return result;
        }
        if (result == null && create) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getApplicationSession", "creating new App Session");
            }
            SipApplicationSessionImpl _sipAppSession = (SipApplicationSessionImpl)WASXSipApplicationSessionFactory.getInstance().createSipApplicationSession(this.getApplicationId());
            _sipAppSession.setSynchronizer(this.getSynchronizer());
            _sipAppSession.setServiceSynchronizer(this.getServiceSynchronizer());
            if (this._tUserTimer != null) {
                _sipAppSession.createSipAppTimer(0L, this._tUserTimer.getTimer());
            }
            _sipAppSession.setExpirationFromTU(this.m_expires);
            _sipAppSession.addToApplicationSessionsTable();
            _sipAppSession.addTransctionUser(this._tuWrapper);
            _sipAppSession.setSipApp(this.m_sipServletDesc.getSipApp(), false);
            result = _sipAppSession;
        }
        return result;
    }

    String getApplicationId() {
        if (this.m_applicationId == null && this.getSharedId() != null) {
            int appIDEndIndex = this.getSharedId().lastIndexOf("_");
            this.m_applicationId = this.getSharedId().substring(0, appIDEndIndex);
        }
        return this.m_applicationId;
    }

    private void createTUId(SipApplicationSessionImpl sipApp) {
        String srvrid;
        if (sipApp == null) {
            srvrid = serverIdentifier;
            this.m_applicationId = TransactionUserBase.createNextApplicationSessionId(srvrid);
        } else {
            srvrid = sipApp.getServerID();
        }
        StringBuilder buff = new StringBuilder(this.m_applicationId).append("_").append(TransactionUserBase.getNextTransactionUseID(srvrid));
        this.setSharedId(buff.toString());
    }

    public static String createNextApplicationSessionId() {
        return TransactionUserBase.createNextApplicationSessionId(null);
    }

    public static String createNextApplicationSessionId(String receivedServerID) {
        String srvrid;
        if (receivedServerID != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("creating application session for logical name  " + receivedServerID);
            }
            srvrid = receivedServerID;
        } else {
            srvrid = serverIdentifier;
        }
        return TransactionUserBase.createApplicationId(srvrid);
    }

    boolean hasSipSession() {
        return this._sipSession != null;
    }

    SipServletDesc getSipServletDesc() {
        return this.m_sipServletDesc;
    }

    void setSipServletDesc(SipServletDesc desc) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("TransactionUserBase.setSipServletDesc():" + desc);
        }
        this.m_sipServletDesc = desc;
        this.setDirty();
        this.createTranscationUserTimer();
        this.store();
        this.logToContext(258, desc);
    }

    synchronized void setHandler(String name) throws ServletException {
        SipServletDesc desc;
        SipAppDesc appDesc = this.m_sipServletDesc.getSipApp();
        SipServletDesc sipServletDesc = desc = appDesc == null ? null : appDesc.getSipServlet(name);
        if (null != desc) {
            this.m_sipServletDesc = desc;
            this.setDirty();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setHandler for  " + this, "" + desc);
            }
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setHandler for " + this, "Handler: " + name + " Not available");
            }
            throw new ServletException("No servlet with the specified name exists in the application" + this);
        }
    }

    SipSession getSipSession(boolean create) {
        if (this._sipSession == null && create) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getSipSession", "Create a new SipSession for TU = " + this.getSharedId());
            }
            this._sipSession = SIPSessionFactory.createSIPSession(this._tuWrapper);
        }
        return this._sipSession;
    }

    void logToContext(int state, Object info, Object extendedInfo) {
        if (null != this.m_contextLog) {
            this.m_contextLog.log(state, info, extendedInfo);
        }
    }

    void logToContext(int state, int info, Object extendedInfo) {
        if (null != this.m_contextLog) {
            this.m_contextLog.log(state, info, extendedInfo);
        }
    }

    void logToContext(int state, Object info) {
        if (null != this.m_contextLog) {
            this.m_contextLog.log(state, info);
        }
    }

    void logToContext(int state) {
        if (null != this.m_contextLog) {
            this.m_contextLog.log(state);
        }
    }

    void logToContext(int state, int info) {
        if (null != this.m_contextLog) {
            this.m_contextLog.log(state, info);
        }
    }

    void logToContext(int state, boolean info) {
        if (null != this.m_contextLog) {
            this.m_contextLog.log(state, info);
        }
    }

    boolean isDialog() {
        return this._dialogState.isDialog();
    }

    @Override
    public void store() {
        if (this._sipSession != null) {
            this._sipSession.store();
        }
        SessionRepository.getInstance().put(this.getSharedId(), this);
    }

    @Override
    public void removeFromStorage() {
        SessionRepository.getInstance().removeTuBase(this);
    }

    public void notifyOnActivation() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("TransactionUserBase.notifyOnActivation");
        }
        if (this._sipSession != null) {
            this._sipSession.notifyOnActivation();
        }
        this._tuWrapper.notifyTUOnActivation();
    }

    public void setWrapper(TransactionUserWrapper wrapper) {
        this._tuWrapper = wrapper;
    }

    public boolean shouldBeReplicated(boolean forBootstrap) {
        return this.m_sipServletDesc != null && this.m_sipServletDesc.getSipApp().isDistributed();
    }

    public void cancelExpirationTimer() {
        if (this.getSipApplicationSession() == null && this._tUserTimer != null) {
            this._tUserTimer.cancel();
        }
    }

    public boolean isValid() {
        return !this._isInvalidated;
    }

    private static long getNextTransactionUseID(String logicalName) {
        Counter counter = TransactionUserBase.getCounter(logicalName);
        return counter.getNextCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Counter getCounter(String logicalName) {
        Counter counter = s_nextTransactionIdPerLogicalName.get(logicalName);
        if (counter == null) {
            Map<String, Counter> map = s_nextTransactionIdPerLogicalName;
            synchronized (map) {
                counter = new Counter();
                s_nextTransactionIdPerLogicalName.put(logicalName, counter);
            }
        }
        return counter;
    }

    public static void setNextMaxTransactionId(String logicalName, long id) {
        Counter counter = TransactionUserBase.getCounter(logicalName);
        counter.setHigherCount(id);
    }

    public String toString() {
        StringBuffer myInformation = new StringBuffer(50);
        myInformation.append("Id = ");
        myInformation.append(this.getSharedId());
        myInformation.append(" Info = ");
        myInformation.append(super.toString());
        return myInformation.toString();
    }

    SipSession.State getState() {
        return this._dialogState.getState();
    }

    public void setSessionState(SipSession.State state, SipServletMessage sipMessage) {
        this._dialogState.setSessionState(state, sipMessage);
    }

    void setStateToAfterInitial() {
        this._dialogState.setStateToAfterInitial();
    }

    boolean isAfterInitialState() {
        return this._dialogState.isAfterInitialState();
    }

    SipSession.State updateState(SipServletResponse response) {
        SipSession.State newState;
        SipSession.State oldState;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this.getAppName(), this.getSharedId()};
            c_logger.traceEntry((Object)this, "updateState", params);
        }
        if ((oldState = this._dialogState.getState()) != (newState = this._dialogState.updateState(response))) {
            this.setDirty();
            this.store();
        }
        return newState;
    }

    void checkIfTerminateRequest(SipServletRequest request) {
        this._dialogState.checkIfTerminateRequest(request);
    }

    boolean canBeInvalidated() {
        return this._dialogState.canBeInvalidated();
    }

    public SipSession getRelatedSipSession() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "getRelatedSipSession");
        }
        String relatedId = this._tuWrapper.getRelatedSipSessionId();
        if (this.getApplicationId() != null) {
            SipApplicationSessionImpl as = (SipApplicationSessionImpl)this.getSipApplicationSession();
            if (as == null) {
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceExit(this, "getRelatedSipSession - non found");
                }
                return null;
            }
            Iterator iter = this.getSipApplicationSession().getSessions();
            while (iter.hasNext()) {
                SipSession session = (SipSession)iter.next();
                if (!session.getId().equals(relatedId)) continue;
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceExit(this, "getRelatedSipSession - found: " + session);
                }
                return session;
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "getRelatedSipSession - non found");
        }
        return null;
    }

    public String getSipSessionId() {
        if (this._sipSession != null) {
            return this._sipSession.getId();
        }
        return null;
    }

    public TransactionUserWrapper getWrapper() {
        return this._tuWrapper;
    }

    public Object getSynchronizer() {
        return this._synchronizer;
    }

    public Object getServiceSynchronizer() {
        return this._serviceSynchronizer;
    }

    private SipApplicationSession getSipApplicationSession() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "getSipApplicationSession", (Object)this.m_applicationId);
        }
        return SessionRepository.getInstance().getAppSession(this.getApplicationId());
    }

    private void setSynchronizer(Object synchronizer) {
        this._synchronizer = synchronizer;
    }

    private void setServiceSynchronizer(Object serviceSynchronizer) {
        this._serviceSynchronizer = serviceSynchronizer;
    }

    public String getAppName() {
        String appName = null;
        SipServletDesc desc = this.getSipServletDesc();
        if (desc != null) {
            appName = this.getSipServletDesc().getName();
        }
        return " AppName = " + appName + " ";
    }

    public void setSipSession(SipSessionImplementation sess) {
        if (this._sipSession != null && c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setSipSession", this.m_applicationId);
        }
        this._sipSession = sess;
    }

    public void setSessionKeyBase(String keyBase) {
        this._sessionKeyBase = keyBase;
    }

    public String getSessionKeyBase() {
        return this._sessionKeyBase;
    }

    protected void setDialogAux(DialogAux da) {
        this._dialogState.setDialogAux(da);
    }

    protected DialogAux getDialogAux() {
        return this._dialogState.getDialogAux();
    }

    protected int getWLMDialogState() {
        return this._dialogState.getWLMDialogState();
    }

    private static class Counter {
        private long _count = 0L;

        private Counter() {
        }

        public long getNextCount() {
            return this._count++;
        }

        public void setHigherCount(long count) {
            if (count > this._count) {
                this._count = count;
            }
        }
    }
}

