/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.was;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.anno.info.AnnotationInfo;
import com.ibm.wsspi.anno.info.AnnotationValue;

public class SipServletAnnotation {
    private static final TraceComponent tc = Tr.register(SipServletAnnotation.class);
    private String _servletname = null;
    private String _applicationName = null;
    private String _description = null;
    private String _className = null;
    private int _loadOnStartup = 0;
    private static String APP_NAME = "applicationName";
    private static String SERVLET_NAME = "name";
    private static String DESCRIPTION = "description";
    private static String LOAD_ON_STARTUP = "loadOnStartup";

    public SipServletAnnotation(String className, AnnotationInfo annotationValue) {
        this._className = className;
        if (annotationValue != null) {
            AnnotationValue value = null;
            value = annotationValue.getValue(APP_NAME);
            if (value != null) {
                this._applicationName = value.getStringValue();
            }
            if ((value = annotationValue.getValue(SERVLET_NAME)) != null) {
                this._servletname = value.getStringValue();
            }
            if ((value = annotationValue.getValue(DESCRIPTION)) != null) {
                this._description = value.getStringValue();
            }
            if ((value = annotationValue.getValue(LOAD_ON_STARTUP)) != null) {
                this._loadOnStartup = value.getIntValue();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Received following annotations: \nservletname: " + this._servletname);
            buff.append(" applicationName: " + this._applicationName);
            buff.append(" description: " + this._description);
            buff.append(" loadOnStartup: " + this._loadOnStartup);
            buff.append(" className: " + this._className);
            Tr.debug((TraceComponent)tc, (String)"processSipServletAnnotations", (Object[])new Object[]{buff.toString()});
        }
    }
}

