/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.parser;

import com.ibm.ws.sip.parser.MessageParser;
import com.ibm.ws.sip.parser.util.ObjectPool;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import java.io.Serializable;

public class CharArray
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4102504972399557418L;
    private static ObjectPool s_pool = new ObjectPool(CharArray.class);
    private static final boolean s_acceptNonUtf8ByteSequences = ApplicationProperties.getProperties().getBoolean("acceptNonUtf8Bytes");
    private char[] m_array = null;
    private int m_length = 0;

    public static CharArray getFromPool(int length) {
        CharArray instance = (CharArray)s_pool.get();
        instance.ensureSize(length);
        instance.m_length = length;
        return instance;
    }

    public static CharArray getFromPool(String contents) {
        int len = contents.length();
        CharArray instance = CharArray.getFromPool(len);
        contents.getChars(0, len, instance.m_array, 0);
        return instance;
    }

    public static CharArray getFromPool(byte[] contents, int offset, int length) {
        CharArray instance = CharArray.getFromPool(length);
        char[] dst = instance.m_array;
        int end = offset + length;
        int iDst = 0;
        for (int iSrc = offset; iSrc < end; ++iSrc) {
            char c;
            byte b = contents[iSrc];
            if ((b & 0x80) == 128) {
                int size = MessageParser.utf8size(b);
                if (size == -1) {
                    if (!s_acceptNonUtf8ByteSequences) {
                        throw new IllegalArgumentException("illgal byte value [" + (b & 0xFF) + ']');
                    }
                    c = (char)(b & 0xFF);
                } else {
                    int value = MessageParser.utf8(contents, iSrc, end - iSrc, size);
                    if (value == -1) {
                        if (!s_acceptNonUtf8ByteSequences) {
                            throw new IllegalArgumentException("expected utf-8 trail byte following utf-8 lead byte [" + (b & 0xFF) + ']');
                        }
                        c = (char)(b & 0xFF);
                    } else {
                        c = (char)value;
                        iSrc += size - 1;
                    }
                }
            } else {
                c = (char)b;
            }
            dst[iDst++] = c;
        }
        instance.m_length = iDst;
        return instance;
    }

    public static CharArray getFromPool(char[] contents, int offset, int length) {
        CharArray instance = CharArray.getFromPool(length);
        if (length > 0) {
            System.arraycopy(contents, offset, instance.m_array, 0, length);
        }
        return instance;
    }

    public void returnToPool() {
        s_pool.putBack(this);
    }

    private void ensureSize(int size) {
        if (this.m_array == null || this.m_array.length < size) {
            int round = this.roundSize(size);
            this.m_array = new char[round];
        }
    }

    private int roundSize(int min) {
        int round = min;
        int bits = 0;
        while (round > 0) {
            round /= 2;
            ++bits;
        }
        round = 1 << bits;
        return round;
    }

    public char[] getArray() {
        return this.m_array;
    }

    public int getLength() {
        return this.m_length;
    }

    public char charAt(int position) {
        return this.m_array[position];
    }

    public int hashCode() {
        if (this.m_array == null) {
            return 0;
        }
        int hash = 0;
        char[] array = this.m_array;
        for (int i = this.m_length - 1; i >= 0; --i) {
            int carry = (hash & Integer.MIN_VALUE) == 0 ? 0 : 1;
            hash <<= 1;
            hash |= carry;
            hash ^= array[i];
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CharArray)) {
            return false;
        }
        CharArray other = (CharArray)obj;
        if (this.m_length != other.m_length) {
            return false;
        }
        int len = this.m_length;
        char[] a1 = this.m_array;
        char[] a2 = other.m_array;
        if (!(a1 != null && a2 != null || a1 == null && a2 == null)) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(char[] array, int length) {
        if (this.m_length != length) {
            return false;
        }
        char[] a1 = this.m_array;
        char[] a2 = array;
        for (int i = 0; i < length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String str) {
        int length = str.length();
        if (this.m_length != length) {
            return false;
        }
        char[] array = this.m_array;
        for (int i = 0; i < length; ++i) {
            if (Character.toLowerCase(array[i]) == Character.toLowerCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.m_array == null) {
            return "null";
        }
        return String.valueOf(this.m_array, 0, this.m_length);
    }

    public Object clone() {
        try {
            CharArray ret = (CharArray)super.clone();
            ret.m_length = this.m_length;
            if (this.m_array == null) {
                ret.m_array = null;
            } else {
                ret.m_array = new char[this.m_array.length];
                System.arraycopy(this.m_array, 0, ret.m_array, 0, this.m_array.length);
            }
            return ret;
        }
        catch (CloneNotSupportedException e2) {
            return null;
        }
    }
}

