/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.address.AddressFactoryImpl;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import java.security.Security;
import java.util.HashSet;
import java.util.StringTokenizer;

public class SIPStackConfiguration {
    private static final LogMgr s_logger = Log.get(SIPStackConfiguration.class);
    private int m_uaDispachingThreads;
    public boolean m_logOutMessages;
    public boolean m_logInMessages;
    private boolean m_hideMessageContent;
    private final HashSet<String> m_hideHeaders = new HashSet();
    private boolean m_hideRequestUri;
    private int m_numberOfDispatchThreads;
    private int m_numberOfApplicationThreads;
    public boolean m_autoSendProvisionResponseOnInvite = true;
    public boolean m_auto482ResponseToMergedRequests;
    private boolean m_forceConnectionReuse;
    private boolean m_strictOutboundLocalPort;
    private int m_connectTimeout;
    private boolean m_detectPreEscapedParams;
    private int m_bindRetries;
    private int m_bindRetryDelay;
    private int m_timerT1;
    private int m_timerT2;
    private int m_timerT4;
    private int m_timerA;
    private int m_timerB;
    private int m_timerD;
    private int m_timerE;
    private int m_timerF;
    private int m_timerG;
    private int m_timerH;
    private int m_timerI;
    private int m_timerJ;
    private int m_timerK;
    private int m_nonInviteServerTransactionTimer;
    private int m_inviteServerTransactionTimer;
    private int m_cancelTimer;
    private int m_networkAddressCacheTtl;
    private String m_sentByHost;
    private String m_callIdValue;
    private int m_maxOutboundPendingMessages;
    private boolean m_forceDisplayNameQuoting;
    private boolean m_allowDisplayNameQuotingByApp;
    private boolean m_forceNameAddr;
    private String[] m_commaSeparatedHeaders;
    private boolean m_messageContextPoolingDebug;
    private HashSet<String> m_addressHeaders = new HashSet();
    private boolean m_removeEmptyCommaSeparatedHeaders;

    SIPStackConfiguration() {
        this.init();
    }

    private void init() {
        String networkAddressCacheTtl;
        Object[] params;
        String[] hiddenHeaders;
        this.m_uaDispachingThreads = ApplicationProperties.getProperties().getInt("transactionStackDispachingThreadNumber");
        this.m_logInMessages = ApplicationProperties.getProperties().getBoolean("traceMsgIn");
        this.m_logOutMessages = ApplicationProperties.getProperties().getBoolean("traceMsgOut");
        this.m_hideMessageContent = ApplicationProperties.getProperties().getBoolean("hideMessageBody");
        for (String header : hiddenHeaders = (String[])ApplicationProperties.getProperties().getObject("hideMessageHeaders")) {
            this.m_hideHeaders.add(header);
        }
        this.m_hideRequestUri = ApplicationProperties.getProperties().getBoolean("hideMessageReqUri");
        this.m_numberOfDispatchThreads = ApplicationProperties.getProperties().getInt("dispatchThreads");
        this.m_numberOfApplicationThreads = ApplicationProperties.getProperties().getInt("appThreads");
        this.m_autoSendProvisionResponseOnInvite = ApplicationProperties.getProperties().getBoolean("auto100OnInvite");
        this.m_auto482ResponseToMergedRequests = ApplicationProperties.getProperties().getBoolean("auto482OnMergedRequests");
        this.m_forceConnectionReuse = ApplicationProperties.getProperties().getBoolean("forceConnectionReuse");
        this.m_strictOutboundLocalPort = ApplicationProperties.getProperties().getBoolean("strictOutLocalPort");
        this.m_connectTimeout = ApplicationProperties.getProperties().getInt("connectTimeout");
        this.m_detectPreEscapedParams = ApplicationProperties.getProperties().getBoolean("detectPreEscapedParams");
        AddressFactoryImpl.s_sipurl_cache_init_size = ApplicationProperties.getProperties().getInt("sipurlCacheInitSize");
        AddressFactoryImpl.s_sipurl_cache_max_size = ApplicationProperties.getProperties().getInt("sipurlCacheMaxSize");
        SIPStackUtil.s_ipCacheInitSize = ApplicationProperties.getProperties().getInt("ipCacheInitSize");
        SIPStackUtil.s_ipCacheMaxSize = ApplicationProperties.getProperties().getInt("ipCacheMaxSize");
        this.m_bindRetries = ApplicationProperties.getProperties().getInt("bindRetries");
        this.m_bindRetryDelay = ApplicationProperties.getProperties().getInt("bindRetryDelay");
        this.m_timerT1 = ApplicationProperties.getProperties().getDuration("timerT1");
        if (this.m_timerT1 != 500) {
            if (this.m_timerT1 == -1) {
                this.m_timerT1 = 500;
            }
            if (s_logger.isInfoEnabled()) {
                params = new Object[]{"T1", this.m_timerT1};
                s_logger.info("info.sip.stack.timer", (Object)"Configure", params);
            }
        }
        this.m_timerT2 = ApplicationProperties.getProperties().getDuration("timerT2");
        if (this.m_timerT2 != 4000) {
            if (this.m_timerT2 == -1) {
                this.m_timerT2 = 4000;
            }
            if (s_logger.isInfoEnabled()) {
                params = new Object[]{"T2", this.m_timerT2};
                s_logger.info("info.sip.stack.timer", (Object)"Configure", params);
            }
        }
        this.m_timerT4 = ApplicationProperties.getProperties().getDuration("timerT4");
        if (this.m_timerT4 != 5000) {
            if (this.m_timerT4 == -1) {
                this.m_timerT4 = 5000;
            }
            if (s_logger.isInfoEnabled()) {
                params = new Object[]{"T4", this.m_timerT4};
                s_logger.info("info.sip.stack.timer", (Object)"Configure", params);
            }
        }
        this.m_timerA = ApplicationProperties.getProperties().getDuration("timerA");
        if (this.m_timerA != 500) {
            if (this.m_timerA == -1) {
                this.m_timerA = 500;
            }
            if (s_logger.isInfoEnabled()) {
                params = new Object[]{"Timer A", this.m_timerA};
                s_logger.info("info.sip.stack.timer", (Object)"Configure", params);
            }
        }
        this.m_timerB = ApplicationProperties.getProperties().getDuration("timerB");
        if (this.m_timerB == -1) {
            this.m_timerB = 32000;
        }
        if (this.m_timerB == 32000) {
            this.m_timerB = ApplicationProperties.getProperties().getInt("javax.sip.transaction.timerb");
            if (this.m_timerB != 32000 && s_logger.isWarnEnabled()) {
                s_logger.warn("Configuration property is deprecated. Use [timerB] instead of [javax.sip.transaction.timerb]", null);
            }
        } else if (s_logger.isInfoEnabled()) {
            params = new Object[]{"Timer B", this.m_timerB};
            s_logger.info("info.sip.stack.timer", (Object)"Configure", params);
        }
        this.m_timerD = ApplicationProperties.getProperties().getDuration("timerD");
        if (this.m_timerD != 32000) {
            if (this.m_timerD == -1) {
                this.m_timerD = 32000;
            }
            if (s_logger.isInfoEnabled()) {
                params = new Object[]{"Timer D", this.m_timerD};
                s_logger.info("info.sip.stack.timer", (Object)"Configure", params);
            }
        }
        this.m_timerE = ApplicationProperties.getProperties().getDuration("timerE");
        if (this.m_timerE != 500) {
            if (this.m_timerE == -1) {
                this.m_timerE = 500;
            }
            if (s_logger.isInfoEnabled()) {
                params = new Object[]{"Timer E", this.m_timerE};
                s_logger.info("info.sip.stack.timer", (Object)"Configure", params);
            }
        }
        this.m_timerF = ApplicationProperties.getProperties().getDuration("timerF");
        if (this.m_timerF != 32000) {
            if (this.m_timerF == -1) {
                this.m_timerF = 32000;
            }
            if (s_logger.isInfoEnabled()) {
                params = new Object[]{"Timer F", this.m_timerF};
                s_logger.info("info.sip.stack.timer", (Object)"Configure", params);
            }
        }
        this.m_timerG = ApplicationProperties.getProperties().getDuration("timerG");
        if (this.m_timerG != 500) {
            if (this.m_timerG == -1) {
                this.m_timerG = 500;
            }
            if (s_logger.isInfoEnabled()) {
                params = new Object[]{"Timer G", this.m_timerG};
                s_logger.info("info.sip.stack.timer", (Object)"Configure", params);
            }
        }
        this.m_timerH = ApplicationProperties.getProperties().getDuration("timerH");
        if (this.m_timerH != 32000) {
            if (this.m_timerH == -1) {
                this.m_timerH = 32000;
            }
            if (s_logger.isInfoEnabled()) {
                params = new Object[]{"Timer H", this.m_timerH};
                s_logger.info("info.sip.stack.timer", (Object)"Configure", params);
            }
        }
        this.m_timerI = ApplicationProperties.getProperties().getDuration("timerI");
        if (this.m_timerI != 5000) {
            if (this.m_timerI == -1) {
                this.m_timerI = 5000;
            }
            if (s_logger.isInfoEnabled()) {
                params = new Object[]{"Timer I", this.m_timerI};
                s_logger.info("info.sip.stack.timer", (Object)"Configure", params);
            }
        }
        this.m_timerJ = ApplicationProperties.getProperties().getDuration("timerJ");
        if (this.m_timerJ != 32000) {
            if (this.m_timerJ == -1) {
                this.m_timerJ = 32000;
            }
            if (s_logger.isInfoEnabled()) {
                params = new Object[]{"Timer J", this.m_timerJ};
                s_logger.info("info.sip.stack.timer", (Object)"Configure", params);
            }
        }
        this.m_timerK = ApplicationProperties.getProperties().getDuration("timerK");
        if (this.m_timerK != 5000) {
            if (this.m_timerK == -1) {
                this.m_timerK = 5000;
            }
            if (s_logger.isInfoEnabled()) {
                params = new Object[]{"Timer K", this.m_timerK};
                s_logger.info("info.sip.stack.timer", (Object)"Configure", params);
            }
        }
        this.m_nonInviteServerTransactionTimer = ApplicationProperties.getProperties().getInt("transactionTimerNonInviteServer");
        if (this.m_nonInviteServerTransactionTimer != 34000 && s_logger.isInfoEnabled()) {
            params = new Object[]{"NonInviteServerTransaction", this.m_nonInviteServerTransactionTimer};
            s_logger.info("info.sip.stack.timer", (Object)"Configure", params);
        }
        this.m_inviteServerTransactionTimer = ApplicationProperties.getProperties().getInt("transactionTimerInviteServer");
        if (this.m_inviteServerTransactionTimer != 32000 && s_logger.isInfoEnabled()) {
            params = new Object[]{"InviteServerTransaction", this.m_inviteServerTransactionTimer};
            s_logger.info("info.sip.stack.timer", (Object)"Configure", params);
        }
        this.m_cancelTimer = ApplicationProperties.getProperties().getInt("transactionTimerCancel");
        if (this.m_cancelTimer != 32000 && s_logger.isInfoEnabled()) {
            params = new Object[]{"CancelTimer", this.m_cancelTimer};
            s_logger.info("info.sip.stack.timer", (Object)"Configure", params);
        }
        if (((networkAddressCacheTtl = ApplicationProperties.getProperties().getString("networkaddressCacheTtl")) == null || networkAddressCacheTtl.length() == 0) && (networkAddressCacheTtl = Security.getProperty("networkaddress.cache.ttl")) == null) {
            networkAddressCacheTtl = "-1";
        }
        try {
            this.m_networkAddressCacheTtl = Integer.parseInt(networkAddressCacheTtl);
        }
        catch (NumberFormatException e2) {
            this.m_networkAddressCacheTtl = -1;
        }
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "init", "InetAddress cache TTL: " + this.m_networkAddressCacheTtl);
        }
        this.m_sentByHost = ApplicationProperties.getProperties().getString("sentByHost");
        if (this.m_sentByHost != null && this.m_sentByHost.trim().length() == 0) {
            this.m_sentByHost = null;
        } else if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "init", "sent-by host [" + this.m_sentByHost + ']');
        }
        this.m_callIdValue = ApplicationProperties.getProperties().getString("sipCallidValue");
        if (this.m_callIdValue != null && this.m_callIdValue.trim().length() == 0) {
            this.m_callIdValue = null;
        }
        if (this.m_callIdValue != null && s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "init", "callId value [" + this.m_callIdValue + ']');
        }
        this.m_maxOutboundPendingMessages = ApplicationProperties.getProperties().getInt("maxOutPendingMsgs");
        this.m_forceDisplayNameQuoting = ApplicationProperties.getProperties().getBoolean("forceDisplayNameQuoting");
        this.m_allowDisplayNameQuotingByApp = ApplicationProperties.getProperties().getBoolean("allowDisplayNameQuotingByApp");
        this.m_forceNameAddr = ApplicationProperties.getProperties().getBoolean("forceNameAddr");
        this.m_commaSeparatedHeaders = (String[])ApplicationProperties.getProperties().getObject("commaSeparatedHeaders");
        this.m_messageContextPoolingDebug = ApplicationProperties.getProperties().getBoolean("msgContextPoolingDebug");
        String addressHeaders = ApplicationProperties.getProperties().getString("headersParsedAsAddress");
        if (!"".equals(addressHeaders)) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug(this, "init", "addressHeaders=" + addressHeaders);
            }
            StringTokenizer tokenizer = new StringTokenizer(addressHeaders, ",");
            while (tokenizer.hasMoreElements()) {
                String header;
                header = tokenizer.nextToken().trim().toLowerCase();
                this.m_addressHeaders.add(header);
            }
        }
        this.m_removeEmptyCommaSeparatedHeaders = ApplicationProperties.getProperties().getBoolean("removeEmptyCommaSeparatedHeaders");
    }

    public int getUaDispachingThreads() {
        return this.m_uaDispachingThreads;
    }

    public boolean forceConnectionReuse() {
        return this.m_forceConnectionReuse;
    }

    public boolean strictOutboundLocalPort() {
        return this.m_strictOutboundLocalPort;
    }

    public boolean isAuto100OnInvite() {
        return this.m_autoSendProvisionResponseOnInvite;
    }

    public boolean isAuto482ResponseToMergedRequests() {
        return this.m_auto482ResponseToMergedRequests;
    }

    public boolean isTraceInMsg() {
        return this.m_logInMessages;
    }

    public boolean isTraceOutMsg() {
        return this.m_logOutMessages;
    }

    public boolean hideMessageContent() {
        return this.m_hideMessageContent;
    }

    public HashSet<String> getHiddenHeaders() {
        return this.m_hideHeaders;
    }

    public boolean hideRequestUri() {
        return this.m_hideRequestUri;
    }

    public boolean hideAnything() {
        return this.m_hideMessageContent || this.m_hideRequestUri || !this.m_hideHeaders.isEmpty();
    }

    public int getNumberOfDispatchThreads() {
        return this.m_numberOfDispatchThreads;
    }

    public int getNumberOfApplicationThreads() {
        return this.m_numberOfApplicationThreads;
    }

    public int getConnectTimeout() {
        return this.m_connectTimeout;
    }

    public boolean detectPreEscapedParams() {
        return this.m_detectPreEscapedParams;
    }

    public int getBindRetries() {
        return this.m_bindRetries;
    }

    public int getBindRetryDelay() {
        return this.m_bindRetryDelay;
    }

    public int getTimerT1() {
        return this.m_timerT1;
    }

    public int getTimerT2() {
        return this.m_timerT2;
    }

    public int getTimerT4() {
        return this.m_timerT4;
    }

    public int getTimerA() {
        return this.m_timerA;
    }

    public int getTimerB() {
        return this.m_timerB;
    }

    public int getTimerD() {
        return this.m_timerD;
    }

    public int getTimerE() {
        return this.m_timerE;
    }

    public int getTimerF() {
        return this.m_timerF;
    }

    public int getTimerG() {
        return this.m_timerG;
    }

    public int getTimerH() {
        return this.m_timerH;
    }

    public int getTimerI() {
        return this.m_timerI;
    }

    public int getTimerJ() {
        return this.m_timerJ;
    }

    public int getTimerK() {
        return this.m_timerK;
    }

    public int getNonInviteServerTransactionTimer() {
        return this.m_nonInviteServerTransactionTimer;
    }

    public int getInviteServerTransactionTimer() {
        return this.m_inviteServerTransactionTimer;
    }

    public int getCancelTimer() {
        return this.m_cancelTimer;
    }

    public int getNetworkAddressCacheTtl() {
        return this.m_networkAddressCacheTtl;
    }

    public String getSentByHost() {
        return this.m_sentByHost;
    }

    public String getCallIdValue() {
        return this.m_callIdValue;
    }

    public int getMaxOutboundPendingMessages() {
        return this.m_maxOutboundPendingMessages;
    }

    public boolean forceDisplayNameQuoting() {
        return this.m_forceDisplayNameQuoting;
    }

    public boolean allowDisplayNameQuotingByApp() {
        return this.m_allowDisplayNameQuotingByApp;
    }

    public boolean forceNameAddr() {
        return this.m_forceNameAddr;
    }

    public String[] getCommaSeparatedHeaders() {
        return (String[])this.m_commaSeparatedHeaders.clone();
    }

    public boolean messageContextPoolingDebug() {
        return this.m_messageContextPoolingDebug;
    }

    public HashSet<String> getAddressHeaders() {
        return this.m_addressHeaders;
    }

    public boolean removeEmptyCommaSeparatedHeaders() {
        return this.m_removeEmptyCommaSeparatedHeaders;
    }
}

