/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.chfw;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.EndPointInfo;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.stack.transport.chfw.ActiveConfiguration;
import com.ibm.ws.sip.stack.transport.chfw.GenericChain;
import com.ibm.ws.sip.stack.transport.chfw.GenericEndpointImpl;
import com.ibm.wsspi.channelfw.ChainEventListener;
import java.util.HashMap;
import java.util.Map;

public class GenericUDPChain
extends GenericChain
implements ChainEventListener {
    private static final TraceComponent tc = Tr.register(GenericUDPChain.class);
    private String m_myName;

    public GenericUDPChain(GenericEndpointImpl owner) {
        super(owner);
    }

    @Override
    public void init(String endpointId, Object componentId, CHFWBundle cfBundle, String name) {
        this.m_myName = "UDP_" + name + "_" + endpointId;
        super.init(endpointId, componentId, cfBundle, name);
    }

    @Override
    protected ActiveConfiguration createActiveConfiguration() {
        Map<String, Object> udpOptions = GenericEndpointImpl.getUdpOptions();
        Map<String, Object> endpointOptions = this.owner.getEndpointOptions();
        return new ActiveConfiguration(udpOptions, endpointOptions, this);
    }

    @Override
    protected void createChannels(ActiveConfiguration newConfig) {
        ChainData cd;
        ChannelData sipChannel;
        HashMap<Object, Object> chanProps;
        Map<String, Object> udpOptions = GenericEndpointImpl.getUdpOptions();
        EndPointInfo ep = this.endpointMgr.getEndPoint(this.getEndpointName());
        ep = this.endpointMgr.defineEndPoint(this.getEndpointName(), newConfig.configHost, newConfig.configPort);
        ChannelData udpChannel = this.getChannel(this.getName());
        if (udpChannel == null) {
            String typeName = (String)udpOptions.get("type");
            chanProps = new HashMap<String, Object>(udpOptions);
            chanProps.put("endPointName", this.getEndpointName());
            chanProps.put("hostname", ep.getHost());
            chanProps.put("port", String.valueOf(ep.getPort()));
            udpChannel = this.addChannel(this.getName(), typeName, chanProps, newConfig);
        }
        if ((sipChannel = this.getChannel(this.sipChannelName)) == null) {
            chanProps = new HashMap();
            chanProps.put("endPointName", newConfig.endpointOptions.get("id"));
            chanProps.put("channelChainProtocolType", "udp");
            sipChannel = this.addChannel(this.sipChannelName, "SipInboundChannel", chanProps, newConfig);
        }
        if (null == (cd = this.getCfw().getChain(this.getChainName()))) {
            String[] chanList = new String[]{this.getName(), this.sipChannelName};
            this.addChain(chanList, cd, newConfig);
        }
    }

    @Override
    protected void rebuildTheChannel(ActiveConfiguration oldConfig, ActiveConfiguration newConfig) {
        this.stopChain(oldConfig.toString());
        if (newConfig.udpChanged(oldConfig)) {
            this.removeChannel(this.m_myName);
        }
    }

    @Override
    public String getName() {
        return this.m_myName;
    }

    @Override
    public void setupEventProps(Map<String, Object> eventProps) {
    }
}

