/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.ChannelFactoryData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.channelfw.Channel;
import com.ibm.wsspi.channelfw.ChannelFactory;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.channelfw.exception.ChannelFactoryException;
import com.ibm.wsspi.tcpchannel.SSLConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.udpchannel.UDPContext;
import java.lang.reflect.Constructor;
import java.util.Arrays;

public abstract class SipChannelFactory
implements ChannelFactory {
    private static final TraceComponent tc = Tr.register(SipChannelFactory.class);
    private static final Class[] s_deviceInterfaces = new Class[]{UDPContext.class, TCPConnectionContext.class, SSLConnectionContext.class};

    public void init(ChannelFactoryData data) throws ChannelFactoryException {
    }

    public void destroy() {
    }

    public Class[] getDeviceInterface() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getDeviceInterface", (Object[])new Object[]{Arrays.toString(s_deviceInterfaces)});
        }
        return s_deviceInterfaces;
    }

    public Class getApplicationInterface() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getApplicationInterface", (Object[])new Object[]{""});
        }
        return null;
    }

    protected Channel createControlRegionChannel(ChannelData config) throws ChannelException {
        Channel channel;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"in SipChannelFactory.createControlRegionChannel", (Object[])new Object[0]);
        }
        try {
            Class<?> proxyClass;
            try {
                proxyClass = Class.forName("com.ibm.ws.proxy.channel.sip.SipProxyInboundChannel");
            }
            catch (Exception e2) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                proxyClass = Class.forName("com.ibm.ws.proxy.channel.sip.SipProxyInboundChannel", true, classLoader);
            }
            Class[] params = new Class[]{ChannelData.class};
            Constructor<?> c = proxyClass.getConstructor(params);
            Object[] args = new Object[]{config};
            channel = (Channel)c.newInstance(args);
        }
        catch (Exception e3) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Error creating SipProxyInboundChannel on behalf of SIP Container " + e3), (Object[])new Object[0]);
            }
            throw new ChannelException("Error creating SipProxyInboundChannel on behalf of SIP Container", (Throwable)e3);
        }
        return channel;
    }
}

