/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPListenningConnection;
import com.ibm.ws.sip.stack.transport.chfw.GenericEndpointImpl;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.Channel;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.DiscriminationProcess;
import com.ibm.wsspi.channelfw.Discriminator;
import com.ibm.wsspi.channelfw.InboundChannel;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import jain.protocol.ip.sip.ListeningPoint;
import java.io.IOException;
import java.util.HashMap;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public abstract class SipInboundChannel
implements Discriminator,
SIPListenningConnection,
InboundChannel {
    protected static final TraceComponent tc = Tr.register(SipInboundChannel.class);
    public static final String SipInboundChannelName = "SipInboundChannel";
    private ListeningPoint m_listeningPoint;
    private Class m_deviceInterface;
    private String m_outboundChainName;
    private ChannelData m_config = null;
    private DiscriminationProcess m_discriminationProcess = null;

    public SipInboundChannel(ChannelData config, ListeningPoint lp, String outboundChainName, Class deviceInterface) {
        this.m_listeningPoint = lp;
        this.m_deviceInterface = deviceInterface;
        this.m_outboundChainName = outboundChainName;
        this.m_config = config;
    }

    public Discriminator getDiscriminator() {
        return this;
    }

    public void start() throws ChannelException {
    }

    public void stop(long millisec) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Stop channel: " + this + " time=" + millisec), (Object[])new Object[0]);
        }
        this.signalNoConnections();
    }

    private void signalNoConnections() {
        EventAdmin engine = GenericEndpointImpl.getEventAdmin();
        HashMap<String, String> eventProps = new HashMap<String, String>(1);
        eventProps.put("ChannelName", this.m_config.getExternalName());
        if (engine != null) {
            Event event = new Event(ChannelFramework.EVENT_STOPCHAIN.toString(), eventProps);
            engine.postEvent(event);
        }
    }

    public void init() throws ChannelException {
    }

    public void destroy() throws ChannelException {
    }

    public Class getDeviceInterface() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getDeviceInterface", (Object[])new Object[]{this.m_deviceInterface.getName()});
        }
        return this.m_deviceInterface;
    }

    public void update(ChannelData cc) {
    }

    public Class getDiscriminatoryType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getDiscriminatoryType", (Object[])new Object[]{""});
        }
        return null;
    }

    public Class getApplicationInterface() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getApplicationInterface", (Object[])new Object[]{""});
        }
        return null;
    }

    public int discriminate(VirtualConnection vc, Object discrimData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"discriminate", (Object[])new Object[]{this.toString()});
        }
        return 1;
    }

    public void cleanUpState(VirtualConnection vc) {
    }

    public Class getDiscriminatoryDataType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getDiscriminatoryDataType", (Object[])new Object[]{WsByteBuffer.class.getName()});
        }
        return WsByteBuffer.class;
    }

    public Channel getChannel() {
        return this;
    }

    public int getWeight() {
        return this.m_config.getDiscriminatorWeight();
    }

    @Override
    public void listen() throws IOException {
    }

    @Override
    public void stopListen() {
        block2: {
            try {
                this.stop(0L);
            }
            catch (ChannelException e2) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"stopListen", (Object[])new Object[]{"ChannelException", e2});
            }
        }
    }

    @Override
    public void close() {
        block2: {
            try {
                this.destroy();
            }
            catch (ChannelException e2) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"stopListen", (Object[])new Object[]{"ChannelException", e2});
            }
        }
    }

    @Override
    public ListeningPoint getListeningPoint() {
        return this.m_listeningPoint;
    }

    public String getOutboundChainName() {
        return this.m_outboundChainName;
    }

    public String toString() {
        return this.m_listeningPoint == null ? "null" : this.m_listeningPoint.toString();
    }

    public DiscriminationProcess getDiscriminationProcess() {
        return this.m_discriminationProcess;
    }

    public void setDiscriminationProcess(DiscriminationProcess dp) {
        this.m_discriminationProcess = dp;
    }

    public String getName() {
        return this.m_config.getName();
    }
}

