/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorization.jacc.web.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.jacc.common.PolicyConfigurationManager;
import com.ibm.ws.security.authorization.jacc.web.WebSecurityPropagator;
import com.ibm.ws.security.authorization.jacc.web.impl.ActionString;
import com.ibm.ws.security.authorization.jacc.web.impl.URLMap;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraint;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraintCollection;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.ws.webcontainer.security.metadata.WebResourceCollection;
import com.ibm.ws.webcontainer.webapp.WebAppConfigExtended;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebSecurityPropagatorImpl
implements WebSecurityPropagator {
    private static final TraceComponent tc = Tr.register(WebSecurityPropagatorImpl.class, (String)"Security.Authorization", (String)"com.ibm.ws.security.authorization.jacc.web.resources.JaccWebAuthorizationMessages");
    private static final int EXTENSION_PATTERN = 0;
    private static final int PATHPREFIX_PATTERN = 1;
    private static final int EXACT_PATTERN = 2;
    private static final int DEFAULT_PATTERN = 3;
    private static final String STARSTAR = "**";
    private static final ActionString ALLMETHOD = new ActionString(":NONE");
    static final long serialVersionUID = 4193090874632708401L;

    /*
     * WARNING - void declaration
     */
    public void propagateWebConstraints(PolicyConfigurationFactory pcf, String contextId, Object webAppConfigObject) {
        WebAppConfig webAppConfig = null;
        if (webAppConfigObject != null) {
            try {
                webAppConfig = (WebAppConfig)webAppConfigObject;
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.security.authorization.jacc.web.impl.WebSecurityPropagatorImpl", (String)"62", (Object)this, (Object[])new Object[]{pcf, contextId, webAppConfigObject});
                Tr.error((TraceComponent)tc, (String)"JACC_WEB_SPI_PARAMETER_ERROR", (Object[])new Object[]{webAppConfigObject.getClass().getName(), "propagateWebConstraints", "WebAppConfig"});
                return;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Nothing to propagate due to null webAppConfig object.", (Object[])new Object[0]);
            }
            return;
        }
        SecurityConstraintCollection scc = this.getSecurityMetadata(webAppConfig).getSecurityConstraintCollection();
        if (scc == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Nothing to propagate due to no security constraints.", (Object[])new Object[0]);
            }
            return;
        }
        String appName = webAppConfig.getApplicationName();
        PolicyConfigurationManager.removeModule((String)appName, (String)contextId);
        PolicyConfiguration webPC = null;
        try {
            webPC = pcf.getPolicyConfiguration(contextId, true);
        }
        catch (PolicyContextException policyContextException) {
            void pce;
            FFDCFilter.processException((Throwable)policyContextException, (String)"com.ibm.ws.security.authorization.jacc.web.impl.WebSecurityPropagatorImpl", (String)"88", (Object)this, (Object[])new Object[]{pcf, contextId, webAppConfigObject});
            Tr.error((TraceComponent)tc, (String)"JACC_WEB_GET_POLICYCONFIGURATION_FAILURE", (Object[])new Object[]{contextId, pce});
            return;
        }
        try {
            this.processRole(webPC, webAppConfig);
            List scList = scc.getSecurityConstraints();
            Map<String, URLMap> allURLMap = this.convertURLMap(scList);
            this.processUrlMap(webPC, allURLMap, this.isDenyUncoveredHttpMethods(scList));
            PolicyConfigurationManager.linkConfiguration((String)appName, (PolicyConfiguration)webPC);
            PolicyConfigurationManager.addModule((String)appName, (String)contextId);
        }
        catch (PolicyContextException scList) {
            void e;
            FFDCFilter.processException((Throwable)scList, (String)"com.ibm.ws.security.authorization.jacc.web.impl.WebSecurityPropagatorImpl", (String)"101", (Object)this, (Object[])new Object[]{pcf, contextId, webAppConfigObject});
            Tr.error((TraceComponent)tc, (String)"JACC_WEB_PERMISSION_PROPAGATION_FAILURE", (Object[])new Object[]{contextId, e});
        }
    }

    private void processRole(PolicyConfiguration webPC, WebAppConfig webAppConfig) throws PolicyContextException {
        SecurityMetadata smd = this.getSecurityMetadata(webAppConfig);
        List roles = smd.getRoles();
        Iterator servletNames = webAppConfig.getServletNames();
        while (servletNames.hasNext()) {
            String servletName = (String)servletNames.next();
            boolean starStarFound = false;
            Map roleRefs = smd.getRoleRefs(servletName);
            if (roleRefs != null && !roleRefs.isEmpty()) {
                for (Map.Entry entry : roleRefs.entrySet()) {
                    String refName = (String)entry.getKey();
                    String name = (String)entry.getValue();
                    WebRoleRefPermission wrrp = new WebRoleRefPermission(servletName, refName);
                    if (!starStarFound && STARSTAR.equals(refName)) {
                        starStarFound = true;
                    }
                    webPC.addToRole(name, (Permission)wrrp);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("addToRole(roleRef) role : " + name + " permission : " + wrrp), (Object[])new Object[0]);
                }
            }
            if (!starStarFound) {
                WebRoleRefPermission wrrp = new WebRoleRefPermission(servletName, STARSTAR);
                webPC.addToRole(STARSTAR, (Permission)wrrp);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("addToRole(roleRef) role : ** permission : " + wrrp), (Object[])new Object[0]);
                }
            }
            for (String string : roles) {
                WebRoleRefPermission wrrp = new WebRoleRefPermission(servletName, string);
                webPC.addToRole(string, (Permission)wrrp);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("addToRole(role) role : " + string + " permission : " + wrrp), (Object[])new Object[0]);
            }
        }
        for (String roleName : roles) {
            WebRoleRefPermission wrrp = new WebRoleRefPermission("", roleName);
            webPC.addToRole(roleName, (Permission)wrrp);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("addToRole(every role) role : " + roleName + " permission : " + wrrp), (Object[])new Object[0]);
        }
    }

    private Map<String, URLMap> convertURLMap(List<SecurityConstraint> scList) {
        HashMap<String, URLMap> allURLMap = new HashMap<String, URLMap>();
        URLMap rootURL = new URLMap("/");
        rootURL.setUncheckedSet(null);
        allURLMap.put("/", rootURL);
        for (SecurityConstraint sc : scList) {
            List wrcList = sc.getWebResourceCollections();
            List roles = sc.getRoles();
            String userDataConstraint = "NONE";
            if (sc.isSSLRequired()) {
                userDataConstraint = "CONFIDENTIAL";
            }
            boolean accessPrecluded = sc.isAccessPrecluded();
            for (WebResourceCollection wrc : wrcList) {
                List urls = wrc.getUrlPatterns();
                List methods = wrc.getHttpMethods();
                List omissionMethods = wrc.getOmissionMethods();
                for (String url : urls) {
                    List selected = null;
                    URLMap urlMap = (URLMap)allURLMap.get(url);
                    if (urlMap == null) {
                        urlMap = this.getNewURLMap(url, allURLMap);
                    }
                    boolean omission = false;
                    if (methods == null || methods.size() == 0) {
                        if (omissionMethods != null && omissionMethods.size() > 0) {
                            omission = true;
                            selected = omissionMethods;
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"All Methods are set since HTTP Method isn't defined.", (Object[])new Object[0]);
                        }
                    } else {
                        selected = methods;
                    }
                    if (accessPrecluded) {
                        urlMap.setExcludedSet(selected, omission);
                    } else if (roles == null) {
                        urlMap.setUncheckedSet(selected, omission);
                    } else {
                        for (String role : roles) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Setting role map for role = " + role), (Object[])new Object[0]);
                            }
                            urlMap.setRoleMap(role, selected, omission);
                        }
                    }
                    urlMap.setUserDataMap(userDataConstraint, selected, omission);
                }
            }
        }
        return allURLMap;
    }

    private URLMap getNewURLMap(String url, Map<String, URLMap> urlMaps) {
        URLMap urlMap = new URLMap(url);
        for (Map.Entry<String, URLMap> e : urlMaps.entrySet()) {
            String prevURL = e.getKey();
            URLMap prevURLMap = e.getValue();
            int prevURLType = this.urlType(prevURL);
            switch (this.urlType(url)) {
                case 0: {
                    if (prevURLType == 1 || prevURLType == 2 && this.urlPatternMatch(url, prevURL)) {
                        urlMap.appendURLPattern(prevURL);
                        break;
                    }
                    if (prevURLType != 3) break;
                    prevURLMap.appendURLPattern(url);
                    break;
                }
                case 1: {
                    if ((prevURLType == 1 || prevURLType == 2) && this.urlPatternMatch(url, prevURL)) {
                        urlMap.appendURLPattern(prevURL);
                        break;
                    }
                    if (prevURLType == 1 && this.urlPatternMatch(prevURL, url)) {
                        prevURLMap.appendURLPattern(url);
                        break;
                    }
                    if (prevURLType != 0 && prevURLType != 3) break;
                    prevURLMap.appendURLPattern(url);
                    break;
                }
                case 2: {
                    if ((prevURLType == 0 || prevURLType == 1) && this.urlPatternMatch(prevURL, url)) {
                        prevURLMap.appendURLPattern(url);
                        break;
                    }
                    if (prevURLType != 3) break;
                    prevURLMap.appendURLPattern(url);
                    break;
                }
                case 3: {
                    if (prevURLType == 3) break;
                    urlMap.appendURLPattern(prevURL);
                    break;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("full urlPattern created is: " + urlMap.getURLPattern()), (Object[])new Object[0]);
        }
        urlMaps.put(url, urlMap);
        return urlMap;
    }

    private void processUrlMap(PolicyConfiguration webPC, Map<String, URLMap> allURLMap, boolean isDenyUncoveredHttpMethodsSet) throws PolicyContextException {
        Permissions webUncheckedPerms = new Permissions();
        Permissions webExcludedPerms = new Permissions();
        boolean uncheckedAdded = false;
        boolean excludedAdded = false;
        for (Map.Entry<String, URLMap> e : allURLMap.entrySet()) {
            URLMap newMap;
            String urlPatternName;
            String url = e.getKey();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("url is: " + url), (Object[])new Object[0]);
            }
            if (this.isUnqualified(url, urlPatternName = (newMap = e.getValue()).getURLPattern())) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("url: " + url + " is unqualified"), (Object[])new Object[0]);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("urlPatternName: " + urlPatternName), (Object[])new Object[0]);
            }
            boolean excludedSet = false;
            ActionString excludedString = newMap.getExcludedString();
            boolean done = false;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Method string for Excluded Permission: " + excludedString), (Object[])new Object[0]);
            }
            if (excludedString != null) {
                String actionString = excludedString.getActions();
                webExcludedPerms.add((Permission)new WebResourcePermission(urlPatternName, actionString));
                webExcludedPerms.add((Permission)new WebUserDataPermission(urlPatternName, actionString));
                excludedSet = true;
                excludedAdded = true;
                if (actionString == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"all methods is set for excluded", (Object[])new Object[0]);
                    }
                    done = true;
                }
            }
            Map<String, String> rMap = null;
            if (done) continue;
            rMap = newMap.getRoleMap();
            ActionString uString = newMap.getUncheckedString();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Method string for Unchecked Permission: " + uString), (Object[])new Object[0]);
            }
            if (uString != null) {
                WebResourcePermission wrp = new WebResourcePermission(urlPatternName, uString.getActions());
                if (!isDenyUncoveredHttpMethodsSet) {
                    webUncheckedPerms.add((Permission)wrp);
                } else {
                    webExcludedPerms.add((Permission)wrp);
                    excludedAdded = true;
                }
            } else if (!excludedSet && rMap == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"set unchecked for all methods", (Object[])new Object[0]);
                }
                webUncheckedPerms.add((Permission)new WebResourcePermission(urlPatternName, (String)null));
                uncheckedAdded = true;
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"unchecked list is null", (Object[])new Object[0]);
            }
            ActionString userDataConfidential = null;
            userDataConfidential = newMap.getUserDataString("CONFIDENTIAL_OR_INTEGRAL");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("\nUserData - Confidential: " + userDataConfidential), (Object[])new Object[0]);
            }
            if (userDataConfidential != null) {
                String actions = userDataConfidential.getActions();
                this.addUserData(webUncheckedPerms, urlPatternName, actions);
                uncheckedAdded = true;
                if (actions != null && actions.startsWith(":")) {
                    done = true;
                }
            }
            if (!done) {
                ActionString userDataRest = null;
                if (userDataConfidential == null && !excludedSet) {
                    userDataRest = ALLMETHOD;
                } else {
                    userDataRest = newMap.getUserDataString("REST");
                    if (userDataRest == null && userDataConfidential == null) {
                        userDataRest = ALLMETHOD;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("UserData - Rest: " + userDataRest), (Object[])new Object[0]);
                }
                if (userDataRest != null) {
                    if (!isDenyUncoveredHttpMethodsSet || uString == null) {
                        this.addUserData(webUncheckedPerms, urlPatternName, userDataRest.getActions());
                        uncheckedAdded = true;
                    } else if (ALLMETHOD.equals(userDataRest)) {
                        String action = uString.getActions();
                        this.addUserData(webExcludedPerms, urlPatternName, action);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("UserData - setExcluded: " + action), (Object[])new Object[0]);
                        }
                        excludedAdded = true;
                        action = uString.getReverseActions();
                        this.addUserData(webUncheckedPerms, urlPatternName, action);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("UserData - setUnchecked: " + action), (Object[])new Object[0]);
                        }
                        uncheckedAdded = true;
                    } else {
                        this.addUserData(webExcludedPerms, urlPatternName, userDataRest.getActions());
                        excludedAdded = true;
                    }
                }
            }
            if (rMap != null) {
                for (Map.Entry<String, String> en : rMap.entrySet()) {
                    WebResourcePermission wrp;
                    String methodString;
                    String role = en.getKey();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("role is " + role), (Object[])new Object[0]);
                    }
                    if ((methodString = en.getValue()) == null || methodString.length() == 0) {
                        wrp = new WebResourcePermission(urlPatternName, (String)null);
                        webPC.addToRole(role, (Permission)wrp);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("addToRole(all methods) role : " + role + " permission : " + wrp), (Object[])new Object[0]);
                        continue;
                    }
                    wrp = new WebResourcePermission(urlPatternName, methodString);
                    webPC.addToRole(role, (Permission)wrp);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("addToRole(specific methods) role : " + role + " permission : " + wrp), (Object[])new Object[0]);
                }
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("No role map. URL: " + urlPatternName), (Object[])new Object[0]);
        }
        if (excludedAdded) {
            webPC.addToExcludedPolicy((PermissionCollection)webExcludedPerms);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addToExcludedPolicy permission : " + webExcludedPerms), (Object[])new Object[0]);
            }
        }
        if (uncheckedAdded) {
            webPC.addToUncheckedPolicy((PermissionCollection)webUncheckedPerms);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addToUncheckedPolicy permission : " + webUncheckedPerms), (Object[])new Object[0]);
            }
        }
    }

    private boolean isUnqualified(String url, String urlPattern) {
        boolean unqualified = false;
        if (urlPattern.indexOf(":") != -1) {
            int idx = urlPattern.indexOf(":");
            StringTokenizer st = new StringTokenizer(urlPattern.substring(idx + 1), ":");
            while (st.hasMoreTokens()) {
                if (!this.urlPatternMatch(st.nextToken(), url)) continue;
                unqualified = true;
                break;
            }
        }
        return unqualified;
    }

    private void addUserData(Permissions permissions, String url, String userdata) {
        if (userdata != null && userdata.startsWith(":")) {
            String transport = userdata.substring(1);
            permissions.add((Permission)new WebUserDataPermission(url, null, transport));
        } else {
            permissions.add((Permission)new WebUserDataPermission(url, userdata));
        }
    }

    private int urlType(String urlPattern) {
        String pattern = urlPattern.toString();
        if (pattern.startsWith("*.")) {
            return 0;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            return 1;
        }
        if (pattern.equals("/")) {
            return 3;
        }
        return 2;
    }

    protected boolean urlPatternMatch(String pattern1, String pattern2) {
        if (pattern1.equals(pattern2)) {
            return true;
        }
        if (pattern1.equals("/*")) {
            return true;
        }
        if (pattern1.startsWith("/") && pattern1.endsWith("/*")) {
            String subPattern = pattern1.substring(0, pattern1.length() - 2);
            int pLength = subPattern.length();
            if (pattern2.startsWith(subPattern) && (pattern2.length() == pLength || pattern2.charAt(pLength) == '/')) {
                return true;
            }
        }
        if (pattern1.startsWith("*.") && pattern2.endsWith(pattern1.substring(1))) {
            return true;
        }
        return pattern1.equals("/");
    }

    private SecurityMetadata getSecurityMetadata(WebAppConfig webAppConfig) {
        WebModuleMetaData wmmd = ((WebAppConfigExtended)webAppConfig).getMetaData();
        return (SecurityMetadata)wmmd.getSecurityMetaData();
    }

    private boolean isDenyUncoveredHttpMethods(List<SecurityConstraint> scList) {
        for (SecurityConstraint sc : scList) {
            List wrcList = sc.getWebResourceCollections();
            for (WebResourceCollection wrc : wrcList) {
                if (!wrc.getDenyUncoveredHttpMethods()) continue;
                return true;
            }
        }
        return false;
    }
}

