/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.StringTokenizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PageLoader {
    private static final TraceComponent tc = Tr.register(PageLoader.class, (String)"spnego", (String)"com.ibm.ws.security.spnego.internal.resources.SpnegoMessages");
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    public static final String DEFAULT_CONTENT_ENCODING = "UTF-8";
    private static final String HTTP_CONTENT_ENCODING_MARKER = "charset=";
    private transient String contentType;
    private transient String contentEncoding;
    private transient String content;
    private static String defaultContentEncoding = null;
    static final long serialVersionUID = 3522946134929854367L;

    PageLoader(String customUrl, String defaultErrorPageContent) {
        if (customUrl == null) {
            this.useDefaultErrorPage(defaultErrorPageContent);
        } else {
            boolean load = this.processCustomErrorPage(customUrl);
            if (!load) {
                this.useDefaultErrorPage(defaultErrorPageContent);
            }
        }
    }

    void useDefaultErrorPage(String defaultErrorPageContent) {
        this.content = defaultErrorPageContent;
        this.contentType = DEFAULT_CONTENT_TYPE;
        this.contentEncoding = DEFAULT_CONTENT_ENCODING;
    }

    boolean processCustomErrorPage(String customUrl) {
        boolean result = false;
        try {
            URL pageURL = new URL(customUrl);
            result = this.loadCustomErrorPage(pageURL, customUrl);
        }
        catch (MalformedURLException pageURL) {
            FFDCFilter.processException((Throwable)pageURL, (String)"com.ibm.ws.security.spnego.PageLoader", (String)"68", (Object)this, (Object[])new Object[]{customUrl});
            Tr.error((TraceComponent)tc, (String)"SPNEGO_CUSTOM_ERROR_PAGE_MALFORMED", (Object[])new Object[]{customUrl});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    boolean loadCustomErrorPage(URL pageURL, String customUrl) {
        boolean result;
        block30: {
            BufferedReader br;
            InputStreamReader isr;
            InputStream in;
            block29: {
                result = false;
                in = null;
                isr = null;
                br = null;
                URLConnection pageConnection = pageURL.openConnection();
                if (pageConnection == null) break block29;
                in = pageConnection.getInputStream();
                this.contentType = this.getContentType(pageConnection);
                this.contentEncoding = this.getContentEncoding(pageURL, pageConnection, this.contentType);
                isr = new InputStreamReader(in, this.contentEncoding);
                br = new BufferedReader(isr);
                this.content = this.getContent(br);
                result = true;
            }
            try {
                if (br != null) {
                    br.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (in != null) {
                    in.close();
                }
                break block30;
            }
            catch (IOException pageConnection) {
                FFDCFilter.processException((Throwable)pageConnection, (String)"com.ibm.ws.security.spnego.PageLoader", (String)"107", (Object)this, (Object[])new Object[]{pageURL, customUrl});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("failed to clean up a stream: " + e), (Object[])new Object[0]);
                }
                break block30;
            }
            catch (UnsupportedEncodingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.spnego.PageLoader", (String)"95", (Object)this, (Object[])new Object[]{pageURL, customUrl});
                Tr.error((TraceComponent)tc, (String)"SPNEGO_LOAD_CUSTOM_ERROR_PAGE_ERROR", (Object[])new Object[]{customUrl, e.getMessage() == null ? "UnsupportedEncodingException" : e.getMessage()});
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e5333333332) {
                    FFDCFilter.processException((Throwable)e5333333332, (String)"com.ibm.ws.security.spnego.PageLoader", (String)"107", (Object)this, (Object[])new Object[]{pageURL, customUrl});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("failed to clean up a stream: " + e5333333332), (Object[])new Object[0]);
                    }
                    break block30;
                }
            }
            catch (IOException e2) {
                FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.security.spnego.PageLoader", (String)"97", (Object)this, (Object[])new Object[]{pageURL, customUrl});
                Tr.error((TraceComponent)tc, (String)"SPNEGO_LOAD_CUSTOM_ERROR_PAGE_ERROR", (Object[])new Object[]{customUrl, e2.getMessage() == null ? "IOException" : e2.getMessage()});
                {
                    catch (Throwable throwable) {
                        block31: {
                            try {
                                if (br != null) {
                                    br.close();
                                }
                                if (isr != null) {
                                    isr.close();
                                }
                                if (in != null) {
                                    in.close();
                                }
                            }
                            catch (IOException iOException) {
                                void e3;
                                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.spnego.PageLoader", (String)"107", (Object)this, (Object[])new Object[]{pageURL, customUrl});
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block31;
                                Tr.debug((TraceComponent)tc, (String)("failed to clean up a stream: " + e3), (Object[])new Object[0]);
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e6333333332) {
                    FFDCFilter.processException((Throwable)e6333333332, (String)"com.ibm.ws.security.spnego.PageLoader", (String)"107", (Object)this, (Object[])new Object[]{pageURL, customUrl});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("failed to clean up a stream: " + e6333333332), (Object[])new Object[0]);
                    }
                }
            }
        }
        return result;
    }

    protected String getContent(BufferedReader br) throws IOException {
        String line;
        StringBuffer pageBuffer = new StringBuffer();
        while ((line = br.readLine()) != null) {
            pageBuffer.append(line);
            pageBuffer.append("\r\n");
        }
        return pageBuffer.toString();
    }

    protected String getContentType(URLConnection pageConnection) {
        String ct = pageConnection.getContentType();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("contentType: " + this.contentType), (Object[])new Object[0]);
        }
        if (ct == null || "content/unknown".equalsIgnoreCase(ct)) {
            ct = "text/*";
        }
        return ct;
    }

    protected String getContentEncoding(URL pageURL, URLConnection pageConnection, String ct) {
        String input;
        String ce = pageConnection.getContentEncoding();
        if (ce == null && (ce = this.getContentEncodingFromHttpContentType(ct)) == null && (ce = this.getContentEncodingFromHttpContentType(input = this.getContentTypeFromPage(pageURL))) == null) {
            ce = this.getDefaultContentEncoding();
        }
        return ce;
    }

    protected final String getContentEncodingFromHttpContentType(String ct) {
        String encoding = null;
        if (ct != null) {
            StringTokenizer st = new StringTokenizer(ct, ";");
            while (st.hasMoreTokens() && encoding == null) {
                String value = st.nextToken();
                int pos = value.indexOf(HTTP_CONTENT_ENCODING_MARKER);
                if (pos <= -1 || pos >= value.length() - HTTP_CONTENT_ENCODING_MARKER.length() || (encoding = value.substring(pos + HTTP_CONTENT_ENCODING_MARKER.length())) == null) continue;
                encoding = encoding.trim();
            }
        }
        return encoding;
    }

    protected final String getDefaultContentEncoding() {
        if (defaultContentEncoding == null) {
            this.synchGetDefaultContentEncoding();
        }
        return defaultContentEncoding;
    }

    private final synchronized void synchGetDefaultContentEncoding() {
        if (defaultContentEncoding == null && (defaultContentEncoding = System.getProperty("file.encoding")) == null) {
            defaultContentEncoding = DEFAULT_CONTENT_ENCODING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    protected String getContentTypeFromPage(URL pageURL) {
        String output;
        block30: {
            String lineLower;
            output = null;
            InputStream in = null;
            InputStreamReader isr = null;
            BufferedReader br = null;
            in = pageURL.openStream();
            isr = new InputStreamReader(in, "ISO-8859-1");
            br = new BufferedReader(isr);
            String line2333333332 = null;
            while ((line2333333332 = br.readLine()) != null && ((lineLower = line2333333332.toLowerCase(Locale.ENGLISH)).indexOf("meta") <= 0 || lineLower.indexOf("http-equiv") <= 0 || lineLower.indexOf("content-type") <= 0 || (output = this.getContentTypeFromMeta(line2333333332)) == null || output.length() <= 0) && lineLower.indexOf("</head>") <= 0) {
            }
            try {
                if (in != null) {
                    in.close();
                }
                if (br != null) {
                    br.close();
                }
                if (isr != null) {
                    isr.close();
                }
                break block30;
            }
            catch (IOException line2333333332) {
                FFDCFilter.processException((Throwable)line2333333332, (String)"com.ibm.ws.security.spnego.PageLoader", (String)"262", (Object)this, (Object[])new Object[]{pageURL});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)"failed to clean up a stream", (Object[])new Object[]{e});
                }
                break block30;
            }
            catch (UnsupportedEncodingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.spnego.PageLoader", (String)"247", (Object)this, (Object[])new Object[]{pageURL});
                Tr.error((TraceComponent)tc, (String)"SPNEGO_CUSTOM_ERROR_PAGE_CONTENT_TYPE_ERROR", (Object[])new Object[]{e.getMessage() == null ? "UnsupportedEncodingException" : e.getMessage()});
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (br != null) {
                        br.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                }
                catch (IOException e533333332) {
                    FFDCFilter.processException((Throwable)e533333332, (String)"com.ibm.ws.security.spnego.PageLoader", (String)"262", (Object)this, (Object[])new Object[]{pageURL});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"failed to clean up a stream", (Object[])new Object[]{e533333332});
                    }
                    break block30;
                }
            }
            catch (IOException e2) {
                FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.security.spnego.PageLoader", (String)"249", (Object)this, (Object[])new Object[]{pageURL});
                Tr.error((TraceComponent)tc, (String)"SPNEGO_CUSTOM_ERROR_PAGE_CONTENT_TYPE_ERROR", (Object[])new Object[]{e2.getMessage() == null ? "IOException" : e2.getMessage()});
                {
                    catch (Throwable throwable) {
                        block31: {
                            try {
                                if (in != null) {
                                    in.close();
                                }
                                if (br != null) {
                                    br.close();
                                }
                                if (isr != null) {
                                    isr.close();
                                }
                            }
                            catch (IOException iOException) {
                                void e3;
                                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.spnego.PageLoader", (String)"262", (Object)this, (Object[])new Object[]{pageURL});
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block31;
                                Tr.debug((TraceComponent)tc, (String)"failed to clean up a stream", (Object[])new Object[]{e3});
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (br != null) {
                        br.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                }
                catch (IOException e633333332) {
                    FFDCFilter.processException((Throwable)e633333332, (String)"com.ibm.ws.security.spnego.PageLoader", (String)"262", (Object)this, (Object[])new Object[]{pageURL});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"failed to clean up a stream", (Object[])new Object[]{e633333332});
                    }
                }
            }
        }
        return output;
    }

    protected String getContentTypeFromMeta(String input) {
        String output = null;
        if (input != null && input.length() > 0) {
            String CONTENT = "content";
            String lower = input.toLowerCase(Locale.ENGLISH);
            String work = input;
            boolean exit = false;
            while (!exit) {
                int index = lower.indexOf(CONTENT);
                int offset = index + CONTENT.length();
                if (index > 0 && lower.length() > offset) {
                    if ((work = work.substring(offset).trim()).charAt(0) != '=') {
                        lower = work.toLowerCase(Locale.ENGLISH);
                        continue;
                    }
                    String[] array = work.split("\"");
                    if (array.length <= 2 || (work = array[1]).length() <= 0) break;
                    output = work.trim();
                    break;
                }
                exit = true;
            }
        }
        return output;
    }

    String getContentType() {
        return this.contentType;
    }

    String getEncoding() {
        return this.contentEncoding;
    }

    String getContent() {
        return this.content;
    }
}

