/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.token;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.token.IDTokenValidationFailedException;
import com.ibm.ws.security.openidconnect.token.JWTPayload;
import java.util.Iterator;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CheckAudience {
    private static final TraceComponent tc = Tr.register(CheckAudience.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.common.internal.resources.OidcCommonMessages");
    private final String clientId;
    private JWTPayload payload;
    static final long serialVersionUID = -8464082453506778211L;

    public CheckAudience(String uri) {
        this.clientId = uri;
    }

    public CheckAudience(String uri, JWTPayload payload2) {
        this.clientId = uri;
        this.payload = payload2;
    }

    public void check() throws IDTokenValidationFailedException {
        this.checkStrings(this.clientId, this.payload);
    }

    boolean singleAudienceElementCheck(String clientId, String aud) {
        return aud.equals(clientId);
    }

    boolean multipleAudienceElementCheck(String clientId, List<String> audList) {
        Iterator<String> it = audList.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(clientId)) continue;
            return true;
        }
        return false;
    }

    private void checkStrings(String clientId, JWTPayload payload) throws IDTokenValidationFailedException {
        boolean audienceCheck = false;
        String aud = null;
        String azp = null;
        Object audienceElement = payload.get("aud");
        if (audienceElement instanceof String) {
            aud = (String)audienceElement;
            audienceCheck = this.singleAudienceElementCheck(clientId, aud);
        } else if (audienceElement instanceof List) {
            if (((List)audienceElement).size() == 1) {
                aud = (String)((List)audienceElement).get(0);
                audienceCheck = this.singleAudienceElementCheck(clientId, aud);
            } else if (((List)audienceElement).size() > 1 && this.multipleAudienceElementCheck(clientId, (List)audienceElement) && (azp = (String)payload.get("azp")) != null) {
                if (!azp.equals(clientId)) {
                    Tr.error((TraceComponent)tc, (String)"OIDC_IDTOKEN_VERIFY_AUD_AZP_ERR", (Object[])new Object[]{azp, clientId});
                    throw new IDTokenValidationFailedException(Tr.formatMessage((TraceComponent)tc, (String)"OIDC_IDTOKEN_VERIFY_AUD_AZP_ERR", (Object[])new Object[]{azp, clientId}));
                }
                audienceCheck = true;
            }
        }
        if (!audienceCheck) {
            Tr.error((TraceComponent)tc, (String)"OIDC_IDTOKEN_VERIFY_AUD_ERR", (Object[])new Object[]{aud, clientId});
            throw IDTokenValidationFailedException.format("OIDC_IDTOKEN_VERIFY_AUD_ERR", aud, clientId);
        }
    }
}

