/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.custom.jdbc.impl;

import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLHADBRetry;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLNonTransactionalDataSource;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLRecoverableUnitImpl;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLRecoverableUnitSectionImpl;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.CustomLogProperties;
import com.ibm.ws.recoverylog.spi.DistributedRecoveryLog;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.HeartbeatLog;
import com.ibm.ws.recoverylog.spi.HeartbeatLogManager;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidRecoverableUnitException;
import com.ibm.ws.recoverylog.spi.Lock;
import com.ibm.ws.recoverylog.spi.LogAllocationException;
import com.ibm.ws.recoverylog.spi.LogClosedException;
import com.ibm.ws.recoverylog.spi.LogCorruptedException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogCursorCallback;
import com.ibm.ws.recoverylog.spi.LogCursorImpl;
import com.ibm.ws.recoverylog.spi.LogIncompatibleException;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.MultiScopeLog;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSectionExistsException;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.utils.RecoverableUnitIdTable;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.DataSource;

public class SQLMultiScopeRecoveryLog
implements LogCursorCallback,
MultiScopeLog,
HeartbeatLog {
    private static final TraceComponent tc = Tr.register(SQLMultiScopeRecoveryLog.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private final RecoveryAgent _recoveryAgent;
    private final String _clientName;
    private final int _clientVersion;
    private final String _logName;
    private final int _logIdentifier;
    private final String _logIdentifierString;
    private final String _serverName;
    private final Properties _internalLogProperties;
    private URL[] _urls;
    private String _dbURL;
    private volatile boolean _isOracle = false;
    private volatile boolean _isDB2 = false;
    private boolean isolationFailureReported = false;
    private HashMap<Long, RecoverableUnit> _recoverableUnits;
    private int _closesRequired;
    private final CustomLogProperties _customLogProperties;
    private boolean _failed;
    private boolean _incompatible;
    private RecoverableUnitIdTable _recUnitIdTable = new RecoverableUnitIdTable();
    private final String _traceId;
    private final boolean _bypassContainmentCheck;
    private static final String _recoveryTableName = "WAS_";
    private static final String _recoveryIndexName = "IXWS";
    private String _recoveryTableNameSuffix = "";
    final FailureScope _failureScope;
    private final boolean _isHomeServer;
    private static final String genericTablePreString = "CREATE TABLE ";
    private static final String genericTablePostString = "( SERVER_NAME VARCHAR(128), SERVICE_ID SMALLINT, RU_ID BIGINT, RUSECTION_ID BIGINT, RUSECTION_DATA_INDEX SMALLINT, DATA LONG VARCHAR FOR BIT DATA) ";
    private static final String db2TablePreString = "CREATE TABLE ";
    private static final String db2TablePostString = "( SERVER_NAME VARCHAR(128), SERVICE_ID SMALLINT, RU_ID BIGINT, RUSECTION_ID BIGINT, RUSECTION_DATA_INDEX SMALLINT, DATA BLOB) ";
    private static final String oracleTablePreString = "CREATE TABLE ";
    private static final String oracleTablePostString = "( SERVER_NAME VARCHAR(128), SERVICE_ID SMALLINT, RU_ID NUMBER(19), RUSECTION_ID NUMBER(19), RUSECTION_DATA_INDEX SMALLINT, DATA BLOB) ";
    private static final String indexPreString = "CREATE INDEX ";
    private static final String indexPostString = "( \"RU_ID\" ASC, \"SERVICE_ID\" ASC, \"SERVER_NAME\" ASC) ";
    private DataSource _theDS = null;
    private Connection _reservedConn = null;
    private int _inserts;
    private int _updates;
    private int _removes;
    private static final Object _CreateTableLock = new Object();
    private final List<ruForReplay> _cachedInserts = new ArrayList<ruForReplay>();
    private final List<ruForReplay> _cachedUpdates = new ArrayList<ruForReplay>();
    private final List<ruForReplay> _cachedRemoves = new ArrayList<ruForReplay>();
    private static final int[] _db2TransientErrorCodes = new int[]{-1015, -1034, -1035, -6036, -30081, -30108, -1224, -1229, -518, -514, -30080, -924, -923, -906, -4498, -4499, -1776};
    private static final int[] _oracleTransientErrorCodes = new int[]{20, 28, 1012, 1014, 1033, 1034, 1035, 1089, 1090, 1092, 3113, 3114, 12505, 12514, 12541, 12560, 12571, 17002, 17008, 17009, 17410, 17401, 17430, 25408, 24794, 17447, 30006};
    private int[] _sqlTransientErrorCodes;
    private final int DEFAULT_TRANSIENT_RETRY_SLEEP_TIME = 10000;
    private final int LIGHTWEIGHT_TRANSIENT_RETRY_SLEEP_TIME = 1000;
    private final int _transientRetrySleepTime;
    private final int DEFAULT_TRANSIENT_RETRY_ATTEMPTS = 180;
    private final int LIGHTWEIGHT_TRANSIENT_RETRY_ATTEMPTS = 2;
    private final int _transientRetryAttempts;
    private boolean sqlTransientErrorHandlingEnabled = false;
    private boolean _serverStopping;
    volatile MultiScopeLog _associatedLog = null;
    volatile boolean _failAssociatedLog = false;
    private final String _currentProcessServerName;
    private static volatile boolean _useNewLockingScheme = false;
    private static int _logGoneStaleTime = 10;
    private int _peerLockTimeBetweenHeartbeats = 5;
    private static final long _reservedConnectionActiveSectionIDSet = 255L;
    private static final long _reservedConnectionActiveSectionIDUnset = 1L;

    public SQLMultiScopeRecoveryLog(CustomLogProperties logProperties, RecoveryAgent recoveryAgent, FailureScope fs) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SQLMultiScopeRecoveryLog", (Object)new Object[]{logProperties, recoveryAgent, fs, this});
        }
        this._customLogProperties = logProperties;
        this._recoveryAgent = recoveryAgent;
        this._logName = this._customLogProperties.logName();
        this._logIdentifier = this._customLogProperties.logIdentifier();
        this._logIdentifierString = this.logTypeFromInteger(this._logIdentifier);
        this._clientName = recoveryAgent.clientName();
        this._clientVersion = recoveryAgent.clientVersion();
        this._serverName = fs.serverName();
        this._failureScope = fs;
        this._isHomeServer = Configuration.localFailureScope().equals(this._failureScope);
        this._internalLogProperties = this._customLogProperties.properties();
        this._urls = null;
        this._dbURL = null;
        this._currentProcessServerName = Configuration.fqServerName();
        this._transientRetryAttempts = this.getTransientSQLErrorRetryAttempts();
        this._transientRetrySleepTime = this.getTransientSQLErrorRetrySleepTime();
        this._inserts = 0;
        this._updates = 0;
        this._removes = 0;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Recovery log belongs to server " + this._serverName));
            Tr.debug((TraceComponent)tc, (String)("Recovery log belongs to home server " + this._isHomeServer));
            Tr.debug((TraceComponent)tc, (String)("Recovery log created by client service " + this._clientName + " at version " + this._clientVersion));
            Tr.debug((TraceComponent)tc, (String)("Recovery log name is " + this._logName));
            Tr.debug((TraceComponent)tc, (String)("Recovery log identifier is " + this._logIdentifier));
            Tr.debug((TraceComponent)tc, (String)("Recovery log internal properties are " + this._internalLogProperties));
            Tr.debug((TraceComponent)tc, (String)"FIS 114950");
        }
        Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Use SQL RecoveryLog for " + this._logName + " on server " + this._serverName));
        this._traceId = "SQLMultiScopeRecoveryLog:serverName=" + this._serverName + ":clientName=" + this._clientName + ":clientVersion=" + this._clientVersion + ":logName=" + this._logName + ":logIdentifier=" + this._logIdentifier + " @" + System.identityHashCode(this);
        boolean bl = this._bypassContainmentCheck = !Configuration.HAEnabled() && !Configuration.isZOS();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("_bypassContainmentCheck = " + this._bypassContainmentCheck));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SQLMultiScopeRecoveryLog", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void openLog() throws LogCorruptedException, LogAllocationException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"openLog", (Object)this);
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        if (this._serverStopping) {
            Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Cannot open SQL RecoveryLog " + this._logName + " for server " + this._serverName + " as the server is stopping"));
            InternalLogException ile = new InternalLogException("Cannot open the log as the server is stopping", null);
            this.markFailed(ile);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
            }
            throw ile;
        }
        Connection conn = null;
        if (this._closesRequired == 0) {
            if (this._recoverableUnits != null) {
                this._recoverableUnits.clear();
            }
            this._recoverableUnits = new HashMap();
            this._cachedInserts.clear();
            this._cachedUpdates.clear();
            this._cachedRemoves.clear();
            this._inserts = 0;
            this._updates = 0;
            this._removes = 0;
            this._reservedConn = null;
            Throwable nonTransientException = null;
            this._recUnitIdTable = new RecoverableUnitIdTable();
            int initialIsolation = 4;
            try {
                String fullLogDirectory = this._internalLogProperties.getProperty("LOG_DIRECTORY");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("fullLogDirectory = " + fullLogDirectory));
                }
                if ((conn = !fullLogDirectory.contains("datasource") ? this.getConnFromTranLogDirString(fullLogDirectory) : this.getConnection(fullLogDirectory)) == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"Null connection InternalLogException");
                    }
                    throw new InternalLogException("Failed to get JDBC Connection", null);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Set autocommit FALSE and RR isolation on the connection");
                }
                initialIsolation = this.prepareConnectionForBatch(conn);
                conn = this.assertDBTableExists(conn, initialIsolation);
                boolean secondPhaseSuccess = false;
                SQLException currentSqlEx = null;
                try {
                    this.updateHADBLock(conn);
                    this.recover(conn);
                    conn.commit();
                    secondPhaseSuccess = true;
                }
                catch (SQLException sqlex) {
                    Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Caught SQLException when opening SQL RecoveryLog " + this._logName + " for server " + this._serverName + " SQLException: " + sqlex));
                    currentSqlEx = sqlex;
                }
                finally {
                    if (conn != null) {
                        if (secondPhaseSuccess) {
                            this.closeConnectionAfterBatch(conn, initialIsolation);
                        } else {
                            block49: {
                                block48: {
                                    try {
                                        conn.rollback();
                                    }
                                    catch (Throwable exc) {
                                        if (!tc.isDebugEnabled()) break block48;
                                        Tr.debug((TraceComponent)tc, (String)"Rolling back on NOT secondPhaseSuccess", (Object)exc);
                                    }
                                }
                                try {
                                    this.closeConnectionAfterBatch(conn, initialIsolation);
                                }
                                catch (Throwable exc) {
                                    if (!tc.isDebugEnabled()) break block49;
                                    Tr.debug((TraceComponent)tc, (String)"Close Failed on NOT secondPhaseSuccess", (Object)exc);
                                }
                            }
                            boolean failAndReport = true;
                            nonTransientException = currentSqlEx;
                            OpenLogRetry openLogRetry = new OpenLogRetry();
                            openLogRetry.setNonTransientException(currentSqlEx);
                            if (this.sqlTransientErrorHandlingEnabled && (failAndReport = openLogRetry.retryAfterSQLException(this, this._theDS, currentSqlEx, this._transientRetryAttempts, this._transientRetrySleepTime))) {
                                nonTransientException = openLogRetry.getNonTransientException();
                            }
                            if (failAndReport) {
                                Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Cannot recover from SQLException when opening SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + nonTransientException));
                                this.markFailed(nonTransientException);
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                                }
                                throw new InternalLogException(nonTransientException);
                            }
                            Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Have recovered from SQLException when opening SQL RecoveryLog " + this._logName + " for server " + this._serverName));
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Connection was NULL");
                    }
                }
            }
            catch (SQLException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.openLog", (String)"464", (Object)this);
                this.markFailed(exc);
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                }
                throw new InternalLogException((Throwable)exc);
            }
            catch (Throwable exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.openLog", (String)"500", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unexpected exception caught in openLog", (Object)exc);
                }
                this.markFailed(exc);
                this._recoverableUnits = null;
                for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)(" " + ste));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                }
                throw new InternalLogException(exc);
            }
        }
        ++this._closesRequired;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Closes required: " + this._closesRequired));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"openLog");
        }
    }

    public Connection getConnFromTranLogDirString(String fullLogDirectory) throws LogCorruptedException, LogAllocationException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnFromTranLogDirString", (Object)new Object[]{fullLogDirectory, this});
        }
        Connection conn = null;
        try {
            ClassLoader sqlDriverClassLoader;
            Class<?> cls;
            Properties dbProps;
            block16: {
                dbProps = new Properties();
                this.parseLogDirectoryString(fullLogDirectory, dbProps);
                cls = null;
                sqlDriverClassLoader = null;
                try {
                    sqlDriverClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() {
                            URLClassLoader cl = new URLClassLoader(SQLMultiScopeRecoveryLog.this._urls);
                            return cl;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Tr.error((TraceComponent)tc, (String)e.getMessage());
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
                }
            }
            if (this._isOracle) {
                cls = sqlDriverClassLoader.loadClass("oracle.jdbc.OracleDriver");
            } else if (this._isDB2) {
                cls = sqlDriverClassLoader.loadClass("com.ibm.db2.jcc.DB2Driver");
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"defaulting to DB2Driver");
                }
                cls = sqlDriverClassLoader.loadClass("com.ibm.db2.jcc.DB2Driver");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("instantiate jdbc driver class = " + cls));
            }
            Driver d = (Driver)cls.newInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" **** Does this driver accept my URL? " + d.acceptsURL(this._dbURL)));
            }
            DriverManager.registerDriver(d);
            conn = d.connect(this._dbURL, dbProps);
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.openLog", (String)"500", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unexpected exception caught in openLog", (Object)exc);
            }
            this.markFailed(exc);
            this._recoverableUnits = null;
            for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)(" " + ste));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConnFromTranLogDirString", (Object)conn);
        }
        return conn;
    }

    public void parseLogDirectoryString(String fullLogDirectory, Properties dbProps) throws MalformedURLException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseLogDirectoryString", (Object)new Object[]{fullLogDirectory, this});
        }
        StringTokenizer st = new StringTokenizer(fullLogDirectory, "?");
        String cname = st.nextToken();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cname = " + cname));
        }
        String dbPropertiesString = st.nextToken();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dbPropertiesString = " + dbPropertiesString));
        }
        if (dbPropertiesString.contains("oracle")) {
            this._isOracle = true;
            this._sqlTransientErrorCodes = _oracleTransientErrorCodes;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Configure a connection to an ORACLE database");
            }
        } else if (dbPropertiesString.contains("DB2")) {
            this._isDB2 = true;
            this._sqlTransientErrorCodes = _db2TransientErrorCodes;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Configure a connection to a DB2 database");
            }
            this.sqlTransientErrorHandlingEnabled = true;
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"This is neither Oracle nor DB2");
        }
        dbProps.load(new StringReader(dbPropertiesString.replace(',', '\n')));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dbProps = " + dbProps));
        }
        this._dbURL = dbProps.getProperty("url");
        dbProps.remove("url");
        String dbDir = dbProps.getProperty("dbdir");
        dbProps.remove("dbdir");
        String file3String = dbDir + "\\";
        String file1String = "";
        String file2String = "";
        if (this._isOracle) {
            file1String = file3String + "ojdbc6.jar";
        } else {
            file1String = file3String + "db2jcc.jar";
            file2String = file3String + "db2jcc_license_cu.jar";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DB URL: " + this._dbURL));
            Tr.debug((TraceComponent)tc, (String)("DB props: " + dbProps));
            Tr.debug((TraceComponent)tc, (String)("DB file1String: " + file1String));
            Tr.debug((TraceComponent)tc, (String)("DB file2String: " + file2String));
            Tr.debug((TraceComponent)tc, (String)("DB file3String: " + file3String));
        }
        File file1 = new File(file1String);
        File file2 = new File(file2String);
        File file3 = new File(file3String);
        URL url1 = file1.toURL();
        URL url2 = file2.toURL();
        URL url3 = file3.toURL();
        if (this._isOracle) {
            this._urls = new URL[]{url1};
        } else if (this._isDB2) {
            this._urls = new URL[]{url1, url2, url3};
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"defaulting to DB2 stype _urls");
            }
            this._urls = new URL[]{url1, url2, url3};
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseLogDirectoryString");
        }
    }

    private Connection getConnection(String fullLogDirectory) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnection", (Object)fullLogDirectory);
        }
        Connection conn = null;
        StringTokenizer st = new StringTokenizer(fullLogDirectory, "?");
        String cname = st.nextToken();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cname = " + cname));
        }
        Properties dbStringProps = new Properties();
        String dbPropertiesString = st.nextToken();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dbPropertiesString = " + dbPropertiesString));
        }
        dbStringProps.load(new StringReader(dbPropertiesString.replace(',', '\n')));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dbStringProps = " + dbStringProps));
        }
        String dsName = dbStringProps.getProperty("datasource");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Extracted Data Source name = " + dsName));
        }
        if (dsName != null && !dsName.trim().isEmpty()) {
            dsName = dsName.trim();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Trimmed Data Source name to = " + dsName));
            }
        }
        String tableSuffix = dbStringProps.getProperty("tablesuffix");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Extracted Table Suffix = " + tableSuffix));
        }
        if (tableSuffix != null && !tableSuffix.equals("")) {
            this._recoveryTableNameSuffix = tableSuffix;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Full RecoveryTableName = WAS_" + this._recoveryTableNameSuffix));
            }
        }
        SQLNonTransactionalDataSource sqlNonTranDS = new SQLNonTransactionalDataSource(dsName, this._customLogProperties);
        this._theDS = sqlNonTranDS.getDataSource();
        if (this._theDS != null) {
            String dbName;
            conn = this._theDS.getConnection();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got connection: " + conn));
            }
            DatabaseMetaData mdata = conn.getMetaData();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got metadata: " + mdata));
            }
            if ((dbName = mdata.getDatabaseProductName()).toLowerCase().contains("oracle")) {
                this._isOracle = true;
                this._sqlTransientErrorCodes = _oracleTransientErrorCodes;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"This is an Oracle Database");
                }
                this.sqlTransientErrorHandlingEnabled = true;
            } else if (dbName.toLowerCase().contains("db2")) {
                this._isDB2 = true;
                this._sqlTransientErrorCodes = _db2TransientErrorCodes;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"This is a DB2 Database");
                }
                this.sqlTransientErrorHandlingEnabled = true;
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("This is neither Oracle nor DB2, it is " + dbName));
            }
            String dbVersion = mdata.getDatabaseProductVersion();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("You are now connected to " + dbName + ", version " + dbVersion));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)conn);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover(Connection conn) throws SQLException, RecoverableUnitSectionExistsException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover", (Object)conn);
        }
        Statement recoveryStmt = null;
        ResultSet recoveryRS = null;
        try {
            recoveryStmt = conn.createStatement();
            String queryString = "SELECT RU_ID, RUSECTION_ID, RUSECTION_DATA_INDEX, DATA FROM WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " WHERE SERVER_NAME='" + this._serverName + "' AND SERVICE_ID=" + this._recoveryAgent.clientIdentifier();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Retrieve all rows from table using - " + queryString));
            }
            recoveryRS = recoveryStmt.executeQuery(queryString);
            while (recoveryRS.next()) {
                long ruId = recoveryRS.getLong(1);
                if (ruId != -1L) {
                    SQLRecoverableUnitSectionImpl sect;
                    SQLRecoverableUnitImpl ru = (SQLRecoverableUnitImpl)this._recoverableUnits.get(ruId);
                    if (ru == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Creating ru with id: " + ruId));
                        }
                        ru = new SQLRecoverableUnitImpl(this, ruId, this._failureScope, true);
                    }
                    long sectId = recoveryRS.getLong(2);
                    int index = recoveryRS.getInt(3);
                    byte[] data = recoveryRS.getBytes(4);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("sql tranlog: read ruId: " + ruId));
                        Tr.event((TraceComponent)tc, (String)("sql tranlog: read sectionId: " + sectId));
                        Tr.event((TraceComponent)tc, (String)("sql tranlog: read item: " + index));
                        Tr.event((TraceComponent)tc, (String)("sql tranlog: read data: " + RLSUtils.toHexString((byte[])data, (int)32)));
                    }
                    if ((sect = (SQLRecoverableUnitSectionImpl)ru.lookupSection((int)sectId)) == null) {
                        sect = (SQLRecoverableUnitSectionImpl)ru.createSection((int)sectId, index == 0);
                    }
                    sect.addData(index, data);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Bypass locking row with id: " + ruId));
            }
        }
        finally {
            if (recoveryRS != null && !recoveryRS.isClosed()) {
                recoveryRS.close();
            }
            if (recoveryStmt != null && !recoveryStmt.isClosed()) {
                recoveryStmt.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recover");
        }
    }

    public byte[] serviceData() throws LogClosedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serviceData", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serviceData", null);
        }
        return null;
    }

    public synchronized void recoveryComplete() throws LogClosedException, InternalLogException, LogIncompatibleException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryComplete", (Object)this);
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (this._closesRequired == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
        }
    }

    public synchronized void recoveryComplete(byte[] serviceData) throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryComplete", (Object)new Object[]{RLSUtils.toHexString((byte[])serviceData, (int)32), this});
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (this._closesRequired == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
        }
    }

    public void closeLog(byte[] serviceData) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeLog", (Object)new Object[]{RLSUtils.toHexString((byte[])serviceData, (int)32), this});
        }
        this.closeLog();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLog");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void closeLog() throws InternalLogException {
        block42: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"closeLog", (Object)new Object[]{this._reservedConn, this._closesRequired, this});
            }
            boolean successfulSQL = false;
            boolean successfulConnection = true;
            try {
                if (this._closesRequired > 0) {
                    boolean initialReservedConnection = false;
                    try {
                        if (this._reservedConn == null) {
                            if (this._serverStopping) {
                                if (_useNewLockingScheme && !this._isHomeServer) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("Not the home server, failurescope is " + this._failureScope));
                                    }
                                    successfulConnection = false;
                                } else {
                                    Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Server stopping but no reserved connection when closing SQL RecoveryLog " + this._logName + " for server " + this._serverName));
                                    InternalLogException ile = new InternalLogException();
                                    throw ile;
                                }
                            }
                        } else {
                            initialReservedConnection = true;
                            if (this._reservedConn.isClosed()) {
                                if (_useNewLockingScheme && !this._isHomeServer) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("Not the home server, failurescope is " + this._failureScope));
                                    }
                                    successfulConnection = false;
                                } else {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Reserved Connection is already closed");
                                    }
                                    InternalLogException ile = new InternalLogException();
                                    this.markFailed(ile);
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit((TraceComponent)tc, (String)("closeLog called when _closesRequired is " + this._closesRequired), (Object)((Object)ile));
                                    }
                                    throw ile;
                                }
                            }
                        }
                        if (successfulConnection) {
                            this.internalKeypoint();
                            successfulSQL = true;
                            --this._closesRequired;
                        }
                    }
                    catch (LogClosedException exc) {
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.closeLog", (String)"948", (Object)this);
                        InternalLogException ile = new InternalLogException((Throwable)exc);
                        this.markFailed(ile);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)((Object)ile));
                        }
                        throw ile;
                    }
                    catch (InternalLogException exc) {
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.closeLog", (String)"948", (Object)this);
                        this.markFailed(exc);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)((Object)exc));
                        }
                        throw exc;
                    }
                    catch (Throwable exc) {
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.closeLog", (String)"955", (Object)this);
                        this.markFailed(exc);
                        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)(" " + ste));
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)"InternalLogException");
                        }
                        throw new InternalLogException(exc);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Closes required: " + this._closesRequired));
                    }
                    try {
                        if (this._closesRequired <= 0) {
                            if (initialReservedConnection && !_useNewLockingScheme) {
                                this.unlatchHADBLock();
                            }
                            this._recoverableUnits = null;
                            this._closesRequired = 0;
                        }
                        break block42;
                    }
                    catch (Throwable exc) {
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.closeLog", (String)"550", (Object)this);
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Unexpected exception caught in closeLog while unsetting the latch", (Object)exc);
                        }
                        break block42;
                    }
                }
                InternalLogException ile = new InternalLogException();
                this.markFailed(ile);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("closeLog called when _closesRequired is " + this._closesRequired), (Object)((Object)ile));
                }
                throw ile;
            }
            finally {
                if (!successfulSQL) {
                    --this._closesRequired;
                    if (this._reservedConn != null) {
                        try {
                            this._reservedConn.close();
                        }
                        catch (Exception exception) {}
                    }
                    this._reservedConn = null;
                    this._recoverableUnits = null;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Closes required: " + this._closesRequired));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLog");
        }
    }

    public synchronized void closeLogImmediate() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeLogImmediate", (Object)this);
        }
        this._closesRequired = 0;
        this._reservedConn = null;
        this._recoverableUnits = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLogImmediate");
        }
    }

    public synchronized RecoverableUnit createRecoverableUnit(FailureScope failureScope) throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createRecoverableUnit", (Object)new Object[]{failureScope, this});
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        if (this._closesRequired == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        SQLRecoverableUnitImpl recoverableUnit = null;
        long identity = this._recUnitIdTable.nextId((Object)this);
        recoverableUnit = new SQLRecoverableUnitImpl(this, identity, failureScope);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("SQLMultiScopeRecoveryLog '" + this._logName + "' created a new RecoverableUnit with id '" + identity + "'"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)recoverableUnit);
        }
        return recoverableUnit;
    }

    public synchronized void removeRecoverableUnit(long identity) throws LogClosedException, InvalidRecoverableUnitException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)new Object[]{identity, this});
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (this._closesRequired == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        SQLRecoverableUnitImpl recoverableUnit = null;
        recoverableUnit = this.removeRecoverableUnitMapEntries(identity);
        if (recoverableUnit == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)"InvalidRecoverableUnitException");
            }
            throw new InvalidRecoverableUnitException(null);
        }
        try {
            recoverableUnit.remove();
            ruForReplay deleteRU = new ruForReplay(identity, 0L, 0, null);
            this._cachedRemoves.add(deleteRU);
            ++this._removes;
        }
        catch (InternalLogException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.removeRecoverableUnit", (String)"1182", (Object)this);
            this.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)((Object)exc));
            }
            throw exc;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.removeRecoverableUnit", (String)"1186", (Object)this);
            this.markFailed(e);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)e);
            }
            throw new InternalLogException((Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit");
        }
    }

    public synchronized LogCursor recoverableUnits(FailureScope failureScope) throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoverableUnits", (Object)new Object[]{failureScope, this});
        }
        if (this._closesRequired == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoverableUnits", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        ArrayList<SQLRecoverableUnitImpl> recoverableUnits = new ArrayList<SQLRecoverableUnitImpl>();
        for (SQLRecoverableUnitImpl sQLRecoverableUnitImpl : this._recoverableUnits.values()) {
            if (!this._bypassContainmentCheck && !sQLRecoverableUnitImpl.failureScope().isContainedBy(failureScope)) continue;
            recoverableUnits.add(sQLRecoverableUnitImpl);
        }
        LogCursorImpl logCursorImpl = new LogCursorImpl((Lock)null, recoverableUnits, true, (LogCursorCallback)this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoverableUnits", (Object)logCursorImpl);
        }
        return logCursorImpl;
    }

    public LogCursor recoverableUnits() throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoverableUnits", (Object)this);
        }
        LogCursor cursor = this.recoverableUnits(this._failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoverableUnits", (Object)cursor);
        }
        return cursor;
    }

    public RecoverableUnit lookupRecoverableUnit(long identity) throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupRecoverableUnit", (Object)new Object[]{identity, this});
        }
        SQLRecoverableUnitImpl runit = this.getRecoverableUnit(identity);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lookupRecoverableUnit", (Object)runit);
        }
        return runit;
    }

    public RecoverableUnit createRecoverableUnit() throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createRecoverableUnit", (Object)this);
        }
        RecoverableUnit runit = this.createRecoverableUnit(this._failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)runit);
        }
        return runit;
    }

    public LogProperties logProperties() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"logProperties", (Object)this._customLogProperties);
        }
        return this._customLogProperties;
    }

    public void keypoint() throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypoint", (Object)this);
        }
        this.internalKeypoint();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypoint");
        }
    }

    public void internalKeypoint() throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"internalKeypoint", (Object)new Object[]{this, this._reservedConn});
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"internalKeypoint", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"internalKeypoint", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (this._closesRequired == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"internalKeypoint", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        try {
            this.internalForceSections();
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.internalKeypoint", (String)"537", (Object)this);
            for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)(" " + ste));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"internalKeypoint", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"internalKeypoint");
        }
    }

    public synchronized void writeRUSection(long ruId, long sectionId, int index, byte[] data) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeRUSection ", (Object)new Object[]{ruId, sectionId, index, data, this});
        }
        if (this.failed() || this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeRUSection", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (this._closesRequired <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeRUSection", (Object)this);
            }
            throw new InternalLogException((Throwable)new LogClosedException());
        }
        try {
            this.internalWriteRUSection(ruId, sectionId, index, data, false);
        }
        catch (Exception exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.writeRUSection", (String)"1581", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"An unexpected error occured whilst writing data");
            }
            this.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeRUSection", (Object)"InternalLogException");
            }
            throw new InternalLogException((Throwable)exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeRUSection");
        }
    }

    public void internalWriteRUSection(long ruId, long sectionId, int index, byte[] data, boolean replaying) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"internalWriteRUSection ", (Object)new Object[]{ruId, sectionId, index, data, replaying, this});
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("sql tranlog: writing ruId: " + ruId));
            Tr.event((TraceComponent)tc, (String)("sql tranlog: writing sectionId: " + sectionId));
            Tr.event((TraceComponent)tc, (String)("sql tranlog: writing item: " + index));
            Tr.event((TraceComponent)tc, (String)("sql tranlog: writing data: " + RLSUtils.toHexString((byte[])data, (int)32)));
        }
        ruForReplay insertRU = new ruForReplay(ruId, sectionId, index, data);
        this._cachedInserts.add(insertRU);
        ++this._inserts;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"internalWriteRUSection");
        }
    }

    public synchronized void updateRUSection(long ruId, long sectionId, byte[] data) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateRUSection ", (Object)new Object[]{ruId, sectionId, data, this});
        }
        if (this.failed() || this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updateRUSection", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (this._closesRequired <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updateRUSection", (Object)this);
            }
            throw new InternalLogException((Throwable)new LogClosedException());
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("sql tranlog: writing ruId: " + ruId));
            Tr.event((TraceComponent)tc, (String)("sql tranlog: writing sectionId: " + sectionId));
            Tr.event((TraceComponent)tc, (String)("sql tranlog: writing data: " + RLSUtils.toHexString((byte[])data, (int)32)));
        }
        try {
            this.internalUpdateRUSection(ruId, sectionId, data, false);
        }
        catch (Exception exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.updateRUSection", (String)"1581", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"An unexpected error occured whilst updating a RecoverableUnit");
            }
            this.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updateRUSection", (Object)"InternalLogException");
            }
            throw new InternalLogException((Throwable)exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateRUSection");
        }
    }

    public void internalUpdateRUSection(long ruId, long sectionId, byte[] data, boolean replaying) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"internalUpdateRUSection ", (Object)new Object[]{ruId, sectionId, data, replaying, this});
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("sql tranlog: updating ruId: " + ruId));
            Tr.event((TraceComponent)tc, (String)("sql tranlog: updating sectionId: " + sectionId));
            Tr.event((TraceComponent)tc, (String)("sql tranlog: updating data: " + RLSUtils.toHexString((byte[])data, (int)32)));
        }
        ruForReplay updateRU = new ruForReplay(ruId, sectionId, 0, data);
        this._cachedUpdates.add(updateRU);
        ++this._updates;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"internalUpdateRUSection");
        }
    }

    public synchronized void forceSections() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forceSections", (Object)new Object[]{this});
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"forceSections", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (this._closesRequired <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"forceSections", (Object)this);
            }
            throw new InternalLogException((Throwable)new LogClosedException());
        }
        try {
            this.internalForceSections();
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.forceSections", (String)"537", (Object)this);
            for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)(" " + ste));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"forceSections", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"forceSections");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @FFDCIgnore(value={SQLException.class, SQLRecoverableException.class})
    void internalForceSections() throws Exception {
        if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"internalForceSections", (Object)new Object[]{this, this._reservedConn});
        }
        conn = null;
        sqlSuccess = false;
        successfulConnection = true;
        currentSqlEx = null;
        nonTransientException /* !! */  = null;
        initialIsolation = 4;
        try {
            if (this._reservedConn != null) ** GOTO lbl27
            if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Reserved Connection is NULL, attempt to get new DataSource connection");
            }
            if (!this._serverStopping) {
                conn = this._theDS.getConnection();
            } else if (SQLMultiScopeRecoveryLog._useNewLockingScheme && !this._isHomeServer) {
                if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Not the home server, failurescope is " + this._failureScope));
                }
                successfulConnection = false;
            } else {
                Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0100E: Server stopping but no reserved connection when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName));
                ile = new InternalLogException("Server stopping, no reserved connection", null);
                this.markFailed(ile);
                if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"forceSections", (Object)"InternalLogException");
                }
                throw ile;
lbl27:
                // 1 sources

                if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Drive SQL using reserved connection");
                }
                conn = this._reservedConn;
            }
            if (successfulConnection) {
                initialIsolation = this.prepareConnectionForBatch(conn);
                lockSuccess = this.takeHADBLock(conn);
                if (lockSuccess) {
                    this.executeBatchStatements(conn);
                }
                conn.commit();
                sqlSuccess = true;
            }
        }
        catch (SQLException sqlex) {
            Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0107W: Caught SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName + " SQLException: " + sqlex));
            currentSqlEx = sqlex;
            if (conn == null) {
                nonTransientException /* !! */  = sqlex;
            }
        }
        catch (Throwable exc) {
            Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0107W: Caught non-SQLException Throwable when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Throwable: " + exc));
            nonTransientException /* !! */  = exc;
        }
        finally {
            if (conn != null) {
                if (sqlSuccess) {
                    if (this._reservedConn == null) {
                        this.closeConnectionAfterBatch(conn, initialIsolation);
                    }
                } else {
                    block63: {
                        block62: {
                            try {
                                conn.rollback();
                            }
                            catch (SQLRecoverableException sqlrecexc) {
                                if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Rollback Failed, after force sections failure, got SQL Recoverable Exception: " + sqlrecexc));
                                }
                            }
                            catch (Throwable exc) {
                                if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block62;
                                Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Rollback Failed, after force sections failure, got exception: " + exc));
                            }
                        }
                        if (this._reservedConn == null) {
                            try {
                                this.closeConnectionAfterBatch(conn, initialIsolation);
                            }
                            catch (SQLRecoverableException sqlrecexc) {
                                if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Close Failed, after force sections failure, got SQL Recoverable Exception: " + sqlrecexc));
                                }
                            }
                            catch (Throwable exc) {
                                if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block63;
                                Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Close Failed, after force sections failure, got exception: " + exc));
                            }
                        }
                    }
                    failAndReport = true;
                    if (currentSqlEx != null) {
                        nonTransientException /* !! */  = currentSqlEx;
                        forceSectionsRetry = new ForceSectionsRetry();
                        forceSectionsRetry.setNonTransientException(currentSqlEx);
                        if (this.sqlTransientErrorHandlingEnabled && (failAndReport = forceSectionsRetry.retryAfterSQLException(this, this._theDS, currentSqlEx, this._transientRetryAttempts, this._transientRetrySleepTime))) {
                            nonTransientException /* !! */  = forceSectionsRetry.getNonTransientException();
                        }
                    }
                    if (failAndReport) {
                        Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0100E: Cannot recover from SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + nonTransientException /* !! */ ));
                        this.markFailed(nonTransientException /* !! */ );
                        if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"forceSections", (Object)"InternalLogException");
                        }
                        throw new InternalLogException((Throwable)nonTransientException /* !! */ );
                    }
                    Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0108I: Have recovered from SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName));
                }
            } else {
                if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Connection was NULL");
                }
                if (SQLMultiScopeRecoveryLog._useNewLockingScheme && !this._isHomeServer) {
                    if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Not the home server, failurescope is " + this._failureScope));
                    }
                    successfulConnection = false;
                } else {
                    Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0100E: Cannot recover from SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + nonTransientException /* !! */ ));
                    this.markFailed(nonTransientException /* !! */ );
                    if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"forceSections", (Object)"InternalLogException");
                    }
                    throw new InternalLogException((Throwable)nonTransientException /* !! */ );
                }
            }
            this._cachedInserts.clear();
            this._cachedUpdates.clear();
            this._cachedRemoves.clear();
            this._inserts = 0;
            this._updates = 0;
            this._removes = 0;
        }
        if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"internalForceSections");
        }
    }

    boolean isSQLErrorTransient(SQLException sqlex) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isSQLErrorTransient ", (Object)new Object[]{sqlex, this});
        }
        boolean retryBatch = false;
        int sqlErrorCode = sqlex.getErrorCode();
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)" SQL exception:");
            Tr.event((TraceComponent)tc, (String)(" Message: " + sqlex.getMessage()));
            Tr.event((TraceComponent)tc, (String)(" SQLSTATE: " + sqlex.getSQLState()));
            Tr.event((TraceComponent)tc, (String)(" Error code: " + sqlErrorCode));
        }
        for (int transientCode : this._sqlTransientErrorCodes) {
            Tr.event((TraceComponent)tc, (String)("Test against stored code: " + transientCode));
            if (transientCode != sqlErrorCode) continue;
            Tr.event((TraceComponent)tc, (String)"TRANSIENT: A connection failed but could be reestablished, retry.");
            retryBatch = true;
            break;
        }
        if (!retryBatch && sqlex instanceof BatchUpdateException) {
            BatchUpdateException buex = (BatchUpdateException)sqlex;
            Tr.event((TraceComponent)tc, (String)"BatchUpdateException: Update Counts - ");
            int[] updateCounts = buex.getUpdateCounts();
            for (int i = 0; i < updateCounts.length; ++i) {
                Tr.event((TraceComponent)tc, (String)("   Statement " + i + ":" + updateCounts[i]));
            }
            block2: for (SQLException nextex = buex.getNextException(); nextex != null; nextex = nextex.getNextException()) {
                sqlErrorCode = nextex.getErrorCode();
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)" SQL exception:");
                    Tr.event((TraceComponent)tc, (String)(" Message: " + nextex.getMessage()));
                    Tr.event((TraceComponent)tc, (String)(" SQLSTATE: " + nextex.getSQLState()));
                    Tr.event((TraceComponent)tc, (String)(" Error code: " + sqlErrorCode));
                }
                for (int transientCode : this._sqlTransientErrorCodes) {
                    Tr.event((TraceComponent)tc, (String)("Test against stored code: " + transientCode));
                    if (transientCode != sqlErrorCode) continue;
                    Tr.event((TraceComponent)tc, (String)"TRANSIENT: A connection failed but could be reestablished, retry.");
                    retryBatch = true;
                    continue block2;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isSQLErrorTransient", (Object)retryBatch);
        }
        return retryBatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatchStatements(Connection conn) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"executeBatchStatements", (Object)new Object[]{conn, this});
        }
        Statement insertStatement = null;
        Statement updateStatement = null;
        Statement removeStatement = null;
        try {
            int[] numUpdates;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Prepare the INSERT statement for " + this._inserts + " inserts"));
            }
            if (this._inserts > 0) {
                String insertString = "INSERT INTO WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " (SERVER_NAME, SERVICE_ID, RU_ID, RUSECTION_ID, RUSECTION_DATA_INDEX, DATA) VALUES (?,?,?,?,?,?)";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("INSERT string - " + insertString));
                }
                insertStatement = conn.prepareStatement(insertString);
                insertStatement.setString(1, this._serverName);
                insertStatement.setShort(2, (short)this._recoveryAgent.clientIdentifier());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Prepare the UPDATE statement for " + this._updates + " updates"));
            }
            if (this._updates > 0) {
                String updateString = "UPDATE WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " SET DATA = ? WHERE SERVER_NAME = ? AND SERVICE_ID = ? AND RU_ID = ? AND RUSECTION_ID = ? AND RUSECTION_DATA_INDEX = 0";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("UPDATE string - " + updateString));
                }
                updateStatement = conn.prepareStatement(updateString);
                updateStatement.setString(2, this._serverName);
                updateStatement.setShort(3, (short)this._recoveryAgent.clientIdentifier());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Prepare the DELETE statement for " + this._removes + " removes"));
            }
            if (this._removes > 0) {
                String removeString = "DELETE FROM WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " WHERE SERVER_NAME = ? AND SERVICE_ID = ? AND RU_ID = ? ";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("DELETE string - " + (String)removeString));
                }
                removeStatement = conn.prepareStatement(removeString);
                removeStatement.setString(1, this._serverName);
                removeStatement.setShort(2, (short)this._recoveryAgent.clientIdentifier());
            }
            if (this._inserts > 0) {
                for (ruForReplay element : this._cachedInserts) {
                    insertStatement.setLong(3, element.getRuId());
                    insertStatement.setLong(4, element.getSectionId());
                    insertStatement.setShort(5, (short)element.getIndex());
                    insertStatement.setBytes(6, element.getData());
                    insertStatement.addBatch();
                }
            }
            if (this._updates > 0) {
                for (ruForReplay element : this._cachedUpdates) {
                    updateStatement.setLong(4, element.getRuId());
                    updateStatement.setLong(5, element.getSectionId());
                    updateStatement.setBytes(1, element.getData());
                    updateStatement.addBatch();
                }
            }
            if (this._removes > 0) {
                for (ruForReplay element : this._cachedRemoves) {
                    removeStatement.setLong(3, element.getRuId());
                    removeStatement.addBatch();
                }
            }
            if (this._inserts > 0) {
                numUpdates = insertStatement.executeBatch();
                if (tc.isDebugEnabled()) {
                    for (int i = 0; i < numUpdates.length; ++i) {
                        if (numUpdates[i] == -2) {
                            Tr.debug((TraceComponent)tc, (String)("Execution " + i + ": unknown number of rows updated"));
                            continue;
                        }
                        Tr.debug((TraceComponent)tc, (String)("Execution " + i + "successful: " + numUpdates[i] + " rows updated"));
                    }
                }
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("sql tranlog: batch inserts: " + this._inserts));
            }
            if (this._updates > 0) {
                numUpdates = updateStatement.executeBatch();
                if (tc.isDebugEnabled()) {
                    for (int i = 0; i < numUpdates.length; ++i) {
                        if (numUpdates[i] == -2) {
                            Tr.debug((TraceComponent)tc, (String)("Execution " + i + ": unknown number of rows updated"));
                            continue;
                        }
                        Tr.debug((TraceComponent)tc, (String)("Execution " + i + "successful: " + numUpdates[i] + " rows updated"));
                    }
                }
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("sql tranlog: batch updates: " + this._updates));
            }
            if (this._removes > 0) {
                numUpdates = removeStatement.executeBatch();
                if (tc.isDebugEnabled()) {
                    for (int i = 0; i < numUpdates.length; ++i) {
                        if (numUpdates[i] == -2) {
                            Tr.debug((TraceComponent)tc, (String)("Execution " + i + ": unknown number of rows updated"));
                            continue;
                        }
                        Tr.debug((TraceComponent)tc, (String)("Execution " + i + "successful: " + numUpdates[i] + " rows updated"));
                    }
                }
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("sql tranlog: batch deletes: " + this._removes + ", for obj: " + this));
            }
        }
        finally {
            if (insertStatement != null && !insertStatement.isClosed()) {
                insertStatement.close();
            }
            if (updateStatement != null && !updateStatement.isClosed()) {
                updateStatement.close();
            }
            if (removeStatement != null && !removeStatement.isClosed()) {
                removeStatement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"executeBatchStatements");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean takeHADBLock(Connection conn) throws SQLException, InternalLogException {
        boolean lockSuccess;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"takeHADBLock", (Object)new Object[]{conn, this});
            }
            Statement lockingStmt = null;
            ResultSet lockingRS = null;
            lockSuccess = false;
            try {
                lockingStmt = conn.createStatement();
                String queryString = "SELECT SERVER_NAME FROM WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " WHERE RU_ID=-1 FOR UPDATE";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Attempt to select the HA LOCKING ROW for UPDATE using - " + queryString));
                }
                if ((lockingRS = lockingStmt.executeQuery(queryString)).next()) {
                    String storedServerName = lockingRS.getString(1);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Acquired lock on HA Lock row, stored server value is: " + storedServerName));
                    }
                    if (this._currentProcessServerName.equalsIgnoreCase(storedServerName)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"This server OWNS the HA lock row as expected");
                        }
                        lockSuccess = true;
                        break block18;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ANOTHER server OWNS the lock row - we need to mark the log as failed");
                    }
                    if (_useNewLockingScheme && !this._isHomeServer) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Not the home server, failurescope is " + this._failureScope));
                        }
                        break block18;
                    }
                    Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Another server owns the log cannot force SQL RecoveryLog " + this._logName + " for server " + this._serverName));
                    InternalLogException ile = new InternalLogException("Another server has locked the HA lock row", null);
                    this.markFailed(ile);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"takeHADBLock", (Object)"InternalLogException");
                    }
                    throw ile;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Could not find HA Lock row");
                }
                InternalLogException ile = new InternalLogException("Could not find the HA lock row", null);
                Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Could not find HA lock row when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName));
                this.markFailed(ile);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"takeHADBLock", (Object)"InternalLogException");
                }
                throw ile;
            }
            finally {
                if (lockingRS != null && !lockingRS.isClosed()) {
                    lockingRS.close();
                }
                if (lockingStmt != null && !lockingStmt.isClosed()) {
                    lockingStmt.close();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"takeHADBLock", (Object)lockSuccess);
        }
        return lockSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHADBLock(Connection conn) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateHADBLock", (Object)new Object[]{conn, this});
        }
        Statement readForUpdateStmt = null;
        Statement updateStmt = null;
        Statement specStatement = null;
        ResultSet readForUpdateRS = null;
        boolean lockingRecordExists = false;
        try {
            int latchRetryCount = 0;
            boolean needToRetryLatch = false;
            do {
                needToRetryLatch = false;
                readForUpdateStmt = conn.createStatement();
                readForUpdateRS = this.readHADBLock(readForUpdateStmt);
                if (readForUpdateRS.next()) {
                    Long latch;
                    lockingRecordExists = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Acquired lock on HA Lock row");
                    }
                    String storedServerName = readForUpdateRS.getString(1);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Stored server value is: " + storedServerName));
                    }
                    if (this._currentProcessServerName.equalsIgnoreCase(storedServerName)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"This server ALREADY OWNS the HA lock row");
                        }
                        if (_useNewLockingScheme || 255L != (latch = Long.valueOf(readForUpdateRS.getLong(2))) || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"latch is set in HA lock row - it will be unset when we perform the UPDATE");
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ANOTHER server OWNS the lock");
                    }
                    if (_useNewLockingScheme || 255L != (latch = Long.valueOf(readForUpdateRS.getLong(2))) || this._isHomeServer) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("latch is set in HA lock row for remote failurescope, latchRetryCount = " + latchRetryCount));
                    }
                    if (++latchRetryCount >= 3) continue;
                    needToRetryLatch = true;
                    if (readForUpdateRS != null) {
                        try {
                            readForUpdateRS.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (readForUpdateStmt != null) {
                        try {
                            readForUpdateStmt.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    conn.rollback();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                lockingRecordExists = false;
            } while (needToRetryLatch);
            if (lockingRecordExists) {
                updateStmt = conn.createStatement();
                String updateString = null;
                updateString = !_useNewLockingScheme ? "UPDATE WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " SET SERVER_NAME = '" + this._currentProcessServerName + "', RUSECTION_ID = " + 1L + " WHERE RU_ID = -1" : "UPDATE WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " SET SERVER_NAME = '" + this._currentProcessServerName + "' WHERE RU_ID = -1";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Updating HA Lock using update string - " + updateString));
                }
                int ret = updateStmt.executeUpdate(updateString);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Have updated HA Lock row with return: " + ret));
                }
            } else {
                short serviceId = 1;
                String insertString = "INSERT INTO WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " (SERVER_NAME, SERVICE_ID, RU_ID, RUSECTION_ID, RUSECTION_DATA_INDEX, DATA) VALUES (?,?,?,?,?,?)";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Need to setup HA Lock row using - " + insertString));
                }
                specStatement = conn.prepareStatement(insertString);
                specStatement.setString(1, this._currentProcessServerName);
                specStatement.setShort(2, serviceId);
                specStatement.setLong(3, -1L);
                specStatement.setLong(4, 1L);
                specStatement.setShort(5, (short)1);
                byte[] buf = new byte[2];
                specStatement.setBytes(6, buf);
                int ret = specStatement.executeUpdate();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Have inserted HA Lock row with return: " + ret));
                }
            }
        }
        finally {
            if (readForUpdateRS != null) {
                try {
                    readForUpdateRS.close();
                }
                catch (Exception exception) {}
            }
            if (readForUpdateStmt != null) {
                try {
                    readForUpdateStmt.close();
                }
                catch (Exception exception) {}
            }
            if (updateStmt != null) {
                try {
                    updateStmt.close();
                }
                catch (Exception exception) {}
            }
            if (specStatement != null) {
                try {
                    specStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateHADBLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDBTable(Connection conn) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createDBTable", (Object)new Object[]{conn, this});
        }
        Statement createTableStmt = null;
        Statement specStatement = null;
        boolean success = false;
        try {
            createTableStmt = conn.createStatement();
            if (this._isOracle) {
                String oracleFullTableName = _recoveryTableName + this._logIdentifierString + this._recoveryTableNameSuffix;
                String oracleTableString = "CREATE TABLE " + oracleFullTableName + oracleTablePostString;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create Oracle Table using: " + oracleTableString));
                }
                String oracleIndexString = "CREATE INDEX IXWS" + this._logIdentifierString + this._recoveryTableNameSuffix + " ON " + oracleFullTableName + indexPostString;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create Oracle Index using: " + oracleIndexString));
                }
                createTableStmt.executeUpdate(oracleTableString);
                createTableStmt.executeUpdate(oracleIndexString);
            } else if (this._isDB2) {
                String db2FullTableName = _recoveryTableName + this._logIdentifierString + this._recoveryTableNameSuffix;
                String db2TableString = "CREATE TABLE " + db2FullTableName + db2TablePostString;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create DB2 Table using: " + db2TableString));
                }
                String db2IndexString = "CREATE INDEX IXWS" + this._logIdentifierString + this._recoveryTableNameSuffix + " ON " + db2FullTableName + indexPostString;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create DB2 Index using: " + db2IndexString));
                }
                createTableStmt.executeUpdate(db2TableString);
                createTableStmt.executeUpdate(db2IndexString);
            } else {
                String genericFullTableName = _recoveryTableName + this._logIdentifierString + this._recoveryTableNameSuffix;
                String genericTableString = "CREATE TABLE " + genericFullTableName + genericTablePostString;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create Generic Table using: " + genericTableString));
                }
                String genericIndexString = "CREATE INDEX IXWS" + this._logIdentifierString + this._recoveryTableNameSuffix + " ON " + genericFullTableName + indexPostString;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create Generic Index using: " + genericIndexString));
                }
                createTableStmt.executeUpdate(genericTableString);
                createTableStmt.executeUpdate(genericIndexString);
            }
            short serviceId = (short)this._recoveryAgent.clientIdentifier();
            String insertString = "INSERT INTO WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " (SERVER_NAME, SERVICE_ID, RU_ID, RUSECTION_ID, RUSECTION_DATA_INDEX, DATA) VALUES (?,?,?,?,?,?)";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Have created the table, insert special HA LOCKING row using - " + insertString));
            }
            specStatement = conn.prepareStatement(insertString);
            specStatement.setString(1, this._currentProcessServerName);
            specStatement.setShort(2, serviceId);
            specStatement.setLong(3, -1L);
            specStatement.setLong(4, 1L);
            specStatement.setShort(5, (short)1);
            byte[] buf = new byte[2];
            specStatement.setBytes(6, buf);
            int ret = specStatement.executeUpdate();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Have inserted HA LOCKING ROW with return: " + ret));
            }
            conn.commit();
            success = true;
        }
        finally {
            if (createTableStmt != null && !createTableStmt.isClosed()) {
                createTableStmt.close();
            }
            if (specStatement != null && !specStatement.isClosed()) {
                specStatement.close();
            }
            if (!success) {
                conn.rollback();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createDBTable");
        }
    }

    public synchronized void removing(Object target) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removing", (Object)new Object[]{target, this});
        }
        if (this.failed() || this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removing", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (this._closesRequired <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removing", (Object)this);
            }
            throw new InternalLogException((Throwable)new LogClosedException());
        }
        try {
            this.removeRecoverableUnit(((SQLRecoverableUnitImpl)target).identity());
        }
        catch (InternalLogException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.removing", (String)"1573", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"An unexpected error occured whilst removing a RecoverableUnit");
            }
            this.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removing", (Object)((Object)exc));
            }
            throw exc;
        }
        catch (Exception exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.removing", (String)"1581", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"An unexpected error occured whilst removing a RecoverableUnit");
            }
            this.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removing", (Object)"InternalLogException");
            }
            throw new InternalLogException((Throwable)exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removing");
        }
    }

    protected boolean failed() {
        if (tc.isDebugEnabled() && this._failed) {
            Tr.debug((TraceComponent)tc, (String)("failed: RecoveryLog has been marked as failed. [" + this + "]"));
        }
        return this._failed;
    }

    protected boolean incompatible() {
        if (tc.isDebugEnabled() && this._incompatible) {
            Tr.debug((TraceComponent)tc, (String)("incompatible: RecoveryLog has been marked as incompatible. [" + this + "]"));
        }
        return this._incompatible;
    }

    protected void markFailed(Throwable t) {
        this.markFailed(t, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markFailed(Throwable t, boolean report) {
        boolean newFailure = false;
        SQLMultiScopeRecoveryLog sQLMultiScopeRecoveryLog = this;
        synchronized (sQLMultiScopeRecoveryLog) {
            if (tc.isDebugEnabled() && this._failed) {
                Tr.debug((TraceComponent)tc, (String)("markFailed: RecoveryLog has been marked as failed. [" + this + "]"));
            }
            if (!this._failed) {
                newFailure = true;
                this._failed = true;
                if (report) {
                    Object[] errorObject = new Object[]{this._logIdentifier, this._clientName};
                    Tr.audit((TraceComponent)tc, (String)"CWRLS0008_RECOVERY_LOG_FAILED", (Object)errorObject);
                    Tr.info((TraceComponent)tc, (String)"CWRLS0009_RECOVERY_LOG_FAILED_DETAIL", (Object)t);
                }
                if (Configuration.HAEnabled()) {
                    if (Configuration.localFailureScope().equals(this._failureScope)) {
                        Tr.error((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object)t);
                        Configuration.getRecoveryLogComponent().terminateServer();
                    } else {
                        Configuration.getRecoveryLogComponent().leaveGroup(this._failureScope);
                    }
                }
            }
        }
        if (newFailure && this._associatedLog != null) {
            if (this._failAssociatedLog) {
                if (tc.isDebugEnabled() && this._failed) {
                    Tr.debug((TraceComponent)tc, (String)"associated log will be marked as failed", (Object)this._associatedLog);
                }
                this._associatedLog.markFailedByAssociation();
            } else {
                this._associatedLog.provideServiceability();
            }
        }
    }

    public synchronized void markFailedByAssociation() {
        if (!this._failed) {
            this._failed = true;
            if (tc.isDebugEnabled() && this._failed) {
                Tr.debug((TraceComponent)tc, (String)("markFailedByAssociation: RecoveryLog has been marked as failed by association. [" + this + "]"));
            }
            this.provideServiceability();
        } else if (tc.isDebugEnabled() && this._failed) {
            Tr.debug((TraceComponent)tc, (String)("markFailedByAssociation: RecoveryLog was already failed when marked as failed by association. [" + this + "]"));
        }
    }

    protected synchronized void markIncompatible() {
        if (tc.isDebugEnabled() && this._incompatible) {
            Tr.debug((TraceComponent)tc, (String)("markIncompatible: RecoveryLog has been marked as incompatible. [" + this + "]"));
        }
        this._incompatible = true;
    }

    protected void addRecoverableUnit(RecoverableUnit recoverableUnit, boolean recovered) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addRecoverableUnit", (Object)new Object[]{recoverableUnit, recovered, this});
        }
        long identity = recoverableUnit.identity();
        this._recoverableUnits.put(identity, recoverableUnit);
        if (recovered) {
            this._recUnitIdTable.reserveId(identity, (Object)recoverableUnit);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addRecoverableUnit");
        }
    }

    protected SQLRecoverableUnitImpl removeRecoverableUnitMapEntries(long identity) {
        SQLRecoverableUnitImpl recoverableUnit;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeRecoverableUnitMapEntries", (Object)new Object[]{identity, this});
        }
        if ((recoverableUnit = (SQLRecoverableUnitImpl)this._recoverableUnits.remove(identity)) != null && !recoverableUnit._recovered) {
            this._recUnitIdTable.removeId(identity);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnitMapEntries", (Object)recoverableUnit);
        }
        return recoverableUnit;
    }

    protected SQLRecoverableUnitImpl getRecoverableUnit(long identity) throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRecoverableUnit", (Object)new Object[]{identity, this});
        }
        SQLRecoverableUnitImpl recoverableUnit = null;
        if (this.incompatible() || this.failed() || this._closesRequired <= 0) {
            LogClosedException lce = new LogClosedException();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRecoverableUnit", (Object)((Object)lce));
            }
            throw lce;
        }
        recoverableUnit = (SQLRecoverableUnitImpl)this._recoverableUnits.get(identity);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRecoverableUnit", (Object)recoverableUnit);
        }
        return recoverableUnit;
    }

    String serverName() {
        return this._serverName;
    }

    String clientName() {
        return this._clientName;
    }

    public int clientVersion() {
        return this._clientVersion;
    }

    public String logName() {
        return this._logName;
    }

    public int logIdentifier() {
        return this._logIdentifier;
    }

    public synchronized void serverStopping() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serverStopping ", (Object)new Object[]{this});
        }
        SQLException transientException = null;
        this._serverStopping = true;
        if (_useNewLockingScheme) {
            HeartbeatLogManager.stopTimeout();
        }
        if (this.failed() || this.incompatible() || this._closesRequired <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"serverStopping", (Object)this);
            }
            return;
        }
        try {
            transientException = this.reserveConnection();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.serverStopping", (String)"3513", (Object)this);
        }
        if (transientException != null) {
            Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Caught SQLException when server stopping for SQL RecoveryLog " + this._logName + " for server " + this._serverName + " SQLException: " + transientException));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Try to reexecute the SQL using connection from DS: " + this._theDS));
            }
            try {
                transientException = this.reserveConnection();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.serverStopping", (String)"3513", (Object)this);
            }
            if (transientException != null) {
                FFDCFilter.processException((Throwable)transientException, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.serverStopping", (String)"3507", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serverStopping");
        }
    }

    public String toString() {
        return this._traceId;
    }

    private String logTypeFromInteger(int x) {
        switch (x) {
            case 1: {
                return "TRAN_LOG";
            }
            case 2: {
                return "PARTNER_LOG";
            }
            case 3: {
                return "COMP_LOG";
            }
        }
        return "";
    }

    private Integer getTransientSQLErrorRetryAttempts() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTransientSQLErrorRetryAttempts");
        }
        Integer transientSqlRetryAttempts = null;
        try {
            transientSqlRetryAttempts = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() {
                    return Integer.getInteger("com.ibm.ws.recoverylog.custom.jdbc.impl.TransientRetryAttempts", 180);
                }
            });
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SqlMultiScopeRecoveryLog.getTransientSQLErrorRetryAttempts", (String)"132");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception setting transient SQL retry attempts", (Object)e);
            }
            transientSqlRetryAttempts = null;
        }
        if (transientSqlRetryAttempts == null) {
            transientSqlRetryAttempts = 180;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTransientSQLErrorRetryAttempts", (Object)transientSqlRetryAttempts);
        }
        return transientSqlRetryAttempts;
    }

    private Integer getTransientSQLErrorRetrySleepTime() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTransientSQLErrorRetrySleepTime");
        }
        Integer transientSqlRetrySleepTime = null;
        try {
            transientSqlRetrySleepTime = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() {
                    return Integer.getInteger("com.ibm.ws.recoverylog.custom.jdbc.impl.TransientRetrySleepTime", 10000);
                }
            });
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SqlMultiScopeRecoveryLog.getTransientSQLErrorRetrySleepTime", (String)"132");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception setting transient SQL retry sleep time", (Object)e);
            }
            transientSqlRetrySleepTime = null;
        }
        if (transientSqlRetrySleepTime == null) {
            transientSqlRetrySleepTime = 10000;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTransientSQLErrorRetrySleepTime", (Object)transientSqlRetrySleepTime);
        }
        return transientSqlRetrySleepTime;
    }

    public void associateLog(DistributedRecoveryLog otherLog, boolean failAssociatedLog) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"associateLog", (Object)new Object[]{otherLog, failAssociatedLog, this});
        }
        if (otherLog instanceof MultiScopeLog) {
            this._associatedLog = (MultiScopeLog)otherLog;
            this._failAssociatedLog = failAssociatedLog;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"associateLog");
        }
    }

    public void provideServiceability() {
        Exception e = new Exception();
        try {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.provideServiceability", (String)"3624", (Object)this);
            HashMap<Long, RecoverableUnit> rus = this._recoverableUnits;
            if (rus != null) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.provideServiceability", (String)"3628", rus);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    int prepareConnectionForBatch(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
        int initialIsolation = 4;
        if (this._isDB2) {
            try {
                initialIsolation = conn.getTransactionIsolation();
                if (4 != initialIsolation && 8 != initialIsolation) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Transaction isolation level was " + initialIsolation + " , setting to TRANSACTION_REPEATABLE_READ"));
                    }
                    conn.setTransactionIsolation(4);
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setTransactionIsolation to RR threw Exception. Transaction isolation level was " + initialIsolation + " "), (Object)e);
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.prepareConnectionForBatch", (String)"3668", (Object)this);
                if (!this.isolationFailureReported) {
                    this.isolationFailureReported = true;
                    Tr.warning((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object)e);
                }
                initialIsolation = 4;
            }
        }
        return initialIsolation;
    }

    void closeConnectionAfterBatch(Connection conn, int initialIsolation) throws SQLException {
        block4: {
            if (this._isDB2 && 4 != initialIsolation && 8 != initialIsolation) {
                try {
                    conn.setTransactionIsolation(initialIsolation);
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("setTransactionIsolation threw Exception. Specified transaction isolation level was " + initialIsolation + " "), (Object)e);
                    }
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.closeConnectionAfterBatch", (String)"3696", (Object)this);
                    if (this.isolationFailureReported) break block4;
                    this.isolationFailureReported = true;
                    Tr.warning((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object)e);
                }
            }
        }
        conn.setAutoCommit(true);
        conn.close();
    }

    private ResultSet readHADBLock(Statement lockingStmt) throws SQLException {
        String queryString = "SELECT SERVER_NAME, RUSECTION_ID FROM WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " WHERE RU_ID=-1 FOR UPDATE";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Attempt to select the HA LOCKING ROW for UPDATE - " + queryString));
        }
        return lockingStmt.executeQuery(queryString);
    }

    private int setHADBLockLatch(Statement lockingStmt, boolean setLatch) throws SQLException {
        long latch = setLatch ? 255L : 1L;
        String updateString = "UPDATE WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " SET RUSECTION_ID = " + latch + " WHERE RU_ID = -1";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Attempt to UPDATE the HA LOCKING ROW - " + updateString));
        }
        return lockingStmt.executeUpdate(updateString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLException reserveConnection() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reserveConnection", (Object)new Object[]{this._reservedConn, this});
        }
        boolean success = false;
        Statement lockingStmt = null;
        ResultSet lockingRS = null;
        SQLException transientException = null;
        try {
            this._reservedConn = this._theDS.getConnection();
            this.prepareConnectionForBatch(this._reservedConn);
            lockingStmt = this._reservedConn.createStatement();
            lockingRS = this.readHADBLock(lockingStmt);
            if (lockingRS.next()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Acquired lock on HA Lock row");
                }
                String storedServerName = lockingRS.getString(1);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Stored server value is: " + storedServerName));
                }
                if (this._currentProcessServerName.equalsIgnoreCase(storedServerName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"This server OWNS the HA lock row");
                    }
                    if (this._isHomeServer && !_useNewLockingScheme) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"it's the local server's failure scope - set the latch");
                        }
                        int ret = this.setHADBLockLatch(lockingStmt, true);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Have updated HA Lock row's latch return value: " + ret));
                        }
                    }
                    success = true;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Too late, another server has already got the lock: ");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"There's no locking row!!!");
            }
        }
        catch (SQLException sqlex) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SQLException creating reservedConnection or reading the lock", (Object)sqlex);
            }
            if (this.sqlTransientErrorHandlingEnabled && this.isSQLErrorTransient(sqlex)) {
                transientException = sqlex;
            } else {
                FFDCFilter.processException((Throwable)sqlex, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.reserveConnection", (String)"3901", (Object)this);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception selecting/updating the HADBLock row ", (Object)e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.reserveConnection", (String)"3906", (Object)this);
        }
        finally {
            block144: {
                block143: {
                    if (lockingRS != null) {
                        try {
                            lockingRS.close();
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) break block143;
                            Tr.debug((TraceComponent)tc, (String)"Exception closing ResultsSet", (Object)e);
                        }
                    }
                }
                if (lockingStmt != null) {
                    try {
                        lockingStmt.close();
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block144;
                        Tr.debug((TraceComponent)tc, (String)"Exception closing Statement", (Object)e);
                    }
                }
            }
            try {
                if (success) {
                    this._reservedConn.commit();
                } else if (this._reservedConn != null) {
                    this._reservedConn.rollback();
                }
            }
            catch (SQLException sqlex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SQLException ending transaction on connection (commit is " + success + "): "), (Object)sqlex);
                }
                if (success && transientException == null) {
                    if (this.sqlTransientErrorHandlingEnabled && this.isSQLErrorTransient(sqlex)) {
                        transientException = sqlex;
                    } else {
                        FFDCFilter.processException((Throwable)sqlex, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.reserveConnection", (String)"3937", (Object)this);
                    }
                }
                success = false;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception ending transaction on connection (commit is " + success + "): "), (Object)e);
                }
                success = false;
            }
            finally {
                if (!success && this._reservedConn != null) {
                    try {
                        this._reservedConn.close();
                    }
                    catch (Exception sqlex) {
                    }
                    finally {
                        this._reservedConn = null;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reserveConnection", (Object)transientException);
        }
        return transientException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unlatchHADBLock() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unlatchHADBLock", (Object)new Object[]{this._reservedConn, this});
        }
        boolean success = false;
        Statement lockingStmt = null;
        ResultSet lockingRS = null;
        if (this._isHomeServer && this._reservedConn != null) {
            try {
                lockingStmt = this._reservedConn.createStatement();
                lockingRS = this.readHADBLock(lockingStmt);
                if (lockingRS.next()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Acquired lock on HA Lock row");
                    }
                    String storedServerName = lockingRS.getString(1);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Stored server value is: " + storedServerName));
                    }
                    if (this._currentProcessServerName.equalsIgnoreCase(storedServerName)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"This server OWNS the HA lock row");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"it's the local server's failure scope - unset the latch");
                        }
                        int ret = this.setHADBLockLatch(lockingStmt, false);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Have updated HA Lock row's latch return value: " + ret));
                        }
                        success = true;
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Too late, another server has already got the lock");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"There's no locking row!!!");
                }
            }
            catch (SQLException sqlex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SQLException selecting/updating the HADBLock row", (Object)sqlex);
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception selecting/updating the HADBLock row ", (Object)e);
                }
            }
            finally {
                block63: {
                    block62: {
                        block61: {
                            if (lockingRS != null) {
                                try {
                                    lockingRS.close();
                                }
                                catch (Exception e) {
                                    if (!tc.isDebugEnabled()) break block61;
                                    Tr.debug((TraceComponent)tc, (String)"Exception closing ResultsSet", (Object)e);
                                }
                            }
                        }
                        if (lockingStmt != null) {
                            try {
                                lockingStmt.close();
                            }
                            catch (Exception e) {
                                if (!tc.isDebugEnabled()) break block62;
                                Tr.debug((TraceComponent)tc, (String)"Exception closing Statement", (Object)e);
                            }
                        }
                    }
                    if (success) {
                        try {
                            this._reservedConn.commit();
                        }
                        catch (Exception e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Exception committing connection: ", (Object)e);
                            }
                            success = false;
                        }
                    } else {
                        try {
                            this._reservedConn.rollback();
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) break block63;
                            Tr.debug((TraceComponent)tc, (String)"Exception rolling back connection: ", (Object)e);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unlatchHADBLock", (Object)success);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection assertDBTableExists(Connection conn, int initialIsolation) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"assertDBTableExists", (Object)new Object[]{conn, initialIsolation});
        }
        ResultSet touchRS = null;
        Statement touchStmt = null;
        boolean handleFailover = false;
        boolean success = false;
        Object object = _CreateTableLock;
        synchronized (object) {
            int queryRetries = 0;
            Object excToCheck = null;
            while (!success) {
                try {
                    if (conn == null) {
                        conn = this._theDS.getConnection();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Acquired connection in Database retry scenario");
                        }
                        initialIsolation = this.prepareConnectionForBatch(conn);
                    }
                    if ((touchRS = this.readHADBLock(touchStmt = conn.createStatement())) != null) {
                        try {
                            touchRS.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (touchStmt != null) {
                        try {
                            touchStmt.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        conn.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    success = true;
                }
                catch (Exception ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Query failed with exception: " + ex));
                    }
                    if (touchRS != null) {
                        try {
                            touchRS.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (touchStmt != null) {
                        try {
                            touchStmt.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        if (conn == null) {
                            throw ex;
                        }
                        this.createDBTable(conn);
                        success = true;
                    }
                    catch (Exception createException) {
                        long sleepTime;
                        boolean isTransient;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Table Creation failed with exception: " + createException));
                        }
                        if (conn != null) {
                            try {
                                this.closeConnectionAfterBatch(conn, initialIsolation);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            conn = null;
                        }
                        boolean bl = isTransient = this.sqlTransientErrorHandlingEnabled && createException instanceof SQLException && this.isSQLErrorTransient((SQLException)createException);
                        if (++queryRetries >= 2) {
                            if (!handleFailover && isTransient) {
                                queryRetries = 0;
                                handleFailover = true;
                            } else {
                                FFDCFilter.processException((Throwable)createException, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.openLog", (String)"48", (Object)this);
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"assertDBTableExists", (Object)createException);
                                }
                                throw createException;
                            }
                        }
                        long l = sleepTime = isTransient ? (long)this._transientRetrySleepTime : 1000L;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("sleeping for ms=" + sleepTime));
                        }
                        try {
                            Thread.sleep(sleepTime);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"assertDBTableExists", (Object)conn);
        }
        return conn;
    }

    @FFDCIgnore(value={LogClosedException.class})
    public void heartBeat() throws LogClosedException {
        Exception nonTransientException;
        boolean sqlSuccess;
        block27: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"heartBeat", (Object)new Object[]{this._closesRequired, this});
            }
            sqlSuccess = false;
            nonTransientException = null;
            int initialIsolation = 4;
            if (!(this._closesRequired <= 0 || this._serverStopping || this.failed() || this.incompatible())) {
                SQLException currentSqlEx;
                block29: {
                    Connection conn;
                    block28: {
                        currentSqlEx = null;
                        conn = null;
                        try {
                            String fullLogDirectory = this._internalLogProperties.getProperty("LOG_DIRECTORY");
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("fullLogDirectory = " + fullLogDirectory));
                            }
                            conn = this.getConnection(fullLogDirectory);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Acquired connection for heartbeat - " + conn));
                            }
                            initialIsolation = this.prepareConnectionForBatch(conn);
                            this.internalHeartBeat(conn);
                            conn.commit();
                            sqlSuccess = true;
                        }
                        catch (SQLException sqlex) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("heartbeat failed with SQL exception: " + sqlex));
                            }
                            currentSqlEx = sqlex;
                            if (conn == null) {
                                nonTransientException = sqlex;
                            }
                        }
                        catch (Exception ex) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("heartbeat failed with general Exception: " + ex));
                            }
                            nonTransientException = ex;
                        }
                        if (sqlSuccess) {
                            try {
                                this.closeConnectionAfterBatch(conn, initialIsolation);
                            }
                            catch (Throwable exc) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Close Failed, after heartbeat success, got exception: " + exc));
                                }
                                break block27;
                            }
                        }
                        try {
                            conn.rollback();
                        }
                        catch (Throwable exc) {
                            if (!tc.isDebugEnabled()) break block28;
                            Tr.debug((TraceComponent)tc, (String)("Rollback Failed, after heartbeat failure, got exception: " + exc));
                        }
                    }
                    try {
                        this.closeConnectionAfterBatch(conn, initialIsolation);
                    }
                    catch (Throwable exc) {
                        if (!tc.isDebugEnabled()) break block29;
                        Tr.debug((TraceComponent)tc, (String)("Close Failed, after heartbeat failure, got exception: " + exc));
                    }
                }
                if (this.sqlTransientErrorHandlingEnabled) {
                    if (nonTransientException == null) {
                        HeartbeatRetry heartbeatRetry = new HeartbeatRetry();
                        sqlSuccess = heartbeatRetry.retryAndReport(this, this._theDS, this._serverName, currentSqlEx, 2, 1000);
                    } else {
                        Tr.debug((TraceComponent)tc, (String)("Cannot recover from Exception when heartbeating for server " + this._serverName + " Exception: " + nonTransientException));
                    }
                } else {
                    if (nonTransientException == null) {
                        nonTransientException = currentSqlEx;
                    }
                    Tr.debug((TraceComponent)tc, (String)("Encountered Exception when heartbeating for server " + this._serverName + " Exception: " + nonTransientException));
                }
            } else {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"heartbeat", (Object)"Log is not in a fit state for a heartbeat");
                }
                throw new LogClosedException();
            }
        }
        if (!sqlSuccess) {
            this.markFailed(nonTransientException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"heartBeat");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalHeartBeat(Connection conn) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"internalHeartBeat", (Object)new Object[]{conn});
        }
        Statement lockingStmt = null;
        ResultSet lockingRS = null;
        try {
            lockingStmt = conn.createStatement();
            String queryString = "SELECT RUSECTION_ID FROM WAS_PARTNER_LOG" + this._recoveryTableNameSuffix + " WHERE RU_ID=-1 FOR UPDATE";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Attempt to select the HA LOCKING ROW for UPDATE using - " + queryString));
            }
            if ((lockingRS = lockingStmt.executeQuery(queryString)).next()) {
                long storedTimestamp = lockingRS.getLong(1);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Acquired lock on HA Lock row, stored timestamp is: " + storedTimestamp));
                }
                long fir1 = System.currentTimeMillis();
                String updateString = "UPDATE WAS_PARTNER_LOG" + this._recoveryTableNameSuffix + " SET RUSECTION_ID = " + fir1 + " WHERE RU_ID = -1";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Update timestamp using using - " + updateString));
                }
                int ret = lockingStmt.executeUpdate(updateString);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Have updated HA Lock row with return: " + ret));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not find HA Lock row, unable to update timestamp");
            }
        }
        finally {
            if (lockingRS != null && !lockingRS.isClosed()) {
                lockingRS.close();
            }
            if (lockingStmt != null && !lockingStmt.isClosed()) {
                lockingStmt.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"internalHeartBeat");
        }
    }

    public boolean claimLocalRecoveryLogs() {
        boolean isClaimed;
        block31: {
            SQLException currentSqlEx;
            Connection conn;
            int initialIsolation;
            Exception nonTransientException;
            boolean tableExists;
            boolean sqlSuccess;
            block30: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"claimLocalRecoveryLogs", (Object)this);
                }
                isClaimed = false;
                sqlSuccess = false;
                tableExists = false;
                nonTransientException = null;
                initialIsolation = 4;
                _useNewLockingScheme = true;
                conn = null;
                currentSqlEx = null;
                try {
                    String fullLogDirectory = this._internalLogProperties.getProperty("LOG_DIRECTORY");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("fullLogDirectory = " + fullLogDirectory));
                    }
                    conn = this.getConnection(fullLogDirectory);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Acquired connection for attempt to claim local server logs - " + conn));
                    }
                    initialIsolation = this.prepareConnectionForBatch(conn);
                    conn = this.assertDBTableExists(conn, initialIsolation);
                    tableExists = true;
                }
                catch (SQLException sqlex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("claimLocalRecoveryLogs failed when testing table existence with SQLException: " + sqlex));
                    }
                }
                catch (Exception exc) {
                    if (!tc.isDebugEnabled()) break block30;
                    Tr.debug((TraceComponent)tc, (String)("claimLocalRecoveryLogs failed when testing table existence with Exception: " + exc));
                }
            }
            if (tableExists) {
                block33: {
                    block32: {
                        try {
                            isClaimed = this.internalClaimRecoveryLogs(conn, true);
                            conn.commit();
                            sqlSuccess = true;
                        }
                        catch (SQLException sqlex) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("claimLocalRecoveryLogs failed with SQLException: " + sqlex));
                            }
                            currentSqlEx = sqlex;
                            if (conn == null) {
                                nonTransientException = sqlex;
                            }
                        }
                        catch (Exception exc) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("claimLocalRecoveryLogs failed with Exception: " + exc));
                            }
                            nonTransientException = exc;
                        }
                        if (sqlSuccess) {
                            try {
                                this.closeConnectionAfterBatch(conn, initialIsolation);
                            }
                            catch (Throwable exc) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Close Failed, after claimLocalRecoveryLogs success, got exception: " + exc));
                                }
                                break block31;
                            }
                        }
                        try {
                            conn.rollback();
                        }
                        catch (Throwable exc) {
                            if (!tc.isDebugEnabled()) break block32;
                            Tr.debug((TraceComponent)tc, (String)("Rollback Failed, after claimLocalRecoveryLogs failure, got exception: " + exc));
                        }
                    }
                    try {
                        this.closeConnectionAfterBatch(conn, initialIsolation);
                    }
                    catch (Throwable exc) {
                        if (!tc.isDebugEnabled()) break block33;
                        Tr.debug((TraceComponent)tc, (String)("Close Failed, after claimLocalRecoveryLogs failure, got exception: " + exc));
                    }
                }
                if (this.sqlTransientErrorHandlingEnabled) {
                    if (nonTransientException == null) {
                        ClaimLocalRetry claimLocalRetry = new ClaimLocalRetry();
                        sqlSuccess = claimLocalRetry.retryAndReport(this, this._theDS, this._serverName, currentSqlEx, this._transientRetryAttempts, this._transientRetrySleepTime);
                        if (sqlSuccess) {
                            isClaimed = claimLocalRetry.isClaimed();
                        }
                    } else {
                        Tr.debug((TraceComponent)tc, (String)("Cannot recover from Exception when claiming local recovery logs for server " + this._serverName + " Exception: " + nonTransientException));
                    }
                } else {
                    if (nonTransientException == null) {
                        nonTransientException = currentSqlEx;
                    }
                    Tr.debug((TraceComponent)tc, (String)("Encountered Exception when claiming local recovery logs for server " + this._serverName + " Exception: " + nonTransientException));
                }
            }
        }
        if (isClaimed) {
            HeartbeatLogManager.setTimeout((HeartbeatLog)this, (int)this._peerLockTimeBetweenHeartbeats);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"claimLocalRecoveryLogs", (Object)new Boolean(isClaimed));
        }
        return isClaimed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean internalClaimRecoveryLogs(Connection conn, boolean isHomeServer) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"internalClaimRecoveryLogs", (Object)new Object[]{conn, isHomeServer});
        }
        boolean isClaimed = false;
        boolean doUpdate = true;
        String updateString = "";
        String reportString = "";
        Statement lockingStmt = null;
        ResultSet lockingRS = null;
        try {
            long curTimestamp = System.currentTimeMillis();
            lockingStmt = conn.createStatement();
            String queryString = "SELECT SERVER_NAME, RUSECTION_ID FROM WAS_PARTNER_LOG" + this._recoveryTableNameSuffix + " WHERE RU_ID=-1 FOR UPDATE";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Attempt to select the HA LOCKING ROW for UPDATE using - " + queryString));
            }
            if ((lockingRS = lockingStmt.executeQuery(queryString)).next()) {
                long fir1;
                String storedServerName = lockingRS.getString(1);
                long storedTimestamp = lockingRS.getLong(2);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Acquired lock on HA Lock row, stored server value is: " + storedServerName + ", timestamp is: " + storedTimestamp + ", stale time is: " + _logGoneStaleTime));
                }
                if (isHomeServer) {
                    doUpdate = true;
                    if (this._currentProcessServerName.equalsIgnoreCase(storedServerName)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"This server ALREADY OWNS the HA lock row");
                        }
                        fir1 = System.currentTimeMillis();
                        updateString = "UPDATE WAS_PARTNER_LOG" + this._recoveryTableNameSuffix + " SET RUSECTION_ID = " + fir1 + " WHERE RU_ID = -1";
                        reportString = "Claim the logs for the local server using - ";
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Another server owns the HA lock row, we will aggressively claim it,  WAS_PARTNER_LOG" + this._recoveryTableNameSuffix + ", currenttime: " + curTimestamp + ", storedTime: " + storedTimestamp));
                        }
                        fir1 = System.currentTimeMillis();
                        updateString = "UPDATE WAS_PARTNER_LOG" + this._recoveryTableNameSuffix + " SET SERVER_NAME = '" + this._currentProcessServerName + "', RUSECTION_ID = " + fir1 + " WHERE RU_ID = -1";
                        reportString = "Claim the logs for the local server from a peer using - ";
                    }
                } else if (curTimestamp - storedTimestamp > (long)(_logGoneStaleTime * 1000)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Timestamp is STALE for WAS_PARTNER_LOG" + this._recoveryTableNameSuffix + ", currenttime: " + curTimestamp + ", storedTime: " + storedTimestamp));
                    }
                    fir1 = System.currentTimeMillis();
                    updateString = "UPDATE WAS_PARTNER_LOG" + this._recoveryTableNameSuffix + " SET SERVER_NAME = '" + this._currentProcessServerName + "', RUSECTION_ID = " + fir1 + " WHERE RU_ID = -1";
                    reportString = "Claim peer logs from a peer server using - ";
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Timestamp is NOT STALE for WAS_PARTNER_LOG" + this._recoveryTableNameSuffix + ", currenttime: " + curTimestamp + ", storedTime: " + storedTimestamp));
                    }
                    doUpdate = false;
                }
                if (doUpdate) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(reportString + updateString));
                    }
                    int ret = lockingStmt.executeUpdate(updateString);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Have updated HA Lock row with return: " + ret));
                    }
                    isClaimed = true;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not find HA Lock row, unable to retrieve timestamp");
            }
        }
        finally {
            if (lockingRS != null && !lockingRS.isClosed()) {
                lockingRS.close();
            }
            if (lockingStmt != null && !lockingStmt.isClosed()) {
                lockingStmt.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"internalClaimRecoveryLogs", (Object)new Boolean(isClaimed));
        }
        return isClaimed;
    }

    public boolean claimPeerRecoveryLogs() {
        boolean isClaimed;
        block24: {
            SQLException currentSqlEx;
            Exception nonTransientException;
            boolean sqlSuccess;
            block26: {
                Connection conn;
                int initialIsolation;
                block25: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"claimPeerRecoveryLogs", (Object)this);
                    }
                    sqlSuccess = false;
                    isClaimed = false;
                    nonTransientException = null;
                    initialIsolation = 4;
                    _useNewLockingScheme = true;
                    conn = null;
                    currentSqlEx = null;
                    try {
                        String fullLogDirectory = this._internalLogProperties.getProperty("LOG_DIRECTORY");
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("fullLogDirectory = " + fullLogDirectory));
                        }
                        conn = this.getConnection(fullLogDirectory);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Acquired connection for staleness test - " + conn));
                        }
                        initialIsolation = this.prepareConnectionForBatch(conn);
                        isClaimed = this.internalClaimRecoveryLogs(conn, false);
                        conn.commit();
                        sqlSuccess = true;
                    }
                    catch (SQLException sqlex) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("claimPeerRecoveryLogs failed with SQLException: " + sqlex));
                        }
                        currentSqlEx = sqlex;
                        if (conn == null) {
                            nonTransientException = sqlex;
                        }
                    }
                    catch (Exception exc) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("claimPeerRecoveryLogs failed with Exception: " + exc));
                        }
                        nonTransientException = exc;
                    }
                    if (sqlSuccess) {
                        try {
                            this.closeConnectionAfterBatch(conn, initialIsolation);
                        }
                        catch (Throwable exc) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Close Failed, after claimPeerRecoveryLogs success, got exception: " + exc));
                            }
                            break block24;
                        }
                    }
                    try {
                        conn.rollback();
                    }
                    catch (Throwable exc) {
                        if (!tc.isDebugEnabled()) break block25;
                        Tr.debug((TraceComponent)tc, (String)("Rollback Failed, after claimPeerRecoveryLogs failure, got exception: " + exc));
                    }
                }
                try {
                    this.closeConnectionAfterBatch(conn, initialIsolation);
                }
                catch (Throwable exc) {
                    if (!tc.isDebugEnabled()) break block26;
                    Tr.debug((TraceComponent)tc, (String)("Close Failed, after claimPeerRecoveryLogs failure, got exception: " + exc));
                }
            }
            if (this.sqlTransientErrorHandlingEnabled) {
                if (nonTransientException == null) {
                    ClaimPeerRetry claimPeerRetry = new ClaimPeerRetry();
                    sqlSuccess = claimPeerRetry.retryAndReport(this, this._theDS, this._serverName, currentSqlEx, 2, 1000);
                    if (sqlSuccess) {
                        isClaimed = claimPeerRetry.isClaimed();
                    }
                } else {
                    Tr.debug((TraceComponent)tc, (String)("Cannot recover from Exception when claiming peer recovery logs for server " + this._serverName + " Exception: " + nonTransientException));
                }
            } else {
                if (nonTransientException == null) {
                    nonTransientException = currentSqlEx;
                }
                Tr.debug((TraceComponent)tc, (String)("Encountered Exception when claiming peer recovery logs for server " + this._serverName + " Exception: " + nonTransientException));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"claimPeerRecoveryLogs", (Object)new Boolean(isClaimed));
        }
        return isClaimed;
    }

    public void setTimeBeforeLogStale(int timeBeforeStale) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setTimeBeforeLogStale", (Object)timeBeforeStale);
        }
        _logGoneStaleTime = timeBeforeStale;
    }

    public void setTimeBetweenHeartbeats(int timeBetweenHeartbeats) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setTimeBetweenHeartbeats", (Object)timeBetweenHeartbeats);
        }
        this._peerLockTimeBetweenHeartbeats = timeBetweenHeartbeats;
    }

    class OpenLogRetry
    extends SQLHADBRetry {
        OpenLogRetry() {
        }

        @Override
        public void retryCode(Connection conn) throws SQLException, Exception {
            SQLMultiScopeRecoveryLog.this.updateHADBLock(conn);
            SQLMultiScopeRecoveryLog.this._recoverableUnits.clear();
            SQLMultiScopeRecoveryLog.this._recUnitIdTable = new RecoverableUnitIdTable();
            SQLMultiScopeRecoveryLog.this.recover(conn);
        }

        @Override
        public String getOperationDescription() {
            return "opening recovery log";
        }
    }

    class ForceSectionsRetry
    extends SQLHADBRetry {
        ForceSectionsRetry() {
        }

        @Override
        public void retryCode(Connection conn) throws SQLException, Exception {
            boolean lockSuccess = SQLMultiScopeRecoveryLog.this.takeHADBLock(conn);
            if (lockSuccess) {
                SQLMultiScopeRecoveryLog.this.executeBatchStatements(conn);
            }
        }

        @Override
        public String getOperationDescription() {
            return "forcing sections";
        }
    }

    class HeartbeatRetry
    extends SQLHADBRetry {
        HeartbeatRetry() {
        }

        @Override
        public void retryCode(Connection conn) throws SQLException, Exception {
            SQLMultiScopeRecoveryLog.this.internalHeartBeat(conn);
        }

        @Override
        public String getOperationDescription() {
            return "heartbeating";
        }
    }

    class ClaimPeerRetry
    extends SQLHADBRetry {
        boolean _isClaimed = false;

        ClaimPeerRetry() {
        }

        @Override
        public void retryCode(Connection conn) throws SQLException, Exception {
            this._isClaimed = SQLMultiScopeRecoveryLog.this.internalClaimRecoveryLogs(conn, false);
        }

        @Override
        public String getOperationDescription() {
            return "claiming peer recovery logs";
        }

        public boolean isClaimed() {
            return this._isClaimed;
        }
    }

    class ClaimLocalRetry
    extends SQLHADBRetry {
        boolean _isClaimed = false;

        ClaimLocalRetry() {
        }

        @Override
        public void retryCode(Connection conn) throws SQLException, Exception {
            this._isClaimed = SQLMultiScopeRecoveryLog.this.internalClaimRecoveryLogs(conn, true);
        }

        public boolean isClaimed() {
            return this._isClaimed;
        }

        @Override
        public String getOperationDescription() {
            return "claiming local recovery logs";
        }
    }

    private class ruForReplay {
        private final long _ruId;
        private final long _sectionId;
        private final int _index;
        private byte[] _data = null;

        public ruForReplay(long ruId, long sectionId, int index, byte[] data) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"ruForReplay", (Object)new Object[]{ruId, sectionId, index, data});
            }
            this._ruId = ruId;
            this._sectionId = sectionId;
            this._index = index;
            this._data = data;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ruForReplay", (Object)this);
            }
        }

        public long getRuId() {
            return this._ruId;
        }

        public long getSectionId() {
            return this._sectionId;
        }

        public int getIndex() {
            return this._index;
        }

        private byte[] getData() {
            return this._data;
        }
    }
}

