/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.resource;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.resource.URIResolver;
import org.xml.sax.InputSource;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class ExtendedURIResolver {
    protected URIResolver currentResolver;
    protected String lastestImportUri;
    protected Stack<InputStream> resourceOpened;
    private static final Logger LOG = LogUtils.getL7dLogger(ExtendedURIResolver.class);
    static final long serialVersionUID = 5771804263818170412L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExtendedURIResolver() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.resource.ExtendedURIResolver", "<init>", new Object[0]);
        }
        this.resourceOpened = new Stack();
        this.currentResolver = new URIResolver();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.resource.ExtendedURIResolver", "<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public InputSource resolve(String curUri, String baseUri) throws ConnectException, SocketTimeoutException {
        block9: {
            InputSource inputSource;
            block10: {
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.entering("org.apache.cxf.resource.ExtendedURIResolver", "resolve", new Object[]{curUri, baseUri});
                }
                try {
                    this.currentResolver.resolve(baseUri, curUri, this.getClass());
                    if (!this.currentResolver.isResolved()) break block9;
                    if (this.currentResolver.getURI() != null && this.currentResolver.getURI().isAbsolute()) {
                        curUri = this.currentResolver.getURI().toString();
                    }
                    if (this.currentResolver.isFile()) {
                        curUri = this.currentResolver.getFile().getAbsoluteFile().toURI().toString();
                    }
                    InputStream in = this.currentResolver.getInputStream();
                    this.resourceOpened.addElement(in);
                    InputSource source = new InputSource(in);
                    source.setSystemId(curUri);
                    source.setPublicId(curUri);
                    InputSource inputSource2 = source;
                    inputSource = inputSource2;
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block10;
                }
                catch (IOException e) {
                    LOG.log(Level.FINE, "Ignoring IOException 2: " + e);
                    break block9;
                }
                finally {
                    this.lastestImportUri = curUri;
                }
                inputSource = inputSource;
                LOG.exiting("org.apache.cxf.resource.ExtendedURIResolver", "resolve", inputSource);
            }
            return inputSource;
        }
        InputSource inputSource = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            inputSource = inputSource;
            LOG.exiting("org.apache.cxf.resource.ExtendedURIResolver", "resolve", inputSource);
        }
        return inputSource;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void close() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.resource.ExtendedURIResolver", "close", new Object[0]);
        }
        while (!this.resourceOpened.isEmpty()) {
            try {
                InputStream in = this.resourceOpened.pop();
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.resource.ExtendedURIResolver", "close");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getLatestImportURI() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.resource.ExtendedURIResolver", "getLatestImportURI", new Object[0]);
        }
        String string = this.getURI();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.resource.ExtendedURIResolver", "getLatestImportURI", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getURI() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.resource.ExtendedURIResolver", "getURI", new Object[0]);
        }
        if (this.currentResolver.getURI() != null) {
            String string = this.currentResolver.getURI().toString();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.resource.ExtendedURIResolver", "getURI", string);
            }
            return string;
        }
        String string = this.lastestImportUri;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.resource.ExtendedURIResolver", "getURI", string);
        }
        return string;
    }
}

