/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.internal.ApplicationConfigurator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class ApplicationStateCoordinator {
    private static final CountDownLatch waitForStartingAppPidsLatch;
    private static volatile ApplicationConfigurator appConfigurator;
    private static volatile LatchAndAppSet unconfiguredApps;
    private static volatile LatchAndAppSet unstartedApps;
    private static volatile LatchAndAppSet unstoppedApps;
    private static long startTimeout;
    private static long stopTimeout;
    static final long serialVersionUID = 3588775605535999067L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static void setApplicationConfigurator(ApplicationConfigurator applicationConfigurator) {
        ConfigurationAdmin configAdmin;
        appConfigurator = applicationConfigurator;
        ConfigurationAdmin configurationAdmin = configAdmin = appConfigurator != null ? appConfigurator.getConfigAdminService() : null;
        if (configAdmin != null) {
            ApplicationStateCoordinator.getConfiguredStartingAppPids(configAdmin);
            waitForStartingAppPidsLatch.countDown();
        }
    }

    public static void setApplicationStartTimeout(long applicationStarttimeout) {
        startTimeout = applicationStarttimeout;
    }

    public static long getApplicationStartTimeout() {
        return startTimeout;
    }

    public static void setApplicationStopTimeout(long applicationStoptimeout) {
        stopTimeout = applicationStoptimeout;
    }

    public static long getApplicationStopTimeout() {
        return stopTimeout;
    }

    private static void getConfiguredStartingAppPids(ConfigurationAdmin configAdmin) {
        ArrayList<String> appPids = new ArrayList<String>();
        try {
            Configuration[] configs = configAdmin.listConfigurations("(service.factoryPid=com.ibm.ws.app.manager)");
            if (configs != null) {
                for (Configuration config : configs) {
                    appPids.add(config.getPid());
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.app.manager.ApplicationStateCoordinator", (String)"109", null, (Object[])new Object[]{configAdmin});
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.app.manager.ApplicationStateCoordinator", (String)"111", null, (Object[])new Object[]{configAdmin});
        }
        unconfiguredApps = new LatchAndAppSet(new HashSet<String>(appPids));
        unstartedApps = new LatchAndAppSet(new HashSet<String>(appPids));
    }

    public static String[] getSlowlyStartingApps() {
        TimeUnit unit = TimeUnit.SECONDS;
        try {
            while (!waitForStartingAppPidsLatch.await(1L, TimeUnit.SECONDS)) {
                if (!FrameworkState.isStopping()) continue;
                return null;
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.app.manager.ApplicationStateCoordinator", (String)"130", null, (Object[])new Object[0]);
        }
        if (appConfigurator != null) {
            long endTime = System.nanoTime() + unit.toNanos(ApplicationStateCoordinator.getApplicationStartTimeout());
            try {
                while (!unconfiguredApps.await(1L, TimeUnit.SECONDS) && System.nanoTime() < endTime) {
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.app.manager.ApplicationStateCoordinator", (String)"142", null, (Object[])new Object[0]);
            }
            appConfigurator.readyForAppsToStart();
            endTime = System.nanoTime() + unit.toNanos(ApplicationStateCoordinator.getApplicationStartTimeout());
            try {
                while (!unstartedApps.await(1L, TimeUnit.SECONDS) && System.nanoTime() < endTime) {
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.app.manager.ApplicationStateCoordinator", (String)"154", null, (Object[])new Object[0]);
            }
        }
        LatchAndAppSet unstarted = unstartedApps;
        unstartedApps = null;
        unconfiguredApps = null;
        return unstarted.getSlowAppPids();
    }

    public static void updateConfiguredAppStatus(String appPid) {
        LatchAndAppSet unconfigured = unconfiguredApps;
        if (unconfigured != null) {
            unconfigured.removeAppPid(appPid);
        }
    }

    public static void updateStartingAppStatus(String appPid, AppStatus appStatus) {
        LatchAndAppSet unstarted = unstartedApps;
        if (unstarted != null) {
            unstarted.removeAppPid(appPid);
        }
        appConfigurator.unblockAppStartDependencies(appPid);
    }

    public static String[] getSlowlyStoppingApps() {
        TimeUnit unit = TimeUnit.SECONDS;
        if (appConfigurator == null) {
            return null;
        }
        appConfigurator.readyForAppsToStop();
        long endTime = System.nanoTime() + unit.toNanos(ApplicationStateCoordinator.getApplicationStopTimeout());
        try {
            while (!unstoppedApps.await(1L, TimeUnit.SECONDS) && System.nanoTime() < endTime) {
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.app.manager.ApplicationStateCoordinator", (String)"193", null, (Object[])new Object[0]);
        }
        LatchAndAppSet unstopped = unstoppedApps;
        unstoppedApps = null;
        return unstopped.getSlowAppPids();
    }

    public static void setStoppingAppPids(Set<String> appPids) {
        unstoppedApps = new LatchAndAppSet(appPids);
    }

    public static void updateStoppingAppStatus(String appPid, AppStatus appStatus) {
        LatchAndAppSet unstopped = unstoppedApps;
        if (unstopped != null) {
            unstopped.removeAppPid(appPid);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ApplicationStateCoordinator.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.ApplicationStateCoordinator");
        waitForStartingAppPidsLatch = new CountDownLatch(1);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class LatchAndAppSet {
        private final Set<String> appPids;
        private final CountDownLatch latch;
        static final long serialVersionUID = 3117678605269479427L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        LatchAndAppSet(Set<String> appPids) {
            this.appPids = appPids;
            this.latch = new CountDownLatch(appPids.size());
        }

        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.latch.await(timeout, unit);
        }

        public synchronized void removeAppPid(String appPid) {
            if (this.appPids.remove(appPid)) {
                this.latch.countDown();
            }
        }

        public String[] getSlowAppPids() {
            String[] slowApps = null;
            if (!this.appPids.isEmpty()) {
                slowApps = new String[this.appPids.size()];
                this.appPids.toArray(slowApps);
                this.appPids.clear();
            }
            return slowApps;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(LatchAndAppSet.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.ApplicationStateCoordinator$LatchAndAppSet");
        }
    }

    public static enum AppStatus {
        FAILED,
        STOPPED,
        STARTED,
        REMOVED,
        DUP_APP_NAME;

    }
}

