/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.mp;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.ContextualAction;
import com.ibm.ws.concurrent.mp.ManagedCompletableFuture;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import java.util.ArrayList;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ContextualRunnable
implements Runnable,
ContextualAction<Runnable> {
    private final Runnable action;
    private final ManagedCompletableFuture<Void> completableFuture;
    private final ThreadContextDescriptor threadContextDescriptor;
    static final long serialVersionUID = -1411687933055850750L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ContextualRunnable(ThreadContextDescriptor threadContextDescriptor, Runnable action) {
        this.action = action;
        this.completableFuture = null;
        this.threadContextDescriptor = threadContextDescriptor;
    }

    ContextualRunnable(ThreadContextDescriptor threadContextDescriptor, Runnable action, ManagedCompletableFuture<Void> completableFuture) {
        this.action = action;
        this.completableFuture = completableFuture;
        this.threadContextDescriptor = threadContextDescriptor;
    }

    @Trivial
    public Runnable getAction() {
        return this.action;
    }

    @Trivial
    public ThreadContextDescriptor getContextDescriptor() {
        return this.threadContextDescriptor;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Throwable failure = null;
        ArrayList contextApplied = null;
        try {
            if (this.threadContextDescriptor != null) {
                contextApplied = this.threadContextDescriptor.taskStarting();
            }
            this.action.run();
        }
        catch (Error | RuntimeException x) {
            try {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.mp.ContextualRunnable", (String)"61", (Object)this, (Object[])new Object[0]);
                failure = x;
                throw x;
            }
            catch (Throwable throwable) {
                try {
                    if (contextApplied == null) throw throwable;
                    this.threadContextDescriptor.taskStopping(contextApplied);
                    throw throwable;
                }
                catch (RuntimeException runtimeException) {
                    void x2;
                    FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.concurrent.mp.ContextualRunnable", (String)"68", (Object)this, (Object[])new Object[0]);
                    failure = x2;
                    throw x2;
                }
                finally {
                    if (this.completableFuture != null) {
                        if (failure == null) {
                            this.completableFuture.super_complete(null);
                        } else {
                            this.completableFuture.super_completeExceptionally(failure);
                        }
                    }
                }
            }
        }
        try {
            if (contextApplied == null) return;
            this.threadContextDescriptor.taskStopping(contextApplied);
            return;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.concurrent.mp.ContextualRunnable", (String)"68", (Object)this, (Object[])new Object[0]);
            failure = x;
            throw x;
        }
        finally {
            if (this.completableFuture != null) {
                if (failure == null) {
                    this.completableFuture.super_complete(null);
                } else {
                    this.completableFuture.super_completeExceptionally(failure);
                }
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.concurrent.mp.ContextualRunnable", ContextualRunnable.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.mp.resources.CWWKCMessages");
    }
}

